/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.issort;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DynamicJavaSort;
import com.iscobol.io.IndexFile;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SeqVarLenFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.issort.RpnEvaluator;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.rts.DynamicSort;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.SortKey;
import com.iscobol.rts.SortKeyItem;
import com.iscobol.rts.VarType;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic9Comp_3;
import com.iscobol.types.Pic9Comp_4;
import com.iscobol.types.Pic9Comp_5;
import com.iscobol.types.Pic9Comp_6;
import com.iscobol.types.PicDisplay;
import com.iscobol.types.PicNativeFloat;
import com.iscobol.types.PicX;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class IsSort
implements VarType {
    public static final int COMP_OPT = 66;
    private static final int PRIO_MIN = 0;
    private static final int PRIO_OR = 3;
    private static final int PRIO_AND = 6;
    private static final int PRIO_CLOSEPAR = 99;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_SS = -2;
    private final ArrayDeque<String> tokens;
    private final ArrayList<FileDesc> use = new ArrayList();
    private final ArrayList<FileDesc> give = new ArrayList();
    private ArrayDeque<CondDesc> rpnCond = new ArrayDeque();
    private FileDesc lastFile;
    private Error _errorCode = Error.SORT000U;
    private String _errorDesc;
    private int cobErrno;
    private boolean merge;
    private int maxRecLenFound;
    private final SortKey sortFields = new SortKey();
    private DynamicSort sortImpl;
    private PicX sortRecord;
    private String sortPath = "";
    private boolean include;
    private boolean omit;
    private int condFormat = 1;

    public IsSort(Reader reader) {
        this.tokens = IsSort.tokenizer(reader);
        try {
            this.parse();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.setErrorCode(Error.SORT015U, "unexpected commands end");
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        if (this.maxRecLenFound <= 0) {
            this.setErrorCode(Error.SORT015U, "no record description found");
            return;
        }
        this.process();
    }

    private boolean setErrorCode(Error error, String string) {
        this._errorCode = error;
        this._errorDesc = string;
        return false;
    }

    public boolean hasErrors() {
        return this._errorCode.code != 0;
    }

    public Error getErrorCode() {
        return this._errorCode;
    }

    public String getErrorDesc() {
        return this._errorDesc;
    }

    public void buildFileArray(ArrayList<FileDesc> arrayList, CobolFile[] cobolFileArray, ICobolVar[] iCobolVarArray) {
        int n2 = 0;
        for (FileDesc fileDesc : arrayList) {
            if (fileDesc.recMax == 0) {
                fileDesc.recMax = this.maxRecLenFound;
                fileDesc.recLen = this.maxRecLenFound;
            }
            CobolVarHelper cobolVarHelper = new CobolVarHelper("all", 66).picX("record", fileDesc.recMax).picX("name", fileDesc.name.length());
            ICobolVar iCobolVar = cobolVarHelper.get("record");
            ICobolVar iCobolVar2 = cobolVarHelper.get("name");
            iCobolVar2.set(fileDesc.name);
            iCobolVarArray[n2] = iCobolVar2;
            switch (fileDesc.org) {
                case 1: {
                    cobolFileArray[n2] = new IndexFile(fileDesc.name, fileDesc.recMax, iCobolVar, fileDesc.recLen, false, 1);
                    if (fileDesc.keys.size() <= 0) break;
                    int n3 = fileDesc.keys.size();
                    PicX[] picXArray = new PicX[n3];
                    int n4 = 0;
                    boolean bl = false;
                    for (KeyDesc keyDesc : fileDesc.keys) {
                        if (keyDesc.type != 5) {
                            if (n4 > 0) {
                                CobolVar[] cobolVarArray = new PicX[n4];
                                for (int i2 = 0; i2 < n4; ++i2) {
                                    cobolVarArray[i2] = picXArray[i2];
                                }
                                cobolFileArray[n2].key(cobolVarArray, bl);
                                n4 = 0;
                            }
                            bl = keyDesc.type == 2 || keyDesc.type == 4;
                        }
                        picXArray[n4++] = new PicX((byte[])null, keyDesc.offset, keyDesc.length, null, null, null, false, false);
                    }
                    CobolVar[] cobolVarArray = new PicX[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        cobolVarArray[i3] = picXArray[i3];
                    }
                    cobolFileArray[n2].key(cobolVarArray, bl);
                    break;
                }
                case 2: {
                    cobolFileArray[n2] = new RelativeDFile(fileDesc.name, fileDesc.recMax, iCobolVar, fileDesc.recLen, false, 1);
                    break;
                }
                case 3: {
                    if (fileDesc.recLen == fileDesc.recMax) {
                        cobolFileArray[n2] = new SequentialDFile(fileDesc.name, fileDesc.recMax, iCobolVar, fileDesc.recLen, false, 1);
                        break;
                    }
                    cobolFileArray[n2] = new SeqVarLenFile(fileDesc.name, fileDesc.recMax, iCobolVar, fileDesc.recLen, false);
                    break;
                }
                case 4: {
                    cobolFileArray[n2] = new LineSequentialDFile(fileDesc.name, fileDesc.recMax, iCobolVar, fileDesc.recLen, false, 1);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown file type " + fileDesc.org);
                }
            }
            ++n2;
        }
    }

    public void initSort() {
        int n2;
        this.sortRecord = new PicX(new byte[this.maxRecLenFound], 0, this.maxRecLenFound, null, null, null, false, false);
        this.sortImpl = new DynamicJavaSort();
        CobolFile[] cobolFileArray = new CobolFile[this.use.size()];
        ICobolVar[] iCobolVarArray = new ICobolVar[this.use.size()];
        CobolFile[] cobolFileArray2 = new CobolFile[this.give.size()];
        ICobolVar[] iCobolVarArray2 = new ICobolVar[this.give.size()];
        if (cobolFileArray.length > 0) {
            this.buildFileArray(this.use, cobolFileArray, iCobolVarArray);
        }
        if (cobolFileArray2.length > 0) {
            this.buildFileArray(this.give, cobolFileArray2, iCobolVarArray2);
        }
        if (this.omit || this.include) {
            try {
                if (this.merge) {
                    this.sortImpl.initMerge(this.sortPath, this.sortRecord, this.sortFields, null, null, cobolFileArray2, iCobolVarArray2);
                } else {
                    this.sortImpl.initSort(this.sortPath, this.sortRecord, this.sortFields, null, null, cobolFileArray2, iCobolVarArray2);
                }
                n2 = this.processFiles(cobolFileArray, iCobolVarArray);
            }
            catch (CobolIOException cobolIOException) {
                n2 = 0;
                this.setErrorCode(Error.SORT100U, cobolIOException.getMessage());
            }
        } else {
            try {
                n2 = this.merge ? this.sortImpl.initMerge(this.sortPath, this.sortRecord, this.sortFields, cobolFileArray, iCobolVarArray, cobolFileArray2, iCobolVarArray2) : this.sortImpl.initSort(this.sortPath, this.sortRecord, this.sortFields, cobolFileArray, iCobolVarArray, cobolFileArray2, iCobolVarArray2);
            }
            catch (CobolIOException cobolIOException) {
                n2 = 0;
                this.setErrorCode(Error.SORT100U, cobolIOException.getMessage());
            }
        }
        if (n2 != 1) {
            this.setErrorCode(Error.SORT100U, "system error: permanent I/O error");
        }
    }

    private int processFiles(CobolFile[] cobolFileArray, ICobolVar[] iCobolVarArray) {
        RpnEvaluator rpnEvaluator = new RpnEvaluator(this.rpnCond.size(), null);
        int n2 = 1;
        for (CondDesc condDesc : this.rpnCond) {
            Object object;
            if (condDesc.op == 10) {
                rpnEvaluator.addAnd();
                continue;
            }
            if (condDesc.op == 11) {
                rpnEvaluator.addOr();
                continue;
            }
            if (condDesc.leftType == 16) {
                if (condDesc.rightType != 16) continue;
                if (condDesc.cData != null) {
                    object = condDesc.cData.getBytes();
                    rpnEvaluator.addByteCompare(this.sortRecord.getMemory(), condDesc.leftOffset, condDesc.getEnumOp(), (byte[])object, 0, Math.min(condDesc.leftLength, ((byte[])object).length));
                    continue;
                }
                rpnEvaluator.addByteCompare(this.sortRecord.getMemory(), condDesc.leftOffset, condDesc.getEnumOp(), this.sortRecord.getMemory(), (int)condDesc.rightValueOrOffset, Math.min(condDesc.leftLength, condDesc.rightLength));
                continue;
            }
            if (condDesc.leftType == -2) {
                if (condDesc.cData != null) {
                    object = condDesc.cData.getBytes();
                    if (condDesc.leftLength > ((byte[])object).length) {
                        rpnEvaluator.addSubstringFaster(this.sortRecord.getMemory(), condDesc.leftOffset, condDesc.leftLength, condDesc.getEnumOp(), (byte[])object);
                        continue;
                    }
                    rpnEvaluator.addSubstringSearch((byte[])object, 0, ((byte[])object).length, condDesc.getEnumOp(), this.sortRecord.getMemory(), condDesc.leftOffset, condDesc.leftLength);
                    continue;
                }
                if (condDesc.leftLength > condDesc.rightLength) {
                    rpnEvaluator.addSubstringSearch(this.sortRecord.getMemory(), condDesc.leftOffset, condDesc.leftLength, condDesc.getEnumOp(), this.sortRecord.getMemory(), (int)condDesc.rightValueOrOffset, condDesc.rightLength);
                    continue;
                }
                rpnEvaluator.addSubstringSearch(this.sortRecord.getMemory(), (int)condDesc.rightValueOrOffset, condDesc.rightLength, condDesc.getEnumOp(), this.sortRecord.getMemory(), condDesc.leftOffset, condDesc.leftLength);
                continue;
            }
            object = this.getNumericVar(this.sortRecord, condDesc.leftType, condDesc.leftOffset, condDesc.leftLength);
            if (condDesc.rightLength > 0) {
                NumericVar numericVar = this.getNumericVar(this.sortRecord, condDesc.rightType, (int)condDesc.rightValueOrOffset, condDesc.rightLength);
                rpnEvaluator.addVarCompare((NumericVar)object, condDesc.getEnumOp(), numericVar);
                continue;
            }
            rpnEvaluator.addVarIntCompare((NumericVar)object, condDesc.getEnumOp(), condDesc.rightValueOrOffset);
        }
        if (cobolFileArray != null && cobolFileArray.length > 0) {
            for (int i2 = 0; i2 < cobolFileArray.length; ++i2) {
                try {
                    cobolFileArray[i2].open(iCobolVarArray[i2], 1, 1);
                    while (n2 == 1) {
                        int n3 = cobolFileArray[i2].readNext(false, this.sortRecord);
                        if (this.include) {
                            if (!rpnEvaluator.evaluate()) continue;
                            n2 = this.sortImpl.releaseRecord(n3);
                            continue;
                        }
                        if (this.omit) {
                            if (rpnEvaluator.evaluate()) continue;
                            n2 = this.sortImpl.releaseRecord(n3);
                            continue;
                        }
                        n2 = this.sortImpl.releaseRecord(n3);
                    }
                }
                catch (AtEndException atEndException) {
                    // empty catch block
                }
                cobolFileArray[i2].close();
            }
            if (n2 == 1) {
                n2 = this.sortImpl.endInput();
            }
        }
        return n2;
    }

    private void process() {
        this.initSort();
    }

    private void parse() throws NoSuchElementException {
        while (!this.tokens.isEmpty()) {
            String string = this.tokens.pop().toLowerCase();
            if (string.equals("merge")) {
                this.merge = true;
                if (this.fields()) continue;
                return;
            }
            if (string.equals("sort")) {
                this.merge = false;
                if (this.fields()) continue;
                return;
            }
            if (string.equals("use")) {
                string = this.tokens.pop();
                this.lastFile = new FileDesc(string);
                this.use.add(this.lastFile);
                continue;
            }
            if (string.equals("give")) {
                string = this.tokens.pop();
                this.lastFile = new FileDesc(string);
                this.give.add(this.lastFile);
                continue;
            }
            if (string.equals("org")) {
                if (this.lastFile == null) {
                    this.setErrorCode(Error.SORT015U, "org with no use/give");
                    return;
                }
                string = this.tokens.pop().toLowerCase();
                if (string.equals("ix")) {
                    this.lastFile.org = 1;
                    continue;
                }
                if (string.equals("rl")) {
                    this.lastFile.org = 2;
                    continue;
                }
                if (string.equals("sq")) {
                    this.lastFile.org = 3;
                    continue;
                }
                if (string.equals("ls")) {
                    this.lastFile.org = 4;
                    continue;
                }
                this.setErrorCode(Error.SORT015U, "unknown org `" + string + "`");
                return;
            }
            if (string.equals("record")) {
                if (this.lastFile == null) {
                    this.setErrorCode(Error.SORT015U, "record with no use/give");
                    return;
                }
                if (this.record()) continue;
                return;
            }
            if (string.equals("key")) {
                if (this.lastFile == null) {
                    this.setErrorCode(Error.SORT015U, "key with no use/give");
                    return;
                }
                if (this.key()) continue;
                return;
            }
            if (string.equals("omit")) {
                if (this.omit || this.include) {
                    this.setErrorCode(Error.SORT015U, "only 1 omit/include clause allowed");
                    return;
                }
                this.omit = true;
                if (!this.cond()) continue;
                return;
            }
            if (string.equals("include")) {
                if (this.omit || this.include) {
                    this.setErrorCode(Error.SORT015U, "only 1 omit/include clause allowed");
                    return;
                }
                this.include = true;
                if (this.cond()) continue;
                return;
            }
            this.setErrorCode(Error.SORT015U, "unexpected token `" + string + "`");
            return;
        }
    }

    private String skipComma() throws NoSuchElementException {
        String string = this.tokens.pop();
        if (",".equals(string)) {
            string = this.tokens.pop();
        }
        return string;
    }

    private boolean eatComma() throws NoSuchElementException {
        String string = this.tokens.pop();
        return this.checkComma(string);
    }

    private boolean checkComma(String string) throws NoSuchElementException {
        if (!",".equals(string)) {
            return this.setErrorCode(Error.SORT015U, "expected `,`, found `" + string + "`");
        }
        return true;
    }

    private NumericVar getNumericVar(PicX picX, int n2, int n3, int n4) {
        NumericVar numericVar;
        switch (n2) {
            case 1: {
                numericVar = new PicDisplay(picX, n3, n4, 0, false, null, null, null, 0, false, false, false);
                break;
            }
            case 5: {
                numericVar = new PicDisplay(picX, n3, n4, 0, true, null, null, null, 0, false, true, false);
                break;
            }
            case 3: {
                numericVar = new PicDisplay(picX, n3, n4, 0, true, null, null, null, 0, false, false, false);
                break;
            }
            case 4: {
                numericVar = new PicDisplay(picX, n3, n4, 0, true, null, null, null, 0, true, true, false);
                break;
            }
            case 2: {
                numericVar = new PicDisplay(picX, n3, n4, 0, true, null, null, null, 0, true, false, false);
                break;
            }
            case 12: {
                numericVar = new Pic9Comp_4(picX, n3, n4, false, 0, 0, null, null, null, false, true);
                break;
            }
            case 11: {
                numericVar = new Pic9Comp_4(picX, n3, n4, true, 0, 0, null, null, null, false, true);
                break;
            }
            case 14: {
                numericVar = new Pic9Comp_5(picX, n3, n4, false, 0, 0, null, null, null, false, true);
                break;
            }
            case 13: {
                numericVar = new Pic9Comp_5(picX, n3, n4, true, 0, 0, null, null, null, false, true);
                break;
            }
            case 10: {
                numericVar = new Pic9Comp_6((CobolVar)picX, n3, n4 * 2, 0, null, null, null, false);
                break;
            }
            case 8: {
                numericVar = new Pic9Comp_3((CobolVar)picX, n3, n4 * 2 - 1, 0, true, null, null, null, 0, false);
                break;
            }
            case 15: {
                numericVar = new PicNativeFloat(picX, n3, n4, null, null, null, false);
                break;
            }
            default: {
                throw new RuntimeException("Internal error: unhandled type=" + n2);
            }
        }
        return numericVar;
    }

    private int getType(String string) {
        if ((string = string.toLowerCase()).equals("bi") || string.equals("cx")) {
            return 12;
        }
        if (string.equals("c5")) {
            return 14;
        }
        if (string.equals("c6")) {
            return 10;
        }
        if (string.equals("ch")) {
            return 16;
        }
        if (string.equals("fl")) {
            return 15;
        }
        if (string.equals("li")) {
            return 5;
        }
        if (string.equals("ls")) {
            return 4;
        }
        if (string.equals("nu")) {
            return 1;
        }
        if (string.equals("pd")) {
            return 8;
        }
        if (string.equals("sb")) {
            return 11;
        }
        if (string.equals("s5")) {
            return 13;
        }
        if (string.equals("zd") || string.equals("ti")) {
            return 3;
        }
        if (string.equals("ts")) {
            return 2;
        }
        if (string.equals("ss")) {
            return -2;
        }
        return -1;
    }

    private boolean cond() throws NoSuchElementException {
        String string = this.tokens.pop();
        if ("format".equals(string.toLowerCase())) {
            string = this.tokens.pop();
            if ("=".equals(string)) {
                string = this.tokens.pop();
            }
            this.condFormat = this.getType(string);
            if (this.condFormat == -1) {
                return this.setErrorCode(Error.SORT015U, "unknown type `" + string + "`");
            }
            string = this.skipComma();
        }
        if ("cond".equals(string.toLowerCase())) {
            string = this.tokens.pop();
            if (!"=".equals(string)) {
                this.tokens.push(string);
            }
            if (this.condition()) {
                if (!this.tokens.isEmpty()) {
                    string = this.tokens.pop();
                    if ("format".equals(string.toLowerCase())) {
                        string = this.tokens.pop();
                        if ("=".equals(string)) {
                            string = this.tokens.pop();
                        }
                        this.condFormat = this.getType(string);
                        if (this.condFormat == -1) {
                            return this.setErrorCode(Error.SORT015U, "unknown type `" + string + "`");
                        }
                    } else {
                        string = this.tokens.pop();
                    }
                }
                for (CondDesc condDesc : this.rpnCond) {
                    if (condDesc.leftType == -1) {
                        condDesc.leftType = this.condFormat;
                    }
                    if (condDesc.rightType == -1) {
                        condDesc.rightType = this.condFormat;
                    }
                    if (condDesc.leftType == 15 && condDesc.leftLength != 4 && condDesc.leftLength != 8) {
                        return this.setErrorCode(Error.SORT015U, "length must be 4 or 8 for floating point numbers");
                    }
                    if (condDesc.rightType != 15 || condDesc.rightLength == 4 || condDesc.rightLength == 8) continue;
                    return this.setErrorCode(Error.SORT015U, "length must be 4 or 8 for floating point numbers");
                }
                return true;
            }
            return false;
        }
        return this.setErrorCode(Error.SORT015U, "unexpected token `" + string + "`");
    }

    private boolean condition() throws NoSuchElementException {
        this.operand(this.tokens.pop());
        this.operator(0);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean operand(String string) throws NoSuchElementException {
        int n2;
        int n3;
        int n4;
        if (string.equals("(")) {
            this.condition();
            string = this.skipComma();
            if (string.equals(")")) return true;
            return this.setErrorCode(Error.SORT015U, "expected parenthesis, found `" + string + "`");
        }
        long l2 = 0L;
        int n5 = -99;
        int n6 = -99;
        String string2 = null;
        try {
            n4 = Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
        }
        string = this.skipComma();
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
        }
        string = this.skipComma();
        int n7 = this.getType(string);
        if (n7 != -1) {
            string = this.skipComma();
        }
        if ((string = string.toLowerCase()).equals("eq")) {
            n2 = 1;
        } else if (string.equals("ne")) {
            n2 = 2;
        } else if (string.equals("gt")) {
            n2 = 3;
        } else if (string.equals("lt")) {
            n2 = 4;
        } else if (string.equals("ge")) {
            n2 = 5;
        } else {
            if (!string.equals("le")) return this.setErrorCode(Error.SORT015U, "unknown logical operator `" + string + "`");
            n2 = 6;
        }
        if (n7 == -2) {
            if (n2 != 1 && n2 != 2) {
                return this.setErrorCode(Error.SORT015U, "Only either `eq` or `ne` are allowed with type `ss`");
            }
            string = this.skipComma();
            if (!"c".equals(string.toLowerCase())) return this.setErrorCode(Error.SORT015U, "Only `c'<string>'` supported with type `ss`");
            string2 = this.skipComma();
        } else {
            string = this.skipComma();
            if ("c".equals(string.toLowerCase())) {
                string2 = this.skipComma();
                n6 = 16;
            } else {
                try {
                    l2 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
                }
                if (!this.tokens.isEmpty()) {
                    string = this.skipComma();
                    try {
                        n5 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n5 = -99;
                    }
                    if (n5 == -99) {
                        this.tokens.push(string);
                    } else {
                        --l2;
                        if (!this.tokens.isEmpty() && (n6 = this.getType(string = this.skipComma())) < 0) {
                            this.tokens.push(string);
                        }
                    }
                }
            }
        }
        this.rpnCond.add(new CondDesc(n4, n3, n7, n2, l2, n5, n6, string2));
        return true;
    }

    int getPrio(String string) {
        switch (CondDesc.getOp(string)) {
            case 11: {
                return 3;
            }
            case 10: {
                return 6;
            }
        }
        return 99;
    }

    private boolean operator(int n2) throws NoSuchElementException {
        if (!this.tokens.isEmpty()) {
            String string = this.skipComma();
            int n3 = this.getPrio(string);
            if (n3 == 99) {
                this.tokens.push(string);
            } else if (n2 >= n3) {
                this.tokens.push(string);
            } else {
                this.operand(this.skipComma());
                if (!this.tokens.isEmpty()) {
                    String string2 = this.skipComma();
                    int n4 = this.getPrio(string2);
                    this.tokens.push(string2);
                    if (n4 == 99) {
                        this.rpnCond.add(new CondDesc(string));
                    } else if (n4 > n3) {
                        this.operator(n3);
                        this.rpnCond.add(new CondDesc(string));
                        this.operator(n2);
                    } else {
                        this.rpnCond.add(new CondDesc(string));
                        this.operator(n2);
                    }
                } else {
                    this.rpnCond.add(new CondDesc(string));
                }
            }
        }
        return true;
    }

    private boolean fields() throws NoSuchElementException {
        String string = this.tokens.pop();
        if ("fields".equals(string.toLowerCase())) {
            string = this.tokens.pop();
            if ("=".equals(string)) {
                string = this.tokens.pop();
            }
            if ("(".equals(string)) {
                ArrayList<SortKeyItem> arrayList = new ArrayList<SortKeyItem>();
                string = ",";
                do {
                    boolean bl;
                    int n2;
                    int n3;
                    if (!this.checkComma(string)) {
                        return false;
                    }
                    string = this.tokens.pop();
                    try {
                        n3 = Integer.parseInt(string) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
                    }
                    if (!this.eatComma()) {
                        return false;
                    }
                    string = this.tokens.pop();
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
                    }
                    if (!this.eatComma()) {
                        return false;
                    }
                    string = this.tokens.pop();
                    int n4 = this.getType(string);
                    if (n4 < 0) {
                        return this.setErrorCode(Error.SORT002U, "not nupported `" + string + "`");
                    }
                    if (!this.eatComma()) {
                        return false;
                    }
                    string = this.tokens.pop();
                    if ("a".equals(string.toLowerCase())) {
                        bl = false;
                    } else if ("d".equals(string.toLowerCase())) {
                        bl = true;
                    } else {
                        return this.setErrorCode(Error.SORT015U, "expected `a` or `d`, found `" + string + "`");
                    }
                    arrayList.add(new SortKeyItem(bl, n4, n3, n2, 0, this.sortFields));
                } while (!")".equals(string = this.tokens.pop()));
                SortKeyItem[] sortKeyItemArray = new SortKeyItem[arrayList.size()];
                arrayList.toArray(sortKeyItemArray);
                this.sortFields.keyArray = sortKeyItemArray;
                return true;
            }
        }
        return this.setErrorCode(Error.SORT015U, "unexpected token `" + string + "`");
    }

    private boolean key() throws NoSuchElementException {
        int n2 = 0;
        String string = this.tokens.pop();
        if ("=".equals(string)) {
            string = this.tokens.pop();
        }
        if ("(".equals(string)) {
            string = ",";
            int n3 = 0;
            do {
                int n4;
                int n5;
                if (!this.checkComma(string)) {
                    return false;
                }
                string = this.tokens.pop();
                try {
                    n5 = Integer.parseInt(string) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
                }
                if (!this.eatComma()) {
                    return false;
                }
                string = this.tokens.pop();
                try {
                    n4 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
                }
                if (!this.eatComma()) {
                    return false;
                }
                string = this.tokens.pop();
                if ((string = string.toLowerCase()).equals("p")) {
                    n2 = 1;
                } else {
                    if (string.equals("pd")) {
                        return this.setErrorCode(Error.SORT002U, "key type `" + string + "`");
                    }
                    if (string.equals("a")) {
                        n2 = 3;
                    } else if (string.equals("ad")) {
                        n2 = 4;
                    } else if (string.equals("c")) {
                        n2 = 5;
                    } else {
                        return this.setErrorCode(Error.SORT015U, "unexpected key type `" + string + "`");
                    }
                }
                if (n3 == 0) {
                    if (n2 != 1) {
                        return this.setErrorCode(Error.SORT015U, "the first key must be declared as primary");
                    }
                } else if (n2 == 1) {
                    return this.setErrorCode(Error.SORT015U, "only the first key can be declared as primary");
                }
                this.lastFile.keys.add(new KeyDesc(n5, n4, n2));
                ++n3;
            } while (!")".equals(string = this.tokens.pop()));
            return true;
        }
        return this.setErrorCode(Error.SORT015U, "unexpected token `" + string + "`");
    }

    private boolean record() throws NoSuchElementException {
        int n2;
        int n3;
        int n4 = 102;
        String string = this.tokens.pop();
        if ("f".equals(string.toLowerCase())) {
            n4 = 102;
        } else if ("v".equals(string.toLowerCase())) {
            n4 = 118;
        } else {
            return this.setErrorCode(Error.SORT015U, "expected `f` or `v`, found `" + string + "`");
        }
        string = this.tokens.pop();
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
        }
        if (n4 == 118) {
            string = this.tokens.pop();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return this.setErrorCode(Error.SORT015U, "expected integer, found `" + string + "`");
            }
        } else {
            n2 = n3;
        }
        this.lastFile.format = (char)n4;
        this.lastFile.recLen = n3;
        this.lastFile.recMax = n2;
        if (n2 > this.maxRecLenFound) {
            this.maxRecLenFound = n2;
        }
        return true;
    }

    private static void debug(String string) {
        System.out.println(string);
    }

    private static void exit(Error error, String string) {
        if (error == Error.SORT015U && string == null) {
            System.err.println("");
            System.err.println("usage: java IsSort -v");
            System.err.println("       java IsSort <instructions>");
            System.err.println("       java IsSort take <filename>");
            System.err.println("");
        } else if (error.code != 0) {
            System.err.print("Error " + error.code + " - " + error.mesg);
            if (string != null) {
                System.err.println(": " + string);
            } else {
                System.err.println("");
            }
        }
        System.exit(error.code);
    }

    private static void exit(Error error) {
        IsSort.exit(error, null);
    }

    public static void main(String[] stringArray) {
        IsSort isSort;
        if (stringArray.length == 0) {
            IsSort.exit(Error.SORT015U);
        }
        if ("-v".equalsIgnoreCase(stringArray[0])) {
            String string = RuntimeProperties.getFullVersionNumber();
            if (string.startsWith("isCOBOL")) {
                string = "isCOBOL-Sort" + string.substring(7);
            }
            System.out.println(string);
            return;
        }
        if ("take".equalsIgnoreCase(stringArray[0])) {
            if (stringArray.length == 2) {
                FileReader fileReader;
                try {
                    fileReader = new FileReader(stringArray[1]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IsSort.exit(Error.SORT015U, fileNotFoundException.getMessage());
                    fileReader = null;
                }
                isSort = new IsSort(fileReader);
            } else {
                IsSort.exit(Error.SORT015U);
                isSort = null;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[i2]);
            }
            isSort = new IsSort(new StringReader(stringBuilder.toString()));
        }
        IsSort.exit(isSort.getErrorCode(), isSort.getErrorDesc());
    }

    private static ArrayDeque<String> tokenizer(Reader reader) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        boolean bl = true;
        int n2 = 2;
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = 1;
        int n7 = 0;
        StringBuilder stringBuilder = null;
        try {
            int n8;
            block40: while ((n8 = reader.read()) >= 0) {
                switch (n8) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 26: 
                    case 32: {
                        switch (n6) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 4: {
                                arrayDeque.add(stringBuilder.toString());
                                stringBuilder = null;
                                n6 = 1;
                                break;
                            }
                            case 3: {
                                stringBuilder.append((char)n8);
                                break;
                            }
                            case 5: {
                                if (n8 != 10) break;
                                n6 = 1;
                            }
                        }
                        continue block40;
                    }
                    case 40: 
                    case 41: 
                    case 44: 
                    case 61: {
                        switch (n6) {
                            case 1: {
                                arrayDeque.add(Character.toString((char)n8));
                                break;
                            }
                            case 2: 
                            case 4: {
                                arrayDeque.add(stringBuilder.toString());
                                stringBuilder = null;
                                arrayDeque.add(Character.toString((char)n8));
                                n6 = 1;
                                break;
                            }
                            case 3: {
                                stringBuilder.append((char)n8);
                                break;
                            }
                        }
                        continue block40;
                    }
                    case 42: {
                        switch (n6) {
                            case 1: {
                                n6 = 5;
                                break;
                            }
                            case 2: 
                            case 4: {
                                arrayDeque.add(stringBuilder.toString());
                                stringBuilder = null;
                                n6 = 5;
                                break;
                            }
                            case 3: {
                                stringBuilder.append((char)n8);
                                break;
                            }
                        }
                        continue block40;
                    }
                    case 34: 
                    case 39: {
                        switch (n6) {
                            case 2: {
                                arrayDeque.add(stringBuilder.toString());
                            }
                            case 1: {
                                stringBuilder = new StringBuilder();
                                n6 = 3;
                                n7 = n8;
                                break;
                            }
                            case 3: {
                                if (n8 == n7) {
                                    n6 = 4;
                                    break;
                                }
                                stringBuilder.append((char)n8);
                                break;
                            }
                            case 4: {
                                if (n8 == n7) {
                                    stringBuilder.append((char)n8);
                                    n6 = 3;
                                    break;
                                }
                                arrayDeque.add(stringBuilder.toString());
                                stringBuilder = new StringBuilder();
                                n6 = 3;
                                n7 = n8;
                                break;
                            }
                        }
                        continue block40;
                    }
                }
                switch (n6) {
                    case 1: {
                        stringBuilder = new StringBuilder(Character.toString((char)n8));
                        n6 = 2;
                        break;
                    }
                    case 2: {
                        stringBuilder.append((char)n8);
                        break;
                    }
                    case 4: {
                        arrayDeque.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder(Character.toString((char)n8));
                        n6 = 2;
                        break;
                    }
                    case 3: {
                        stringBuilder.append((char)n8);
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        switch (n6) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                arrayDeque.add(stringBuilder.toString());
                break;
            }
        }
        return arrayDeque;
    }

    public static enum Error {
        SORT002U(2, "Unsupported feature"),
        SORT015U(15, "Command statement error(s) detected"),
        SORT100U(100, "I/O error"),
        SORT000U(0, "Success");

        public final int code;
        public final String mesg;

        private Error(int n3, String string2) {
            this.code = n3;
            this.mesg = string2;
        }
    }

    private static class CondDesc {
        static final int INVALID_OP = -1;
        static final int EQ = 1;
        static final int NE = 2;
        static final int GT = 3;
        static final int LT = 4;
        static final int GE = 5;
        static final int LE = 6;
        static final int AND = 10;
        static final int OR = 11;
        final int leftOffset;
        final int leftLength;
        int leftType;
        final int op;
        final long rightValueOrOffset;
        final int rightLength;
        int rightType;
        final String cData;

        static int getOp(String string) {
            if ((string = string.toLowerCase()).equals("|") || string.equals("or")) {
                return 11;
            }
            if (string.equals("&") || string.equals("and")) {
                return 10;
            }
            return -1;
        }

        CondDesc(String string) {
            this.leftOffset = -1;
            this.leftLength = -1;
            this.leftType = -1;
            this.op = CondDesc.getOp(string);
            this.rightValueOrOffset = -1L;
            this.rightLength = -1;
            this.rightType = -1;
            this.cData = null;
            if (this.op == -1) {
                throw new RuntimeException("Internal error: logic op = " + this.op);
            }
        }

        CondDesc(int n2, int n3, int n4, int n5, long l2, int n6, int n7, String string) {
            if (n5 != 1 && n5 != 2 && n5 != 3 && n5 != 4 && n5 != 5 && n5 != 6) {
                throw new RuntimeException("Internal error: op = " + n5);
            }
            this.leftOffset = n2;
            this.leftLength = n3;
            this.leftType = n4;
            this.op = n5;
            this.rightValueOrOffset = l2;
            this.rightLength = n6;
            this.rightType = n7;
            this.cData = string;
        }

        RpnEvaluator.Operator getEnumOp() {
            switch (this.op) {
                case 1: {
                    return RpnEvaluator.Operator.EQ;
                }
                case 2: {
                    return RpnEvaluator.Operator.NE;
                }
                case 3: {
                    return RpnEvaluator.Operator.GT;
                }
                case 4: {
                    return RpnEvaluator.Operator.LT;
                }
                case 5: {
                    return RpnEvaluator.Operator.GE;
                }
                case 6: {
                    return RpnEvaluator.Operator.LE;
                }
            }
            return null;
        }

        public String toString() {
            String string;
            if (this.op == 11) {
                string = "OR";
            } else if (this.op == 10) {
                string = "AND";
            } else {
                String[] stringArray = new String[]{"", "eq", "ne", "gt", "lt", "ge", "le"};
                string = "lOffs=" + this.leftOffset + ",lLen=" + this.leftLength + ",lType=" + this.leftType + ",op=" + stringArray[this.op];
                string = this.rightLength <= 0 ? (this.cData != null ? string + ",cData=" + this.cData : string + ",rValue=" + this.rightValueOrOffset) : string + ",rOffs=" + this.rightValueOrOffset + ",rLen=" + this.rightLength + ",rType=" + this.rightType;
            }
            return string;
        }
    }

    private class FileDesc {
        static final int ORG_IX = 1;
        static final int ORG_RL = 2;
        static final int ORG_SQ = 3;
        static final int ORG_LS = 4;
        final String name;
        char format = (char)102;
        int recLen;
        int recMax;
        int org = 3;
        final ArrayList<KeyDesc> keys = new ArrayList();

        FileDesc(String string) {
            this.name = string;
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.name;
        }
    }

    private class KeyDesc {
        static final int KEY_P = 1;
        static final int KEY_PD = 2;
        static final int KEY_A = 3;
        static final int KEY_AD = 4;
        static final int KEY_C = 5;
        final int offset;
        final int length;
        final int type;

        KeyDesc(int n2, int n3, int n4) {
            if (n4 < 1 || n4 > 5) {
                throw new IllegalArgumentException("Type");
            }
            this.offset = n2;
            this.length = n3;
            this.type = n4;
        }
    }
}

