/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.issort;

import com.iscobol.types.NumericVar;

public class RpnEvaluator {
    static final int[] fixedRight = new int[255];
    final byte[] colSeq;
    private final Condition[] condStack;
    private final boolean[] results;
    private int nItems;

    public RpnEvaluator(int n2, byte[] byArray) {
        if (byArray == null) {
            this.colSeq = new byte[255];
            for (int i2 = 0; i2 < 255; ++i2) {
                this.colSeq[i2] = (byte)i2;
            }
        } else {
            this.colSeq = byArray;
        }
        this.condStack = new Condition[n2];
        this.results = new boolean[n2 > 0 ? n2 : 1];
        this.results[0] = true;
    }

    public void addAnd() {
        this.condStack[this.nItems++] = new And();
    }

    public void addByteCompare(byte[] byArray, int n2, Operator operator, byte[] byArray2, int n3, int n4) {
        this.condStack[this.nItems++] = new ByteCompare(byArray, n2, operator, byArray2, n3, n4);
    }

    public void addSubstringSearch(byte[] byArray, int n2, int n3, Operator operator, byte[] byArray2, int n4, int n5) {
        this.condStack[this.nItems++] = new SubstringSearch(byArray, n2, n3, operator, byArray2, n4, n5);
    }

    public void addSubstringFaster(byte[] byArray, int n2, int n3, Operator operator, byte[] byArray2) {
        this.condStack[this.nItems++] = new SubstringFaster(byArray, n2, n3, operator, byArray2);
    }

    public void addVarCompare(NumericVar numericVar, Operator operator, NumericVar numericVar2) {
        this.condStack[this.nItems++] = new VarCompare(numericVar, operator, numericVar2);
    }

    public void addVarIntCompare(NumericVar numericVar, Operator operator, long l2) {
        this.condStack[this.nItems++] = new VarIntCompare(numericVar, operator, l2);
    }

    public void addOr() {
        this.condStack[this.nItems++] = new Or();
    }

    public boolean evaluate() {
        int n2 = 0;
        block10: for (int i2 = 0; i2 < this.nItems; ++i2) {
            Condition condition = this.condStack[i2];
            switch (condition.op) {
                case EQ: {
                    this.results[n2++] = condition.evaluate() == 0;
                    continue block10;
                }
                case NE: {
                    this.results[n2++] = condition.evaluate() != 0;
                    continue block10;
                }
                case GT: {
                    this.results[n2++] = condition.evaluate() > 0;
                    continue block10;
                }
                case LT: {
                    this.results[n2++] = condition.evaluate() < 0;
                    continue block10;
                }
                case GE: {
                    this.results[n2++] = condition.evaluate() >= 0;
                    continue block10;
                }
                case LE: {
                    this.results[n2++] = condition.evaluate() <= 0;
                    continue block10;
                }
                case AND: {
                    n2 -= 2;
                    int n3 = n2++;
                    this.results[n3] = this.results[n3] & this.results[n2];
                    continue block10;
                }
                case OR: {
                    n2 -= 2;
                    int n4 = n2++;
                    this.results[n4] = this.results[n4] | this.results[n2];
                }
            }
        }
        return this.results[0];
    }

    static {
        for (int i2 = 0; i2 < fixedRight.length; ++i2) {
            RpnEvaluator.fixedRight[i2] = -1;
        }
    }

    public class VarIntCompare
    extends Condition {
        private final NumericVar lVar;
        private final long rVar;

        public VarIntCompare(NumericVar numericVar, Operator operator, long l2) {
            super(operator);
            this.lVar = numericVar;
            this.rVar = l2;
        }

        @Override
        int evaluate() {
            long l2 = this.lVar.tolong() - this.rVar;
            if (l2 == 0L) {
                return 0;
            }
            if (l2 > 0L) {
                return 1;
            }
            return -1;
        }
    }

    public class VarCompare
    extends Condition {
        private final NumericVar lVar;
        private final NumericVar rVar;

        public VarCompare(NumericVar numericVar, Operator operator, NumericVar numericVar2) {
            super(operator);
            this.lVar = numericVar;
            this.rVar = numericVar2;
        }

        @Override
        int evaluate() {
            return this.lVar.compareTo(this.rVar);
        }
    }

    public class SubstringFaster
    extends SubstringSearch {
        public SubstringFaster(byte[] byArray, int n2, int n3, Operator operator, byte[] byArray2) {
            super(byArray, n2, n3, operator, byArray2, 0, byArray2.length);
            System.arraycopy(fixedRight, 0, this.right, 0, fixedRight.length);
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                this.right[byArray2[i2]] = i2;
            }
        }

        @Override
        final int evaluate() {
            return this.intEvaluate();
        }
    }

    public class SubstringSearch
    extends Condition {
        private final byte[] txt;
        private final int tOff;
        private final int tLen;
        private final byte[] pat;
        private final int pOff;
        private final int pLen;
        int[] right;
        private final int myTRUE;
        private final int myFALSE;

        public SubstringSearch(byte[] byArray, int n2, int n3, Operator operator, byte[] byArray2, int n4, int n5) {
            super(operator);
            this.right = new int[255];
            this.txt = byArray;
            this.tOff = n2;
            this.tLen = n3;
            this.pat = byArray2;
            this.pOff = n4;
            this.pLen = n5;
            if (operator == Operator.EQ) {
                this.myTRUE = 0;
                this.myFALSE = -1;
            } else {
                this.myTRUE = -1;
                this.myFALSE = 0;
            }
        }

        @Override
        int evaluate() {
            System.arraycopy(fixedRight, 0, this.right, 0, fixedRight.length);
            for (int i2 = 0; i2 < this.pLen; ++i2) {
                this.right[this.pat[this.pOff + i2]] = i2;
            }
            return this.intEvaluate();
        }

        final int intEvaluate() {
            int n2 = this.myFALSE;
            int n3 = 1;
            int n4 = this.tOff + this.tLen - this.pLen + 1;
            for (int i2 = this.tOff; i2 < n4; i2 += n3) {
                int n5 = this.pOff + this.pLen - 1;
                int n6 = i2 + this.pLen - 1;
                while (n5 >= this.pOff) {
                    if (this.txt[n6] != this.pat[n5]) {
                        n3 = n5 - this.pOff - this.right[this.txt[n6]];
                        if (n3 >= 1) break;
                        n3 = 1;
                        break;
                    }
                    --n5;
                    --n6;
                }
                if (n5 >= this.pOff) continue;
                n2 = this.myTRUE;
                break;
            }
            return n2;
        }
    }

    public class ByteCompare
    extends Condition {
        private final byte[] lRec;
        private final int lOffs;
        private final byte[] rRec;
        private final int rOffs;
        private final int len;

        public ByteCompare(byte[] byArray, int n2, Operator operator, byte[] byArray2, int n3, int n4) {
            super(operator);
            this.lRec = byArray;
            this.lOffs = n2;
            this.rRec = byArray2;
            this.rOffs = n3;
            this.len = n4;
        }

        @Override
        int evaluate() {
            int n2 = this.lOffs + this.len;
            int n3 = this.lOffs;
            int n4 = this.rOffs;
            while (n3 < n2) {
                int n5 = RpnEvaluator.this.colSeq[this.lRec[n3] & 0xFF] - RpnEvaluator.this.colSeq[this.rRec[n4] & 0xFF];
                if (n5 != 0) {
                    return n5;
                }
                ++n3;
                ++n4;
            }
            return 0;
        }
    }

    public class Or
    extends Condition {
        public Or() {
            super(Operator.OR);
        }

        @Override
        int evaluate() {
            return 0;
        }
    }

    public class And
    extends Condition {
        public And() {
            super(Operator.AND);
        }

        @Override
        int evaluate() {
            return 0;
        }
    }

    public abstract class Condition {
        final Operator op;

        Condition(Operator operator) {
            this.op = operator;
        }

        abstract int evaluate();
    }

    public static enum Operator {
        EQ,
        NE,
        GT,
        LT,
        GE,
        LE,
        AND,
        OR;

    }
}

