/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.java;

import com.iscobol.java.CobolVarHelper;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EFDHelper
extends DefaultHandler {
    private Field root;
    private Stack<Field> stack = new Stack();
    private Key key;
    private ArrayList<Key> keys = new ArrayList();

    public EFDHelper(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public EFDHelper(InputStream inputStream) throws IOException {
        SAXParserFactory sAXParserFactory = RtsUtil.newSAXParserFactory();
        sAXParserFactory.setNamespaceAware(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IscobolRuntimeException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("field".equals(string3) || "occurs".equals(string3)) {
            Field field = new Field(attributes);
            if (this.root == null) {
                this.root = field;
            } else {
                this.stack.peek().addChild(field);
            }
            this.stack.push(field);
        } else if ("key".equals(string3)) {
            String string4 = attributes.getValue("duplicate");
            if ("true".equals(string4)) {
                this.key = new Key(true);
                this.keys.add(this.key);
            } else {
                this.key = new Key(false);
                this.keys.add(this.key);
            }
        } else if ("part".equals(string3)) {
            this.key.fields.add(attributes.getValue("name"));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("field".equals(string3) || "occurs".equals(string3)) {
            this.stack.pop();
        }
    }

    public CobolVarHelper getVarHelper(int n2) {
        if (this.root != null) {
            CobolVarHelper cobolVarHelper = new CobolVarHelper("FILLER", n2);
            this.getVarRecur(this.root, cobolVarHelper);
            return cobolVarHelper;
        }
        return null;
    }

    public CobolVarHelper getVarHelper() {
        return this.getVarHelper(0);
    }

    private void getVarRecur(Field field, CobolVarHelper cobolVarHelper) {
        if (field.hasChildren()) {
            cobolVarHelper.group(field.name);
            if (field.number > 0) {
                cobolVarHelper.occurs(field.number);
            }
            Iterator<Field> iterator = field.children();
            while (iterator.hasNext()) {
                this.getVarRecur(iterator.next(), cobolVarHelper);
            }
            cobolVarHelper.endGroup();
        } else {
            switch (field.type) {
                case NumUnsigned: {
                    cobolVarHelper.pic9(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case NumSignSep: {
                    cobolVarHelper.picS9(field.name, field.digits - field.scale, field.scale).signSeparate(true);
                    break;
                }
                case NumSigned: {
                    cobolVarHelper.picS9(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case NumSepLead: {
                    cobolVarHelper.picS9(field.name, field.digits - field.scale, field.scale).signSeparate(true).signLeading(true);
                    break;
                }
                case NumLeading: {
                    cobolVarHelper.picS9(field.name, field.digits - field.scale, field.scale).signLeading(true);
                    break;
                }
                case CompSigned: {
                    cobolVarHelper.picS9Comp2(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case CompUnsigned: {
                    cobolVarHelper.pic9Comp2(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case PackedPositive: {
                    cobolVarHelper.pic9Comp3(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case PackedSigned: {
                    cobolVarHelper.picS9Comp3(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case PackedUnsigned: {
                    cobolVarHelper.pic9Comp6(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case BinarySigned: {
                    if (field.size == 2 && field.digits == 5) {
                        cobolVarHelper.pic9Comp1(field.name);
                        break;
                    }
                    cobolVarHelper.picS9Comp4(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case BinaryUnsigned: {
                    cobolVarHelper.pic9Comp4(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case NativeSigned: {
                    cobolVarHelper.picS9Comp5(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case NativeUnsigned: {
                    cobolVarHelper.pic9Comp5(field.name, field.digits - field.scale, field.scale);
                    break;
                }
                case Float: {
                    if (field.size == 4) {
                        cobolVarHelper.picFloat(field.name);
                        break;
                    }
                    cobolVarHelper.picDouble(field.name);
                    break;
                }
                case National: {
                    cobolVarHelper.picN(field.name, field.size / 2);
                    break;
                }
                default: {
                    cobolVarHelper.picX(field.name, field.size);
                }
            }
        }
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public Key[] getKeys() {
        return this.keys.toArray(new Key[this.keys.size()]);
    }

    public static class Key {
        final boolean dups;
        private final ArrayList<String> fields = new ArrayList();

        private Key(boolean bl) {
            this.dups = bl;
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }

        public boolean duplicates() {
            return this.dups;
        }
    }

    public static class Field {
        final String name;
        final int offset;
        final int size;
        final Type type;
        final int digits;
        final int scale;
        final int number;
        final boolean hidden = false;
        private ArrayList<Field> children;

        Field(Attributes attributes) {
            int n2;
            try {
                n2 = Integer.parseInt(attributes.getValue("size"));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            this.size = n2;
            try {
                n2 = Integer.parseInt(attributes.getValue("number"));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            this.number = n2;
            if (this.number > 0) {
                this.name = "FILLER";
                this.offset = -1;
                this.type = Type.Alphanum;
                this.digits = -1;
                this.scale = -1;
            } else {
                this.name = attributes.getValue("name");
                try {
                    n2 = Integer.parseInt(attributes.getValue("offset"));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                this.offset = n2;
                String string = attributes.getValue("type");
                Type type = Type.Alphanum;
                if (string != null) {
                    for (Type type2 : Type.values()) {
                        if (!string.equals(type2.toString())) continue;
                        type = type2;
                        break;
                    }
                }
                this.type = type;
                try {
                    n2 = Integer.parseInt(attributes.getValue("digits"));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                this.digits = n2;
                try {
                    n2 = Integer.parseInt(attributes.getValue("scale"));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                this.scale = n2;
            }
        }

        void addChild(Field field) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(field);
        }

        boolean hasChildren() {
            return this.children != null;
        }

        Iterator<Field> children() {
            return this.children.iterator();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.number > 0) {
                stringBuilder.append("occurs ");
                stringBuilder.append(this.number);
                stringBuilder.append(";");
                stringBuilder.append(this.size);
            } else {
                stringBuilder.append(this.name);
                stringBuilder.append(" ");
                stringBuilder.append(this.offset);
                stringBuilder.append(";");
                stringBuilder.append(this.size);
                if (this.children != null) {
                    stringBuilder.append(" group");
                } else {
                    stringBuilder.append(";");
                    stringBuilder.append((Object)this.type);
                    stringBuilder.append(";");
                    stringBuilder.append(this.digits);
                    stringBuilder.append(";");
                    stringBuilder.append(this.scale);
                }
            }
            return stringBuilder.toString();
        }
    }

    static enum Type {
        NumUnsigned,
        NumSignSep,
        NumSigned,
        NumSepLead,
        NumLeading,
        CompSigned,
        CompUnsigned,
        PackedPositive,
        PackedSigned,
        PackedUnsigned,
        BinarySigned,
        BinaryUnsigned,
        NativeSigned,
        NativeUnsigned,
        Float,
        Alphanum,
        JavaObject,
        National;

    }
}

