/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class C$DESKTOP
implements IscobolCall {
    public static final int CDESKTOP_BROWSE = 1;
    public static final int CDESKTOP_EDIT = 2;
    public static final int CDESKTOP_MAIL = 3;
    public static final int CDESKTOP_OPEN = 4;
    public static final int CDESKTOP_PRINT = 5;
    private String msg = "";

    @Override
    public Object call(Object[] objectArray) {
        if (objectArray == null) {
            return this.call((CobolVar[])null);
        }
        CobolVar[] cobolVarArray = new CobolVar[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            cobolVarArray[i2] = (CobolVar)objectArray[i2];
        }
        return this.call(cobolVarArray);
    }

    private CobolVar call(CobolVar[] cobolVarArray) {
        int n2 = 0;
        Logger logger = LoggerFactory.get(8);
        if (ScreenUtility.isWD2()) {
            this.msg = "Screen utility is WD2";
            n2 = -1;
        } else if (cobolVarArray != null && cobolVarArray.length >= 2 && cobolVarArray[0] instanceof NumericVar) {
            int n3 = cobolVarArray[0].toint();
            String string = cobolVarArray[1].toString().trim();
            boolean bl = IscobolSystem.isAS() && cobolVarArray.length > 2 && cobolVarArray[2] instanceof NumericVar && cobolVarArray[2].toint() != 0;
            GuiFactory guiFactory = ScreenUtility.getGuiFactory();
            switch (n3) {
                case 1: {
                    n2 = this.desktop1(guiFactory, "BROWSE", string, bl);
                    break;
                }
                case 3: {
                    n2 = this.desktop1(guiFactory, "MAIL", string, bl);
                    break;
                }
                case 4: {
                    n2 = this.desktop2(guiFactory, "OPEN", string, bl);
                    break;
                }
                case 2: {
                    n2 = this.desktop2(guiFactory, "EDIT", string, bl);
                    break;
                }
                case 5: {
                    n2 = this.desktop2(guiFactory, "PRINT", string, bl);
                    break;
                }
                default: {
                    this.msg = "Invalid operation code";
                    break;
                }
            }
        } else {
            this.msg = "Invalid arguments";
            n2 = -2;
        }
        if (logger != null && this.msg.length() > 0) {
            logger.info("C$DESKTOP: errmsg=" + this.msg);
        }
        return NumericVar.literal(n2, false);
    }

    private int desktop1(GuiFactory guiFactory, String string, String string2, boolean bl) {
        if (bl) {
            try {
                return guiFactory.desktop(string, string2);
            }
            catch (IOException iOException) {
                this.msg = iOException.getMessage();
                return -3;
            }
        }
        return ScreenUtility.desktop(string, string2);
    }

    private int desktop2(GuiFactory guiFactory, String string, String string2, boolean bl) {
        if (bl) {
            try {
                File file = new File(string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                return guiFactory.desktop(string, file.getName(), byArray);
            }
            catch (IOException iOException) {
                this.msg = iOException.getMessage();
                return -3;
            }
        }
        return ScreenUtility.desktop(string, string2);
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int n2, int n3) {
    }
}

