/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import com.iscobol.lib.CBLScanDir;
import com.iscobol.rts.Factory;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;

public class CBL_DIR_SCAN_READ
extends CBLScanDir {
    private PicX ENTRY = Factory.getVarAlphanum((byte[])null, 0, 32768, false, null, null, null, "DIR-ENTRY", false, false);
    private NumericVar ATTRIBUTE = Factory.getVarCompN(this.ENTRY, 0, 4, false, null, null, null, "DIR-ATTRIBUTE", false, 10, 0, false, false, false);
    private PicX DATE_STAMP = Factory.getVarAlphanum(this.ENTRY, 4, 59, false, null, null, null, "DIR-DATE-STAMP", false, false);
    private NumericVar YEAR = Factory.getVarCompN(this.DATE_STAMP, 4, 4, false, null, null, null, "DIR-YEAR", false, 10, 0, false, false, false);
    private NumericVar MONTH = Factory.getVarCompN(this.DATE_STAMP, 8, 2, false, null, null, null, "DIR-MONTH", false, 5, 0, false, false, false);
    private NumericVar DAY = Factory.getVarCompN(this.DATE_STAMP, 10, 2, false, null, null, null, "DIR-DAY", false, 5, 0, false, false, false);
    private NumericVar HOUR = Factory.getVarCompN(this.DATE_STAMP, 12, 2, false, null, null, null, "DIR-HOUR", false, 5, 0, false, false, false);
    private NumericVar MINUTE = Factory.getVarCompN(this.DATE_STAMP, 14, 2, false, null, null, null, "DIR-MINUTE", false, 5, 0, false, false, false);
    private NumericVar SECOND = Factory.getVarCompN(this.DATE_STAMP, 16, 2, false, null, null, null, "DIR-SECOND", false, 5, 0, false, false, false);
    private NumericVar MILLISEC = Factory.getVarCompN(this.DATE_STAMP, 18, 2, false, null, null, null, "DIR-MILLISEC", false, 5, 0, false, false, false);
    private NumericVar DST = Factory.getVarCompN(this.DATE_STAMP, 20, 1, false, null, null, null, "DIR-DST", false, 3, 0, false, false, false);
    private NumericVar SIZE = Factory.getVarCompN(this.DATE_STAMP, 21, 8, false, null, null, null, "DIR-SIZE", false, 20, 0, false, false, false);
    private NumericVar NAME_MAX_LEN = Factory.getVarCompN(this.DATE_STAMP, 29, 2, false, null, null, null, "DIR-NAME-MAX-LEN", false, 5, 0, false, false, false);
    private PicX ENTRY_NAME = Factory.getVarAlphanum(this.DATE_STAMP, 31, 32737, false, null, null, null, "DIR-ENTRY-NAME", false, false);

    private long doWork(CobolVar cobolVar, CobolVar cobolVar2) {
        int n2 = cobolVar.toint();
        this.ENTRY.link(cobolVar2);
        int n3 = this.NAME_MAX_LEN.toint();
        CBLScanDir.Entries entries = CBL_DIR_SCAN_READ.getObject(n2);
        if (entries == null) {
            return 2L;
        }
        File file = entries.next();
        if (file == null) {
            return 3L;
        }
        int n4 = 0;
        n4 = file.isFile() ? (n4 |= 1) : (file.isDirectory() ? (n4 |= 2) : (n4 |= 4));
        if (file.canRead()) {
            n4 |= 8;
        }
        if (file.canWrite()) {
            n4 |= 0x10;
        }
        if (file.isHidden()) {
            n4 |= 0x20;
        }
        this.ATTRIBUTE.set(n4);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(file.lastModified()));
        this.YEAR.set(gregorianCalendar.get(1));
        this.MONTH.set(gregorianCalendar.get(2) + 1);
        this.DAY.set(gregorianCalendar.get(5));
        this.HOUR.set(gregorianCalendar.get(11));
        this.MINUTE.set(gregorianCalendar.get(12));
        this.SECOND.set(gregorianCalendar.get(13));
        this.MILLISEC.set(gregorianCalendar.get(14));
        this.DST.set(0);
        this.SIZE.set(file.length());
        String string = entries.getName(file);
        if (n3 >= string.length()) {
            this.ENTRY_NAME.sub(1, Math.min(n3, string.length())).set(string);
        }
        return 0L;
    }

    @Override
    public Object call(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 1) {
            this.RETURN_CODE.set(this.doWork((CobolVar)objectArray[0], (CobolVar)objectArray[1]));
        } else {
            this.RETURN_CODE.set(127L);
        }
        return this.RETURN_CODE;
    }

    @Override
    public final String getName() {
        return "CBL_DIR_SCAN_READ";
    }
}

