/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import java.util.Stack;

public class ExpressionEvaluator {
    public static double evaluate(String string) {
        Stack<Double> stack = new Stack<Double>();
        Stack<Character> stack2 = new Stack<Character>();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ') continue;
            if (c2 >= '0' && c2 <= '9') {
                StringBuilder stringBuilder = new StringBuilder();
                while (i2 < string.length() && string.charAt(i2) >= '0' && string.charAt(i2) <= '9') {
                    stringBuilder.append(string.charAt(i2));
                    ++i2;
                }
                --i2;
                stack.push(Double.parseDouble(stringBuilder.toString()));
                continue;
            }
            if (c2 == '(') {
                stack2.push(Character.valueOf(c2));
                continue;
            }
            if (c2 == ')') {
                while (((Character)stack2.peek()).charValue() != '(') {
                    stack.push(ExpressionEvaluator.applyOperation(((Character)stack2.pop()).charValue(), (Double)stack.pop(), (Double)stack.pop()));
                }
                stack2.pop();
                continue;
            }
            if (c2 != '+' && c2 != '-' && c2 != '*' && c2 != '/') continue;
            while (!stack2.empty() && ExpressionEvaluator.hasPrecedence(c2, ((Character)stack2.peek()).charValue())) {
                stack.push(ExpressionEvaluator.applyOperation(((Character)stack2.pop()).charValue(), (Double)stack.pop(), (Double)stack.pop()));
            }
            stack2.push(Character.valueOf(c2));
        }
        while (!stack2.empty()) {
            stack.push(ExpressionEvaluator.applyOperation(((Character)stack2.pop()).charValue(), (Double)stack.pop(), (Double)stack.pop()));
        }
        return (Double)stack.pop();
    }

    private static boolean hasPrecedence(char c2, char c3) {
        if (c3 == '(' || c3 == ')') {
            return false;
        }
        return c2 != '*' && c2 != '/' || c3 != '+' && c3 != '-';
    }

    private static double applyOperation(char c2, double d2, double d3) {
        switch (c2) {
            case '+': {
                return d3 + d2;
            }
            case '-': {
                return d3 - d2;
            }
            case '*': {
                return d3 * d2;
            }
            case '/': {
                if (d2 == 0.0) {
                    throw new UnsupportedOperationException("Cannot divide by zero");
                }
                return d3 / d2;
            }
        }
        return 0.0;
    }
}

