/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.types_n.PicInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class C$SOCKET
implements IscobolCall,
RuntimeErrorsNumbers {
    private static final int AGS_CREATE_SERVER = 1;
    private static final int AGS_ACCEPT = 2;
    private static final int AGS_CREATE_CLIENT = 3;
    private static final int AGS_CLOSE = 4;
    private static final int AGS_WRITE = 5;
    private static final int AGS_READ = 6;
    private static final int AGS_FLUSH = 7;
    private static final int AGS_EMPTY = 8;
    private static final int AGS_GETHOSTNAME = 9;
    private static final int AGS_LAST_ERROR = 10;
    private static final int AGS_NEXT_READ = 11;
    private static final int AGS_REMOTE_NAME = 12;
    private static final int AGS_REMOTE_ADDR = 13;
    private static final int AGS_READ_LINE = 14;
    private static final int AGS_GETHOSTADDR = 15;
    private static final int AGS_GETSOCKETPORT = 16;
    private static final int GETREMOTEADDRESS = 31;
    private static final int EBADF = 10009;
    private static final int EINVAL = 10022;
    private static final int EADDRINUSE = 10048;
    private static final int ENETUNREACH = 10051;
    private static final int ECONNREFUSED = 10061;
    private static final int EUNKNOWN = 10102;
    private static final int SUCCESS = 0;
    private static final int ERROR = -1;
    private static final int NULL = 0;
    private PicInt returnCode = new PicInt(Memory.getMemory(4), 0, 0, null, null, "", false);
    private Result lastResult;
    private int operationErrorCode;
    private MySocket socket;

    private static String getErrMsg(int n2) {
        switch (n2) {
            case 0: {
                return "Success";
            }
            case 10022: {
                return "Invalid argument";
            }
            case 10009: {
                return "Bad file descriptor";
            }
        }
        return "No description available";
    }

    @Override
    public Object call(Object[] objectArray) {
        Result result;
        this.operationErrorCode = -1;
        this.socket = null;
        if (objectArray != null) {
            ICobolVar[] iCobolVarArray = new ICobolVar[objectArray.length];
            System.arraycopy(objectArray, 0, iCobolVarArray, 0, objectArray.length);
            try {
                result = this.call(iCobolVarArray);
            }
            catch (ClassCastException classCastException) {
                result = new Result(10009);
            }
            catch (BindException bindException) {
                result = new Result(bindException);
            }
            catch (ConnectException connectException) {
                result = new Result(connectException);
            }
            catch (NoRouteToHostException noRouteToHostException) {
                result = new Result(noRouteToHostException);
            }
            catch (PortUnreachableException portUnreachableException) {
                result = new Result(portUnreachableException);
            }
            catch (SocketException socketException) {
                result = new Result(socketException);
            }
            catch (IOException iOException) {
                result = new Result(iOException);
            }
        } else {
            result = new Result(this.operationErrorCode, 10102);
        }
        this.lastResult = result;
        if (this.socket != null) {
            this.socket.setLastResult(this.lastResult);
        }
        this.returnCode.set(this.lastResult.returnCode);
        return this.returnCode;
    }

    public Result call(ICobolVar[] iCobolVarArray) throws IOException {
        Result result;
        switch (iCobolVarArray[0].toint()) {
            case 1: {
                this.operationErrorCode = 0;
                if (iCobolVarArray.length > 1) {
                    int n2 = iCobolVarArray[1].toint();
                    MyServerSocket myServerSocket = new MyServerSocket(n2);
                    int n3 = UserHandles.ssetId(myServerSocket);
                    result = new Result(n3);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 2: {
                this.operationErrorCode = 0;
                if (iCobolVarArray.length > 1) {
                    MyServerSocket myServerSocket = (MyServerSocket)UserHandles.getId(iCobolVarArray[1].toint());
                    if (myServerSocket != null) {
                        int n4 = myServerSocket.accept();
                        result = new Result(n4);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 3: {
                this.operationErrorCode = 0;
                if (iCobolVarArray.length > 2) {
                    int n5 = iCobolVarArray[1].toint();
                    String string = iCobolVarArray[2].toString().trim();
                    this.socket = new MySocket(string, n5);
                    int n6 = UserHandles.ssetId(this.socket);
                    result = new Result(n6);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 4: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 1) {
                    int n7 = iCobolVarArray[1].toint();
                    Object object = UserHandles.getId(n7);
                    if (object instanceof MyServerSocket) {
                        ((MyServerSocket)object).close();
                        result = new Result(0);
                        UserHandles.free(n7);
                        break;
                    }
                    if (object instanceof MySocket) {
                        ((MySocket)object).close();
                        result = new Result(0);
                        UserHandles.free(n7);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 5: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 3) {
                    this.socket = (MySocket)UserHandles.getId(iCobolVarArray[1].toint());
                    if (this.socket != null) {
                        byte[] byArray = iCobolVarArray[2].getBytes();
                        int n8 = iCobolVarArray[3].toint();
                        if (n8 > 0 && n8 <= byArray.length) {
                            this.socket.write(byArray, 0, n8);
                            result = new Result(n8);
                            break;
                        }
                        result = new Result(this.operationErrorCode, 10022);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 6: 
            case 14: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 3) {
                    this.socket = (MySocket)UserHandles.getId(iCobolVarArray[1].toint());
                    if (this.socket != null) {
                        boolean bl;
                        byte[] byArray = null;
                        if (!(iCobolVarArray[2] instanceof IPicAnyLength)) {
                            byArray = new byte[iCobolVarArray[2].length()];
                        }
                        int n9 = iCobolVarArray[3].toint();
                        int n10 = iCobolVarArray.length > 4 ? iCobolVarArray[4].toint() : -1;
                        boolean bl2 = bl = iCobolVarArray[0].toint() == 14;
                        if (n9 > 0) {
                            if (byArray != null) {
                                if (n9 <= byArray.length) {
                                    result = bl ? new Result(this.socket.readLn(byArray, n9, n10)) : new Result(this.socket.read(byArray, n9, n10));
                                    if (result.returnCode < 0) break;
                                    iCobolVarArray[2].set(byArray, 0, result.returnCode, true);
                                    break;
                                }
                                result = new Result(this.operationErrorCode, 10022);
                                break;
                            }
                            byArray = bl ? this.socket.readLn(n9, n10) : this.socket.read(n9, n10);
                            result = new Result(byArray.length);
                            if (result.returnCode < 0) break;
                            iCobolVarArray[2].set(byArray, 0, result.returnCode, true);
                            break;
                        }
                        if (n9 == 0) {
                            result = new Result(this.socket.available());
                            break;
                        }
                        n9 = -n9;
                        if (byArray != null) {
                            if (n9 <= byArray.length) {
                                result = bl ? new Result(this.socket.readLn(byArray, n9, n10)) : new Result(this.socket.read(byArray, n9, n10));
                                if (result.returnCode < 0) break;
                                this.socket.fillBuffer(byArray, 0, result.returnCode, false);
                                iCobolVarArray[2].set(byArray, 0, result.returnCode, true);
                                break;
                            }
                            result = new Result(this.operationErrorCode, 10022);
                            break;
                        }
                        byArray = bl ? this.socket.readLn(n9, n10) : this.socket.read(n9, n10);
                        result = new Result(byArray.length);
                        if (result.returnCode < 0) break;
                        this.socket.fillBuffer(byArray, 0, result.returnCode, false);
                        iCobolVarArray[2].set(byArray, 0, result.returnCode, true);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 7: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 1) {
                    int n11 = iCobolVarArray[1].toint();
                    this.socket = (MySocket)UserHandles.getId(n11);
                    if (this.socket != null) {
                        this.socket.flush();
                        result = new Result(0);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 8: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 2) {
                    int n12 = iCobolVarArray[2].toint();
                    int n13 = iCobolVarArray[1].toint();
                    this.socket = (MySocket)UserHandles.getId(n13);
                    if (this.socket != null) {
                        this.socket.empty(n12);
                        result = new Result(0);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 9: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 1) {
                    iCobolVarArray[1].set(InetAddress.getLocalHost().getHostName());
                    result = new Result(0);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 10: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 1) {
                    Result result2 = null;
                    int n14 = iCobolVarArray[1].toint();
                    if (n14 == 0) {
                        result2 = this.lastResult;
                    } else {
                        n14 = iCobolVarArray[1].toint();
                        this.socket = (MySocket)UserHandles.getId(n14);
                        if (this.socket != null) {
                            result2 = this.socket.getLastResult();
                        }
                    }
                    if (result2 != null) {
                        result = new Result(result2.errorCode);
                        if (iCobolVarArray.length <= 2) break;
                        iCobolVarArray[2].set(result2.errorMsg);
                        break;
                    }
                    result = new Result(0);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 11: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 2) {
                    int n15 = iCobolVarArray[1].toint();
                    MyServerSocket myServerSocket = (MyServerSocket)UserHandles.getId(n15);
                    if (myServerSocket != null) {
                        int n16 = iCobolVarArray[2].toint();
                        int n17 = myServerSocket.select(n16, n15);
                        if (n17 == n15) {
                            myServerSocket.accept();
                            n17 = myServerSocket.select(n16, n15);
                        }
                        result = new Result(n17);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10022);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 12: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 2) {
                    int n18 = iCobolVarArray[1].toint();
                    this.socket = (MySocket)UserHandles.getId(n18);
                    if (this.socket != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                        iCobolVarArray[2].set(inetSocketAddress.getHostName());
                        result = new Result(0);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 13: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 2) {
                    int n19 = iCobolVarArray[1].toint();
                    this.socket = (MySocket)UserHandles.getId(n19);
                    if (this.socket != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                        iCobolVarArray[2].set(this.getIpAddress(inetSocketAddress.getAddress()));
                        result = new Result(0);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 15: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 1) {
                    iCobolVarArray[1].set(this.getIpAddress(InetAddress.getLocalHost()));
                    result = new Result(0);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 16: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 2) {
                    int n20 = iCobolVarArray[1].toint();
                    this.socket = (MySocket)UserHandles.getId(n20);
                    if (this.socket != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                        iCobolVarArray[2].set(inetSocketAddress.getPort());
                        result = new Result(0);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            case 31: {
                this.operationErrorCode = -1;
                if (iCobolVarArray.length > 2) {
                    int n21 = iCobolVarArray[1].toint();
                    this.socket = (MySocket)UserHandles.getId(n21);
                    if (this.socket != null) {
                        Enumeration enumeration = iCobolVarArray[2].getChildren();
                        if (enumeration.hasMoreElements()) {
                            ICobolVar[] iCobolVarArray2 = new ICobolVar[3];
                            for (int i2 = 0; i2 < iCobolVarArray2.length && enumeration.hasMoreElements(); ++i2) {
                                iCobolVarArray2[i2] = (ICobolVar)enumeration.nextElement();
                            }
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socket.socket.getRemoteSocketAddress();
                            if (iCobolVarArray2[0] != null) {
                                iCobolVarArray2[0].set(inetSocketAddress.getHostName());
                            }
                            if (iCobolVarArray2[1] != null) {
                                iCobolVarArray2[1].set(this.getIpAddress(inetSocketAddress.getAddress()));
                            }
                            if (iCobolVarArray2[2] != null) {
                                iCobolVarArray2[2].set(inetSocketAddress.getPort());
                            }
                            result = new Result(0);
                            break;
                        }
                        result = new Result(this.operationErrorCode, 10022);
                        break;
                    }
                    result = new Result(this.operationErrorCode, 10009);
                    break;
                }
                result = new Result(this.operationErrorCode, 10022);
                break;
            }
            default: {
                this.operationErrorCode = -1;
                result = new Result(this.operationErrorCode, 10022);
            }
        }
        return result;
    }

    private String getIpAddress(InetAddress inetAddress) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = inetAddress.getAddress();
        stringBuffer.append(byArray[0] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[1] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[2] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[3] & 0xFF);
        return stringBuffer.toString();
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int n2, int n3) {
    }

    private class Result {
        final int returnCode;
        final int errorCode;
        final String errorMsg;

        Result(int n2, int n3, String string) {
            this.returnCode = n2;
            this.errorCode = n3;
            this.errorMsg = string;
        }

        Result(NoRouteToHostException noRouteToHostException) {
            this(c$SOCKET.operationErrorCode, 10051, noRouteToHostException.toString());
        }

        Result(ConnectException connectException) {
            this(c$SOCKET.operationErrorCode, 10061, connectException.toString());
        }

        Result(BindException bindException) {
            this(c$SOCKET.operationErrorCode, 10048, bindException.toString());
        }

        Result(SocketException socketException) {
            this(c$SOCKET.operationErrorCode, 10102, socketException.toString());
        }

        Result(IOException iOException) {
            this(c$SOCKET.operationErrorCode, 10102, iOException.toString());
        }

        Result(int n2, int n3) {
            this(n2, n3, C$SOCKET.getErrMsg(n3));
        }

        Result(int n2) {
            this(n2, 0);
        }
    }

    static class MySocket {
        private final MyServerSocket server;
        private final Socket socket;
        private final InputStream is;
        private final OutputStream os;
        private byte[] lastRead;
        private Result lastResult;
        private final int maxBufferSize;

        MySocket(Socket socket, MyServerSocket myServerSocket) throws IOException {
            this.server = myServerSocket;
            this.socket = socket;
            this.socket.setTcpNoDelay(Config.b(".csocket.tcp_nodelay", true));
            if (Config.b(".csocket.setkeepalive", false)) {
                this.socket.setKeepAlive(true);
            }
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
            this.maxBufferSize = Config.a(".csocket.maxbuffersize", 4098);
        }

        MySocket(String string, int n2) throws IOException {
            this(new Socket(string, n2), null);
        }

        SocketChannel getChannel() {
            return this.socket.getChannel();
        }

        void write(byte[] byArray, int n2, int n3) throws IOException {
            this.os.write(byArray, n2, n3);
        }

        int available() throws IOException {
            int n2;
            int n3;
            int n4;
            byte[] byArray = new byte[this.maxBufferSize];
            if (this.lastRead != null) {
                if (this.lastRead.length >= this.maxBufferSize) {
                    return this.lastRead.length;
                }
                n4 = this.lastRead.length;
                System.arraycopy(this.lastRead, 0, byArray, 0, n4);
            } else {
                n4 = 0;
            }
            this.socket.setSoTimeout(1);
            try {
                n3 = this.is.read(byArray, n4, this.maxBufferSize - n4);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                n3 = 0;
            }
            if (n3 >= 0) {
                n2 = n3 + n4;
                this.lastRead = new byte[n2];
                System.arraycopy(byArray, 0, this.lastRead, 0, n2);
            } else {
                n2 = 0;
            }
            this.socket.setSoTimeout(0);
            return n2;
        }

        int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.lastRead != null) {
                int n4 = this.lastRead.length;
                if (n4 == n2) {
                    System.arraycopy(this.lastRead, 0, byArray, 0, n2);
                    this.lastRead = null;
                    return n2;
                }
                if (n4 < n2) {
                    System.arraycopy(this.lastRead, 0, byArray, 0, n4);
                    this.lastRead = null;
                    return this._read(byArray, n4, n2 - n4, n3) + n4;
                }
                System.arraycopy(this.lastRead, 0, byArray, 0, n2);
                byte[] byArray2 = new byte[n4 - n2];
                System.arraycopy(this.lastRead, n2, byArray2, 0, byArray2.length);
                this.lastRead = byArray2;
                return n2;
            }
            return this._read(byArray, 0, n2, n3);
        }

        private int findNl(byte[] byArray, int n2, int n3) {
            int n4 = n2 + n3;
            int n5 = n2;
            if (n2 > 0) {
                --n2;
            }
            while (n5 < n4) {
                if (byArray[n5] == 10) {
                    int n6 = n5++;
                    this.fillBuffer(byArray, n5, n4 - n5, true);
                    return n6;
                }
                ++n5;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int _readLn(byte[] byArray, int n2, int n3, int n4) throws IOException {
            int n5 = 0;
            byte[] byArray2 = new byte[n3];
            int n6 = 0;
            if (n4 >= 0) {
                this.socket.setSoTimeout(n4 > 0 ? n4 : 1);
            }
            try {
                for (n6 = 0; n6 < n3 && n5 >= 0; n6 += n5) {
                    n5 = this.is.read(byArray2, n6, n3 - n6);
                    if (n5 >= 0) {
                        int n7 = this.findNl(byArray2, n6, n5);
                        if (n7 < 0) continue;
                        int n8 = n7 = this.cpStripCr(byArray2, 0, byArray, n2, n7);
                        return n8;
                    }
                    int n9 = -1;
                    return n9;
                }
                System.arraycopy(byArray2, 0, byArray, n2, n3);
                int n10 = n3;
                return n10;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n6 > 0) {
                    System.arraycopy(byArray2, 0, byArray, n2, n6);
                    int n11 = n6;
                    return n11;
                }
                int n12 = 0;
                return n12;
            }
            finally {
                if (n4 >= 0) {
                    this.socket.setSoTimeout(0);
                }
            }
        }

        private int cpStripCr(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
            if (n4 > 0) {
                if (byArray[n2 + n4 - 1] == 13) {
                    --n4;
                }
                System.arraycopy(byArray, n2, byArray2, n3, n4);
            }
            return n4;
        }

        int readLn(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            if (this.lastRead != null) {
                byte[] byArray2 = this.lastRead;
                this.lastRead = null;
                int n5 = this.findNl(byArray2, 0, byArray2.length);
                if (n5 >= 0) {
                    n4 = this.cpStripCr(byArray2, 0, byArray, 0, n5);
                } else {
                    int n6 = byArray2.length;
                    if (n6 == n2) {
                        n4 = this.cpStripCr(byArray2, 0, byArray, 0, n2);
                    } else if (n6 < n2) {
                        n6 = this.cpStripCr(byArray2, 0, byArray, 0, n6);
                        n4 = this._readLn(byArray, n6, n2 - n6, n3) + n6;
                    } else {
                        this.cpStripCr(byArray2, 0, byArray, 0, n2);
                        this.lastRead = new byte[n6 - n2];
                        System.arraycopy(byArray2, n2, this.lastRead, 0, this.lastRead.length);
                        n4 = n2;
                    }
                }
            } else {
                n4 = this._readLn(byArray, 0, n2, n3);
            }
            return n4;
        }

        void fillBuffer(byte[] byArray, int n2, int n3, boolean bl) {
            if (this.lastRead == null) {
                this.lastRead = new byte[n3];
                System.arraycopy(byArray, n2, this.lastRead, 0, n3);
            } else {
                byte[] byArray2 = new byte[this.lastRead.length + n3];
                if (bl) {
                    System.arraycopy(this.lastRead, 0, byArray2, 0, this.lastRead.length);
                    System.arraycopy(byArray, n2, byArray2, this.lastRead.length, n3);
                } else {
                    System.arraycopy(byArray, n2, byArray2, 0, n3);
                    System.arraycopy(this.lastRead, 0, byArray2, n3, this.lastRead.length);
                }
                this.lastRead = byArray2;
            }
        }

        private int _read(byte[] byArray, int n2, int n3) throws IOException {
            return this._read(byArray, n2, n3, -1);
        }

        private int _read(byte[] byArray, int n2, int n3, int n4) throws IOException {
            int n5;
            int n6 = 0;
            if (n4 >= 0) {
                this.socket.setSoTimeout(n4 > 0 ? n4 : 1);
            }
            try {
                for (n5 = 0; n5 < n3 && (n6 = this.is.read(byArray, n2 + n5, n3 - n5)) > 0; n5 += n6) {
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            if (n4 >= 0) {
                this.socket.setSoTimeout(0);
            }
            if (n5 == 0) {
                return n6;
            }
            return n5;
        }

        void flush() throws IOException {
            this.os.flush();
            int n2 = this.is.available();
            if (n2 > 0) {
                byte[] byArray = new byte[n2];
                this._read(byArray, 0, n2);
                this.fillBuffer(byArray, 0, n2, true);
            }
        }

        void empty(int n2) throws IOException {
            this.flush();
            if (this.lastRead != null) {
                int n3 = this.lastRead.length;
                if (n3 == n2) {
                    this.lastRead = null;
                } else if (n3 >= n2) {
                    byte[] byArray = new byte[n3 - n2];
                    System.arraycopy(this.lastRead, n2, byArray, 0, n3 - n2);
                    this.lastRead = byArray;
                } else {
                    this.lastRead = null;
                    byte[] byArray = new byte[n2 - n3];
                    this._read(byArray, 0, byArray.length);
                }
            } else {
                byte[] byArray = new byte[n2];
                this._read(byArray, 0, byArray.length);
            }
        }

        void close() throws IOException {
            this.socket.shutdownOutput();
            this.socket.close();
            if (this.server != null) {
                this.server.remove(this.socket);
            }
        }

        void setLastResult(Result result) {
            this.lastResult = result;
        }

        Result getLastResult() {
            return this.lastResult;
        }

        byte[] read(int n2, int n3) throws IOException {
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = this.read(byArray, Math.min(n2, byArray.length), n3);
            while (n4 > 0) {
                byteArrayOutputStream.write(byArray, 0, n4);
                if (n4 == n2 || n4 < byArray.length) break;
                n4 = this.read(byArray, Math.min(n2 -= n4, byArray.length), n3);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }

        byte[] readLn(int n2, int n3) throws IOException {
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = this.readLn(byArray, Math.min(n2, byArray.length), n3);
            while (n4 > 0) {
                byteArrayOutputStream.write(byArray, 0, n4);
                if (n4 == n2 || n4 < byArray.length) break;
                n4 = this.readLn(byArray, Math.min(n2 -= n4, byArray.length), n3);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    static class MyServerSocket {
        private final ServerSocket server;
        private final HashMap sockets = new HashMap();
        private final int port;
        private ServerSocketChannel channel;

        public MyServerSocket(int n2) throws IOException {
            int n3;
            this.port = n2;
            this.channel = ServerSocketChannel.open();
            this.server = this.channel.socket();
            if (Config.b(".csocket.reuseaddr", false)) {
                this.server.setReuseAddress(true);
            }
            if ((n3 = Config.a(".csocket.maxbuffersize", 0)) > 0) {
                this.server.setReceiveBufferSize(n3);
            }
            this.server.bind(new InetSocketAddress(this.port));
        }

        public int accept() throws IOException {
            SocketChannel socketChannel = this.channel.accept();
            Socket socket = socketChannel.socket();
            MySocket mySocket = new MySocket(socket, this);
            int n2 = UserHandles.ssetId(mySocket);
            this.sockets.put(socket, new MySocketRef(n2, mySocket));
            return n2;
        }

        public void close() throws IOException {
            this.server.close();
        }

        public int select(int n2, int n3) throws IOException {
            SocketChannel socketChannel;
            Iterator iterator;
            Selector selector;
            int n4;
            block9: {
                block8: {
                    block10: {
                        byte[] byArray;
                        int n5;
                        MySocketRef mySocketRef;
                        SelectionKey selectionKey = null;
                        n4 = 0;
                        selector = Selector.open();
                        boolean bl = n2 == 0;
                        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        this.channel.configureBlocking(false);
                        this.channel.register(selector, 16);
                        iterator = this.sockets.keySet().iterator();
                        while (iterator.hasNext()) {
                            socketChannel = ((Socket)iterator.next()).getChannel();
                            if (socketChannel == null) continue;
                            socketChannel.configureBlocking(false);
                            socketChannel.register(selector, 1);
                        }
                        while (true) {
                            Iterator<SelectionKey> iterator2;
                            if (bl) {
                                selector.selectNow();
                            } else {
                                selector.select(n2);
                            }
                            Set<SelectionKey> set = selector.selectedKeys();
                            selectionKey = set != null ? ((iterator2 = set.iterator()) != null && iterator2.hasNext() ? iterator2.next() : null) : null;
                            if (selectionKey == null) break block8;
                            if (selectionKey.isAcceptable()) {
                                n4 = n3;
                                break block9;
                            }
                            SocketChannel socketChannel2 = (SocketChannel)selectionKey.channel();
                            mySocketRef = (MySocketRef)this.sockets.get(socketChannel2.socket());
                            if (mySocketRef == null) break block10;
                            n4 = mySocketRef.hndl;
                            n5 = socketChannel2.read(byteBuffer);
                            byArray = byteBuffer.array();
                            if (n5 != -1) break;
                            mySocketRef.socket.close();
                            UserHandles.free(mySocketRef.hndl);
                            this.sockets.remove(mySocketRef.socket.socket);
                        }
                        if (n5 > 0) {
                            mySocketRef.socket.fillBuffer(byArray, 0, byArray.length, true);
                        }
                        break block9;
                    }
                    n4 = 0;
                    break block9;
                }
                n4 = 0;
            }
            selector.close();
            iterator = this.sockets.keySet().iterator();
            while (iterator.hasNext()) {
                socketChannel = ((Socket)iterator.next()).getChannel();
                if (socketChannel == null) continue;
                socketChannel.configureBlocking(true);
            }
            this.channel.configureBlocking(true);
            return n4;
        }

        public void remove(Socket socket) {
            this.sockets.remove(socket);
        }
    }

    static final class MySocketRef {
        final int hndl;
        final MySocket socket;

        MySocketRef(int n2, MySocket mySocket) {
            this.hndl = n2;
            this.socket = mySocket;
        }
    }
}

