/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib_n;

import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public abstract class CBLScanDir
implements IscobolCall {
    static final long RET_SUCCESS = 0L;
    static final long RET_CANNOT_START = 1L;
    static final long RET_INVALID_HANDLE = 2L;
    static final long RET_SEARCH_FINISHED = 3L;
    static final long RET_OTHER_ERROR = 127L;
    final NumericVar RETURN_CODE = Factory.getVarBinary(Factory.getMem(8), 0, 8, false, null, null, null, "RETURN-CODE", false, 18, 0, true, false, false);

    static Entries getObject(int n2) {
        return (Entries)UserHandles.getId(n2);
    }

    static int getHandle(Entries entries) {
        return UserHandles.ssetId(entries);
    }

    static Entries delObject(int n2) {
        Entries entries = CBLScanDir.getObject(n2);
        if (entries != null) {
            UserHandles.free(n2);
        }
        return entries;
    }

    public abstract String getName();

    final String getString(CobolVar cobolVar) {
        String string = cobolVar.toString();
        int n2 = string.indexOf(0);
        if (n2 >= 0) {
            string = n2 == 0 ? "" : string.substring(0, n2);
        }
        return string;
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int n2, int n3) {
    }

    static class Entries
    implements FilenameFilter {
        int index = 0;
        private final File[] list;
        private final int searchAttr;
        private final int flags;
        private File directory;
        private final String match;

        Entries(String string, int n2, int n3) {
            File file;
            string = string.trim();
            File file2 = com.iscobol.rts.File.get(string);
            this.searchAttr = n2 & 7;
            this.flags = n3;
            try {
                file = new File(file2.getCanonicalPath());
            }
            catch (IOException iOException) {
                file = new File(file2.getAbsolutePath());
            }
            this.directory = file;
            if (this.directory.isDirectory()) {
                this.match = null;
                this.directory = file2;
            } else {
                this.match = this.directory.getName();
                this.directory = file2.getParentFile();
            }
            this.list = this.directory.listFiles(this);
        }

        File next() {
            if (this.list != null && this.index < this.list.length) {
                return this.list[this.index++];
            }
            return null;
        }

        private boolean checkType(File file, String string) {
            if (this.searchAttr == 7) {
                return true;
            }
            if (this.searchAttr == 0) {
                return false;
            }
            File file2 = new File(file, string);
            int n2 = file2.isFile() ? 1 : (file2.isDirectory() ? 2 : 4);
            return (n2 & this.searchAttr) != 0;
        }

        @Override
        public boolean accept(File file, String string) {
            if (this.match == null) {
                return this.checkType(file, string);
            }
            if ((this.flags & 2) == 2) {
                if (this.match(string, this.match)) {
                    return this.checkType(file, string);
                }
                return false;
            }
            if (string.equals(this.match)) {
                return this.checkType(file, string);
            }
            return false;
        }

        private boolean recurMatch(char[] cArray, int n2, char[] cArray2, int n3) {
            while (n3 < cArray2.length && n2 < cArray.length) {
                switch (cArray2[n3]) {
                    case '*': {
                        ++n3;
                        while (n3 < cArray2.length && cArray2[n3] == '*') {
                            ++n3;
                        }
                        if (n3 >= cArray2.length) {
                            return true;
                        }
                        while (n2 < cArray.length) {
                            if (this.recurMatch(cArray, n2, cArray2, n3)) {
                                return true;
                            }
                            ++n2;
                        }
                        break;
                    }
                    case '?': {
                        ++n3;
                        break;
                    }
                    case '!': {
                        if ((this.flags & 1) == 1 && ++n3 >= cArray2.length) break;
                    }
                    default: {
                        if (cArray2[n3] != cArray[n2]) {
                            return false;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            while (n3 < cArray2.length && cArray2[n3] == '*') {
                ++n3;
            }
            return n3 >= cArray2.length && n2 >= cArray.length;
        }

        boolean match(String string, String string2) {
            return this.recurMatch(string.toCharArray(), 0, string2.toCharArray(), 0);
        }

        String getName(File file) {
            String string = file.getName();
            return string;
        }
    }
}

