/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.as.ClientInfo;
import com.iscobol.logger.IscobolFormatter;
import com.iscobol.logger.Logger;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Java14Logger
implements Logger {
    private java.util.logging.Logger log = java.util.logging.Logger.getAnonymousLogger();
    private String filename;
    private Handler handler;
    private boolean thread;

    @Override
    public void setFileName(String string) throws IOException {
        this.setFileName(string, false);
    }

    @Override
    public void setFileName(String string, boolean bl) throws IOException {
        this.setFileName(string, -1, 1, bl);
    }

    @Override
    public void setFileName(String string, int n2, int n3, boolean bl) throws IOException {
        this.filename = string;
        if (this.handler != null) {
            this.log.removeHandler(this.handler);
            this.handler.close();
        }
        if (string != null) {
            this.log.setLevel(Level.FINEST);
            this.log.setUseParentHandlers(false);
            ClientInfo clientInfo = (ClientInfo)IscobolSystem.get(ClientInfo.class);
            if (clientInfo != null) {
                string = string + "." + clientInfo.getThreadId();
            } else {
                HTTPSessionInfo hTTPSessionInfo = (HTTPSessionInfo)IscobolSystem.get(HTTPSessionInfo.class);
                if (hTTPSessionInfo != null) {
                    string = string + "." + hTTPSessionInfo.getSessionId();
                }
            }
            if (n2 > 0) {
                this.handler = new FileHandler(string, n2, n3, bl);
                this.log.addHandler(this.handler);
            } else {
                this.handler = new FileHandler(string, bl);
                this.log.addHandler(this.handler);
            }
            this.handler.setFormatter(new IscobolFormatter());
        }
    }

    @Override
    public void severe(String string) {
        if (this.thread && Factory.getd(false) != null) {
            Object object = Factory.peekCall(1);
            if (object != null) {
                this.log.severe(string + " [" + object.getClass().getName() + " Thread=" + Factory.getCurrentThreadId() + "]");
            } else {
                this.log.severe(string + " [Thread=" + Factory.getCurrentThreadId() + "]");
            }
        } else {
            this.log.severe(string);
        }
    }

    @Override
    public void info(String string) {
        if (this.thread && Factory.getd(false) != null) {
            Object object = Factory.peekCall(1);
            if (object != null) {
                this.log.info(string + " [" + object.getClass().getName() + " Thread=" + Factory.getCurrentThreadId() + "]");
            } else {
                this.log.info(string + " [Thread=" + Factory.getCurrentThreadId() + "]");
            }
        } else {
            this.log.info(string);
        }
    }

    @Override
    public void warning(String string) {
        if (this.thread && Factory.getd(false) != null) {
            Object object = Factory.peekCall(1);
            if (object != null) {
                this.log.warning(string + " [" + object.getClass().getName() + " Thread=" + Factory.getCurrentThreadId() + "]");
            } else {
                this.log.warning(string + " [Thread=" + Factory.getCurrentThreadId() + "]");
            }
        } else {
            this.log.warning(string);
        }
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.log.removeHandler(this.handler);
            this.handler.close();
        }
    }

    public boolean isShowThreadInfo() {
        return this.thread;
    }

    public void setShowThreadInfo(boolean bl) {
        this.thread = bl;
    }
}

