/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.logger.Logger;
import com.iscobol.rts.Config;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.Version;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LoggerFactory
implements Finalizable {
    public static final int TR_NONE = 0;
    public static final int TR_ENV = 1;
    public static final int TR_C_STACK = 2;
    public static final int TR_P_STACK = 4;
    public static final int TR_IO = 8;
    public static final int TR_IO_KEY = 16;
    public static final int TR_IO_RECORD = 32;
    public static final int TR_TC_PROBLEMS = 64;
    public static final int TR_TC_RPC_CALL = 128;
    public static final int TR_ESQL = 256;
    public static final int TR_GUI = 512;
    public static final int TR_LIB_STACK = 1024;
    public static final int TR_DEVELOPERS = 2048;
    private int logLen;
    private int count = 1;
    private boolean append;
    private PropertyChangeSupport changeListeners;
    private Set logFiles = new HashSet();
    private Logger logger;
    private boolean firstTime = true;
    private int traceLevel = 0;

    @Override
    public void myFinalize() {
        this.intCloseLog();
    }

    public void finalize() {
        this.intCloseLog();
    }

    private void intCloseLog() {
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        LoggerFactory loggerFactory;
        if (propertyChangeListener == null) {
            return;
        }
        LoggerFactory loggerFactory2 = loggerFactory = LoggerFactory.get();
        synchronized (loggerFactory2) {
            if (loggerFactory.changeListeners == null) {
                loggerFactory.changeListeners = new PropertyChangeSupport(loggerFactory);
            }
            loggerFactory.changeListeners.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        LoggerFactory loggerFactory = LoggerFactory.get();
        if (loggerFactory.changeListeners != null) {
            LoggerFactory loggerFactory2 = loggerFactory;
            synchronized (loggerFactory2) {
                loggerFactory.changeListeners.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private static LoggerFactory get() {
        LoggerFactory loggerFactory = (LoggerFactory)IscobolSystem.get(LoggerFactory.class);
        if (loggerFactory == null) {
            loggerFactory = new LoggerFactory();
            IscobolSystem.set(LoggerFactory.class, loggerFactory);
        }
        return loggerFactory;
    }

    private static void createLogger(Config config, LoggerFactory loggerFactory) {
        loggerFactory.traceLevel = config == null ? Config.a(".tracelevel", 0) : Config.a(config, ".tracelevel", 0);
        if (loggerFactory.traceLevel != 0) {
            boolean bl;
            String string;
            String string2;
            String string3 = Config.a();
            int n2 = 0;
            if (string3 != null && (n2 = string3.length()) > 0) {
                if (string3.charAt(n2 - 1) == '.') {
                    string3 = string3.substring(0, n2 - 1);
                }
            } else {
                string3 = "";
            }
            if (config == null) {
                string2 = Config.a(".logclass", "com.iscobol.logger.Java14Logger");
                string = Config.a(".logfile", "%t/" + string3 + "%g.log");
                loggerFactory.logLen = Config.a(".logfile.maxlen", -1);
                loggerFactory.count = Config.a(".logfile.number", 1);
                loggerFactory.append = Config.b(".logfile.append", false);
                bl = Config.b(".logfile.thread", false);
            } else {
                string2 = Config.a(config, ".logclass", "com.iscobol.logger.Java14Logger");
                string = Config.a(config, ".logfile", "%t/" + string3 + "%g.log");
                loggerFactory.logLen = Config.a(config, ".logfile.maxlen", -1);
                loggerFactory.count = Config.a(config, ".logfile.number", 1);
                loggerFactory.append = Config.a(config, ".logfile.append", false);
                bl = Config.a(config, ".logfile.thread", false);
            }
            string = LoggerFactory.decodeName(string);
            try {
                Class<?> clazz = Class.forName(string2);
                if (clazz == null) {
                    throw new InstantiationException(string2 + " is not found!!!");
                }
                if (!Logger.class.isAssignableFrom(clazz)) {
                    throw new InstantiationException(string2 + "!=" + Logger.class);
                }
                if (loggerFactory.logger != null) {
                    loggerFactory.logger.setFileName(null);
                }
                loggerFactory.logger = (Logger)Class.forName(string2).newInstance();
                boolean bl2 = loggerFactory.logFiles.contains(string);
                loggerFactory.logger.setFileName(string, loggerFactory.logLen, loggerFactory.count, loggerFactory.append || bl2);
                LoggerFactory.setShowThreadInfo(loggerFactory, bl);
                if (!bl2) {
                    loggerFactory.logFiles.add(string);
                    if (Config.a() == "iscobol.") {
                        loggerFactory.logger.info("ISCOBOL " + Version.getVersion());
                    } else {
                        loggerFactory.logger.info(string3.toUpperCase());
                    }
                    if ((loggerFactory.traceLevel & 1) != 0) {
                        String string4 = System.getProperty("line.separator", "\n");
                        String string5 = " JVM Options=";
                        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
                        Iterator<String> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            string5 = string5 + string4 + "      " + iterator.next();
                        }
                        loggerFactory.logger.info(string5);
                    }
                }
            }
            catch (Exception exception) {
                throw new IscobolRuntimeException(exception);
            }
        }
    }

    public static Logger get(int n2) {
        return LoggerFactory.get(null, n2);
    }

    public static Logger get(Config config, int n2) {
        return LoggerFactory.get(config, n2, false);
    }

    public static Logger get(Config config, int n2, boolean bl) {
        LoggerFactory loggerFactory = LoggerFactory.get();
        if (bl || loggerFactory.firstTime) {
            LoggerFactory.createLogger(config, loggerFactory);
        }
        loggerFactory.firstTime = false;
        if ((loggerFactory.traceLevel & n2) != 0 || n2 == -99) {
            return loggerFactory.logger;
        }
        return null;
    }

    public static void setTraceLevel(int n2) {
        LoggerFactory loggerFactory = LoggerFactory.get();
        int n3 = loggerFactory.traceLevel;
        loggerFactory.traceLevel = n2;
        if (n2 == 0) {
            if (loggerFactory.logger != null) {
                LoggerFactory.setLogFile(loggerFactory, null);
                loggerFactory.logger = null;
            }
        } else if (loggerFactory.logger == null) {
            LoggerFactory.createLogger(null, loggerFactory);
        }
        if (loggerFactory.changeListeners != null) {
            loggerFactory.changeListeners.firePropertyChange(Config.a() + "tracelevel", n3, n2);
        }
    }

    public static int getTraceLevel() {
        return LoggerFactory.get().traceLevel;
    }

    public static void setLogFile(String string) {
        LoggerFactory.setLogFile(LoggerFactory.get(), string);
    }

    private static void setLogFile(LoggerFactory loggerFactory, String string) {
        Logger logger = loggerFactory.logger;
        loggerFactory.logLen = Config.a(".logfile.maxlen", -1);
        loggerFactory.count = Config.a(".logfile.number", 1);
        loggerFactory.append = Config.b(".logfile.append", false);
        try {
            if (logger != null) {
                if (string != null) {
                    logger.setFileName(string, loggerFactory.logLen, loggerFactory.count, loggerFactory.append || loggerFactory.logFiles.contains(string));
                    loggerFactory.logFiles.add(string);
                } else {
                    logger.setFileName(null);
                }
            }
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
    }

    public static void setShowThreadInfo(boolean bl) {
        LoggerFactory.setShowThreadInfo(LoggerFactory.get(), bl);
    }

    private static void setShowThreadInfo(LoggerFactory loggerFactory, boolean bl) {
        try {
            loggerFactory.logger.getClass().getMethod("setShowThreadInfo", Boolean.TYPE).invoke((Object)loggerFactory.logger, bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getLogFile() {
        Logger logger = LoggerFactory.get().logger;
        if (logger != null) {
            return logger.getFileName();
        }
        return null;
    }

    public static void closeLog() {
        LoggerFactory loggerFactory = (LoggerFactory)IscobolSystem.get(LoggerFactory.class);
        if (loggerFactory != null) {
            loggerFactory.intCloseLog();
        }
    }

    public static String decodeName(String string) {
        File file;
        String string2 = string;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string3 = System.getProperty("java.io.tmpdir");
        String string4 = System.getProperty("user.home");
        String string5 = "" + gregorianCalendar.get(1);
        String string6 = gregorianCalendar.get(2) + 1 > 9 ? "" + (gregorianCalendar.get(2) + 1) : "0" + (gregorianCalendar.get(2) + 1);
        String string7 = gregorianCalendar.get(5) > 9 ? "" + gregorianCalendar.get(5) : "0" + gregorianCalendar.get(5);
        String string8 = gregorianCalendar.get(11) > 9 ? "" + gregorianCalendar.get(11) : "0" + gregorianCalendar.get(11);
        String string9 = gregorianCalendar.get(12) > 9 ? "" + gregorianCalendar.get(12) : "0" + gregorianCalendar.get(12);
        String string10 = gregorianCalendar.get(13) > 9 ? "" + gregorianCalendar.get(13) : "0" + gregorianCalendar.get(13);
        String string11 = "" + gregorianCalendar.get(14);
        switch (string11.length()) {
            case 4: {
                string11 = string11.substring(0, 2);
                break;
            }
            case 3: {
                string11 = "0" + string11.charAt(0);
                break;
            }
            case 1: 
            case 2: {
                string11 = "00";
            }
        }
        string2 = string2.replace("%yyyy", string5);
        string2 = string2.replace("%mm", string6);
        string2 = string2.replace("%dd", string7);
        string2 = string2.replace("%hh", string8);
        string2 = string2.replace("%nn", string9);
        string2 = string2.replace("%ss", string10);
        string2 = string2.replace("%cc", string11);
        string2 = string2.replace("%t", string3);
        string2 = string2.replace("%h", string4);
        String string12 = "";
        if (string2.replace('\\', '/').contains("/")) {
            string12 = string2.replace('\\', '/').substring(0, string2.replace('\\', '/').lastIndexOf(47));
        }
        if (!(file = new File(string12)).exists()) {
            file.mkdirs();
        }
        return string2;
    }

    public static Logger getCurrLog() {
        return LoggerFactory.get((Config)IscobolSystem.get(Config.class), -99, false);
    }
}

