/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServletLogger {
    public static final String K_rest_logmethod_property = "iscobol.rest.log";
    public static final String K_rest_logfolder_property = "iscobol.rest.log.folder";
    public static final String K_soap_logmethod_property = "iscobol.soap.log";
    public static final String K_soap_logfolder_property = "iscobol.soap.log.folder";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd - HH.mm.ss.SSSS");
    private String logFilename;
    private File logFile;

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public void setLogFilename(String string) {
        this.logFilename = string;
    }

    public static String reportTimestamp() {
        Date date = new Date();
        return sdf.format(date);
    }

    public void reportLog(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.logFile, true));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            printWriter.println(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static String prettyPrint(String string) {
        try {
            Object object;
            Document document = RtsUtil.newDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(string.getBytes("utf-8"))));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                object = nodeList.item(i2);
                object.getParentNode().removeChild((Node)object);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", "2");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException);
            }
            object = transformerFactory.newTransformer();
            ((Transformer)object).setOutputProperty("encoding", "UTF-8");
            ((Transformer)object).setOutputProperty("omit-xml-declaration", "yes");
            ((Transformer)object).setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ServletLogger getInstance(String string, String string2, String string3, String string4) {
        ServletLogger servletLogger = null;
        boolean bl = Config.b(string, false);
        if (string3 != null) {
            bl = Config.b(string + "." + string3.toLowerCase(), bl);
        }
        if (bl &= Config.a(string2, null) != null) {
            servletLogger = new ServletLogger();
            String string5 = Config.a(string2, "");
            if (string5.length() > 0) {
                string5 = LoggerFactory.decodeName(string5 + "/");
                string5 = string5.substring(0, string5.lastIndexOf(47));
            }
            servletLogger.setLogFile(new File(string5, (string3 != null ? string3 + "-" : "") + string4 + ".log"));
        }
        return servletLogger;
    }
}

