/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.math;

import com.iscobol.math.BigCobolInt;

public class BigCobolDec
extends BigCobolInt {
    private static final long serialVersionUID = 1L;
    public static final int ROUND_DOWN = 0;
    public static final int ROUND_HALF_UP = 1;
    static final double[] dbl10Pow = new double[MAX_PRECISION + 1];
    private int scale;

    public static void main(String[] stringArray) {
    }

    public static final BigCobolDec valueOf(long l2) {
        return new BigCobolDec(l2);
    }

    public static final BigCobolDec valueOf(long l2, int n2) {
        return new BigCobolDec(l2, n2);
    }

    public BigCobolDec() {
    }

    public BigCobolDec(byte[] byArray, boolean bl, int n2) {
        super(byArray, 0, byArray.length, bl);
        this.scale = n2;
    }

    public BigCobolDec(byte[] byArray, int n2, int n3, boolean bl, int n4) {
        super(byArray, n2, n3, bl);
        this.scale = n4;
    }

    public BigCobolDec(int n2) {
        super(n2);
    }

    public BigCobolDec(double d2) {
        if (d2 < 0.0) {
            this.negative = true;
            d2 *= -1.0;
        }
        if (d2 >= 1.0E36) {
            this.value[3] = 999999999;
            this.value[2] = 999999999;
            this.value[1] = 999999999;
            this.value[0] = 999999999;
            this.uvi = 3;
        } else if (d2 >= 1.0E-36) {
            int n2;
            this.uvi = 0;
            while (this.uvi < this.value.length && !(d2 < 1.0)) {
                if (d2 >= 1.0E9) {
                    this.value[this.uvi] = (int)(d2 % 1.0E9);
                    d2 /= 1.0E9;
                } else {
                    this.value[this.uvi] = (int)d2;
                    d2 -= (double)this.value[this.uvi];
                    break;
                }
                ++this.uvi;
            }
            for (int i2 = this.precision(); i2 < 36 && d2 > 0.0; d2 -= (double)n2, ++i2) {
                this.shift(1);
                ++this.scale;
                n2 = (int)(d2 *= 10.0);
                this.value[0] = this.value[0] + n2;
            }
        }
    }

    public BigCobolDec(long l2) {
        super(l2);
    }

    public BigCobolDec(long l2, int n2) {
        super(l2);
        this.scale = n2;
    }

    public BigCobolDec(String string) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            BigCobolDec.parseInt(this, string);
        } else {
            String string2 = string.substring(n2 + 1, string.length());
            this.scale = string2.length();
            BigCobolDec.parseInt(this, string.substring(0, n2) + string2);
        }
    }

    public BigCobolDec(BigCobolInt bigCobolInt, int n2) {
        super(bigCobolInt);
        this.scale = n2;
    }

    public BigCobolDec(BigCobolDec bigCobolDec) {
        super(bigCobolDec);
        this.scale = bigCobolDec.scale;
    }

    public int scale() {
        return this.scale;
    }

    public BigCobolDec setScale(int n2) {
        return this.setScale(n2, 0);
    }

    public BigCobolDec setScale(int n2, int n3) {
        BigCobolDec bigCobolDec = new BigCobolDec(this);
        bigCobolDec.setMyScale(n2, n3);
        return bigCobolDec;
    }

    public void roundUpIfNeeded(int n2) {
        if (this.getDecDigit(n2 - 1) >= 5) {
            boolean bl = this.isNegative();
            this.shift(-n2);
            BigCobolDec.oneDigitAdd(this.value, this.uvi, 1, this.value);
            this.shift(n2);
            if (bl != this.isNegative()) {
                this.negateMe();
            }
        }
    }

    public void setMyScale(int n2, int n3) {
        if (this.scale != n2) {
            if (n3 == 0) {
                this.shift(n2 - this.scale);
            } else if (n2 < this.scale && this.getDecDigit(this.scale - n2 - 1) >= 5) {
                this.shift(n2 - this.scale);
                this.uvi = BigCobolDec.oneDigitAdd(this.value, this.uvi, 1, this.value);
            } else {
                this.shift(n2 - this.scale);
            }
            this.scale = n2;
        }
    }

    @Override
    public int toByteArray(byte[] byArray, byte[] byArray2) {
        int n2 = super.toByteArray(byArray, byArray2);
        if (this.scale == 0) {
            return n2;
        }
        int n3 = byArray[0] == byArray2[10] ? 1 : 0;
        int n4 = n2 - n3 - this.scale;
        if (n4 > 0) {
            n4 += n3;
            for (int i2 = n2 - 1; i2 >= n4; --i2) {
                byArray[i2 + 1] = byArray[i2];
            }
            byArray[i2 + 1] = byArray2[11];
            ++n2;
        } else {
            int n5 = n2 + 1 - n4;
            for (int i3 = n2; i3 >= n3; --i3) {
                byArray[n5] = byArray[i3];
                --n5;
            }
            while (n5 > n3) {
                byArray[n5--] = byArray2[0];
            }
            byArray[n3] = byArray2[11];
            n2 = this.scale + n3 + 2;
        }
        return n2;
    }

    @Override
    public String toString() {
        if (this.scale > 0) {
            int n2;
            String string = super.toString();
            if (this.isNegative()) {
                string = string.substring(1);
            }
            if ((n2 = string.length()) > this.scale) {
                if (this.isNegative()) {
                    return "-" + string.substring(0, n2 - this.scale) + '.' + string.substring(n2 - this.scale, n2);
                }
                return string.substring(0, n2 - this.scale) + '.' + string.substring(n2 - this.scale, n2);
            }
            if (n2 == this.scale) {
                if (this.isNegative()) {
                    return "-0." + string;
                }
                return "0." + string;
            }
            StringBuffer stringBuffer = new StringBuffer(this.scale + 1);
            if (this.isNegative()) {
                stringBuffer.append("-0.");
            } else {
                stringBuffer.append("0.");
            }
            for (int i2 = this.scale - n2; i2 > 0; --i2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return super.toString();
    }

    private final BigCobolDec intAddSub(BigCobolDec bigCobolDec, boolean bl) {
        BigCobolDec bigCobolDec2;
        int n2;
        int n3;
        if (this.scale > 0 && (n3 = this.precision() - MAX_PRECISION + 1) > 0) {
            this.shift(-n3);
            this.scale -= n3;
        }
        if (bigCobolDec.scale > 0 && (n3 = bigCobolDec.precision() - MAX_PRECISION + 1) > 0) {
            bigCobolDec.shift(-n3);
            bigCobolDec.scale -= n3;
        }
        if ((n2 = this.scale - bigCobolDec.scale) == 0) {
            bigCobolDec2 = new BigCobolDec(this);
            bigCobolDec2.scale = this.scale;
            bigCobolDec2.addSub(bigCobolDec, bl);
            bigCobolDec2.normalize();
        } else {
            boolean bl2;
            BigCobolDec bigCobolDec3;
            boolean bl3;
            BigCobolDec bigCobolDec4;
            if (n2 > 0) {
                bigCobolDec4 = this;
                bl3 = this.negative;
                bigCobolDec3 = bigCobolDec;
                bl2 = bl;
            } else {
                bigCobolDec4 = bigCobolDec;
                bl3 = bl;
                bigCobolDec3 = this;
                bl2 = this.negative;
                n2 *= -1;
            }
            int n4 = n2 + bigCobolDec3.precision() - MAX_PRECISION + 1;
            if (n4 > 0) {
                if (n2 <= n4) {
                    bigCobolDec2 = new BigCobolDec(bigCobolDec4);
                    bigCobolDec2.negative = bl3;
                    bigCobolDec2.shift(-n2);
                    bigCobolDec2.scale = bigCobolDec4.scale - n2;
                    bigCobolDec2.addSub(bigCobolDec3, bl2);
                    bigCobolDec2.normalize();
                } else {
                    bigCobolDec2 = new BigCobolDec(bigCobolDec4);
                    bigCobolDec2.negative = bl3;
                    bigCobolDec3 = new BigCobolDec(bigCobolDec3);
                    bigCobolDec3.negative = bl2;
                    bigCobolDec2.shift(-n4);
                    bigCobolDec3.shift(n2 - n4);
                    bigCobolDec2.scale = bigCobolDec4.scale - n4;
                    bigCobolDec2.addSub(bigCobolDec3, bl2);
                    bigCobolDec2.normalize();
                }
            } else {
                bigCobolDec2 = new BigCobolDec(bigCobolDec3);
                bigCobolDec2.negative = bl2;
                bigCobolDec2.shift(n2);
                bigCobolDec2.scale = bigCobolDec4.scale;
                bigCobolDec2.addSub(bigCobolDec4, bl3);
                bigCobolDec2.normalize();
            }
        }
        return bigCobolDec2;
    }

    @Override
    public int compareTo(BigCobolInt bigCobolInt) {
        if (this.scale == 0) {
            return super.compareTo(bigCobolInt);
        }
        return this.compareTo(new BigCobolDec(bigCobolInt, 0));
    }

    public int compareTo(BigCobolDec bigCobolDec) {
        if (this.scale == bigCobolDec.scale) {
            return super.compareTo(bigCobolDec);
        }
        BigCobolDec bigCobolDec2 = this.subtract(bigCobolDec);
        if (bigCobolDec2.negative) {
            return -1;
        }
        if (bigCobolDec2.isZero()) {
            return 0;
        }
        return 1;
    }

    public BigCobolDec add(BigCobolDec bigCobolDec) {
        return this.intAddSub(bigCobolDec, bigCobolDec.negative);
    }

    public BigCobolDec subtract(BigCobolDec bigCobolDec) {
        return this.intAddSub(bigCobolDec, !bigCobolDec.negative);
    }

    public BigCobolDec multiply(BigCobolDec bigCobolDec) {
        BigCobolDec bigCobolDec2 = new BigCobolDec();
        if (!this.isZero() && !bigCobolDec.isZero()) {
            int n2 = this.precision() + bigCobolDec.precision() - MAX_PRECISION;
            if (n2 <= 0) {
                bigCobolDec2.uvi = BigCobolDec.absMul(this.value, this.uvi, bigCobolDec.value, bigCobolDec.uvi, bigCobolDec2.value);
                bigCobolDec2.negative = this.negative != bigCobolDec.negative;
                bigCobolDec2.scale = this.scale + bigCobolDec.scale;
            } else {
                int[] nArray = new int[this.value.length + bigCobolDec.value.length];
                int n3 = BigCobolDec.absMul(this.value, this.uvi, bigCobolDec.value, bigCobolDec.uvi, nArray);
                int n4 = Math.min(this.scale + bigCobolDec.scale, n2);
                BigCobolDec.shift(nArray, n3, -n4);
                for (int i2 = bigCobolDec2.value.length - 1; i2 >= 0; --i2) {
                    bigCobolDec2.value[i2] = nArray[i2];
                }
                bigCobolDec2.uvi = bigCobolDec2.value.length - 1;
                bigCobolDec2.negative = this.negative != bigCobolDec.negative;
                bigCobolDec2.scale = this.scale + bigCobolDec.scale - n4;
            }
        }
        return bigCobolDec2;
    }

    public BigCobolDec divide(BigCobolDec bigCobolDec, int n2) {
        return this.divide(bigCobolDec, this.scale, n2);
    }

    public BigCobolDec divide(BigCobolDec bigCobolDec, int n2, int n3) {
        int n4;
        if (bigCobolDec.isZero()) {
            throw new ArithmeticException("BigCobolDec divide by zero");
        }
        BigCobolDec bigCobolDec2 = new BigCobolDec();
        if (this.isZero()) {
            return bigCobolDec2;
        }
        int[] nArray = new int[this.value.length << 1];
        int[] nArray2 = new int[this.value.length + 1];
        int n5 = this.uvi;
        int n6 = this.scale;
        int n7 = this.minDigits() - bigCobolDec.minDigits();
        for (int i2 = this.uvi; i2 >= 0; --i2) {
            nArray[i2] = this.value[i2];
        }
        if (n7 <= 0) {
            n6 -= n7;
            ++n6;
            n5 = BigCobolDec.shift(nArray, n5, -n7 + 1);
        }
        BigCobolInt bigCobolInt = null;
        int n8 = n6 - bigCobolDec.scale;
        int n9 = n2 - n8;
        if (n9 > 0) {
            n4 = n7 > 0 ? MAX_PRECISION - n7 - n9 - 1 : MAX_PRECISION - n9 - 2;
            if (n4 < 0) {
                n9 += n4;
                n2 += n4;
            }
            n5 = BigCobolDec.shift(nArray, n5, n9);
        }
        if (n3 != 0 && n9 >= 0) {
            bigCobolInt = new BigCobolInt();
            n4 = BigCobolDec.absDiv(nArray, n5, bigCobolDec.value, bigCobolDec.uvi, nArray2, bigCobolInt.value);
            bigCobolDec2.uvi = n4 & 0xFF;
            bigCobolInt.uvi = (n4 & 0xFF00) >> 8;
            bigCobolInt.negative = this.negative;
            bigCobolInt.uvi = BigCobolDec.oneDigitMultiply(bigCobolInt.value, bigCobolInt.uvi, 2L, bigCobolInt.value);
        } else {
            n4 = BigCobolDec.absDiv(nArray, n5, bigCobolDec.value, bigCobolDec.uvi, nArray2, null);
            bigCobolDec2.uvi = n4 & 0xFF;
        }
        boolean bl = bigCobolDec2.negative = this.negative != bigCobolDec.negative;
        if (n9 < 0) {
            if (n3 != 0) {
                byte by = BigCobolDec.getDecDigit(nArray2, bigCobolDec2.uvi, -n9 - 1);
                bigCobolDec2.uvi = BigCobolDec.shift(nArray2, bigCobolDec2.uvi, n9);
                if (by >= 5) {
                    bigCobolDec2.uvi = BigCobolDec.oneDigitAdd(nArray2, bigCobolDec2.uvi, 1, nArray2);
                }
            } else {
                bigCobolDec2.uvi = BigCobolDec.shift(nArray2, bigCobolDec2.uvi, n9);
            }
        } else if (n3 != 0 && BigCobolDec.absCompareTo(bigCobolDec.value, bigCobolDec.uvi, bigCobolInt.value, bigCobolInt.uvi) <= 0) {
            bigCobolDec2.uvi = BigCobolDec.oneDigitAdd(nArray2, bigCobolDec2.uvi, 1, nArray2);
        }
        for (int i3 = bigCobolDec2.uvi; i3 >= 0; --i3) {
            bigCobolDec2.value[i3] = nArray2[i3];
        }
        bigCobolDec2.scale = n2;
        return bigCobolDec2;
    }

    public void narrowMe(int n2, int n3) {
        this.narrowMe(n2, n3, 0);
    }

    public void narrowMe(int n2, int n3, int n4) {
        if (n3 != this.scale) {
            this.setScale(n3, n4);
        }
        this.narrowMe(n2);
    }

    @Override
    public double doubleValue() {
        this.normalizeScale();
        return super.doubleValue() / dbl10Pow[this.scale];
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        if (this.scale == 0) {
            return super.longValue();
        }
        long l2 = 0L;
        for (int i2 = this.precision() - 1; i2 >= this.scale; --i2) {
            l2 *= 10L;
            l2 += (long)this.getDecDigit(i2);
        }
        if (this.negative) {
            return -l2;
        }
        return l2;
    }

    public boolean hasFractionalPart() {
        if (this.scale != 0) {
            for (int i2 = this.scale - 1; i2 >= 0; --i2) {
                if (this.getDecDigit(i2) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public int shortValue() {
        return (short)this.longValue();
    }

    public BigCobolDec negate() {
        BigCobolDec bigCobolDec = new BigCobolDec(this);
        bigCobolDec.negateMe();
        return bigCobolDec;
    }

    public long unscaled18Digits(int n2) {
        long l2;
        if (n2 == this.scale) {
            l2 = this.value[1];
            l2 *= 1000000000L;
            l2 += (long)this.value[0];
        } else {
            int[] nArray = new int[this.value.length];
            for (int i2 = this.value.length - 1; i2 >= 0; --i2) {
                nArray[i2] = this.value[i2];
            }
            BigCobolDec.shift(nArray, this.uvi, n2 - this.scale);
            l2 = nArray[1];
            l2 *= 1000000000L;
            l2 += (long)nArray[0];
        }
        if (this.negative) {
            return -l2;
        }
        return l2;
    }

    private int minDigits() {
        return super.precision();
    }

    @Override
    public int precision() {
        int n2 = super.precision();
        return this.scale > n2 ? this.scale : n2;
    }

    public int normalizeScale() {
        int n2;
        if (this.scale == 0 || this.isZero()) {
            n2 = this.scale;
            this.scale = 0;
        } else {
            int n3;
            for (n3 = 0; n3 <= this.uvi && this.value[n3] == 0; ++n3) {
            }
            int n4 = n3 * MAXDECDIGITS;
            if (n4 >= this.scale) {
                this.shift(-this.scale);
                n2 = this.scale;
                this.scale = 0;
            } else {
                int n5;
                int n6 = this.scale - n4;
                if (n6 > MAXDECDIGITS) {
                    n6 = MAXDECDIGITS;
                }
                for (n5 = 1; n5 <= n6 && this.value[n3] % TENPOW[n5] == 0; ++n5) {
                }
                --n5;
                if ((n5 += n4) > 0) {
                    this.shift(-n5);
                    n2 = n5;
                    this.scale -= n5;
                } else {
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    static {
        BigCobolDec.dbl10Pow[0] = 1.0;
        for (int i2 = 1; i2 <= MAX_PRECISION; ++i2) {
            BigCobolDec.dbl10Pow[i2] = Math.pow(10.0, i2);
        }
    }
}

