/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.math;

import java.io.Serializable;

public class BigCobolInt
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final long VALUPLIMIT = 1000000000L;
    static final String VALUPLIMITSTR = "1000000000";
    static final int MAXDECDIGITS;
    static final int NDIGITS = 4;
    static final int MAX_PRECISION;
    static final String[] ZEROFILL;
    static final int[] TENPOW;
    static final int MINUS = 10;
    static final int POINT = 11;
    protected int[] value = new int[4];
    protected boolean negative;
    protected int uvi;

    public static void main(String[] stringArray) {
    }

    public BigCobolInt() {
    }

    public BigCobolInt(byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        if (bl && byArray[n2] < 0) {
            byte[] byArray2 = new byte[n3];
            int n5 = 1;
            n4 = n3 - 1;
            int n6 = n4 + n2;
            while (n4 >= 0) {
                byArray2[n4] = (byte)(n5 += ~byArray[n6] & 0xFF);
                n5 >>= 8;
                --n4;
                --n6;
            }
            byArray = byArray2;
            n2 = 0;
            this.negative = true;
        }
        this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, byArray[n2] & 0xFF, this.value);
        int n7 = n2 + n3;
        for (n4 = n2 + 1; n4 < n7 && this.uvi < this.value.length; ++n4) {
            this.uvi = BigCobolInt.oneDigitMultiply(this.value, this.uvi, 256L, this.value);
            if (this.uvi >= this.value.length) continue;
            this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, byArray[n4] & 0xFF, this.value);
        }
        if (this.uvi == this.value.length) {
            --this.uvi;
        }
    }

    public BigCobolInt(BigCobolInt bigCobolInt) {
        this.negative = bigCobolInt.negative;
        this.uvi = bigCobolInt.uvi;
        this.value[0] = bigCobolInt.value[0];
        this.value[1] = bigCobolInt.value[1];
        this.value[2] = bigCobolInt.value[2];
        this.value[3] = bigCobolInt.value[3];
    }

    public BigCobolInt(int n2) {
        if (n2 < 0) {
            this.negative = true;
            n2 = -n2;
        }
        if ((long)n2 < 1000000000L) {
            this.value[0] = n2;
        } else {
            this.value[0] = (int)((long)n2 % 1000000000L);
            this.value[1] = (int)((long)n2 / 1000000000L);
        }
    }

    public BigCobolInt(long l2) {
        if (l2 < 0L) {
            this.negative = true;
            l2 = -l2;
        }
        if (l2 < 1000000000L) {
            this.value[0] = (int)l2;
        } else {
            this.value[0] = (int)(l2 % 1000000000L);
            if ((l2 /= 1000000000L) < 1000000000L) {
                this.uvi = 1;
                this.value[1] = (int)l2;
            } else {
                this.uvi = 2;
                this.value[1] = (int)(l2 % 1000000000L);
                this.value[2] = (int)(l2 / 1000000000L);
            }
        }
    }

    public BigCobolInt(String string) {
        BigCobolInt.parseInt(this, string);
    }

    public static BigCobolInt parseInt(BigCobolInt bigCobolInt, String string) {
        int n2;
        int n3 = 10;
        long l2 = 1L;
        int n4 = string.length();
        NumberFormatException numberFormatException = null;
        bigCobolInt.setZero();
        if (n4 == 0) {
            throw new NumberFormatException("zero length");
        }
        long l3 = 0L;
        l2 = 1L;
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n5 = string.charAt(n2);
            if (n5 <= 57) {
                n5 -= 48;
            } else if (n5 <= 90) {
                n5 -= 65;
                n5 += 10;
            } else if (n5 <= 122) {
                n5 -= 97;
                n5 += 10;
            }
            if (n5 < 0 || n5 >= 10) {
                if (string.charAt(n2) == '-') break;
                numberFormatException = new NumberFormatException("For input string: \"" + string + "\"");
                break;
            }
            l3 += (long)n5 * l2;
            if (l2 >= 1000000000L) {
                if (bigCobolInt.uvi == bigCobolInt.value.length) {
                    if (l3 != 0L && numberFormatException == null) {
                        numberFormatException = new NumberFormatException("overflow: " + string);
                    }
                } else {
                    bigCobolInt.value[bigCobolInt.uvi++] = (int)(l3 % l2);
                }
                l3 /= l2;
                l2 = 1L;
            }
            l2 *= 10L;
        }
        if (l3 > 0L) {
            if (bigCobolInt.uvi == bigCobolInt.value.length) {
                if (l3 != 0L && numberFormatException == null) {
                    numberFormatException = new NumberFormatException("overflow: " + string);
                }
                --bigCobolInt.uvi;
            } else {
                bigCobolInt.value[bigCobolInt.uvi] = (int)l3;
            }
        } else if (bigCobolInt.uvi > 0) {
            --bigCobolInt.uvi;
        }
        if (n2 >= 0 && string.charAt(n2) == '-') {
            bigCobolInt.negative = true;
        }
        bigCobolInt.adjustUvi();
        if (numberFormatException != null) {
            throw numberFormatException;
        }
        return bigCobolInt;
    }

    public static final int shift(int[] nArray, int n2, int n3) {
        if (n3 > 0) {
            boolean bl;
            while (n3 > MAXDECDIGITS) {
                if (++n2 == nArray.length) {
                    bl = true;
                }
                for (int i2 = --n2; i2 > 0; --i2) {
                    nArray[i2] = nArray[i2 - 1];
                }
                nArray[0] = 0;
                n3 -= MAXDECDIGITS;
            }
            if (n3 > 0 && (n2 = BigCobolInt.oneDigitMultiply(nArray, n2, TENPOW[n3], nArray)) == nArray.length) {
                bl = true;
                --n2;
            }
        } else if (n3 < 0) {
            n3 *= -1;
            while (n3 > MAXDECDIGITS) {
                if (--n2 < 0) {
                    nArray[0] = 0;
                    return 0;
                }
                for (int i3 = 0; i3 <= n2; ++i3) {
                    nArray[i3] = nArray[i3 + 1];
                }
                nArray[i3] = 0;
                n3 -= MAXDECDIGITS;
            }
            if (n3 > 0 && (n2 = BigCobolInt.oneDigitDivide(nArray, n2, TENPOW[n3], nArray, null)) == nArray.length) {
                boolean bl = true;
                --n2;
            }
        }
        return n2;
    }

    public final void shift(int n2) {
        this.uvi = BigCobolInt.shift(this.value, this.uvi, n2);
    }

    public static final int precision(int n2) {
        if (n2 < 10000) {
            if (n2 < 100) {
                if (n2 < 10) {
                    return 1;
                }
                return 2;
            }
            if (n2 < 1000) {
                return 3;
            }
            return 4;
        }
        if (n2 < 1000000) {
            if (n2 < 100000) {
                return 5;
            }
            return 6;
        }
        if (n2 < 100000000) {
            if (n2 < 10000000) {
                return 7;
            }
            return 8;
        }
        return 9;
    }

    public int precision() {
        return BigCobolInt.precision(this.value[this.uvi]) + this.uvi * MAXDECDIGITS;
    }

    public BigCobolInt set(BigCobolInt bigCobolInt) {
        this.negative = bigCobolInt.negative;
        this.uvi = bigCobolInt.uvi;
        this.value[0] = bigCobolInt.value[0];
        this.value[1] = bigCobolInt.value[1];
        this.value[2] = bigCobolInt.value[2];
        this.value[3] = bigCobolInt.value[3];
        return this;
    }

    public BigCobolInt setZero() {
        this.negative = false;
        this.uvi = 0;
        this.value[0] = 0;
        this.value[1] = 0;
        this.value[2] = 0;
        this.value[3] = 0;
        return this;
    }

    private static final int absAdd(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 <= n2; ++n3) {
            n4 += nArray[n3];
            if ((long)(n4 += nArray2[n3]) >= 1000000000L) {
                nArray3[n3] = n4 = (int)((long)n4 % 1000000000L);
                n4 = 1;
                continue;
            }
            nArray3[n3] = n4;
            n4 = 0;
        }
        if (n4 != 0 && n3 < nArray3.length) {
            nArray3[n3] = n4;
            return n3;
        }
        return n2;
    }

    private static final int absSub(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 <= n2; ++i2) {
            n3 += nArray[i2];
            if ((n3 -= nArray2[i2]) != 0) {
                n4 = i2;
                if (n3 < 0) {
                    nArray3[i2] = n3 = (int)((long)n3 + 1000000000L);
                    n3 = -1;
                    continue;
                }
                nArray3[i2] = n3;
                n3 = 0;
                continue;
            }
            nArray3[i2] = 0;
        }
        return n4;
    }

    static final int absMul(int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3) {
        int n4 = n2 + n3;
        if (n4 >= nArray3.length) {
            int[] nArray4 = new int[n4 + 1];
            BigCobolInt.absMul_(nArray, n2, nArray2, n3, nArray4, n4);
            n4 = nArray3.length - 1;
            for (int i2 = 0; i2 <= n4; ++i2) {
                nArray3[i2] = nArray4[i2];
            }
        } else {
            n4 = BigCobolInt.absMul_(nArray, n2, nArray2, n3, nArray3, n4);
        }
        return n4;
    }

    private static final int absMul_(int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        int n5;
        int n6;
        long l2 = 0L;
        long l3 = 0L;
        for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = 0; n5 <= n3; ++n5) {
                l2 = nArray[n6];
                l2 *= (long)nArray2[n5];
                l2 += l3;
                if ((l2 += (long)nArray3[n6 + n5]) >= 1000000000L) {
                    l3 = l2;
                    l3 /= 1000000000L;
                    nArray3[n6 + n5] = (int)(l2 %= 1000000000L);
                    continue;
                }
                l3 = 0L;
                nArray3[n6 + n5] = (int)l2;
            }
            if (l3 == 0L) continue;
            if (n6 + n5 < nArray3.length) {
                nArray3[n6 + n5] = (int)l3;
            }
            l3 = 0L;
        }
        for (n5 = 0; n5 <= n3; ++n5) {
            l2 = nArray[n6];
            l2 *= (long)nArray2[n5];
            l2 += l3;
            if ((l2 += (long)nArray3[n6 + n5]) >= 1000000000L) {
                l3 = l2;
                l3 /= 1000000000L;
                nArray3[n6 + n5] = (int)(l2 %= 1000000000L);
                continue;
            }
            l3 = 0L;
            nArray3[n6 + n5] = (int)l2;
        }
        if (l3 != 0L && n6 + n5 < nArray3.length) {
            nArray3[n6 + n5] = (int)l3;
            ++n4;
        }
        return n4;
    }

    protected static final int absCompareTo(int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n2 - n3;
        if (n4 < 0) {
            while (n3 > n2) {
                if (nArray2[n3] != 0) {
                    return n4;
                }
                --n3;
            }
        } else if (n4 > 0) {
            while (n2 > n3) {
                if (nArray[n2] != 0) {
                    return n4;
                }
                --n2;
            }
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            n4 = nArray[i2] - nArray2[i2];
            if (n4 == 0) continue;
            return n4;
        }
        return 0;
    }

    public final int absCompareTo(BigCobolInt bigCobolInt) {
        return BigCobolInt.absCompareTo(this.value, this.uvi, bigCobolInt.value, bigCobolInt.uvi);
    }

    public final boolean isZero() {
        for (int i2 = this.uvi; i2 >= 0; --i2) {
            if (this.value[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public final int signum() {
        if (this.isZero()) {
            return 0;
        }
        if (this.negative) {
            return -1;
        }
        return 1;
    }

    public final boolean isNegative() {
        if (this.negative && this.isZero()) {
            this.negative = false;
        }
        return this.negative;
    }

    public int compareTo(BigCobolInt bigCobolInt) {
        if (this.negative) {
            if (bigCobolInt.negative) {
                return -this.absCompareTo(bigCobolInt);
            }
            return -1;
        }
        if (bigCobolInt.negative) {
            return 1;
        }
        return this.absCompareTo(bigCobolInt);
    }

    protected final void addSub(BigCobolInt bigCobolInt, boolean bl) {
        if (this.negative == bl) {
            this.uvi = BigCobolInt.absAdd(this.value, bigCobolInt.value, this.value, this.uvi > bigCobolInt.uvi ? this.uvi : bigCobolInt.uvi);
        } else if (this.absCompareTo(bigCobolInt) >= 0) {
            this.uvi = BigCobolInt.absSub(this.value, bigCobolInt.value, this.value, this.uvi);
        } else {
            this.uvi = BigCobolInt.absSub(bigCobolInt.value, this.value, this.value, bigCobolInt.uvi);
            this.negative = !this.negative;
        }
    }

    public final void subFromMe(BigCobolInt bigCobolInt) {
        this.addSub(bigCobolInt, !bigCobolInt.negative);
    }

    public final void addToMe(BigCobolInt bigCobolInt) {
        this.addSub(bigCobolInt, bigCobolInt.negative);
    }

    protected static final int oneDigitAdd(int[] nArray, int n2, int n3, int[] nArray2) {
        int n4;
        for (n4 = 0; n4 <= n2; ++n4) {
            if ((long)(n3 += nArray[n4]) >= 1000000000L) {
                nArray2[n4] = n3 = (int)((long)n3 % 1000000000L);
                n3 = 1;
                continue;
            }
            nArray2[n4] = n3;
            n3 = 0;
        }
        if (n3 != 0 && n4 < nArray2.length) {
            nArray2[n4] = n3;
            return n4;
        }
        return n2;
    }

    protected static final int oneDigitMultiply(int[] nArray, int n2, long l2, int[] nArray2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 <= n2; ++n3) {
            long l3 = l2 * (long)nArray[n3] + (long)n4;
            nArray2[n3] = (int)(l3 % 1000000000L);
            n4 = (int)(l3 / 1000000000L);
        }
        if (n4 > 0) {
            if (n3 < nArray2.length) {
                nArray2[n3] = n4;
            }
            return n3;
        }
        return n2;
    }

    private static final int oneDigitDivide(int[] nArray, int n2, int n3, int[] nArray2, int[] nArray3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n4 = n2; n4 >= 0; --n4) {
            n6 = nArray[n4];
            nArray2[n4] = (int)(((long)n5 * 1000000000L + (long)n6) / (long)n3);
            n5 = (int)((long)n5 * 1000000000L + (long)n6 - (long)(nArray2[n4] * n3));
        }
        if (nArray3 != null) {
            nArray3[0] = n5;
        }
        while (n2 > 0 && nArray2[n2] == 0) {
            --n2;
        }
        return n2;
    }

    protected static final int absDiv(int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int[] nArray4) {
        int n4;
        int n5;
        int n6;
        if (n3 == 0) {
            return BigCobolInt.oneDigitDivide(nArray, n2, nArray2[0], nArray3, nArray4);
        }
        int[] nArray5 = new int[(n3 + 1) * 2];
        System.arraycopy(nArray2, 0, nArray5, 0, n3 + 1);
        int[] nArray6 = new int[n2 + 2];
        System.arraycopy(nArray, 0, nArray6, 0, n2 + 1);
        int n7 = (int)(1000000000L / (long)(nArray2[n3] + 1));
        if (n7 != 1) {
            BigCobolInt.oneDigitMultiply(nArray6, n2, n7, nArray6);
            BigCobolInt.oneDigitMultiply(nArray5, n3, n7, nArray5);
        }
        for (n6 = n2 - n3; n6 >= 0; --n6) {
            long l2;
            long l3;
            long l4 = (long)nArray6[n6 + n3 + 1] * 1000000000L + (long)nArray6[n6 + n3] - l3 * (long)nArray5[n3];
            for (l3 = ((long)nArray6[n6 + n3 + 1] * 1000000000L + (long)nArray6[n6 + n3]) / (long)nArray5[n3]; l3 >= 1000000000L || l3 * (long)nArray5[n3 - 1] > 1000000000L * l4 + (long)nArray6[n6 + n3 - 1]; --l3) {
                if ((l4 += (long)nArray5[n3]) < 1000000000L) continue;
            }
            long l5 = 0L;
            for (n5 = 0; n5 <= n3; ++n5) {
                long l6 = l3 * (long)nArray5[n5];
                l2 = (long)nArray6[n5 + n6] - l5 - l6 % 1000000000L;
                l5 = 0L;
                if (l2 < 0L) {
                    l5 = 1L - (l2 + 1L) / 1000000000L;
                    nArray6[n5 + n6] = (int)(l2 + 1000000000L * l5);
                } else {
                    nArray6[n5 + n6] = (int)l2;
                    l5 -= (l2 /= 1000000000L);
                }
                l5 += (l6 /= 1000000000L);
            }
            l2 = (long)nArray6[n6 + n5] - l5;
            nArray6[n6 + n5] = (int)l2;
            nArray3[n6] = (int)l3;
            if (l2 >= 0L) continue;
            int n8 = n6;
            nArray3[n8] = nArray3[n8] - 1;
            l5 = 0L;
            for (n5 = 0; n5 <= n3; ++n5) {
                l2 = (long)(nArray6[n5 + n6] + nArray5[n5]) + l5;
                nArray6[n5 + n6] = (int)(l2 % 1000000000L);
                l5 = l2 /= 1000000000L;
            }
            int n9 = n6 + n5;
            nArray6[n9] = (int)((long)nArray6[n9] + l5);
        }
        for (n4 = n2 - n3; n4 > 0 && nArray3[n4] == 0; --n4) {
        }
        if (nArray4 == null) {
            return n4;
        }
        if (n7 > 1) {
            while (n2 > 0 && nArray6[n2] == 0) {
                --n2;
            }
            return BigCobolInt.oneDigitDivide(nArray6, n2, n7, nArray4, null) << 8 | n4;
        }
        for (n5 = n2; n5 >= 0 && nArray6[n5] == 0; --n5) {
        }
        if (n5 < 0) {
            nArray4[0] = 0;
            return n4;
        }
        for (n6 = n5; n6 >= 0; --n6) {
            nArray4[n6] = nArray6[n6];
        }
        return n5 << 8 | n4;
    }

    public final BigCobolInt addInt(BigCobolInt bigCobolInt) {
        BigCobolInt bigCobolInt2 = new BigCobolInt(this);
        bigCobolInt2.addToMe(bigCobolInt);
        return bigCobolInt2;
    }

    public final BigCobolInt subtractInt(BigCobolInt bigCobolInt) {
        BigCobolInt bigCobolInt2 = new BigCobolInt(this);
        bigCobolInt2.subFromMe(bigCobolInt);
        return bigCobolInt2;
    }

    public final BigCobolInt multiplyInt(BigCobolInt bigCobolInt) {
        BigCobolInt bigCobolInt2 = new BigCobolInt();
        if (!this.isZero() && !bigCobolInt.isZero()) {
            bigCobolInt2.uvi = BigCobolInt.absMul(this.value, this.uvi, bigCobolInt.value, bigCobolInt.uvi, bigCobolInt2.value);
            bigCobolInt2.negative = this.negative != bigCobolInt.negative;
        }
        return bigCobolInt2;
    }

    public final void divideAndRemainderMe(BigCobolInt bigCobolInt, BigCobolInt bigCobolInt2) {
        BigCobolInt bigCobolInt3 = this.divideAndRemainder(bigCobolInt, bigCobolInt2);
        this.value = bigCobolInt3.value;
        this.uvi = bigCobolInt3.uvi;
        this.negative = bigCobolInt3.negative;
    }

    public final BigCobolInt divideAndRemainder(BigCobolInt bigCobolInt, BigCobolInt bigCobolInt2) {
        int n2;
        if (bigCobolInt.isZero()) {
            throw new ArithmeticException("BigCobolInt divide by zero");
        }
        if (this.isZero()) {
            if (bigCobolInt2 != null) {
                bigCobolInt2.setZero();
            }
            return new BigCobolInt();
        }
        int n3 = this.absCompareTo(bigCobolInt);
        if (n3 < 0) {
            if (bigCobolInt2 != null) {
                bigCobolInt2.set(this);
            }
            return new BigCobolInt();
        }
        if (n3 == 0) {
            if (bigCobolInt2 != null) {
                bigCobolInt2.setZero();
            }
            BigCobolInt bigCobolInt3 = new BigCobolInt(1);
            bigCobolInt3.negative = this.negative != bigCobolInt.negative;
            return bigCobolInt3;
        }
        BigCobolInt bigCobolInt4 = new BigCobolInt();
        if (bigCobolInt2 == null) {
            n2 = BigCobolInt.absDiv(this.value, this.uvi, bigCobolInt.value, bigCobolInt.uvi, bigCobolInt4.value, null);
        } else {
            n2 = BigCobolInt.absDiv(this.value, this.uvi, bigCobolInt.value, bigCobolInt.uvi, bigCobolInt4.value, bigCobolInt2.value);
            bigCobolInt2.uvi = (n2 & 0xFF00) >> 8;
            bigCobolInt2.negative = this.negative;
        }
        bigCobolInt4.uvi = n2 & 0xFF;
        bigCobolInt4.negative = this.negative != bigCobolInt.negative;
        return bigCobolInt4;
    }

    private final void setFromBinary(char[] cArray) {
        int n2;
        this.setZero();
        if (cArray[cArray.length - 1] >= '\u8000') {
            int n3 = 1;
            for (n2 = 0; n2 < cArray.length; ++n2) {
                cArray[n2] = (char)(n3 += (char)(~cArray[n2]));
                n3 >>= 16;
            }
            this.negative = true;
        }
        for (n2 = cArray.length - 1; n2 > 0 && cArray[n2] == '\u0000'; --n2) {
        }
        this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, cArray[n2], this.value);
        --n2;
        while (n2 >= 0) {
            this.uvi = BigCobolInt.oneDigitMultiply(this.value, this.uvi, 65536L, this.value);
            this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, cArray[n2], this.value);
            --n2;
        }
    }

    public final byte[] toByteArray() {
        int n2;
        byte[] byArray = new byte[this.value.length << 2];
        int[] nArray = new int[this.value.length];
        int n3 = this.uvi;
        int[] nArray2 = new int[1];
        int n4 = 0;
        for (n2 = n3; n2 >= 0; --n2) {
            nArray[n2] = this.value[n2];
        }
        do {
            n3 = BigCobolInt.oneDigitDivide(nArray, n3, 256, nArray, nArray2);
            byArray[n4++] = (byte)nArray2[0];
        } while (n3 != 0 || nArray[0] != 0);
        if (this.negative) {
            int n5 = 1;
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = (byte)(n5 += ~byArray[n2] & 0xFF);
                n5 >>= 8;
            }
            if (byArray[n4 - 1] >= 0) {
                ++n4;
            }
        } else if (byArray[n4 - 1] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[n4];
        --n4;
        n2 = 0;
        while (n4 >= 0) {
            byArray2[n4] = byArray[n2];
            ++n2;
            --n4;
        }
        return byArray2;
    }

    private final char[] toBinary() {
        int n2;
        char[] cArray = new char[this.value.length << 1];
        int[] nArray = new int[this.value.length];
        int n3 = this.uvi;
        int[] nArray2 = new int[1];
        int n4 = 0;
        for (n2 = n3; n2 >= 0; --n2) {
            nArray[n2] = this.value[n2];
        }
        do {
            n3 = BigCobolInt.oneDigitDivide(nArray, n3, 65536, nArray, nArray2);
            cArray[n4++] = (char)nArray2[0];
        } while (n3 != 0 || nArray[0] != 0);
        if (this.negative) {
            int n5 = 1;
            for (n2 = 0; n2 < cArray.length; ++n2) {
                cArray[n2] = (char)(n5 += (char)(~cArray[n2]));
                n5 >>= 16;
            }
        }
        return cArray;
    }

    public final void narrowMe(int n2) {
        int n3 = (n2 - 1) / MAXDECDIGITS;
        if (n3 < this.uvi) {
            for (int i2 = this.uvi; i2 > n3; --i2) {
                this.value[i2] = 0;
            }
            this.uvi = n3;
        }
        if (n3 == this.uvi && (n2 %= MAXDECDIGITS) > 0) {
            int n4 = this.uvi;
            this.value[n4] = this.value[n4] % TENPOW[n2];
        }
    }

    public static final byte getDecDigit(int[] nArray, int n2, int n3) {
        int n4 = n3 / MAXDECDIGITS;
        if (n4 > n2) {
            return 0;
        }
        return (byte)(nArray[n4] / TENPOW[n3 %= MAXDECDIGITS] % 10);
    }

    public final byte getDecDigit(int n2) {
        return BigCobolInt.getDecDigit(this.value, this.uvi, n2);
    }

    public final void andMe(BigCobolInt bigCobolInt) {
        char[] cArray = this.toBinary();
        char[] cArray2 = bigCobolInt.toBinary();
        for (int i2 = cArray.length - 1; i2 >= 0; --i2) {
            int n2 = i2;
            cArray[n2] = (char)(cArray[n2] & cArray2[i2]);
        }
        this.setFromBinary(cArray);
    }

    public final BigCobolInt and(BigCobolInt bigCobolInt) {
        BigCobolInt bigCobolInt2 = new BigCobolInt(this);
        bigCobolInt2.andMe(bigCobolInt);
        return bigCobolInt2;
    }

    protected void adjustUvi() {
        this.uvi = this.value.length - 1;
        while (this.uvi > 0 && this.value[this.uvi] == 0) {
            --this.uvi;
        }
    }

    protected final void normalize() {
        while (this.uvi > 0) {
            if (this.value[this.uvi] == 0) {
                --this.uvi;
                continue;
            }
            return;
        }
        if (this.negative && this.value[0] == 0) {
            this.negative = false;
        }
    }

    public long longValue() {
        char[] cArray = this.toBinary();
        int n2 = cArray.length;
        if (n2 > 4) {
            n2 = 4;
        }
        long l2 = cArray[0];
        int n3 = 16;
        for (int i2 = 1; i2 < n2; ++i2) {
            l2 |= (long)cArray[i2] << n3;
            n3 += 16;
        }
        if (this.negative) {
            if (l2 > 0L) {
                return -l2;
            }
            return l2;
        }
        if (l2 < 0L) {
            return l2 &= Long.MAX_VALUE;
        }
        return l2;
    }

    public double doubleValue() {
        int n2 = this.value.length - 1;
        double d2 = this.value[n2];
        --n2;
        while (n2 >= 0) {
            d2 *= 1.0E9;
            d2 += (double)this.value[n2];
            --n2;
        }
        if (this.negative) {
            return -d2;
        }
        return d2;
    }

    private static int append(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = BigCobolInt.precision(n3);
        int n5 = n2 >= 0 ? n2 : 0;
        for (int i2 = n2 + n4 - 1; i2 >= n5; --i2) {
            byArray[i2] = byArray2[n3 % 10];
            n3 /= 10;
        }
        return n2 + n4;
    }

    public void toCobolByteArray(byte[] byArray, int n2, byte[] byArray2) {
        int n3;
        int n4 = this.precision();
        int n5 = n2 - n4;
        if (n5 > 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                byArray[n3] = byArray2[0];
            }
        } else {
            n3 = n5;
        }
        int n6 = this.uvi;
        n3 = BigCobolInt.append(byArray, n3, this.value[n6], byArray2);
        --n6;
        while (n6 >= 0) {
            for (int i2 = MAXDECDIGITS - BigCobolInt.precision(this.value[n6]); i2 > 0; --i2) {
                if (n3 >= 0) {
                    byArray[n3++] = byArray2[0];
                    continue;
                }
                ++n3;
            }
            n3 = BigCobolInt.append(byArray, n3, this.value[n6], byArray2);
            --n6;
        }
    }

    public int toByteArray(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        if (this.isZero()) {
            byArray[n2++] = byArray2[0];
        } else {
            if (this.isNegative()) {
                byArray[n2++] = byArray2[10];
            }
            int n3 = this.uvi;
            n2 = BigCobolInt.append(byArray, n2, this.value[n3], byArray2);
            --n3;
            while (n3 >= 0) {
                for (int i2 = MAXDECDIGITS - BigCobolInt.precision(this.value[n3]); i2 > 0; --i2) {
                    byArray[n2++] = byArray2[0];
                }
                n2 = BigCobolInt.append(byArray, n2, this.value[n3], byArray2);
                --n3;
            }
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = this.isNegative() ? new StringBuffer("-") : new StringBuffer();
        int n2 = this.uvi;
        if (n2 >= 0) {
            stringBuffer.append(this.value[n2]);
            --n2;
            while (n2 >= 0) {
                stringBuffer.append(ZEROFILL[BigCobolInt.precision(this.value[n2])]);
                stringBuffer.append(this.value[n2]);
                --n2;
            }
            return stringBuffer.toString();
        }
        return "0";
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            n2 = 31 * n2 + this.value[i2];
        }
        if (this.negative) {
            return -n2;
        }
        return n2;
    }

    public void negateMe() {
        this.negative = !this.negative;
    }

    static {
        int n2;
        MAXDECDIGITS = VALUPLIMITSTR.length() - 1;
        MAX_PRECISION = 4 * MAXDECDIGITS;
        ZEROFILL = new String[MAXDECDIGITS + 1];
        for (n2 = 1; n2 <= MAXDECDIGITS; ++n2) {
            BigCobolInt.ZEROFILL[n2] = VALUPLIMITSTR.substring(n2 + 1);
        }
        TENPOW = new int[MAXDECDIGITS + 1];
        BigCobolInt.TENPOW[0] = 1;
        for (n2 = 1; n2 <= MAXDECDIGITS; ++n2) {
            BigCobolInt.TENPOW[n2] = TENPOW[n2 - 1] * 10;
        }
    }
}

