/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export;

public class UnitConverter {
    private static final float INCH_CM = 2.54f;
    private static final int DPI = 96;
    public static final int EXCEL_COLUMN_WIDTH_FACTOR = 256;
    public static final int EXCEL_MAX_COLUMN_WIDTH = 65280;
    private static final int UNIT_OFFSET_LENGTH = 6;
    private static final int[] UNIT_OFFSET_MAP = new int[]{0, 43, 85, 128, 171, 213};
    public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
    public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;

    private UnitConverter() {
    }

    public static int pixel2ExcelWidthUnits(int n2) {
        int n3 = 256 * (n2 / 6);
        return Math.min(n3 += UNIT_OFFSET_MAP[n2 % 6], 65280);
    }

    public static int inch2ExcelWidthUnits(float f2) {
        return UnitConverter.pixel2ExcelWidthUnits(UnitConverter.inchToPixel(f2));
    }

    public static int pixel2ExcelHeightPoints(int n2) {
        return n2;
    }

    public static int inch2ExcelHeightPoints(float f2) {
        return UnitConverter.pixel2ExcelHeightPoints(UnitConverter.inchToPixel(f2));
    }

    public static int inchToPixel(float f2) {
        return Math.round(f2 * 96.0f);
    }

    public static float pixelToCentimeter(int n2) {
        return UnitConverter.inchToCentimeter(UnitConverter.pixelToInch(n2));
    }

    public static float pixelToInch(int n2) {
        return (float)n2 / 96.0f;
    }

    public static float inchToCentimeter(float f2) {
        return f2 * 2.54f;
    }
}

