/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.ss;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class SSExportHelper {
    private static final DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    public static final int NOT_NUMERIC = 0;
    public static final int NUMERIC_INT = 1;
    public static final int NUMERIC_FLT = 2;
    public static final String DEFAULT_INT_FORMAT = "#,###";
    public static final String DEFAULT_FLT_FORMAT = "#,###.##########";
    private final Map<String, Font> FONTS = new HashMap<String, Font>();
    private Workbook workbook;
    private List<Sheet> sheets = new ArrayList<Sheet>();
    protected DataFormat dataFormat;

    public abstract int getSheetColorCount();

    public abstract int computeAnchorX(int var1, int var2);

    public abstract int computeAnchorY(int var1, int var2);

    public abstract void setBorderedCellStyleAttrs(CellStyle var1, boolean var2, boolean var3, boolean var4, boolean var5, int var6, Color var7);

    public abstract void setFontColor(Font var1, Color var2);

    protected abstract Workbook createWorkbook();

    public abstract void setBackgroundAttrs(CellStyle var1, Color var2);

    public abstract Color getBackgroundColor(CellStyle var1);

    public abstract int getMaxRowsPerSheet();

    public void addMergedRegion(Sheet sheet, int n2, int n3, int n4, int n5) {
        sheet.addMergedRegion(new CellRangeAddress(n2, n3, n4, n5));
    }

    public final Workbook getWorkbook() {
        if (this.workbook == null) {
            this.workbook = this.createWorkbook();
        }
        return this.workbook;
    }

    public final int getSheetCount() {
        return this.sheets.size();
    }

    public final int getFontCount() {
        return this.FONTS.size();
    }

    public void flushRows(Sheet sheet) {
    }

    public final Sheet getSheetAt(int n2) {
        if (n2 < this.sheets.size()) {
            return this.sheets.get(n2);
        }
        return null;
    }

    public Sheet createSheet(String string) {
        Sheet sheet = this.workbook.createSheet(string);
        this.sheets.add(sheet);
        return sheet;
    }

    public void write(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.workbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        this.workbook.close();
    }

    public void dispose() {
        this.workbook = null;
        this.dataFormat = null;
        this.sheets.clear();
        this.FONTS.clear();
    }

    public Double getNumericValue(String string) {
        try {
            string = SSExportHelper.removeChar(string, dfs.getGroupingSeparator());
            string = string.replace(',', '.');
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public int getNumericType(String string) {
        if (string.indexOf(dfs.getGroupingSeparator()) >= 0) {
            if (string.indexOf(dfs.getDecimalSeparator()) >= 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public int[] getDecimals(String string) {
        int[] nArray = new int[2];
        int n2 = string.indexOf(dfs.getDecimalSeparator());
        if (n2 >= 0) {
            nArray[0] = string.length() - n2 - 1;
        }
        if (string.indexOf(dfs.getGroupingSeparator()) >= 0) {
            nArray[1] = 1;
        }
        return nArray;
    }

    private static String removeChar(String string, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == c2) continue;
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    public Font getFont(String string, float f2, boolean bl, boolean bl2, boolean bl3, Color color) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('-');
        stringBuilder.append(f2);
        if (bl) {
            stringBuilder.append("-b");
        }
        if (bl2) {
            stringBuilder.append("-i");
        }
        if (bl3) {
            stringBuilder.append("-u");
        }
        stringBuilder.append(color.getRGB());
        String string2 = stringBuilder.toString();
        Font font = this.FONTS.get(string2);
        if (font == null) {
            font = this.getWorkbook().createFont();
            font.setFontName(string);
            font.setFontHeightInPoints((short)f2);
            font.setBold(bl);
            font.setItalic(bl2);
            if (bl3) {
                font.setUnderline((byte)1);
            }
            this.setFontColor(font, color);
            this.FONTS.put(string2, font);
        }
        return font;
    }

    public short getFormat(String string) {
        if (this.dataFormat == null) {
            this.dataFormat = this.getWorkbook().createDataFormat();
        }
        return this.dataFormat.getFormat(string);
    }
}

