/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.ss;

import com.iscobol.gui.export.ExportDataProvider;
import com.iscobol.gui.export.ExportMonitor;
import com.iscobol.gui.export.Exporter;
import com.iscobol.gui.export.GridDataProvider;
import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class SSGridExporter
implements Exporter {
    private static final int FLUSH_ROW_RATE = 1000;
    private static final float screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    private final Map<String, CellStyle> CELL_STYLES = new TreeMap<String, CellStyle>();
    private String outputFile;
    private String reportName;
    protected GridDataProvider provider;
    private ExportMonitor monitor;
    private int tickRate;
    protected SSExportHelper helper;
    private CellStyle defaultCellStyle;

    public abstract void setCellStyleAttrs(CellStyle var1, int var2, int var3, String var4);

    @Override
    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    @Override
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setDataProvider(ExportDataProvider exportDataProvider) {
        if (!(exportDataProvider instanceof GridDataProvider)) {
            throw new IllegalArgumentException("Invalid Data Provider!");
        }
        this.provider = (GridDataProvider)exportDataProvider;
    }

    @Override
    public ExportDataProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public void export() throws Exception {
        String string;
        Object object;
        if (this.provider == null) {
            throw new Exception("data provider is null");
        }
        if (this.outputFile == null) {
            throw new Exception("output file is null");
        }
        this.helper = this.createExportHelper();
        this.defaultCellStyle = this.helper.getWorkbook().createCellStyle();
        this.reportName = new File(this.outputFile).getName();
        int n2 = this.provider.getRowCount();
        int n3 = this.provider.getColumnCount();
        int n4 = this.provider.getHeadingRowCount();
        int n5 = this.provider.getHeadingColumnCount();
        int n6 = n2 / (this.tickRate - 1);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0 && i2 % 1000 == 0) {
                this.helper.flushRows(this.getSheet(i2));
            }
            if (this.monitor != null && n6 > 0 && i2 > 0 && i2 % n6 == 0) {
                this.monitor.worked(i2 / n6);
            }
            Object object2 = this.getSheet(i2).createRow(i2);
            object2.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(this.provider.getRowHeight(i2)));
            for (int i3 = 0; i3 < n3; ++i3) {
                int n7;
                Cell cell = object2.createCell(i3);
                String string2 = this.provider.getCellData(i2, i3);
                if (i2 < n5) {
                    int n8 = this.provider.getCellRowSpan(i2, i3);
                    int n9 = this.provider.getCellColumnSpan(i2, i3);
                    if (n8 > 1 || n9 > 1) {
                        arrayList.add(new int[]{i2, i3, n8, n9});
                    }
                }
                Double d2 = null;
                object = new int[2];
                string = null;
                if (i2 >= n5 && i3 >= n4) {
                    n7 = this.provider.getColumnDataType(i3);
                    switch (n7) {
                        case 2: {
                            d2 = this.helper.getNumericValue(string2);
                            if (d2 == null) break;
                            object = this.helper.getDecimals(string2);
                            break;
                        }
                        case 3: {
                            string = this.provider.getColumnDateFormat(i3);
                        }
                    }
                } else {
                    n7 = 0;
                }
                CellStyle cellStyle = this.getCellStyle(i2, i3, n7, (int[])object, string);
                cell.setCellStyle(cellStyle);
                if (d2 != null) {
                    cell.setCellValue(d2.doubleValue());
                    continue;
                }
                if (string2 == null || string2.length() <= 0) continue;
                cell.setCellValue(string2);
            }
        }
        for (Object object2 : arrayList) {
            if (object2[2] == 1) {
                String string3 = "";
                int n10 = object2[0];
                int n11 = -1;
                int n12 = object2[1] + object2[3] - 1;
                for (int i4 = object2[1]; i4 <= n12; ++i4) {
                    string = this.provider.getCellData(n10, i4);
                    if (string == null) continue;
                    string3 = string3 + string;
                    if (string.length() <= 0 || n11 >= 0) continue;
                    n11 = i4;
                }
                if (n11 < 0) {
                    n11 = object2[1];
                }
                object = this.getSheet(n10).getRow(n10);
                string = object.getCell(object2[1]);
                CellStyle cellStyle = this.getCellStyle(n10, n11, 0, new int[2], null);
                string.setCellStyle(cellStyle);
                string.setCellValue(string3);
            }
            this.helper.addMergedRegion(this.getSheet(object2[0]), object2[0], object2[0] + object2[2] - 1, object2[1], object2[1] + object2[3] - 1);
        }
        if (n5 > 0 || n4 > 0) {
            int n13 = Math.min(this.provider.getHeadingColumnCount(), this.provider.getColumnCount());
            int n14 = Math.min(this.provider.getHeadingRowCount(), this.provider.getRowCount());
            this.getSheet(0).createFreezePane(n14, n13);
        }
        this.helper.write(this.outputFile);
        this.helper.getWorkbook().close();
        this.CELL_STYLES.clear();
        this.helper.dispose();
        this.helper = null;
        this.defaultCellStyle = null;
        if (this.monitor != null) {
            this.monitor.worked(this.tickRate);
            this.monitor.done();
        }
    }

    private String getStyleKey(int n2, int n3, int n4, int[] nArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Font font = this.provider.getCellFont(n2, n3);
        stringBuilder.append("font=[");
        stringBuilder.append(font.getFamily());
        stringBuilder.append(",");
        stringBuilder.append(font.getSize2D());
        stringBuilder.append(",");
        stringBuilder.append(font.isBold() ? "1" : "0");
        stringBuilder.append(",");
        stringBuilder.append(font.isItalic() ? "1]" : "0]");
        stringBuilder.append(",color=[");
        Color[] colorArray = this.provider.getCellColor(n2, n3);
        stringBuilder.append(colorArray[0].getRGB());
        stringBuilder.append(",");
        stringBuilder.append(colorArray[1].getRGB());
        stringBuilder.append("],align=");
        stringBuilder.append(this.provider.getColumnAlignment(n3));
        stringBuilder.append(",div=");
        stringBuilder.append(this.provider.getColumnDivider(n3));
        if (n4 != 0 && n4 != 1) {
            if (string != null) {
                stringBuilder.append(",df=");
                stringBuilder.append(string);
            } else {
                stringBuilder.append(",nt=");
                stringBuilder.append(nArray[0] + "," + nArray[1]);
            }
        }
        return stringBuilder.toString();
    }

    private CellStyle getCellStyle(int n2, int n3, int n4, int[] nArray, String string) {
        String string2 = this.getStyleKey(n2, n3, n4, nArray, string);
        CellStyle cellStyle = this.CELL_STYLES.get(string2);
        if (cellStyle == null) {
            String string3;
            try {
                cellStyle = this.helper.getWorkbook().createCellStyle();
            }
            catch (Exception exception) {
                return this.defaultCellStyle;
            }
            if (n4 == 0 || n4 == 1) {
                string3 = null;
            } else if (string != null) {
                string3 = string;
            } else if (nArray[0] > 0) {
                string3 = nArray[1] > 0 ? "#,##0." : "0.";
                for (int i2 = 0; i2 < nArray[0]; ++i2) {
                    string3 = string3 + "0";
                }
            } else {
                string3 = nArray[1] > 0 ? "#,###" : "###";
            }
            this.setCellStyleAttrs(cellStyle, n2, n3, string3);
            this.CELL_STYLES.put(string2, cellStyle);
        }
        return cellStyle;
    }

    protected Sheet getSheet(int n2) {
        int n3 = n2 / this.helper.getMaxRowsPerSheet();
        if (n3 >= this.helper.getSheetCount()) {
            this.createSheet(this.reportName + " " + String.valueOf(this.helper.getSheetCount() + 1));
        }
        return this.helper.getSheetAt(n3);
    }

    protected Sheet createSheet(String string) {
        Sheet sheet = this.helper.createSheet(string);
        int n2 = this.provider.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            sheet.setColumnWidth(i2, UnitConverter.pixel2ExcelWidthUnits(this.provider.getColumnWidth(i2)));
        }
        return sheet;
    }

    protected abstract SSExportHelper createExportHelper();

    public org.apache.poi.ss.usermodel.Font getFont(Font font, Color color) {
        return this.helper.getFont(font.getFamily(), font.getSize2D() * 72.0f / screenResolution, font.isBold(), font.isItalic(), false, color);
    }

    @Override
    public void setMonitor(ExportMonitor exportMonitor, int n2) {
        this.monitor = exportMonitor;
        this.tickRate = Math.max(2, n2);
    }
}

