/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.ss;

import com.iscobol.gui.export.ExportDataProvider;
import com.iscobol.gui.export.ExportMonitor;
import com.iscobol.gui.export.Exporter;
import com.iscobol.gui.export.ListBoxDataProvider;
import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class SSListBoxExporter
implements Exporter {
    private static final int FLUSH_ROW_RATE = 1000;
    private static final float screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    private final Map<String, CellStyle> CELL_STYLES = new TreeMap<String, CellStyle>();
    private String outputFile;
    private String reportName;
    protected ListBoxDataProvider provider;
    private ExportMonitor monitor;
    private int tickRate;
    protected SSExportHelper helper;
    private CellStyle defaultCellStyle;

    public abstract void setCellStyleAttrs(CellStyle var1, int var2, int var3, String var4);

    @Override
    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    @Override
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setDataProvider(ExportDataProvider exportDataProvider) {
        if (!(exportDataProvider instanceof ListBoxDataProvider)) {
            throw new IllegalArgumentException("Invalid Data Provider!");
        }
        this.provider = (ListBoxDataProvider)exportDataProvider;
    }

    @Override
    public ExportDataProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public void export() throws Exception {
        if (this.provider == null) {
            throw new Exception("data provider is null");
        }
        if (this.outputFile == null) {
            throw new Exception("output file is null");
        }
        this.helper = this.createExportHelper();
        this.defaultCellStyle = this.helper.getWorkbook().createCellStyle();
        this.reportName = new File(this.outputFile).getName();
        int n2 = this.provider.getRowCount();
        int n3 = this.provider.getColumnCount();
        int n4 = n2 / (this.tickRate - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0 && i2 % 1000 == 0) {
                this.helper.flushRows(this.getSheet(i2));
            }
            if (this.monitor != null && n4 > 0 && i2 > 0 && i2 % n4 == 0) {
                this.monitor.worked(i2 / n4);
            }
            Row row = this.getSheet(i2).createRow(i2);
            row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(this.provider.getRowHeight(i2)));
            String[] stringArray = this.provider.getCellData(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                Cell cell = row.createCell(i3);
                String string = i3 < stringArray.length && stringArray[i3] != null ? stringArray[i3] : "";
                String string2 = string.trim();
                Double d2 = this.helper.getNumericValue(string2);
                int[] nArray = d2 != null ? this.helper.getDecimals(string2) : new int[2];
                CellStyle cellStyle = this.getCellStyle(i2, i3, nArray);
                cell.setCellStyle(cellStyle);
                if (d2 != null) {
                    cell.setCellValue(d2.doubleValue());
                    continue;
                }
                cell.setCellValue(string);
            }
        }
        this.helper.write(this.outputFile);
        this.helper.getWorkbook().close();
        this.CELL_STYLES.clear();
        this.helper.dispose();
        this.helper = null;
        this.defaultCellStyle = null;
        if (this.monitor != null) {
            this.monitor.worked(this.tickRate);
            this.monitor.done();
        }
    }

    private String getStyleKey(int n2, int n3, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Font font = this.provider.getFont();
        stringBuilder.append("font=[");
        stringBuilder.append(font.getFamily());
        stringBuilder.append(",");
        stringBuilder.append(font.getSize2D());
        stringBuilder.append(",");
        stringBuilder.append(font.isBold() ? "1" : "0");
        stringBuilder.append(",");
        stringBuilder.append(font.isItalic() ? "1]" : "0]");
        stringBuilder.append(",color=[");
        Color color = this.provider.getBackgroundColor(n2);
        Color color2 = this.provider.getForegroundColor(n2);
        stringBuilder.append(color.getRGB());
        stringBuilder.append(",");
        stringBuilder.append(color2.getRGB());
        stringBuilder.append("],align=");
        stringBuilder.append(this.provider.getColumnAlignment(n3));
        stringBuilder.append(",div=");
        stringBuilder.append(this.provider.getColumnDivider(n3));
        stringBuilder.append(",nt=");
        stringBuilder.append(nArray[0] + "," + nArray[1]);
        return stringBuilder.toString();
    }

    private CellStyle getCellStyle(int n2, int n3, int[] nArray) {
        String string = this.getStyleKey(n2, n3, nArray);
        CellStyle cellStyle = this.CELL_STYLES.get(string);
        if (cellStyle == null) {
            String string2;
            try {
                cellStyle = this.helper.getWorkbook().createCellStyle();
            }
            catch (Exception exception) {
                return this.defaultCellStyle;
            }
            if (nArray[0] > 0) {
                string2 = nArray[1] > 0 ? "#,##0." : "0.";
                for (int i2 = 0; i2 < nArray[0]; ++i2) {
                    string2 = string2 + "0";
                }
            } else {
                string2 = nArray[1] > 0 ? "#,###" : null;
            }
            this.setCellStyleAttrs(cellStyle, n2, n3, string2);
            this.CELL_STYLES.put(string, cellStyle);
        }
        return cellStyle;
    }

    protected Sheet getSheet(int n2) {
        int n3 = n2 / this.helper.getMaxRowsPerSheet();
        if (n3 >= this.helper.getSheetCount()) {
            this.createSheet(this.reportName + " " + String.valueOf(this.helper.getSheetCount() + 1));
        }
        return this.helper.getSheetAt(n3);
    }

    protected Sheet createSheet(String string) {
        Sheet sheet = this.helper.createSheet(string);
        int n2 = this.provider.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            sheet.setColumnWidth(i2, UnitConverter.pixel2ExcelWidthUnits(this.provider.getColumnWidth(i2)));
        }
        return sheet;
    }

    protected abstract SSExportHelper createExportHelper();

    public org.apache.poi.ss.usermodel.Font getFont(Font font, Color color) {
        return this.helper.getFont(font.getFamily(), font.getSize2D() * 72.0f / screenResolution, font.isBold(), font.isItalic(), false, color);
    }

    @Override
    public void setMonitor(ExportMonitor exportMonitor, int n2) {
        this.monitor = exportMonitor;
        this.tickRate = Math.max(2, n2);
    }
}

