/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xls;

import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class XLSExportHelper
extends SSExportHelper {
    private final Map<Integer, Short> COLORS = new HashMap<Integer, Short>();
    private final Set<Short> COLORS_INDEXES = new HashSet<Short>();

    public XLSExportHelper() {
        this.init();
    }

    private void init() {
        this.COLORS_INDEXES.add(new Short(HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        this.COLORS.put(new Integer(0xFFFFFF & Color.white.getRGB()), new Short(HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        this.COLORS_INDEXES.add(new Short(HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
        this.COLORS.put(new Integer(0xFFFFFF & Color.black.getRGB()), new Short(HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.COLORS.clear();
        this.COLORS_INDEXES.clear();
        this.init();
    }

    @Override
    public int getSheetColorCount() {
        return this.COLORS.size();
    }

    @Override
    public int computeAnchorX(int n2, int n3) {
        float f2 = UnitConverter.pixelToCentimeter(n2) * 10.0f;
        float f3 = UnitConverter.pixelToCentimeter(n3) * 10.0f;
        float f4 = 1023.0f / f2;
        return Math.min(1023, Math.round(f4 * f3));
    }

    @Override
    public int computeAnchorY(int n2, int n3) {
        float f2 = UnitConverter.pixelToCentimeter(n2) * 10.0f;
        float f3 = UnitConverter.pixelToCentimeter(n3) * 10.0f;
        float f4 = 255.0f / f2;
        return Math.min(255, Math.round(f4 * f3));
    }

    @Override
    public void setBorderedCellStyleAttrs(CellStyle cellStyle, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, Color color) {
        BorderStyle borderStyle = this.getBorder(n2);
        short s2 = this.getColor(color, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        if (bl) {
            cellStyle.setBorderTop(borderStyle);
            cellStyle.setTopBorderColor(s2);
        }
        if (bl2) {
            cellStyle.setBorderBottom(borderStyle);
            cellStyle.setBottomBorderColor(s2);
        }
        if (bl3) {
            cellStyle.setBorderLeft(borderStyle);
            cellStyle.setLeftBorderColor(s2);
        }
        if (bl4) {
            cellStyle.setBorderRight(borderStyle);
            cellStyle.setRightBorderColor(s2);
        }
    }

    @Override
    public void setFontColor(Font font, Color color) {
        font.setColor(this.getColor(color, HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
    }

    public short getColor(Color color, short s2) {
        Integer n2 = new Integer(0xFFFFFF & color.getRGB());
        Short s3 = this.COLORS.get(n2);
        if (s3 == null) {
            HSSFPalette hSSFPalette = ((HSSFWorkbook)this.getWorkbook()).getCustomPalette();
            HSSFColor hSSFColor = hSSFPalette.findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            if (hSSFColor != null) {
                s3 = new Short(hSSFColor.getIndex());
            } else {
                for (short s4 = 8; s4 <= 64 && s3 == null; s4 = (short)(s4 + 1)) {
                    Short s5 = new Short(s4);
                    if (this.COLORS_INDEXES.contains(s5)) continue;
                    int n3 = n2;
                    byte by = (byte)((0xFF0000 & n3) >>> 16);
                    byte by2 = (byte)((0xFF00 & n3) >>> 8);
                    byte by3 = (byte)(0xFF & n3);
                    hSSFPalette.setColorAtIndex(s4, by, by2, by3);
                    s3 = s5;
                }
            }
            if (s3 != null) {
                this.COLORS_INDEXES.add(s3);
            } else {
                s3 = new Short(s2);
            }
            this.COLORS.put(n2, s3);
        }
        return s3;
    }

    public BorderStyle getBorder(int n2) {
        if (n2 > 0) {
            short s2 = (short)UnitConverter.pixel2ExcelHeightPoints(n2);
            if (s2 >= 4) {
                return BorderStyle.THICK;
            }
            if (s2 >= 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THIN;
        }
        return BorderStyle.NONE;
    }

    @Override
    protected Workbook createWorkbook() {
        return new HSSFWorkbook();
    }

    @Override
    public void setBackgroundAttrs(CellStyle cellStyle, Color color) {
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(this.getColor(color, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
    }

    @Override
    public Color getBackgroundColor(CellStyle cellStyle) {
        Color color = null;
        short s2 = cellStyle.getFillForegroundColor();
        if (s2 >= 0) {
            HSSFPalette hSSFPalette = ((HSSFWorkbook)this.getWorkbook()).getCustomPalette();
            HSSFColor hSSFColor = hSSFPalette.getColor(s2);
            short[] sArray = hSSFColor.getTriplet();
            color = new Color(sArray[0], sArray[1], sArray[2]);
        }
        return color;
    }

    @Override
    public int getMaxRowsPerSheet() {
        return 65536;
    }
}

