/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xls;

import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.ss.SSGridExporter;
import com.iscobol.misc.export.xls.XLSExportHelper;
import java.awt.Color;
import java.awt.Font;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class XLSGridExporter
extends SSGridExporter {
    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSExportHelper();
    }

    @Override
    public void setCellStyleAttrs(CellStyle cellStyle, int n2, int n3, String string) {
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        Font font = this.provider.getCellFont(n2, n3);
        Color[] colorArray = this.provider.getCellColor(n2, n3);
        int n4 = this.provider.getColumnAlignment(n3);
        org.apache.poi.ss.usermodel.Font font2 = this.getFont(font, colorArray[1]);
        XLSExportHelper xLSExportHelper = (XLSExportHelper)this.helper;
        cellStyle.setFont(font2);
        cellStyle.setFillForegroundColor(xLSExportHelper.getColor(colorArray[0], HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        switch (n4) {
            case 0: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case 4: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            }
        }
        cellStyle.setAlignment(horizontalAlignment);
        cellStyle.setVerticalAlignment(verticalAlignment);
        Color color = this.provider.getDividerColor(n2, n3);
        short s2 = xLSExportHelper.getColor(color, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        int n5 = this.provider.getRowsDivider();
        cellStyle.setBorderBottom(xLSExportHelper.getBorder(n5));
        cellStyle.setBottomBorderColor(s2);
        cellStyle.setBorderLeft(xLSExportHelper.getBorder(this.provider.getColumnDivider(n3)));
        cellStyle.setLeftBorderColor(s2);
        cellStyle.setWrapText(true);
        if (string != null) {
            cellStyle.setDataFormat(this.helper.getFormat(string));
        }
    }
}

