/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xls;

import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.ss.SSListBoxExporter;
import com.iscobol.misc.export.xls.XLSExportHelper;
import java.awt.Color;
import java.awt.Font;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class XLSListBoxExporter
extends SSListBoxExporter {
    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSExportHelper();
    }

    @Override
    public void setCellStyleAttrs(CellStyle cellStyle, int n2, int n3, String string) {
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        Font font = this.provider.getFont();
        Color color = this.provider.getBackgroundColor(n2);
        Color color2 = this.provider.getForegroundColor(n2);
        int n4 = this.provider.getColumnAlignment(n3);
        org.apache.poi.ss.usermodel.Font font2 = this.getFont(font, color2);
        XLSExportHelper xLSExportHelper = (XLSExportHelper)this.helper;
        cellStyle.setFont(font2);
        cellStyle.setFillForegroundColor(xLSExportHelper.getColor(color, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        switch (n4) {
            case 1: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case 2: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            }
        }
        cellStyle.setAlignment(horizontalAlignment);
        cellStyle.setVerticalAlignment(verticalAlignment);
        Color color3 = this.provider.getDividerColor();
        short s2 = xLSExportHelper.getColor(color3, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderRight(xLSExportHelper.getBorder(this.provider.getColumnDivider(n3)));
        cellStyle.setRightBorderColor(s2);
        if (string != null) {
            cellStyle.setDataFormat(this.helper.getFormat(string));
        }
    }
}

