/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xlsx;

import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class XLSXExportHelper
extends SSExportHelper {
    private final Map<Integer, XSSFColor> COLORS = new HashMap<Integer, XSSFColor>();
    private List<StringBuilder> mergedCellsXml = new ArrayList<StringBuilder>();

    @Override
    public int computeAnchorX(int n2, int n3) {
        return n3 * 9525;
    }

    @Override
    public int computeAnchorY(int n2, int n3) {
        return n3 * 9525;
    }

    @Override
    public void setBorderedCellStyleAttrs(CellStyle cellStyle, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, Color color) {
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)cellStyle;
        BorderStyle borderStyle = this.getBorder(n2);
        XSSFColor xSSFColor = this.getColor(color.getRGB());
        if (bl) {
            xSSFCellStyle.setBorderTop(borderStyle);
            xSSFCellStyle.setTopBorderColor(xSSFColor);
        }
        if (bl2) {
            xSSFCellStyle.setBorderBottom(borderStyle);
            xSSFCellStyle.setBottomBorderColor(xSSFColor);
        }
        if (bl3) {
            xSSFCellStyle.setBorderLeft(borderStyle);
            xSSFCellStyle.setLeftBorderColor(xSSFColor);
        }
        if (bl4) {
            xSSFCellStyle.setBorderRight(borderStyle);
            xSSFCellStyle.setRightBorderColor(xSSFColor);
        }
    }

    @Override
    public void setFontColor(Font font, Color color) {
        ((XSSFFont)font).setColor(this.getColor(color.getRGB()));
    }

    public XSSFColor getColor(int n2) {
        Integer n3 = new Integer(n2 &= 0xFFFFFF);
        XSSFColor xSSFColor = this.COLORS.get(n3);
        if (xSSFColor == null) {
            xSSFColor = new XSSFColor(new Color(n2));
            this.COLORS.put(n3, xSSFColor);
        }
        return xSSFColor;
    }

    @Override
    public int getSheetColorCount() {
        return this.COLORS.size();
    }

    public BorderStyle getBorder(int n2) {
        if (n2 > 0) {
            short s2 = (short)UnitConverter.pixel2ExcelHeightPoints(n2);
            if (s2 >= 4) {
                return BorderStyle.THICK;
            }
            if (s2 >= 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THIN;
        }
        return BorderStyle.NONE;
    }

    @Override
    protected Workbook createWorkbook() {
        return new SXSSFWorkbook(null, -1, false, true);
    }

    @Override
    public void flushRows(Sheet sheet) {
        try {
            ((SXSSFSheet)sheet).flushRows();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public int getMaxRowsPerSheet() {
        return 0x100000;
    }

    @Override
    public Sheet createSheet(String string) {
        SXSSFSheet sXSSFSheet = (SXSSFSheet)super.createSheet(string);
        sXSSFSheet.setRandomAccessWindowSize(-1);
        this.mergedCellsXml.add(new StringBuilder());
        return sXSSFSheet;
    }

    @Override
    public void addMergedRegion(Sheet sheet, int n2, int n3, int n4, int n5) {
        int n6 = this.getWorkbook().getSheetIndex(sheet);
        StringBuilder stringBuilder = this.mergedCellsXml.get(n6);
        if (stringBuilder.length() == 0) {
            stringBuilder.append("<mergeCells>");
        }
        stringBuilder.append("<mergeCell ref=\"");
        stringBuilder.append(XLSXExportHelper.getColRef(n4));
        stringBuilder.append(n2 + 1);
        stringBuilder.append(":");
        stringBuilder.append(XLSXExportHelper.getColRef(n5));
        stringBuilder.append(n3 + 1);
        stringBuilder.append("\"/>");
    }

    private static String getColRef(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 >= 26) {
            stringBuilder.insert(0, (char)(n2 % 26 + 65));
            n2 = n2 / 26 - 1;
        }
        stringBuilder.insert(0, (char)(n2 % 26 + 65));
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(String string) throws IOException {
        void var4_7;
        Object object;
        this.flushRows(this.getSheetAt(this.getSheetCount() - 1));
        boolean bl = false;
        for (StringBuilder comparable2 : this.mergedCellsXml) {
            if (comparable2.length() <= 0) continue;
            bl = true;
            break;
        }
        Object var4_5 = null;
        if (bl) {
            File file = File.createTempFile("tmp", ".xlsx");
            object = new FileOutputStream(file);
        } else {
            object = new FileOutputStream(string);
        }
        Workbook workbook = this.getWorkbook();
        workbook.write((OutputStream)object);
        ((FileOutputStream)object).close();
        workbook.close();
        ((SXSSFWorkbook)workbook).dispose();
        if (!bl) {
            return;
        }
        ZipFile zipFile = new ZipFile((File)var4_7);
        object = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream);
        Pattern pattern = Pattern.compile("sheet(\\d+)\\.xml$");
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String string2 = new File(zipEntry.getName()).getName();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                n2 = Integer.parseInt(matcher.group(1)) - 1;
                StringBuilder stringBuilder = this.mergedCellsXml.get(n2);
                if (stringBuilder.length() > 0) {
                    byte[] byArray = "</sheetData>".getBytes();
                    stringBuilder.append("</mergeCells>");
                    int n3 = 0;
                    int n4 = ((InputStream)bufferedInputStream).read();
                    while (n4 >= 0) {
                        bufferedOutputStream.write(n4);
                        if (n4 == byArray[n3]) {
                            if (n3 == byArray.length - 1) {
                                bufferedOutputStream.write(stringBuilder.toString().getBytes());
                            } else {
                                ++n3;
                            }
                        } else {
                            n3 = 0;
                        }
                        n4 = ((InputStream)bufferedInputStream).read();
                    }
                } else {
                    int n5 = ((InputStream)bufferedInputStream).read();
                    while (n5 >= 0) {
                        bufferedOutputStream.write(n5);
                        n5 = ((InputStream)bufferedInputStream).read();
                    }
                }
            } else {
                n2 = ((InputStream)bufferedInputStream).read();
                while (n2 >= 0) {
                    bufferedOutputStream.write(n2);
                    n2 = ((InputStream)bufferedInputStream).read();
                }
            }
            bufferedOutputStream.flush();
            zipOutputStream.closeEntry();
            ((InputStream)bufferedInputStream).close();
        }
        var4_7.deleteOnExit();
        zipFile.close();
        bufferedOutputStream.close();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.COLORS.clear();
        this.mergedCellsXml.clear();
    }

    @Override
    public void setBackgroundAttrs(CellStyle cellStyle, Color color) {
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ((XSSFCellStyle)cellStyle).setFillForegroundColor(this.getColor(color.getRGB()));
    }

    @Override
    public Color getBackgroundColor(CellStyle cellStyle) {
        Color color = null;
        XSSFColor xSSFColor = ((XSSFCellStyle)cellStyle).getFillForegroundColorColor();
        if (xSSFColor != null) {
            byte[] byArray = xSSFColor.getRGB();
            color = new Color(this.toInt(byArray[0]), this.toInt(byArray[1]), this.toInt(byArray[2]));
        }
        return color;
    }

    private int toInt(byte n2) {
        return n2 < 0 ? 256 + n2 : n2;
    }
}

