/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xlsx;

import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.ss.SSGridExporter;
import com.iscobol.misc.export.xlsx.XLSXExportHelper;
import java.awt.Color;
import java.awt.Font;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class XLSXGridExporter
extends SSGridExporter {
    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSXExportHelper();
    }

    @Override
    public void setCellStyleAttrs(CellStyle cellStyle, int n2, int n3, String string) {
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)cellStyle;
        Font font = this.provider.getCellFont(n2, n3);
        Color[] colorArray = this.provider.getCellColor(n2, n3);
        int n4 = this.provider.getColumnAlignment(n3);
        org.apache.poi.ss.usermodel.Font font2 = this.getFont(font, colorArray[1]);
        xSSFCellStyle.setFont(font2);
        XLSXExportHelper xLSXExportHelper = (XLSXExportHelper)this.helper;
        xSSFCellStyle.setFillForegroundColor(xLSXExportHelper.getColor(colorArray[0].getRGB()));
        xSSFCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        switch (n4) {
            case 0: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case 4: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            }
        }
        xSSFCellStyle.setAlignment(horizontalAlignment);
        xSSFCellStyle.setVerticalAlignment(verticalAlignment);
        Color color = this.provider.getDividerColor(n2, n3);
        XSSFColor xSSFColor = xLSXExportHelper.getColor(color.getRGB());
        int n5 = this.provider.getRowsDivider();
        xSSFCellStyle.setBorderBottom(xLSXExportHelper.getBorder(n5));
        xSSFCellStyle.setBottomBorderColor(xSSFColor);
        xSSFCellStyle.setBorderLeft(xLSXExportHelper.getBorder(this.provider.getColumnDivider(n3)));
        xSSFCellStyle.setLeftBorderColor(xSSFColor);
        xSSFCellStyle.setWrapText(true);
        if (string != null) {
            xSSFCellStyle.setDataFormat(this.helper.getFormat(string));
        }
    }
}

