/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import com.iscobol.misc.javabeans.LineNumberRuler;
import com.iscobol.misc.javabeans.StatusLine;
import com.iscobol.misc.javabeans.StyledTextPane;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FindDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class CobolSourceViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANSI_FIXED = 1;
    public static final int TERMINAL_FIXED = 2;
    public static final int ANSI_FREE = 3;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final String SOURCE_STYLE_NAME = "source";
    public static final String KEYWORD_STYLE_NAME = "keyword";
    public static final String STATEMENT_STYLE_NAME = "statement";
    public static final String STRING_STYLE_NAME = "string";
    public static final String NUMBER_STYLE_NAME = "number";
    public static final String COMMENT_STYLE_NAME = "comment";
    public static final String LEVEL_NUMBER_STYLE_NAME = "levelNumber";
    public static final String FIGURATIVE_CONSTANT_NAME = "figurativeConstant";
    private int sourceFormat = 0;
    private String sourceFontName = "Monospaced";
    private int sourceFontSize = 10;
    private int sourceBackground = -1;
    private int sourceForeground = -16777216;
    private boolean sourceFormatMixed;
    private int keywordForeground = -16776961;
    private int statementForeground = -65383;
    private int stringForeground = -16744448;
    private int numberForeground = -3407872;
    private int commentForeground = -8355840;
    private int levelNumberForeground = -3407668;
    private int figurativeConstantForeground = -3381760;
    private int keywordStyle;
    private int statementStyle;
    private int stringStyle;
    private int numberStyle;
    private int commentStyle;
    private int levelNumberStyle;
    private int figurativeConstantStyle;
    private int areaDividerColor = -5196615;
    private boolean showLineNumbers = true;
    private boolean showAreaDividers;
    private boolean showAreaBackground;
    private boolean showStatusLine = true;
    private String notReservedWords = "";
    private int ansiSequenceNumberBackground = -43;
    private int ansiIndicatorAreaBackground = -1;
    private int ansiAreaABackground = -4139562;
    private int ansiAreaBBackground = -2957357;
    private int ansiIdentificationAreaBackground = -1052689;
    private int terminalIndicatorAreaBackground = -1;
    private int terminalAreaABackground = -4139562;
    private int terminalAreaBBackground = -2957357;
    private final Hashtable nrw = new Hashtable();
    private Style source;
    private Style keyword;
    private Style statement;
    private Style string;
    private Style number;
    private Style comment;
    private Style levelNumber;
    private Style figConst;
    private Style def;
    private StyledTextPane textPane;
    private JScrollPane scrollPane;
    private StatusLine statusLine;
    private LineNumberRuler verticalRuler;
    private FindDialog findDialog;
    private JPopupMenu defaultPopup;
    private Vector keyListeners = new Vector();

    public CobolSourceViewer(InputStream inputStream) throws IOException {
        this();
        this.setContents(inputStream);
    }

    public CobolSourceViewer() {
        this.setLayout(new BorderLayout());
        this.textPane = this.createStyledTextPane(this);
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    CobolSourceViewer.this.getDefaultPopup().show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 70 && keyEvent.isControlDown()) {
                    CobolSourceViewer.this.find();
                } else {
                    Enumeration enumeration = CobolSourceViewer.this.keyListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((KeyListener)enumeration.nextElement()).keyPressed(keyEvent);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 70 || !keyEvent.isControlDown()) {
                    Enumeration enumeration = CobolSourceViewer.this.keyListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((KeyListener)enumeration.nextElement()).keyReleased(keyEvent);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 70 || !keyEvent.isControlDown()) {
                    Enumeration enumeration = CobolSourceViewer.this.keyListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((KeyListener)enumeration.nextElement()).keyTyped(keyEvent);
                    }
                }
            }
        });
        this.addStylesToDocument(this.textPane.getStyledDocument());
        Font font = this.getFont(this.source);
        this.textPane.setFont(font);
        this.scrollPane = new JScrollPane(this.textPane);
        this.statusLine = this.createStatusLine();
        this.statusLine.setFont(font);
        this.verticalRuler = this.createVerticalRuler(this.textPane);
        this.verticalRuler.setFont(font);
        this.verticalRuler.setBackground(this.textPane.getBackground());
        this.verticalRuler.setForeground(this.textPane.getForeground());
        this.scrollPane.setRowHeaderView(this.verticalRuler);
        this.statusLine.setRowCol(1, 1);
        this.statusLine.setPercentage(0);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusLine, "South");
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (CobolSourceViewer.this.textPane.isDisplayable() && !CobolSourceViewer.this.textPane.getCaret().isVisible()) {
                    CobolSourceViewer.this.textPane.getCaret().setVisible(true);
                }
                int n2 = caretEvent.getDot();
                int[] nArray = CobolSourceViewer.this.computeLineCol(n2);
                CobolSourceViewer.this.statusLine.setRowCol(nArray[0], nArray[1]);
                double d2 = CobolSourceViewer.this.textPane.getStyledDocument().getLength();
                CobolSourceViewer.this.statusLine.setPercentage((int)((double)(n2 * 100) / d2));
            }
        });
    }

    private JPopupMenu getDefaultPopup() {
        if (this.defaultPopup == null) {
            this.defaultPopup = this.createDefaultPopup();
        }
        return this.defaultPopup;
    }

    private JPopupMenu createDefaultPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Factory.getSysMsg("copy"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CobolSourceViewer.this.copy();
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(Factory.getSysMsg("selectall"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CobolSourceViewer.this.selectAll();
            }
        });
        jPopupMenu.add(jMenuItem2);
        return jPopupMenu;
    }

    protected StyledTextPane createStyledTextPane(CobolSourceViewer cobolSourceViewer) {
        return new StyledTextPane(cobolSourceViewer);
    }

    protected StatusLine createStatusLine() {
        return new StatusLine();
    }

    protected LineNumberRuler createVerticalRuler(StyledTextPane styledTextPane) {
        return new LineNumberRuler(styledTextPane);
    }

    private Font getFont(Style style) {
        return new Font(StyleConstants.getFontFamily(style), 0, StyleConstants.getFontSize(style));
    }

    protected int computeFontSize(int n2) {
        return (int)Math.round((double)(n2 * Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0);
    }

    protected void addStylesToDocument(StyledDocument styledDocument) {
        this.def = StyleContext.getDefaultStyleContext().getStyle("default");
        this.source = styledDocument.addStyle(SOURCE_STYLE_NAME, this.def);
        StyleConstants.setFontFamily(this.def, this.sourceFontName);
        StyleConstants.setFontSize(this.def, this.computeFontSize(this.sourceFontSize));
        this.keyword = styledDocument.addStyle(KEYWORD_STYLE_NAME, this.source);
        this.setStyleForeground(this.keyword, this.keywordForeground);
        this.statement = styledDocument.addStyle(STATEMENT_STYLE_NAME, this.source);
        this.setStyleForeground(this.statement, this.statementForeground);
        this.string = styledDocument.addStyle(STRING_STYLE_NAME, this.source);
        this.setStyleForeground(this.string, this.stringForeground);
        this.number = styledDocument.addStyle(NUMBER_STYLE_NAME, this.source);
        this.setStyleForeground(this.number, this.numberForeground);
        this.comment = styledDocument.addStyle(COMMENT_STYLE_NAME, this.source);
        this.setStyleForeground(this.comment, this.commentForeground);
        this.levelNumber = styledDocument.addStyle(LEVEL_NUMBER_STYLE_NAME, this.source);
        this.setStyleForeground(this.levelNumber, this.levelNumberForeground);
        this.figConst = styledDocument.addStyle(FIGURATIVE_CONSTANT_NAME, this.source);
        this.setStyleForeground(this.figConst, this.figurativeConstantForeground);
    }

    public int getSourceFormat() {
        return this.sourceFormat;
    }

    public void setSourceFormat(int n2) {
        this.setSourceFormat(n2, true);
    }

    public void setSourceFormat(int n2, boolean bl) {
        if (this.sourceFormat != n2) {
            this.sourceFormat = n2;
            if (bl) {
                this.textPane.repaint();
            }
        }
    }

    public int getSourceBackground() {
        return this.sourceBackground;
    }

    public void setSourceBackground(int n2) {
        this.sourceBackground = n2;
        Color color = new Color(this.sourceBackground);
        this.textPane.setBackground(color);
        this.verticalRuler.setBackground(color);
    }

    public int getSourceForeground() {
        return this.sourceForeground;
    }

    public void setSourceForeground(int n2) {
        this.sourceForeground = n2;
        Color color = new Color(this.sourceForeground);
        this.textPane.setForeground(color);
        this.verticalRuler.setForeground(color);
    }

    public boolean isSourceFormatMixed() {
        return this.sourceFormatMixed;
    }

    public void setSourceFormatMixed(boolean bl) {
        if (this.sourceFormatMixed != bl) {
            this.sourceFormatMixed = bl;
            this.textPane.repaint();
        }
    }

    public String getSourceFontName() {
        return this.sourceFontName;
    }

    public void setSourceFontName(String string) {
        this.sourceFontName = string;
        StyleConstants.setFontFamily(this.def, string);
        this.updateFont();
    }

    public int getSourceFontSize() {
        return this.sourceFontSize;
    }

    public void setSourceFontSize(int n2) {
        if (n2 != this.sourceFontSize && n2 > 0) {
            this.sourceFontSize = n2;
            StyleConstants.setFontSize(this.def, this.computeFontSize(this.sourceFontSize));
            this.updateFont();
        }
    }

    private void updateFont() {
        Font font = this.getFont(this.source);
        this.textPane.setFont(font);
        this.verticalRuler.setFont(font);
        this.statusLine.setFont(font);
        this.doLayout();
    }

    private void setStyleForeground(Style style, int n2) {
        StyleConstants.setForeground(style, new Color(n2));
    }

    public int getKeywordForeground() {
        return this.keywordForeground;
    }

    public void setKeywordForeground(int n2) {
        if (this.keywordForeground != n2) {
            this.keywordForeground = n2;
            this.setStyleForeground(this.keyword, this.keywordForeground);
            this.textPane.repaint();
        }
    }

    public int getStatementForeground() {
        return this.statementForeground;
    }

    public void setStatementForeground(int n2) {
        if (this.statementForeground != n2) {
            this.statementForeground = n2;
            this.setStyleForeground(this.statement, this.statementForeground);
            this.textPane.repaint();
        }
    }

    public int getStringForeground() {
        return this.stringForeground;
    }

    public void setStringForeground(int n2) {
        if (this.stringForeground != n2) {
            this.stringForeground = n2;
            this.setStyleForeground(this.string, this.stringForeground);
            this.textPane.repaint();
        }
    }

    public int getNumberForeground() {
        return this.numberForeground;
    }

    public void setNumberForeground(int n2) {
        if (this.numberForeground != n2) {
            this.numberForeground = n2;
            this.setStyleForeground(this.number, this.numberForeground);
            this.textPane.repaint();
        }
    }

    public int getCommentForeground() {
        return this.commentForeground;
    }

    public void setCommentForeground(int n2) {
        if (this.commentForeground != n2) {
            this.commentForeground = n2;
            this.setStyleForeground(this.comment, this.commentForeground);
            this.textPane.repaint();
        }
    }

    public int getLevelNumberForeground() {
        return this.levelNumberForeground;
    }

    public void setLevelNumberForeground(int n2) {
        if (this.levelNumberForeground != n2) {
            this.levelNumberForeground = n2;
            this.setStyleForeground(this.levelNumber, this.levelNumberForeground);
            this.textPane.repaint();
        }
    }

    public int getFigurativeConstantForeground() {
        return this.figurativeConstantForeground;
    }

    public void setFigurativeConstantForeground(int n2) {
        if (this.figurativeConstantForeground != n2) {
            this.figurativeConstantForeground = n2;
            this.setStyleForeground(this.figConst, this.figurativeConstantForeground);
            this.textPane.repaint();
        }
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean bl) {
        if (this.showLineNumbers != bl) {
            this.showLineNumbers = bl;
            if (this.showLineNumbers) {
                this.scrollPane.setRowHeaderView(this.verticalRuler);
            } else {
                this.scrollPane.setRowHeaderView(null);
            }
            this.scrollPane.doLayout();
        }
    }

    public boolean isShowAreaDividers() {
        return this.showAreaDividers;
    }

    public void setShowAreaDividers(boolean bl) {
        if (this.showAreaDividers != bl) {
            this.showAreaDividers = bl;
            if (this.getSourceFormat() == 1 || this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    public boolean isShowAreaBackground() {
        return this.showAreaBackground;
    }

    public void setShowAreaBackground(boolean bl) {
        if (this.showAreaBackground != bl) {
            this.showAreaBackground = bl;
            this.textPane.repaint();
        }
    }

    public boolean isShowStatusLine() {
        return this.showStatusLine;
    }

    public void setShowStatusLine(boolean bl) {
        if (this.showStatusLine != bl) {
            this.showStatusLine = bl;
            if (this.showStatusLine) {
                this.add((Component)this.statusLine, "South");
            } else {
                this.remove(this.statusLine);
            }
            this.doLayout();
        }
    }

    public String getNotReservedWords() {
        return this.notReservedWords;
    }

    public void setNotReservedWords(String string) {
        this.notReservedWords = string;
        if (this.notReservedWords == null) {
            this.notReservedWords = "";
        }
        this.nrw.clear();
        if (this.notReservedWords.length() > 0) {
            String[] stringArray = this.notReservedWords.toUpperCase().split("\\,");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.nrw.put(stringArray[i2], stringArray[i2]);
            }
        }
        this.textPane.repaint();
    }

    public Hashtable getNotReservedWordsTable() {
        return this.nrw;
    }

    public StyledTextPane getStyledTextPane() {
        return this.textPane;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public LineNumberRuler getVerticalRuler() {
        return this.verticalRuler;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public int getAnsiSequenceNumberBackground() {
        return this.ansiSequenceNumberBackground;
    }

    public void setAnsiSequenceNumberBackground(int n2) {
        if (this.ansiSequenceNumberBackground != n2) {
            this.ansiSequenceNumberBackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiIndicatorAreaBackground() {
        return this.ansiIndicatorAreaBackground;
    }

    public void setAnsiIndicatorAreaBackground(int n2) {
        if (this.ansiIndicatorAreaBackground != n2) {
            this.ansiIndicatorAreaBackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiAreaABackground() {
        return this.ansiAreaABackground;
    }

    public void setAnsiAreaABackground(int n2) {
        if (this.ansiAreaABackground != n2) {
            this.ansiAreaABackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiAreaBBackground() {
        return this.ansiAreaBBackground;
    }

    public void setAnsiAreaBBackground(int n2) {
        if (this.ansiAreaBBackground != n2) {
            this.ansiAreaBBackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getAnsiIdentificationAreaBackground() {
        return this.ansiIdentificationAreaBackground;
    }

    public void setAnsiIdentificationAreaBackground(int n2) {
        if (this.ansiIdentificationAreaBackground != n2) {
            this.ansiIdentificationAreaBackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 1) {
                this.textPane.repaint();
            }
        }
    }

    public int getTerminalIndicatorAreaBackground() {
        return this.terminalIndicatorAreaBackground;
    }

    public void setTerminalIndicatorAreaBackground(int n2) {
        if (this.terminalIndicatorAreaBackground != n2) {
            this.terminalIndicatorAreaBackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    public int getTerminalAreaABackground() {
        return this.terminalAreaABackground;
    }

    public void setTerminalAreaABackground(int n2) {
        if (this.terminalAreaABackground != n2) {
            this.terminalAreaABackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    public int getTerminalAreaBBackground() {
        return this.terminalAreaBBackground;
    }

    public void setTerminalAreaBBackground(int n2) {
        if (this.terminalAreaBBackground != n2) {
            this.terminalAreaBBackground = n2;
            if (this.isShowAreaBackground() && this.getSourceFormat() == 2) {
                this.textPane.repaint();
            }
        }
    }

    private void setStyleEffects(Style style, int n2) {
        StyleConstants.setBold(style, (n2 & 1) == 1);
        StyleConstants.setItalic(style, (n2 & 2) == 2);
        StyleConstants.setUnderline(style, (n2 & 4) == 4);
    }

    public int getKeywordStyle() {
        return this.keywordStyle;
    }

    public void setKeywordStyle(int n2) {
        if (this.keywordStyle != n2) {
            this.keywordStyle = n2;
            this.setStyleEffects(this.keyword, this.keywordStyle);
            this.textPane.repaint();
        }
    }

    public int getStatementStyle() {
        return this.statementStyle;
    }

    public void setStatementStyle(int n2) {
        if (this.statementStyle != n2) {
            this.statementStyle = n2;
            this.setStyleEffects(this.statement, this.statementStyle);
            this.textPane.repaint();
        }
    }

    public int getStringStyle() {
        return this.stringStyle;
    }

    public void setStringStyle(int n2) {
        if (this.stringStyle != n2) {
            this.stringStyle = n2;
            this.setStyleEffects(this.string, this.stringStyle);
            this.textPane.repaint();
        }
    }

    public int getNumberStyle() {
        return this.numberStyle;
    }

    public void setNumberStyle(int n2) {
        if (this.numberStyle != n2) {
            this.numberStyle = n2;
            this.setStyleEffects(this.number, this.numberStyle);
            this.textPane.repaint();
        }
    }

    public int getCommentStyle() {
        return this.commentStyle;
    }

    public void setCommentStyle(int n2) {
        if (this.commentStyle != n2) {
            this.commentStyle = n2;
            this.setStyleEffects(this.comment, this.commentStyle);
            this.textPane.repaint();
        }
    }

    public int getLevelNumberStyle() {
        return this.levelNumberStyle;
    }

    public void setLevelNumberStyle(int n2) {
        if (this.levelNumberStyle != n2) {
            this.levelNumberStyle = n2;
            this.setStyleEffects(this.levelNumber, this.levelNumberStyle);
            this.textPane.repaint();
        }
    }

    public int getFigurativeConstantStyle() {
        return this.figurativeConstantStyle;
    }

    public void setFigurativeConstantStyle(int n2) {
        if (this.figurativeConstantStyle != n2) {
            this.figurativeConstantStyle = n2;
            this.setStyleEffects(this.figConst, this.figurativeConstantStyle);
            this.textPane.repaint();
        }
    }

    public int getAreaDividerColor() {
        return this.areaDividerColor;
    }

    public void setAreaDividerColor(int n2) {
        if (this.areaDividerColor != n2) {
            this.areaDividerColor = n2;
            this.textPane.repaint();
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.textPane.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.textPane.removeMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.textPane.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.textPane.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.textPane.addMouseWheelListener(mouseWheelListener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.textPane.removeMouseWheelListener(mouseWheelListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.keyListeners.addElement(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.keyListeners.removeElement(keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.textPane.addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.textPane.removeFocusListener(focusListener);
    }

    @Override
    public void requestFocus() {
        this.textPane.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textPane.requestFocusInWindow();
    }

    public void setContents(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.setContents(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public void setContents(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.setContents(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public void setContents(InputStream inputStream) throws IOException {
        this.setContents(new InputStreamReader(inputStream));
    }

    public void setStringContents(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        this.setContents(stringReader);
        stringReader.close();
    }

    public void setContents(Reader reader) throws IOException {
        this.textPane.setContents(reader);
        this.verticalRuler.setLength(Integer.toString(this.textPane.getLineCount()).length());
    }

    public int getLineCount() {
        return this.textPane.getLineCount();
    }

    private int[] computeLineCol(int n2) {
        Serializable serializable;
        int n3 = 0;
        int n4 = 0;
        try {
            serializable = this.textPane.modelToView(n2);
            n3 = serializable.x;
            n4 = serializable.y;
        }
        catch (Exception exception) {
            return new int[]{1, 1};
        }
        serializable = this.getFont(this.source);
        FontMetrics fontMetrics = this.textPane.getFontMetrics((Font)serializable);
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.charWidth('X');
        return new int[]{n4 / n5 + 1, n3 / n6 + 1};
    }

    public void loadProperties(Properties properties) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                Object object = null;
                String string = properties.getProperty(propertyDescriptorArray[i2].getName());
                if (string != null) {
                    if (propertyDescriptorArray[i2].getPropertyType() == Boolean.TYPE) {
                        object = Boolean.valueOf(string);
                    } else if (propertyDescriptorArray[i2].getPropertyType() == Integer.TYPE) {
                        try {
                            object = Integer.valueOf(string);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        object = string;
                    }
                }
                if (object == null) continue;
                propertyDescriptorArray[i2].getWriteMethod().invoke((Object)this, object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void storeProperties(Properties properties) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            Object[] objectArray = new Object[]{};
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                Object object = propertyDescriptorArray[i2].getReadMethod().invoke((Object)this, objectArray);
                if (object != null) {
                    properties.setProperty(propertyDescriptorArray[i2].getName(), object.toString());
                    continue;
                }
                properties.remove(propertyDescriptorArray[i2].getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void find() {
        JFrame jFrame = null;
        JDialog jDialog = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JFrame) {
                jFrame = (JFrame)container;
                break;
            }
            if (!(container instanceof JDialog)) continue;
            jDialog = (JDialog)container;
            break;
        }
        if (this.findDialog == null) {
            this.findDialog = jFrame != null ? new FindDialog(jFrame, "Find", false) : (jDialog != null ? new FindDialog(jDialog, "Find", false) : new FindDialog((JFrame)null, "Find", false));
            this.findDialog.setFindListener(new FindDialog.FindListener(){

                @Override
                public void find(FindDialog.FindParam findParam) {
                    int n2 = CobolSourceViewer.this.find(findParam.toSearch, findParam.matchCase, findParam.backSearch, findParam.matchMinusUnderscore);
                    if (n2 < 0) {
                        JOptionPane.showMessageDialog(CobolSourceViewer.this, "String '" + findParam.toSearch + "' not found");
                    }
                }
            });
        }
        if (!this.findDialog.isVisible()) {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.open();
            this.findDialog.toFront();
        }
    }

    private String normalizeString(String string, boolean bl, boolean bl2) {
        if (!bl) {
            string = string.toUpperCase();
        }
        if (!bl2) {
            string = string.replace('-', '_');
        }
        return string;
    }

    public int find(String string, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        block13: {
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (styledDocument.getLength() == 0) {
                return -1;
            }
            int n3 = this.textPane.getCaretPosition();
            if (n3 < 0) {
                n3 = 0;
            }
            Element element = styledDocument.getDefaultRootElement();
            int n4 = element.getElementIndex(n3);
            int n5 = element.getElementCount();
            if (n4 < 0 || n4 >= n5) {
                return -1;
            }
            string = this.normalizeString(string, bl, bl3);
            n2 = -1;
            try {
                int n6;
                String string2;
                Element element2;
                int n7;
                if (bl2) {
                    int n8;
                    String string3;
                    Element element3;
                    int n9;
                    for (n9 = n4; n9 >= 0; --n9) {
                        element3 = element.getElement(n9);
                        string3 = n9 == n4 ? styledDocument.getText(element3.getStartOffset(), n3 - element3.getStartOffset()) : styledDocument.getText(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset());
                        n8 = (string3 = this.normalizeString(string3, bl, bl3)).lastIndexOf(string);
                        if (n8 + element3.getStartOffset() == this.textPane.getSelectionStart()) {
                            n8 = n8 > 0 ? string3.lastIndexOf(string, n8 - 1) : -1;
                        }
                        if (n8 < 0) continue;
                        n2 = element3.getStartOffset() + n8;
                        break;
                    }
                    if (n2 >= 0) break block13;
                    for (n9 = n5 - 1; n9 >= n4; --n9) {
                        element3 = element.getElement(n9);
                        string3 = n9 == n4 ? styledDocument.getText(n3, element3.getEndOffset() - n3) : styledDocument.getText(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset());
                        n8 = (string3 = this.normalizeString(string3, bl, bl3)).lastIndexOf(string);
                        if (n8 < 0) continue;
                        n2 = element3.getStartOffset() + n8;
                        break block13;
                    }
                    break block13;
                }
                for (n7 = n4; n7 < n5; ++n7) {
                    element2 = element.getElement(n7);
                    string2 = n7 == n4 ? styledDocument.getText(n3, element2.getEndOffset() - n3) : styledDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                    n6 = (string2 = this.normalizeString(string2, bl, bl3)).indexOf(string);
                    if (n6 < 0) continue;
                    if (n7 == n4) {
                        n2 = n3 + n6;
                        break;
                    }
                    n2 = element2.getStartOffset() + n6;
                    break;
                }
                if (n2 >= 0) break block13;
                for (n7 = 0; n7 <= n4; ++n7) {
                    element2 = element.getElement(n7);
                    string2 = n7 == n4 ? styledDocument.getText(element2.getStartOffset(), n3 - element2.getStartOffset()) : styledDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                    n6 = (string2 = this.normalizeString(string2, bl, bl3)).indexOf(string);
                    if (n6 < 0) continue;
                    n2 = element2.getStartOffset() + n6;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        if (n2 >= 0) {
            this.textPane.setSelectionStart(n2);
            this.textPane.setSelectionEnd(n2 + string.length());
        }
        return n2;
    }

    public void copy() {
        this.textPane.copy();
    }

    public void selectAll() {
        this.textPane.selectAll();
    }
}

