/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import com.iscobol.misc.javabeans.StyledTextPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;

public class LineNumberRuler
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int length = 1;
    private int width = 10;
    private StyledTextPane textPane;

    public LineNumberRuler(StyledTextPane styledTextPane) {
        this.textPane = styledTextPane;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = this.textPane.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        int n2 = this.getSize().width - insets.left - insets.right;
        Rectangle rectangle = graphics.getClipBounds();
        int n3 = this.textPane.viewToModel(new Point(0, rectangle.y));
        int n4 = this.textPane.viewToModel(new Point(0, rectangle.y + rectangle.height));
        while (n3 <= n4) {
            try {
                String string = this.getTextLineNumber(n3);
                int n5 = fontMetrics.stringWidth(string);
                int n6 = this.getOffsetX(n2, n5) + insets.left - 1;
                int n7 = this.getOffsetY(n3, fontMetrics);
                graphics.setColor(this.getForeground());
                graphics.drawString(string, n6, n7);
                n3 = Utilities.getRowEnd(this.textPane, n3) + 1;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private int getOffsetY(int n2, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle rectangle = this.textPane.modelToView(n2);
        int n3 = rectangle.y + rectangle.height;
        int n4 = 0;
        n4 = fontMetrics.getDescent();
        return n3 - n4;
    }

    private int getOffsetX(int n2, int n3) {
        return n2 - n3;
    }

    private String getTextLineNumber(int n2) {
        int n3 = this.textPane.getLineNumber(n2);
        return n3 > 0 ? Integer.toString(n3) : "";
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.textPane.getPreferredSize().height);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateWidth();
    }

    public void setLength(int n2) {
        this.length = n2;
        this.updateWidth();
    }

    public int getLength() {
        return this.length;
    }

    protected void updateWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.width = fontMetrics.charWidth('X') * this.length + 5;
        if (this.textPane != null && this.getParent() != null) {
            this.setPreferredSize(this.getPreferredSize());
            this.getParent().doLayout();
        }
    }
}

