/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusLine
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel rowColLabel;
    private JLabel percLabel;
    private int height = 20;

    public StatusLine() {
        this.setLayout(new BoxLayout(this, 2));
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.rowColLabel = new JLabel("               ");
        this.rowColLabel.setHorizontalAlignment(4);
        this.rowColLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.percLabel = new JLabel("               ");
        this.percLabel.setHorizontalAlignment(4);
        this.percLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.percLabel);
        this.add(this.rowColLabel);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.rowColLabel != null) {
            this.rowColLabel.setFont(font);
            this.percLabel.setFont(font);
            this.height = this.getFontMetrics(font).getHeight() + 2;
        }
    }

    public void setRowCol(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append(":");
        stringBuffer.append(n3);
        stringBuffer.append(" ");
        int n4 = stringBuffer.length();
        for (int i2 = 0; i2 < 15 - n4; ++i2) {
            stringBuffer.insert(0, " ");
        }
        this.rowColLabel.setText(stringBuffer.toString());
        this.doLayout();
    }

    public void setPercentage(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append("%");
        stringBuffer.append(" ");
        int n3 = stringBuffer.length();
        for (int i2 = 0; i2 < 15 - n3; ++i2) {
            stringBuffer.insert(0, " ");
        }
        this.percLabel.setText(stringBuffer.toString());
        this.doLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.height);
    }
}

