/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.GuiWords;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.misc.javabeans.CobolSourceViewer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public class StyledTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private static final int[] ANSI_AREA_COLUMNS;
    private static final int[] TERMINAL_AREA_COLUMNS;
    private static final Set statements;
    private static final Set keywords;
    private static final String eol;
    private int lineCount;
    private CobolSourceViewer viewer;
    private Rectangle oldClip;

    public StyledTextPane(CobolSourceViewer cobolSourceViewer) {
        this.viewer = cobolSourceViewer;
        this.setContentType("text/plain");
        this.setEditable(false);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setBackground(new Color(this.viewer.getSourceBackground()));
        this.setForeground(new Color(this.viewer.getSourceForeground()));
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.putProperty("__EndOfLine__", eol);
    }

    public void setContents(InputStream inputStream) {
        this.setContents(new InputStreamReader(inputStream));
    }

    public void setContents(final Reader reader) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setContentsImpl(reader);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StyledTextPane.this.setContentsImpl(reader);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    private void setContentsImpl(Reader reader) {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = bufferedReader.readLine();
            while (object != null) {
                if (n2 > 0) {
                    stringBuffer.append(eol);
                }
                stringBuffer.append((String)object);
                object = bufferedReader.readLine();
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lineCount = n2;
        object = this.getStyledDocument();
        try {
            object.remove(0, object.getLength());
            object.insertString(0, stringBuffer.toString(), null);
            this.setCaretPosition(0);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected void setStyleAttributes(String string, int n2) throws IOException, BadLocationException {
        StyledDocument styledDocument = this.getStyledDocument();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n3 = 0;
        Hashtable hashtable = this.viewer.getNotReservedWordsTable();
        int n4 = this.viewer.getSourceFormat();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            int n5;
            if (n3 > 0) {
                n2 += eol.length();
            }
            if ((n5 = this.checkFormat(string2)) != n4) {
                bufferedReader.close();
                this.viewer.setSourceFormat(n5);
                return;
            }
            TokenList tokenList = PreProcessor.tokenizer(new StringBuffer(string2), '.', true, true, hashtable);
            boolean bl = false;
            boolean bl2 = true;
            int n6 = 0;
            int n7 = 0;
            Object object = tokenList.getFirstWithSep();
            while (object != null) {
                String string3;
                String string4 = ((Token)object).getWord();
                int n8 = ((Token)object).getOffset();
                int n9 = n6 - n8;
                n6 = Math.min(string2.length(), n8 + string4.length());
                if (n9 >= 0) {
                    n7 = Math.min(n6, n8 + n9);
                    string3 = string2.substring(n7, n6);
                } else {
                    n7 = Math.min(n8, n8 + n9);
                    string3 = string2.substring(n7, n8);
                    styledDocument.setCharacterAttributes(n2, string3.length(), styledDocument.getStyle("source"), true);
                    n2 += string3.length();
                    string3 = string2.substring(n8, n6);
                }
                if (string3.length() != 0) {
                    Style style;
                    if (bl) {
                        style = styledDocument.getStyle("comment");
                    } else {
                        switch (((Token)object).getToknum()) {
                            case 10016: {
                                if (string3.startsWith("*>") || string3.startsWith("|")) {
                                    style = styledDocument.getStyle("comment");
                                    bl2 = false;
                                    break;
                                }
                                if (string3.trim().length() > 0) {
                                    bl2 = false;
                                }
                                style = styledDocument.getStyle("source");
                                break;
                            }
                            case 10002: {
                                style = bl2 && StyledTextPane.isLevelNumber(string3) ? styledDocument.getStyle("levelNumber") : styledDocument.getStyle("number");
                                bl2 = false;
                                break;
                            }
                            case 10017: {
                                style = styledDocument.getStyle("number");
                                bl2 = false;
                                break;
                            }
                            case 10001: 
                            case 10024: {
                                style = styledDocument.getStyle("string");
                                bl2 = false;
                                break;
                            }
                            case 576: 
                            case 577: 
                            case 601: 
                            case 660: 
                            case 661: 
                            case 736: 
                            case 737: 
                            case 822: 
                            case 824: 
                            case 825: {
                                style = styledDocument.getStyle("figurativeConstant");
                                bl2 = false;
                                break;
                            }
                            default: {
                                if (((Token)object).getWord().startsWith("*")) {
                                    if (n4 == 1 && ((Token)object).getOffset() == 6 || n4 == 2 && ((Token)object).getOffset() == 0) {
                                        style = styledDocument.getStyle("comment");
                                        bl = true;
                                    } else {
                                        style = styledDocument.getStyle("source");
                                    }
                                } else {
                                    style = !hashtable.contains(string4) ? (statements.contains(string4) ? styledDocument.getStyle("statement") : (keywords.contains(string4) ? styledDocument.getStyle("keyword") : styledDocument.getStyle("source"))) : styledDocument.getStyle("source");
                                }
                                bl2 = false;
                            }
                        }
                    }
                    styledDocument.setCharacterAttributes(n2, string3.length(), style, true);
                    n2 += string3.length();
                }
                object = tokenList.getNextWithSep();
            }
            if (n6 < string2.length()) {
                object = string2.substring(n6);
                styledDocument.setCharacterAttributes(n2, ((String)object).length(), styledDocument.getStyle("source"), true);
                n2 += ((String)object).length();
            }
            string2 = bufferedReader.readLine();
            ++n3;
        }
        bufferedReader.close();
    }

    protected void paintClientArea(Rectangle rectangle, Graphics graphics) {
        Object object;
        graphics.setColor(new Color(this.viewer.getSourceBackground()));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = this.viewer.getSourceFormat();
        if (this.viewer.isShowAreaBackground()) {
            int n3;
            int n4;
            if (n2 == 1) {
                object = this.getFontMetrics(this.getFont());
                n4 = ((FontMetrics)object).charWidth('X');
                n3 = this.getInsets().left;
                graphics.setColor(new Color(this.viewer.getAnsiSequenceNumberBackground()));
                graphics.fillRect(0, 0, n3 + n4 * ANSI_AREA_COLUMNS[0], this.getHeight());
                graphics.setColor(new Color(this.viewer.getAnsiIndicatorAreaBackground()));
                graphics.fillRect(n3 + n4 * ANSI_AREA_COLUMNS[0], 0, n4 * (ANSI_AREA_COLUMNS[1] - ANSI_AREA_COLUMNS[0]), this.getHeight());
                graphics.setColor(new Color(this.viewer.getAnsiAreaABackground()));
                graphics.fillRect(n3 + n4 * ANSI_AREA_COLUMNS[1], 0, n4 * (ANSI_AREA_COLUMNS[2] - ANSI_AREA_COLUMNS[1]), this.getHeight());
                graphics.setColor(new Color(this.viewer.getAnsiAreaBBackground()));
                graphics.fillRect(n3 + n4 * ANSI_AREA_COLUMNS[2], 0, n4 * (ANSI_AREA_COLUMNS[3] - ANSI_AREA_COLUMNS[2]), this.getHeight());
                graphics.setColor(new Color(this.viewer.getAnsiIdentificationAreaBackground()));
                graphics.fillRect(n3 + n4 * ANSI_AREA_COLUMNS[3], 0, n4 * (ANSI_AREA_COLUMNS[4] - ANSI_AREA_COLUMNS[3]), this.getHeight());
            } else if (n2 == 2) {
                object = this.getFontMetrics(this.getFont());
                n4 = ((FontMetrics)object).charWidth('X');
                n3 = this.getInsets().left;
                graphics.setColor(new Color(this.viewer.getTerminalIndicatorAreaBackground()));
                graphics.fillRect(0, 0, n3 + n4 * TERMINAL_AREA_COLUMNS[0], this.getHeight());
                graphics.setColor(new Color(this.viewer.getTerminalAreaABackground()));
                graphics.fillRect(n3 + n4 * TERMINAL_AREA_COLUMNS[0], 0, n4 * (TERMINAL_AREA_COLUMNS[1] - TERMINAL_AREA_COLUMNS[0]), this.getHeight());
                graphics.setColor(new Color(this.viewer.getTerminalAreaBBackground()));
                graphics.fillRect(n3 + n4 * TERMINAL_AREA_COLUMNS[1], 0, this.getWidth() - n3 - n4 * TERMINAL_AREA_COLUMNS[1], this.getHeight());
            }
        }
        if (this.viewer.isShowAreaDividers()) {
            object = null;
            if (n2 == 1) {
                object = ANSI_AREA_COLUMNS;
            } else if (n2 == 2) {
                object = TERMINAL_AREA_COLUMNS;
            }
            if (object != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                Color color = new Color(this.viewer.getAreaDividerColor());
                graphics.setColor(color);
                int n5 = fontMetrics.charWidth('X');
                int n6 = this.getInsets().left;
                for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                    int n7 = n6 + n5 * object[i2];
                    graphics.drawLine(n7, 0, n7, this.getHeight());
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        this.paintClientArea(rectangle, graphics);
        if (this.oldClip == null || !this.oldClip.equals(rectangle)) {
            StyledDocument styledDocument = this.getStyledDocument();
            int n2 = this.viewToModel(new Point(0, rectangle.y));
            int n3 = this.viewToModel(new Point(0, rectangle.y + rectangle.height + graphics.getFontMetrics().getHeight()));
            n3 = Math.min(styledDocument.getLength(), n3);
            if (n3 > n2 && styledDocument.getLength() > 0) {
                try {
                    String string = styledDocument.getText(n2, n3 - n2);
                    this.setStyleAttributes(string, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.oldClip = rectangle;
        }
        super.paintComponent(graphics);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    private static boolean isLevelNumber(String string) {
        try {
            int n2 = Integer.parseInt(string);
            return n2 >= 1 && n2 <= 49 || n2 == 66 || n2 == 77 || n2 == 78 || n2 == 88;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private int checkFormat(String string) {
        int n2 = this.viewer.getSourceFormat();
        boolean bl = this.viewer.isSourceFormatMixed();
        if (n2 == 0 && string.length() > 0) {
            int n3;
            if (string.charAt(0) == '*' && (bl || string.length() == 1 || string.charAt(1) != '>')) {
                return 2;
            }
            if (string.charAt(0) == '/' || string.charAt(0) == '$') {
                return 2;
            }
            for (n3 = 0; n3 < string.length() && (string.charAt(n3) == ' ' || string.charAt(n3) == '\t'); ++n3) {
            }
            if (n3 < string.length()) {
                if (string.length() > 6 && (string.charAt(6) == '*' || string.charAt(6) == '$') || string.length() > 7 && string.charAt(6) == ' ' || string.charAt(6) == '/') {
                    for (n3 = 0; n3 < 6; ++n3) {
                        if ((string.charAt(n3) != '*' || string.charAt(n3 + 1) != '>') && (string.charAt(n3) != '>' || string.charAt(n3 + 1) != '>')) continue;
                        if (bl) {
                            return 2;
                        }
                        return 3;
                    }
                    if (n2 == 0) {
                        return 1;
                    }
                } else {
                    if (bl) {
                        return 2;
                    }
                    return 3;
                }
            }
        }
        return n2;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLineNumber(int n2) {
        int n3;
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n3 = element.getElementIndex(n2));
        if (element2.getStartOffset() == n2) {
            return n3 + 1;
        }
        return 0;
    }

    static {
        int n2;
        ANSI_AREA_COLUMNS = new int[]{6, 7, 11, 72, 80};
        TERMINAL_AREA_COLUMNS = new int[]{1, 5};
        statements = new HashSet();
        keywords = new HashSet();
        for (n2 = 0; n2 < CobolToken.tokDesc.length; ++n2) {
            if (CobolToken.isStat[n2]) {
                statements.add(CobolToken.tokDesc[n2]);
                continue;
            }
            keywords.add(CobolToken.tokDesc[n2]);
        }
        statements.add("::");
        statements.add(":>");
        for (n2 = 0; n2 < GuiWords.guiWords.length; ++n2) {
            keywords.add(GuiWords.guiWords[n2]);
        }
        eol = System.getProperty("line.separator", "\n");
    }
}

