/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.preview;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;

public class PictureButton
extends Canvas
implements ItemSelectable {
    private Image image;
    private boolean flat;
    private boolean bistate;
    private Rectangle imagePortion;
    private ActionListener actionListener;
    private ItemListener itemListener;
    private FocusListener focusListener;
    private String actionCommand;
    private boolean pressed;
    private boolean isOn;
    private boolean mouseEntered;
    private MediaTracker mt;
    private Dimension preferredSize;

    public PictureButton(Image image) {
        this(image, null, false, false);
    }

    public PictureButton(Image image, Rectangle rectangle) {
        this(image, rectangle, false, false);
    }

    public PictureButton(Image image, Rectangle rectangle, boolean bl) {
        this(image, rectangle, bl, false);
    }

    public PictureButton(Image image, boolean bl) {
        this(image, null, bl, false);
    }

    public PictureButton(Image image, boolean bl, boolean bl2) {
        this(image, null, bl, bl2);
    }

    public PictureButton(Image image, Rectangle rectangle, boolean bl, boolean bl2) {
        this.flat = bl;
        this.bistate = bl2;
        this.imagePortion = rectangle;
        this.mt = new MediaTracker(this);
        if (image != null) {
            this.updateImage(image);
        }
        this.enableEvents(28L);
    }

    public void updateImage(Image image) {
        if (this.image != null) {
            this.mt.removeImage(this.image, 0);
        }
        this.mt.addImage(image, 0);
        this.image = image;
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error " + interruptedException);
            interruptedException.printStackTrace();
            Thread.currentThread().interrupt();
        }
        int n2 = 2;
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension();
        }
        if (this.imagePortion == null) {
            this.preferredSize.setSize(this.image.getWidth(null) + n2, this.image.getHeight(null) + n2);
        } else {
            this.preferredSize.setSize(this.imagePortion.width + n2, this.imagePortion.height + n2);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        int n4 = this.pressed ? 1 : 0;
        graphics.setClip(0, 0, n2, n3);
        if (!this.flat || this.flat && this.mouseEntered || this.pressed) {
            graphics2D.draw3DRect(0, 0, n2 - 1, n3 - 1, !this.pressed);
        }
        if (!this.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        if (this.imagePortion != null) {
            graphics2D.translate(-this.imagePortion.x, -this.imagePortion.y);
        }
        if (this.image != null) {
            int n5 = (this.getSize().width - this.image.getWidth(null)) / 2 + n4;
            int n6 = (this.getSize().height - this.image.getHeight(null)) / 2 + n4;
            graphics2D.drawImage(this.image, n5, n6, this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return this.getSize();
    }

    public boolean getState() {
        if (this.bistate) {
            return this.isOn;
        }
        return false;
    }

    public void setState(boolean bl) {
        if (this.bistate) {
            this.isOn = bl;
            this.pressed = bl;
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (!bl) {
            this.mouseEntered = false;
        }
        if (bl != bl2) {
            this.repaint();
        }
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 501: {
                if (this.bistate) {
                    if (!this.isOn) {
                        this.pressed = true;
                    }
                } else {
                    this.pressed = true;
                }
                this.repaint();
                break;
            }
            case 402: {
                int n3 = ((KeyEvent)aWTEvent).getKeyCode();
                if (n3 != 10 && n3 != 32) break;
            }
            case 502: {
                if (this.bistate) {
                    boolean bl = this.isOn = !this.isOn;
                    this.pressed = this.isOn;
                } else {
                    this.pressed = false;
                }
                this.repaint();
                this.fireEvent();
                break;
            }
            case 1004: {
                if (this.mouseEntered) break;
            }
            case 504: {
                if (!this.flat) break;
                this.mouseEntered = true;
                this.repaint();
                break;
            }
            case 1005: {
                if (!this.mouseEntered) break;
            }
            case 505: {
                if (!this.flat) break;
                this.mouseEntered = false;
                this.repaint();
            }
        }
        super.processEvent(aWTEvent);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this};
    }

    private void fireEvent() {
        if (this.bistate) {
            if (this.itemListener != null) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this, this.isOn ? 1 : 2);
                this.itemListener.itemStateChanged(itemEvent);
            }
        } else if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.actionCommand);
            this.actionListener.actionPerformed(actionEvent);
        }
    }
}

