/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.preview;

import com.iscobol.gui.Events;
import com.iscobol.gui.export.ExportFileChooser;
import com.iscobol.preview.DrawStringItem;
import com.iscobol.preview.PreviewDialog;
import com.iscobol.preview.PreviewDialogSettings;
import com.iscobol.preview.PreviewEvent;
import com.iscobol.preview.PreviewListener;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class Preview
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double FIT_WIDTH = -1.0;
    private static final double FIT_PAGE = -2.0;
    private final float screenResolution;
    private boolean doPrint;
    private boolean doPdf;
    private String filename;
    private int currentPageNumber = 1;
    private int nPages;
    private Printable printable;
    private PageFormat pageFormat;
    private double scale = 1.0;
    boolean antialiasing;
    private DrawStringItem findToken;
    private int findTokenStart;
    private int findTokenEnd;
    private Rectangle findRect;
    private MyPanel previewPanel;
    private JScrollPane scrollPane;
    private JPanel thumbsPanel;
    private JScrollPane thumbsScrollPane;
    private ArrayList previewListeners = new ArrayList();
    private Color selForeground;
    private Color selBackground;
    private boolean showThumbnails;
    private PreviewDialog parent;

    public Preview(Printable printable, PageFormat pageFormat, int n2, String string, Color color, PreviewDialog previewDialog) {
        this.parent = previewDialog;
        JTextField jTextField = new JTextField();
        this.selBackground = jTextField.getSelectionColor();
        this.selForeground = jTextField.getSelectedTextColor();
        this.setLayout(new BorderLayout(10, 0));
        this.setFilename(string);
        this.printable = printable;
        this.screenResolution = this.printable instanceof SpoolPrinter ? (float)((SpoolPrinter)this.printable).getGuiFactory().getScreenRes() : 96.0f;
        this.setPageFormat(pageFormat);
        this.previewPanel = new MyPanel(-1);
        this.previewPanel.boxColor = color;
        this.scrollPane = new JScrollPane(this.previewPanel);
        this.scrollPane.getVerticalScrollBar().setFocusable(false);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.scrollPane.getHorizontalScrollBar().setFocusable(false);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(100);
        this.scrollPane.getViewport().setScrollMode(2);
        this.thumbsPanel = new JPanel(new FlowLayout(1, 10, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                if (Preview.this.nPages == 0 || this.getComponentCount() == 0) {
                    return new Dimension(125, 170);
                }
                ThumbPanel thumbPanel = (ThumbPanel)this.getComponent(0);
                Dimension dimension = thumbPanel.getPreferredSize();
                return new Dimension(dimension.width, (dimension.height + 5) * Preview.this.nPages + 5);
            }
        };
        this.thumbsScrollPane = new JScrollPane(this.thumbsPanel){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = ((Preview)Preview.this).thumbsPanel.getPreferredSize().width + 30;
                dimension.height = ((Preview)Preview.this).scrollPane.getPreferredSize().height;
                return dimension;
            }
        };
        this.thumbsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.thumbsScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.thumbsScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Color.lightGray));
        this.add((Component)this.scrollPane, "Center");
        this.setPageNumber(1);
        this.scrollPane.setPreferredSize(new Dimension((int)(this.previewPanel.docWidth * (double)this.screenResolution / 80.0), (int)(this.previewPanel.docHeight * (double)this.screenResolution / 144.0)));
        this.setPageCount(n2);
        this.setVisible(true);
    }

    public void addPreviewListener(PreviewListener previewListener) {
        this.previewListeners.add(previewListener);
    }

    public void removePreviewListener(PreviewListener previewListener) {
        this.previewListeners.remove(previewListener);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isDoPrint() {
        return this.doPrint;
    }

    public void setDoPrint(boolean bl) {
        this.doPrint = bl;
    }

    public boolean isDoPdf() {
        return this.doPdf;
    }

    public void setDoPdf(boolean bl) {
        this.doPdf = bl;
    }

    public int getPageNumber() {
        return this.currentPageNumber;
    }

    public void setPageNumber(int n2) {
        if (n2 > 0 && n2 <= this.nPages && n2 != this.currentPageNumber) {
            this.currentPageNumber = n2;
            for (int i2 = 0; i2 < this.thumbsPanel.getComponentCount(); ++i2) {
                ThumbPanel thumbPanel = (ThumbPanel)this.thumbsPanel.getComponent(i2);
                thumbPanel.setSelected(i2 == n2 - 1);
                if (!thumbPanel.sel) continue;
                this.thumbsPanel.scrollRectToVisible(thumbPanel.getBounds());
            }
            this.redrawPreview();
        }
    }

    public static PreviewDialog previewDialog(Printable printable, PageFormat pageFormat, int n2, String string, PreviewDialogSettings previewDialogSettings, Events events) {
        PreviewDialog previewDialog = new PreviewDialog(printable, pageFormat, n2, string, previewDialogSettings, events);
        previewDialog.openWindow();
        return previewDialog;
    }

    public void showFirstPage() {
        this.setPageNumber(1);
    }

    public void showLastPage() {
        this.setPageNumber(this.getPageCount());
    }

    public void showNextPage() {
        this.setPageNumber(this.getPageNumber() + 1);
    }

    public void showPreviousPage() {
        this.setPageNumber(this.getPageNumber() - 1);
    }

    public int getPageCount() {
        return this.nPages;
    }

    public void setPageCount(int n2) {
        this.nPages = n2;
        this.thumbsPanel.removeAll();
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.thumbsPanel.add(new ThumbPanel(i2));
        }
        if (n2 > 0) {
            ((ThumbPanel)this.thumbsPanel.getComponent(0)).setSelected(true);
        }
        if (this.currentPageNumber > this.nPages) {
            this.showLastPage();
        }
        this.thumbsPanel.doLayout();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d2) {
        this.scale = d2;
        double d3 = this.previewPanel.getLocalScale();
        this.scrollPane.getVerticalScrollBar().setValue(0);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement((int)(10.0 * d3));
        this.scrollPane.getVerticalScrollBar().setBlockIncrement((int)(100.0 * d3));
        this.scrollPane.getHorizontalScrollBar().setValue(0);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement((int)(10.0 * d3));
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement((int)(100.0 * d3));
        this.previewPanel.setSize(this.previewPanel.getPreferredSize());
        this.previewPanel.repaint();
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean bl) {
        this.antialiasing = bl;
        this.previewPanel.repaint();
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public Printable getPrintable() {
        return this.printable;
    }

    private void redrawPreview() {
        this.previewPanel.repaint();
    }

    private void redrawThumbnails() {
        if (this.isShowThumbnails()) {
            for (int i2 = 0; i2 < this.thumbsPanel.getComponentCount(); ++i2) {
                this.thumbsPanel.getComponent(i2).repaint();
            }
        }
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.setPageFormat(pageFormat, false);
    }

    public void setPageFormat(PageFormat pageFormat, boolean bl) {
        this.pageFormat = pageFormat;
        if (this.previewPanel != null) {
            this.previewPanel.pageFormat(pageFormat, bl);
            this.redrawPreview();
            this.redrawThumbnails();
            this.revalidate();
        }
    }

    public String openSavePdfDialog(Component component, String string, String string2) {
        String string3;
        if (string2 != null && !string2.toLowerCase().endsWith(".pdf")) {
            int n2 = string2.lastIndexOf(46);
            string2 = n2 >= 0 ? string2.substring(0, n2) + ".pdf" : string2 + ".pdf";
        }
        if ((string3 = Preview.openSaveDialog(component, "pdf", "Portable Document Format (*.pdf)", string, string2)) != null) {
            this.filename = string3;
            this.doPrint = true;
            this.doPdf = true;
            return string3;
        }
        return null;
    }

    public static String openSaveDialog(Component component, String string, String string2, String string3) {
        return Preview.openSaveDialog(component, string, string2, SpoolPrinter.getSaveDefaultDirectory(), string3);
    }

    public static String openSaveDialog(Component component, String string, String string2, String string3, String string4) {
        String[] stringArray;
        String[] stringArray2;
        if (string != null) {
            stringArray2 = new String[]{string};
            stringArray = new String[]{string2 != null ? string2 : ""};
        } else {
            stringArray2 = new String[]{};
            stringArray = new String[]{};
        }
        String string5 = string4 != null ? string4 : (string3 != null ? string3 : null);
        return ExportFileChooser.openSaveDialog(string5, stringArray2, stringArray, string, false);
    }

    public void setFindToken(DrawStringItem drawStringItem, int n2, int n3) {
        this.findToken = drawStringItem;
        this.findTokenStart = n2;
        this.findTokenEnd = n3;
        if (drawStringItem != null) {
            if (drawStringItem.pageIndex != this.currentPageNumber) {
                this.currentPageNumber = drawStringItem.pageIndex;
            }
            this.previewPanel.repaint();
            SwingUtilities.invokeLater(() -> {
                Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
                if (this.findRect != null && !rectangle.contains(this.findRect)) {
                    Point point = rectangle.getLocation();
                    int n2 = this.findRect.x + this.findRect.width - rectangle.x - rectangle.width;
                    if (n2 > 0) {
                        point.x += n2;
                    } else {
                        n2 = rectangle.x - this.findRect.x;
                        if (n2 > 0) {
                            point.x -= n2;
                        }
                    }
                    n2 = this.findRect.y + this.findRect.height - rectangle.y - rectangle.height;
                    if (n2 > 0) {
                        point.y += n2;
                    } else {
                        n2 = rectangle.y - this.findRect.y;
                        if (n2 > 0) {
                            point.y -= n2;
                        }
                    }
                    this.scrollPane.getViewport().setViewPosition(point);
                    this.findRect = null;
                }
            });
        } else {
            this.previewPanel.repaint();
        }
    }

    private int getCoordinate(float f2) {
        return Math.round(f2 * this.screenResolution * (float)this.scale / 72.0f);
    }

    public JPanel getPanel() {
        return this.previewPanel;
    }

    public boolean isShowThumbnails() {
        return this.showThumbnails;
    }

    public void setShowThumbnails(boolean bl) {
        if (this.showThumbnails != bl) {
            this.showThumbnails = bl;
            if (this.showThumbnails) {
                this.add((Component)this.thumbsScrollPane, "West");
            } else {
                this.remove(this.thumbsScrollPane);
            }
            this.revalidate();
        }
    }

    static float getHeight(TextLayout textLayout) {
        return textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
    }

    private class ThumbPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        final MyPanel thumb;
        final JLabel lbl;
        final JPanel p;
        private boolean sel;
        private final Border selBorder;

        ThumbPanel(final int n2) {
            Border border;
            super(new BorderLayout());
            this.thumb = new MyPanel(n2);
            this.lbl = new JLabel("" + n2, 0);
            this.add((Component)this.lbl, "South");
            this.p = new JPanel(new BorderLayout(0, 0));
            this.p.add((Component)this.thumb, "Center");
            this.add((Component)this.p, "Center");
            this.selBorder = border = BorderFactory.createBevelBorder(1, Color.blue.brighter().brighter(), Color.blue.brighter(), Color.white.darker().darker(), Color.white.darker());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Preview.this.setPageNumber(n2);
                    Preview.this.parent.updateToolbar();
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.thumb.getPreferredSize();
            dimension.height += this.lbl.getPreferredSize().height + 5;
            return dimension;
        }

        void setSelected(boolean bl) {
            if (this.sel != bl) {
                this.sel = bl;
                if (this.sel) {
                    this.p.setBorder(this.selBorder);
                } else {
                    this.p.setBorder(null);
                }
            }
        }
    }

    class MyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final double THUMB_SCALE = 0.125;
        private double docHeight = 500.0;
        private double docWidth = 500.0;
        private Rectangle2D.Double clipping;
        private Rectangle2D.Double fullPage;
        private Color boxColor;
        private int pageNumber;
        private final boolean isThumbnail;

        MyPanel(int n2) {
            this.pageNumber = n2;
            boolean bl = this.isThumbnail = n2 >= 0;
            if (this.isThumbnail) {
                this.setOpaque(false);
            } else {
                this.setBackground(Color.lightGray);
            }
            this.pageFormat(Preview.this.getPageFormat(), true);
            this.setLayout(null);
        }

        private int pageNumber() {
            return this.isThumbnail ? this.pageNumber : Preview.this.currentPageNumber;
        }

        @Override
        public Dimension getPreferredSize() {
            double d2 = this.getLocalScale();
            return new Dimension((int)(this.docWidth * d2), (int)(this.docHeight * d2));
        }

        double getLocalScale() {
            double d2;
            if (this.isThumbnail) {
                d2 = 0.125;
            } else {
                Dimension dimension = Preview.this.scrollPane.getViewport().getSize();
                d2 = Preview.this.scale;
                if (Preview.this.scale < 0.0) {
                    if (Preview.this.scale == -1.0) {
                        d2 = (double)dimension.width / this.docWidth;
                    } else if (Preview.this.scale == -2.0) {
                        d2 = Math.min((double)dimension.height / this.docHeight, (double)dimension.width / this.docWidth);
                    }
                }
            }
            return d2 * (double)Preview.this.screenResolution / 72.0;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Preview.this.antialiasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            double d2 = this.getLocalScale();
            Printable printable = Preview.this.getPrintable();
            PageFormat pageFormat = Preview.this.getPageFormat();
            if (printable == null || pageFormat == null) {
                graphics2D.drawString("Test MyPanel", 0, 0);
            } else {
                try {
                    SpoolPrinter spoolPrinter;
                    Object object;
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics2D.scale(d2, d2);
                    graphics2D.setColor(Color.white);
                    graphics2D.fill(this.fullPage);
                    graphics2D.setColor(Color.black);
                    graphics2D.draw(this.fullPage);
                    graphics2D.clip(this.clipping);
                    int n2 = this.pageNumber();
                    if (printable.print(graphics2D, pageFormat, n2 - 1) == 1 && n2 > 1) {
                        --n2;
                        object = new PreviewEvent(Preview.this);
                        for (int i2 = 0; i2 < Preview.this.previewListeners.size(); ++i2) {
                            ((PreviewListener)Preview.this.previewListeners.get(i2)).noSuchPage((PreviewEvent)object);
                        }
                        printable.print(graphics2D, pageFormat, n2 - 1);
                    }
                    graphics2D.setColor(this.boxColor);
                    graphics2D.setStroke(new BasicStroke(1.0f));
                    object = new double[4];
                    if (printable instanceof SpoolPrinter && (spoolPrinter = (SpoolPrinter)printable).isReportPreview()) {
                        object = spoolPrinter.getMargins(4);
                    }
                    graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth() - 1.0 - object[2] - object[3], pageFormat.getImageableHeight() - 1.0 - object[0] - object[1]));
                    if (Preview.this.findToken != null && ((Preview)Preview.this).findToken.pageIndex == n2) {
                        graphics2D.setFont(((Preview)Preview.this).findToken.font);
                        String string = ((Preview)Preview.this).findToken.text;
                        float f2 = ((Preview)Preview.this).findToken.x;
                        if (Preview.this.findTokenStart >= 0 && Preview.this.findTokenStart < Preview.this.findTokenEnd && Preview.this.findTokenEnd <= string.length()) {
                            if (Preview.this.findTokenStart > 0) {
                                TextLayout textLayout = new TextLayout(string.substring(0, Preview.this.findTokenStart), graphics2D.getFont(), graphics2D.getFontRenderContext());
                                f2 += textLayout.getAdvance();
                            }
                            string = string.substring(Preview.this.findTokenStart, Preview.this.findTokenEnd);
                        }
                        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
                        float f3 = Preview.getHeight(textLayout) + 1.0f;
                        Rectangle2D.Float float_ = new Rectangle2D.Float(f2, ((Preview)Preview.this).findToken.y - f3 + textLayout.getDescent(), textLayout.getAdvance() + 1.0f, f3);
                        graphics2D.setColor(Preview.this.selBackground);
                        graphics2D.fill(float_);
                        graphics2D.setColor(Preview.this.selForeground);
                        graphics2D.drawString(string, f2, ((Preview)Preview.this).findToken.y);
                        Preview.this.findRect = new Rectangle(Preview.this.getCoordinate(float_.x), Preview.this.getCoordinate(float_.y), Preview.this.getCoordinate(float_.width), Preview.this.getCoordinate(float_.height));
                    }
                }
                catch (PrinterException printerException) {
                    graphics2D.drawString("" + printerException, 0, 0);
                }
            }
        }

        void pageFormat(PageFormat pageFormat, boolean bl) {
            if (pageFormat != null) {
                this.docWidth = pageFormat.getWidth();
                this.docHeight = pageFormat.getHeight();
                this.clipping = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
            } else {
                this.docHeight = 500.0;
                this.docWidth = 500.0;
                this.clipping = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
            if (bl) {
                this.fullPage = new Rectangle2D.Double(0.0, 0.0, this.docWidth, this.docHeight);
            }
        }
    }
}

