/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.preview;

import com.iscobol.gui.Events;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.IscobolWindow;
import com.iscobol.preview.DrawStringItem;
import com.iscobol.preview.Preview;
import com.iscobol.preview.PreviewDialogSettings;
import com.iscobol.preview.PreviewEvent;
import com.iscobol.preview.PreviewListener;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FindDialog;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class PreviewDialog
implements PreviewListener,
FindDialog.FindListener {
    public static final String DEFAULT_DIALOG_TITLE = "Print Preview";
    private static final Dimension IMAGE_BTN_SIZE = new Dimension(25, 25);
    private static final double FIT_WIDTH = -1.0;
    private static final double FIT_PAGE = -2.0;
    private Window window;
    private JPanel commands;
    private JToolBar commandsTbl;
    private Preview preview;
    private JTextField page;
    private JComboBox zoom;
    private JLabel pageCountLbl;
    private Dimension preferredSize;
    private JButton minMaxBtn;
    private JButton firstPageBtn;
    private JButton nextPageBtn;
    private JButton prevPageBtn;
    private JButton lastPageBtn;
    private JButton saveBtn;
    private JButton printBtn;
    private JButton quitBtn;
    private JButton findBtn;
    private JButton zoomInBtn;
    private JButton zoomOutBtn;
    private JButton pageSetupBtn;
    private JCheckBox showThumbBtn;
    private JCheckBox antialiasingChk;
    private Events events;
    private FindDialog findDialog;
    private Printable printable;
    private PageFormat pageFormat;
    private Vector findTokens;
    private int findTokenIdx;
    private int findTokenStartOffs;
    private int findTokenEndOffs;
    private boolean maximized;
    private Rectangle restoreBounds;
    private Object lock = new Object();
    private Map<Window, Boolean> winMap = new LinkedHashMap<Window, Boolean>();
    private ItemListener zoomItemListener;
    private Object[][] zoomValues = new Object[][]{{"1600%", 16.0}, {"800%", 8.0}, {"400%", 4.0}, {"200%", 2.0}, {"150%", 1.5}, {"100%", 1.0}, {"66%", 0.6666666666666666}, {"50%", 0.5}, {"33%", 0.3333333333333333}, {"25%", 0.25}, {Factory.getSysMsg("fit_width"), -1.0}, {Factory.getSysMsg("fit_page"), -2.0}};
    static final double MAX_SCALE = 16.0;
    static final double MIN_SCALE = 0.25;

    private void handlePageTxtEvent() {
        String string = this.page.getText();
        try {
            int n2 = Integer.parseInt(string);
            this.preview.setPageNumber(n2);
        }
        catch (NumberFormatException numberFormatException) {
            this.page.setText("" + this.preview.getPageNumber());
        }
    }

    public PreviewDialog(Printable printable, PageFormat pageFormat, int n2, String string, PreviewDialogSettings previewDialogSettings, Events events) {
        Vector vector;
        Image image;
        Image image2;
        Object object;
        Object object2;
        String string2 = previewDialogSettings.getTitle() != null ? previewDialogSettings.getTitle() : DEFAULT_DIALOG_TITLE;
        Container container = null;
        this.window = null;
        for (Window object32 : Window.getWindows()) {
            if (!object32.isVisible() || !(object32 instanceof JDialog) || !((JDialog)object32).isModal()) continue;
            object2 = new JDialog((JDialog)object32, string2, true);
            ((Window)object2).setIconImage(previewDialogSettings.getIconImage());
            container = ((JDialog)object2).getContentPane();
            this.window = object2;
            break;
        }
        if (this.window == null) {
            object = new JFrame(string2);
            ((JFrame)object).setIconImage(previewDialogSettings.getIconImage());
            container = ((JFrame)object).getContentPane();
            this.window = object;
        }
        this.events = events;
        this.printable = printable;
        this.pageFormat = pageFormat;
        container.setLayout(new BorderLayout());
        object = this.window.getToolkit().getImage(this.getClass().getResource("arrow_beg.png"));
        Image image3 = this.window.getToolkit().getImage(this.getClass().getResource("arrow_back.png"));
        Image image4 = this.window.getToolkit().getImage(this.getClass().getResource("arrow_next.png"));
        Image image5 = this.window.getToolkit().getImage(this.getClass().getResource("arrow_end.png"));
        object2 = this.window.getToolkit().getImage(this.getClass().getResource("zoom_in.png"));
        Image image6 = this.window.getToolkit().getImage(this.getClass().getResource("zoom_out.png"));
        Image image7 = this.window.getToolkit().getImage(this.getClass().getResource("antialiasing.gif"));
        Image image8 = this.window.getToolkit().getImage(this.getClass().getResource("file_pdf.gif"));
        Image image9 = this.window.getToolkit().getImage(this.getClass().getResource("printer.png"));
        Image image10 = this.window.getToolkit().getImage(this.getClass().getResource("pagesetup.png"));
        Image image11 = this.window.getToolkit().getImage(this.getClass().getResource("exit.png"));
        Image image12 = this.window.getToolkit().getImage(this.getClass().getResource("find.gif"));
        Image image13 = this.window.getToolkit().getImage(this.getClass().getResource("show_thumbnails.gif"));
        if (!this.isJFrame()) {
            image2 = this.window.getToolkit().getImage(this.getClass().getResource("maximize.png"));
            image = this.window.getToolkit().getImage(this.getClass().getResource("restore.png"));
        } else {
            image = null;
            image2 = null;
        }
        this.window.addWindowListener(IsguiUtility.windowClosingAdapter(windowEvent -> this.closeWindow()));
        this.maximized = previewDialogSettings.isMaximized();
        this.commandsTbl = new JToolBar();
        this.commandsTbl.setLayout(new BorderLayout());
        this.commands = new JPanel(new FlowLayout());
        this.preview = new Preview(printable, pageFormat, n2, string, previewDialogSettings.getPrintableAreaBoxColor(), this);
        this.preview.addPreviewListener(this);
        boolean bl = previewDialogSettings.getShowThumbnails();
        this.preview.setShowThumbnails(bl);
        if (previewDialogSettings.getShowThumbnailsButton()) {
            this.showThumbBtn = new JCheckBox();
            this.showThumbBtn.setIcon(new ImageIcon(image13));
            this.showThumbBtn.setToolTipText(Factory.getSysMsg("show_thumbs"));
            this.commands.add(this.showThumbBtn);
            this.showThumbBtn.setPreferredSize(IMAGE_BTN_SIZE);
            this.showThumbBtn.setBorderPainted(true);
            this.showThumbBtn.setSelected(bl);
            if (bl) {
                this.showThumbBtn.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.showThumbBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            this.showThumbBtn.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.showThumbBtn.setBorder(BorderFactory.createLoweredBevelBorder());
                    this.preview.setShowThumbnails(true);
                } else {
                    this.showThumbBtn.setBorder(BorderFactory.createRaisedBevelBorder());
                    this.preview.setShowThumbnails(false);
                }
            });
        }
        if (previewDialogSettings.getShowSaveButton()) {
            this.saveBtn = new JButton();
            this.saveBtn.setIcon(new ImageIcon(image8));
            this.saveBtn.setToolTipText(Factory.getSysMsg("save"));
            this.commands.add(this.saveBtn);
            this.saveBtn.addActionListener(actionEvent -> {
                String string;
                String string2 = previewDialogSettings.getSaveDefaultDirectory();
                String string3 = previewDialogSettings.getSaveDefaultFilename();
                if (string3 == null) {
                    string3 = ((SpoolPrinter)this.printable).getReportName();
                    if (string3 == null) {
                        string3 = ((SpoolPrinter)this.printable).getJobName();
                    } else if (string3.toLowerCase().startsWith("@[display]:")) {
                        string3 = string3.substring(11);
                    }
                    if (string3 != null) {
                        int n2 = (string3 = new File(string3).getName()).lastIndexOf(46);
                        string3 = n2 >= 0 ? string3.substring(0, n2) + ".pdf" : string3 + ".pdf";
                    }
                }
                if ((string = this.preview.openSavePdfDialog(this.saveBtn, string2, string3)) != null) {
                    if (previewDialogSettings.isCloseWindowAfterPrintPdf()) {
                        this.closeWindow();
                    } else {
                        try {
                            ((SpoolPrinter)this.printable).printPDF(string);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this.window, exception.getMessage(), exception.getClass().getName(), 0);
                        }
                        finally {
                            this.preview.setDoPdf(false);
                            this.preview.setDoPrint(false);
                        }
                        JOptionPane.showMessageDialog(this.window, "Created file '" + string + "'");
                    }
                }
            });
            this.saveBtn.setPreferredSize(IMAGE_BTN_SIZE);
        }
        if (previewDialogSettings.getShowPrintButton()) {
            this.printBtn = new JButton();
            this.printBtn.setIcon(new ImageIcon(image9));
            this.printBtn.setToolTipText(Factory.getSysMsg("print"));
            this.commands.add(this.printBtn);
            this.printBtn.addActionListener(actionEvent -> {
                SpoolPrinter spoolPrinter = (SpoolPrinter)this.printable;
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PrintRequestAttributeSet printRequestAttributeSet = null;
                if (!previewDialogSettings.getShowPrintDialog() || (printRequestAttributeSet = this.setupPrinter(printerJob, spoolPrinter)) != null) {
                    spoolPrinter.setSavedPrintRequestAttributeSet(printRequestAttributeSet);
                    this.clearPages();
                    if (previewDialogSettings.isCloseWindowAfterPrint()) {
                        this.preview.setDoPrint(true);
                        this.closeWindow();
                    } else {
                        try {
                            printerJob.setPrintable(spoolPrinter);
                            printerJob.setPrintService(spoolPrinter.getCurrPrintService());
                            printerJob.print(spoolPrinter.getPrintRequestAttributeSet());
                        }
                        catch (PrinterException printerException) {
                            JOptionPane.showMessageDialog(this.window, printerException.getMessage(), printerException.getClass().getName(), 0);
                        }
                        spoolPrinter.restorePrintRequestAttributeSet();
                        this.preview.setPageFormat(spoolPrinter.getPageFormat(PrinterJob.getPrinterJob()), true);
                        this.preview.setPageCount(spoolPrinter.getPageCount());
                        this.pageCountLbl.setText("/" + this.preview.getPageCount());
                        this.updateToolbar();
                    }
                }
            });
            this.printBtn.setPreferredSize(IMAGE_BTN_SIZE);
        }
        if (previewDialogSettings.getShowPrintSetupButton()) {
            this.pageSetupBtn = new JButton();
            this.pageSetupBtn.setIcon(new ImageIcon(image10));
            this.pageSetupBtn.setToolTipText(Factory.getSysMsg("page_setup"));
            this.commands.add(this.pageSetupBtn);
            this.pageSetupBtn.setPreferredSize(IMAGE_BTN_SIZE);
            this.pageSetupBtn.addActionListener(actionEvent -> {
                SpoolPrinter spoolPrinter = (SpoolPrinter)this.printable;
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PrintRequestAttributeSet printRequestAttributeSet = this.setupPage(printerJob, spoolPrinter);
                if (printRequestAttributeSet != null) {
                    spoolPrinter.setSavedPrintRequestAttributeSet(printRequestAttributeSet);
                    this.clearPages();
                    this.preview.setPageFormat(spoolPrinter.getPageFormat(PrinterJob.getPrinterJob()), true);
                    this.preview.setPageCount(spoolPrinter.getPageCount());
                    this.pageCountLbl.setText("/" + this.preview.getPageCount());
                    this.updateToolbar();
                }
            });
        }
        this.quitBtn = new JButton();
        this.quitBtn.setIcon(new ImageIcon(image11));
        this.quitBtn.setToolTipText(Factory.getSysMsg("quit"));
        this.commands.add(this.quitBtn);
        this.quitBtn.addActionListener(actionEvent -> this.quit());
        this.quitBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.findBtn = new JButton();
        this.findBtn.setIcon(new ImageIcon(image12));
        this.findBtn.setToolTipText(Factory.getSysMsg("find"));
        this.commands.add(this.findBtn);
        this.findBtn.addActionListener(actionEvent -> this.find());
        this.findBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.commands.add(new JToolBar.Separator());
        this.firstPageBtn = new JButton();
        this.commands.add(this.firstPageBtn);
        this.firstPageBtn.addActionListener(actionEvent -> {
            this.preview.showFirstPage();
            this.updateToolbar();
        });
        this.firstPageBtn.setIcon(new ImageIcon((Image)object));
        this.firstPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.firstPageBtn.setToolTipText(Factory.getSysMsg("first_page"));
        this.prevPageBtn = new JButton();
        this.commands.add(this.prevPageBtn);
        this.prevPageBtn.addActionListener(actionEvent -> {
            this.preview.showPreviousPage();
            this.updateToolbar();
        });
        this.prevPageBtn.setIcon(new ImageIcon(image3));
        this.prevPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.prevPageBtn.setToolTipText(Factory.getSysMsg("prev_page"));
        this.commands.add(new JLabel(Factory.getSysMsg("page"), 2));
        this.page = new JTextField("" + this.preview.getPageNumber());
        this.commands.add(this.page);
        this.page.addFocusListener(IsguiUtility.focusLostAdapter(focusEvent -> {
            this.handlePageTxtEvent();
            this.updateToolbar();
        }));
        this.page.addActionListener(actionEvent -> {
            this.handlePageTxtEvent();
            this.updateToolbar();
        });
        this.page.setPreferredSize(new Dimension(50, 25));
        this.page.setHorizontalAlignment(4);
        this.pageCountLbl = new JLabel("/" + this.preview.getPageCount(), 2);
        this.commands.add(this.pageCountLbl);
        this.nextPageBtn = new JButton();
        this.commands.add(this.nextPageBtn);
        this.nextPageBtn.addActionListener(actionEvent -> {
            this.preview.showNextPage();
            this.updateToolbar();
        });
        this.nextPageBtn.setIcon(new ImageIcon(image4));
        this.nextPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.nextPageBtn.setToolTipText(Factory.getSysMsg("next_page"));
        this.lastPageBtn = new JButton();
        this.commands.add(this.lastPageBtn);
        this.lastPageBtn.addActionListener(actionEvent -> {
            this.preview.showLastPage();
            this.updateToolbar();
        });
        this.lastPageBtn.setIcon(new ImageIcon(image5));
        this.lastPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.lastPageBtn.setToolTipText(Factory.getSysMsg("last_page"));
        this.commands.add(new JToolBar.Separator());
        this.zoomOutBtn = new JButton();
        this.commands.add(this.zoomOutBtn);
        this.zoomOutBtn.addActionListener(actionEvent -> {
            int n2 = this.zoom.getSelectedIndex();
            if (n2 >= 0) {
                if (++n2 < this.zoomValues.length && (Double)this.zoomValues[n2][1] > 0.0) {
                    this.zoom.setSelectedIndex(n2);
                    this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                }
            } else {
                try {
                    double d2 = this.getScale(this.zoom.getEditor().getItem()) / 100.0;
                    for (int i2 = 0; i2 < this.zoomValues.length; ++i2) {
                        if (!(d2 > (Double)this.zoomValues[i2][1])) continue;
                        this.zoom.setSelectedIndex(i2);
                        this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.zoomOutBtn.setIcon(new ImageIcon(image6));
        this.zoomOutBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.zoomOutBtn.setToolTipText(Factory.getSysMsg("zoom_out"));
        this.zoom = new JComboBox();
        this.zoom.setEditable(true);
        this.zoom.setEditor(new MyComboEditor());
        for (int fontMetrics = 0; fontMetrics < this.zoomValues.length; ++fontMetrics) {
            this.zoom.addItem((String)this.zoomValues[fontMetrics][0]);
        }
        this.zoomItemListener = itemEvent -> {
            int n2 = this.zoom.getSelectedIndex();
            if (n2 >= 0) {
                double d2 = (Double)this.zoomValues[n2][1];
                this.preview.setScale(d2);
            } else {
                try {
                    double d3 = this.getScale(this.zoom.getEditor().getItem());
                    this.changeScale(d3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.zoom.addItemListener(this.zoomItemListener);
        FontMetrics fontMetrics = this.zoom.getFontMetrics(this.zoom.getFont());
        int n3 = fontMetrics.stringWidth(this.zoom.getItemAt(this.zoom.getItemCount() - 2).toString());
        int n4 = fontMetrics.stringWidth(this.zoom.getItemAt(this.zoom.getItemCount() - 1).toString());
        this.zoom.setPreferredSize(new Dimension(Math.max(n3, n4) + 25, 25));
        this.commands.add(this.zoom);
        this.zoomInBtn = new JButton();
        this.commands.add(this.zoomInBtn);
        this.zoomInBtn.addActionListener(actionEvent -> {
            int n2 = this.zoom.getSelectedIndex();
            if (n2 >= 0) {
                if (--n2 >= 0 && (Double)this.zoomValues[n2][1] > 0.0) {
                    this.zoom.setSelectedIndex(n2);
                    this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                }
            } else if (this.zoom.getEditor().getItem() != null) {
                try {
                    double d2 = this.getScale(this.zoom.getEditor().getItem()) / 100.0;
                    for (int i2 = this.zoomValues.length - 3; i2 >= 0; --i2) {
                        if (!(d2 < (Double)this.zoomValues[i2][1])) continue;
                        this.zoom.setSelectedIndex(i2);
                        this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.zoomInBtn.setIcon(new ImageIcon((Image)object2));
        this.zoomInBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.zoomInBtn.setToolTipText(Factory.getSysMsg("zoom_in"));
        this.antialiasingChk = new JCheckBox();
        this.commands.add(this.antialiasingChk);
        this.antialiasingChk.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.antialiasingChk.setBorder(BorderFactory.createLoweredBevelBorder());
                this.preview.setAntialiasing(true);
            } else {
                this.antialiasingChk.setBorder(BorderFactory.createRaisedBevelBorder());
                this.preview.setAntialiasing(false);
            }
        });
        this.antialiasingChk.setIcon(new ImageIcon(image7));
        this.antialiasingChk.setPreferredSize(IMAGE_BTN_SIZE);
        this.antialiasingChk.setBorderPainted(true);
        this.antialiasingChk.setBorder(BorderFactory.createRaisedBevelBorder());
        this.antialiasingChk.setToolTipText(Factory.getSysMsg("antialiasing"));
        int[] nArray = ((SpoolPrinter)this.printable).getSearchChars();
        int[] nArray2 = ((SpoolPrinter)this.printable).getSearchMasks();
        if (nArray != null && nArray2 != null && nArray.length == nArray2.length) {
            for (int rectangle = 0; rectangle < nArray.length; ++rectangle) {
                PreviewDialog.addAccelerator(this.findBtn, KeyStroke.getKeyStroke(nArray[rectangle], nArray2[rectangle]), new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PreviewDialog.this.find();
                    }
                });
            }
        }
        PreviewDialog.addAccelerator(this.quitBtn, KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewDialog.this.quit();
            }
        });
        this.commands.add(new JToolBar.Separator());
        if (!this.isJFrame()) {
            this.minMaxBtn = new JButton();
            this.commands.add(this.minMaxBtn);
            this.minMaxBtn.addActionListener(actionEvent -> {
                if (this.maximized) {
                    this.doRestore(image2);
                } else {
                    this.doMaximize(image);
                }
            });
            if (this.maximized) {
                this.minMaxBtn.setIcon(new ImageIcon(image));
                this.minMaxBtn.setToolTipText(Factory.getSysMsg("restore"));
            } else {
                this.minMaxBtn.setIcon(new ImageIcon(image2));
                this.minMaxBtn.setToolTipText(Factory.getSysMsg("maximize"));
            }
            this.minMaxBtn.setPreferredSize(IMAGE_BTN_SIZE);
        }
        this.commandsTbl.add((Component)this.commands, "West");
        container.add((Component)this.commandsTbl, "North");
        container.add((Component)this.preview, "Center");
        Rectangle rectangle = previewDialogSettings.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.preferredSize = rectangle.getSize();
            this.window.setPreferredSize(this.preferredSize);
        }
        if (previewDialogSettings.isShowExportMenu() && !(vector = previewDialogSettings.getMenuBar().getChildren()).isEmpty()) {
            JMenuBar jMenuBar = new JMenuBar();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                PreviewDialogSettings.Menu menu = (PreviewDialogSettings.Menu)vector.elementAt(i2);
                if (menu.getChildren().isEmpty()) continue;
                JMenu jMenu = new JMenu(menu.getTitle());
                jMenuBar.add(jMenu);
                this.addMenuItems(menu.getChildren(), jMenu);
            }
            if (this.isJFrame()) {
                ((JFrame)this.window).setJMenuBar(jMenuBar);
            } else {
                ((JDialog)this.window).setJMenuBar(jMenuBar);
            }
        }
        this.window.pack();
        if (rectangle.x > 0 && rectangle.y > 0) {
            this.window.setLocation(rectangle.getLocation());
        } else if (rectangle.x == 0 && rectangle.y == 0) {
            this.window.setLocationRelativeTo(null);
        } else if (rectangle.x == 0) {
            this.window.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.window.getSize().width) / 2, rectangle.y);
        } else if (rectangle.y == 0) {
            this.window.setLocation(rectangle.x, (Toolkit.getDefaultToolkit().getScreenSize().height - this.window.getSize().height) / 2);
        }
        this.updateToolbar();
        this.antialiasingChk.setSelected(previewDialogSettings.isAntialiasing());
        this.preview.setAntialiasing(previewDialogSettings.isAntialiasing());
        this.changeScale(previewDialogSettings.getScale());
        if (this.maximized) {
            this.doMaximize(image);
        }
    }

    private void doMaximize(Image image) {
        if (this.isJFrame()) {
            ((JFrame)this.window).setExtendedState(6);
        } else {
            this.restoreBounds = this.window.getBounds();
            Rectangle rectangle = this.window.getGraphicsConfiguration().getBounds();
            ((JDialog)this.window).setResizable(false);
            this.window.setBounds(rectangle);
            this.minMaxBtn.setIcon(new ImageIcon(image));
            this.minMaxBtn.setToolTipText(Factory.getSysMsg("restore"));
        }
        this.maximized = true;
    }

    private void doRestore(Image image) {
        if (this.isJFrame()) {
            ((JFrame)this.window).setExtendedState(0);
        } else {
            ((JDialog)this.window).setResizable(true);
            this.window.setBounds(this.restoreBounds);
            this.minMaxBtn.setIcon(new ImageIcon(image));
            this.minMaxBtn.setToolTipText(Factory.getSysMsg("maximize"));
            this.restoreBounds = null;
        }
        this.maximized = false;
    }

    private static boolean addAccelerator(JButton jButton, KeyStroke keyStroke, Action action) {
        ActionMap actionMap = jButton.getActionMap();
        InputMap inputMap = jButton.getInputMap(2);
        actionMap.put("printPreviewAction", action);
        inputMap.put(keyStroke, "printPreviewAction");
        return true;
    }

    private void quit() {
        this.preview.setDoPrint(false);
        this.closeWindow();
    }

    private boolean isJFrame() {
        return this.window instanceof JFrame;
    }

    private void find() {
        if (this.findDialog == null) {
            this.findDialog = this.isJFrame() ? new FindDialog((JFrame)this.window, Factory.getSysMsg("find"), true) : new FindDialog((JDialog)this.window, Factory.getSysMsg("find"), true);
            this.findDialog.setFindListener(this);
        }
        this.findDialog.setLocationRelativeTo(this.window);
        this.findDialog.open();
        this.findDialog.toFront();
    }

    private void addMenuItems(Vector vector, JMenu jMenu) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            JMenuItem jMenuItem;
            PreviewDialogSettings.Menu menu = (PreviewDialogSettings.Menu)vector.elementAt(i2);
            if (menu.getChildren().isEmpty()) {
                jMenuItem = new JMenuItem(menu.getTitle(), menu.getIcon());
                jMenuItem.setActionCommand(Integer.toString(menu.getActionCode()));
                jMenuItem.addActionListener(actionEvent -> {
                    if (this.events != null) {
                        RemoteRecordAccept remoteRecordAccept = new RemoteRecordAccept();
                        remoteRecordAccept.setKeyStatus(Integer.parseInt(actionEvent.getActionCommand()));
                        try {
                            this.events.fireevent(remoteRecordAccept);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenu(menu.getTitle());
            jMenu.add(jMenuItem);
            this.addMenuItems(menu.getChildren(), (JMenu)jMenuItem);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize != null ? this.preferredSize : this.window.getPreferredSize();
    }

    private double getScale(Object object) throws NumberFormatException {
        if (object == null) {
            throw new NumberFormatException("null");
        }
        String string = object.toString();
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        return Double.parseDouble(string);
    }

    private void changeScale(double d2) {
        this.zoom.removeItemListener(this.zoomItemListener);
        if (d2 == -1.0) {
            this.zoom.setSelectedIndex(this.zoom.getItemCount() - 2);
            this.preview.setScale(d2);
        } else if (d2 == -2.0) {
            this.zoom.setSelectedIndex(this.zoom.getItemCount() - 1);
            this.preview.setScale(d2);
        } else {
            double d3 = d2 / 100.0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.zoomValues.length & !bl) {
                if (d3 == (Double)this.zoomValues[n2][1]) {
                    this.zoom.setSelectedIndex(n2);
                    this.preview.setScale(d3);
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                if (d3 < 0.25) {
                    d3 = 0.25;
                    d2 = 0.0;
                }
                if (d3 > 16.0) {
                    d3 = 16.0;
                    d2 = 1600.0;
                }
                this.preview.setScale(d3);
                this.zoom.setSelectedItem("" + d2 + "%");
            }
        }
        this.zoom.addItemListener(this.zoomItemListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openWindow() {
        if (this.isJFrame()) {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (window instanceof IscobolWindow) {
                Serializable serializable;
                long l2 = ((IscobolWindow)((Object)window)).getId();
                long l3 = -1L;
                if (this.printable instanceof SpoolPrinter && (serializable = ((SpoolPrinter)this.printable).getGuiFactory()) != null) {
                    l3 = serializable.getId();
                }
                if (l2 == l3) {
                    while (window instanceof IscobolWindow) {
                        serializable = Boolean.valueOf(window.isEnabled());
                        window.setEnabled(false);
                        this.winMap.put(window, (Boolean)serializable);
                        window = window.getOwner();
                    }
                }
            }
            this.window.setVisible(true);
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.window.setVisible(true);
    }

    void updateToolbar() {
        this.page.setText("" + this.preview.getPageNumber());
        if (this.preview.getPageNumber() == 1) {
            this.firstPageBtn.setEnabled(false);
            this.prevPageBtn.setEnabled(false);
            if (this.preview.getPageNumber() == this.preview.getPageCount()) {
                this.nextPageBtn.setEnabled(false);
                this.lastPageBtn.setEnabled(false);
            } else {
                this.nextPageBtn.setEnabled(true);
                this.lastPageBtn.setEnabled(true);
            }
        } else if (this.preview.getPageNumber() == this.preview.getPageCount()) {
            this.firstPageBtn.setEnabled(true);
            this.prevPageBtn.setEnabled(true);
            this.nextPageBtn.setEnabled(false);
            this.lastPageBtn.setEnabled(false);
        } else {
            this.firstPageBtn.setEnabled(true);
            this.prevPageBtn.setEnabled(true);
            this.nextPageBtn.setEnabled(true);
            this.lastPageBtn.setEnabled(true);
        }
    }

    public Preview getPreview() {
        return this.preview;
    }

    @Override
    public void noSuchPage(PreviewEvent previewEvent) {
        this.page.setText("" + this.preview.getPageNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWindow() {
        this.preview.removePreviewListener(this);
        if (this.isJFrame()) {
            for (Window window : this.winMap.keySet()) {
                window.setEnabled(this.winMap.get(window));
            }
            this.window.dispose();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        } else {
            this.window.dispose();
        }
    }

    public boolean getAntialiasing() {
        return this.antialiasingChk.isSelected();
    }

    public boolean isMaximized() {
        return this.isJFrame() ? ((JFrame)this.window).getExtendedState() == 6 : this.maximized;
    }

    public Rectangle getRestoreBounds() {
        return this.isJFrame() || !this.maximized ? this.window.getBounds() : this.restoreBounds;
    }

    public double getScale() {
        if (this.zoom.getSelectedIndex() >= 0) {
            if (this.zoom.getSelectedIndex() < this.zoom.getItemCount() - 2) {
                return (Double)this.zoomValues[this.zoom.getSelectedIndex()][1] * 100.0;
            }
            return (Double)this.zoomValues[this.zoom.getSelectedIndex()][1];
        }
        if (this.zoom.getEditor().getItem() != null) {
            return this.getScale(this.zoom.getEditor().getItem());
        }
        return 0.0;
    }

    private void setMargins(SpoolPrinter spoolPrinter, PrintRequestAttributeSet printRequestAttributeSet) {
        if (!spoolPrinter.isReportPreview()) {
            return;
        }
        spoolPrinter.setMargins(printRequestAttributeSet);
    }

    private PrintRequestAttributeSet setupPage(PrinterJob printerJob, SpoolPrinter spoolPrinter) {
        boolean bl;
        PrintRequestAttributeSet printRequestAttributeSet = spoolPrinter.getPrintRequestAttributeSet();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet(printRequestAttributeSet);
        MediaPrintableArea mediaPrintableArea = null;
        if (spoolPrinter.isReportPreview()) {
            mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
            printRequestAttributeSet.add(spoolPrinter.getMediaPrintableArea(printRequestAttributeSet.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE));
        }
        boolean bl2 = bl = printerJob.pageDialog(printRequestAttributeSet) != null;
        if (bl) {
            Media media = (Media)printRequestAttributeSet.get(Media.class);
            if (media != null && media instanceof MediaSizeName) {
                spoolPrinter.setMediaSize((MediaSizeName)media);
            }
            if (spoolPrinter.isReportPreview()) {
                this.setMargins(spoolPrinter, printRequestAttributeSet);
            }
            return hashPrintRequestAttributeSet;
        }
        if (mediaPrintableArea != null) {
            printRequestAttributeSet.add(mediaPrintableArea);
        }
        return null;
    }

    private PrintRequestAttributeSet setupPrinter(PrinterJob printerJob, SpoolPrinter spoolPrinter) {
        boolean bl;
        PrintRequestAttributeSet printRequestAttributeSet = spoolPrinter.getPrintRequestAttributeSet();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet(printRequestAttributeSet);
        MediaPrintableArea mediaPrintableArea = null;
        if (spoolPrinter.isReportPreview()) {
            mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
            printRequestAttributeSet.add(spoolPrinter.getMediaPrintableArea(printRequestAttributeSet.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE));
        }
        if (spoolPrinter.getCurrPrintService() != null) {
            try {
                printerJob.setPrintService(spoolPrinter.getCurrPrintService());
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
        if (bl = printerJob.printDialog(printRequestAttributeSet)) {
            Media media = (Media)printRequestAttributeSet.get(Media.class);
            if (media != null && media instanceof MediaSizeName) {
                spoolPrinter.setMediaSize((MediaSizeName)media);
            }
            if (spoolPrinter.isReportPreview()) {
                this.setMargins(spoolPrinter, printRequestAttributeSet);
            }
            if (printerJob.getPrintService() != null) {
                spoolPrinter.setCurrPrinter(printerJob.getPrintService());
            }
            return hashPrintRequestAttributeSet;
        }
        if (mediaPrintableArea != null) {
            printRequestAttributeSet.add(mediaPrintableArea);
        }
        return null;
    }

    @Override
    public void find(FindDialog.FindParam findParam) {
        if (this.findTokens == null || this.findTokens.isEmpty()) {
            this.clearPages();
            this.buildPages();
        }
        this.find(findParam.toSearch, findParam.matchCase, findParam.backSearch, findParam.matchMinusUnderscore);
        if (this.findTokenIdx >= 0) {
            DrawStringItem drawStringItem = (DrawStringItem)this.findTokens.elementAt(this.findTokenIdx);
            this.preview.setFindToken(drawStringItem, this.findTokenStartOffs, this.findTokenEndOffs);
            this.updateToolbar();
        } else {
            JOptionPane.showMessageDialog(this.window, "'" + findParam.toSearch + "': not found");
            this.preview.setFindToken(null, -1, -1);
            this.resetFind();
        }
    }

    private void clearPages() {
        SpoolPrinter spoolPrinter = (SpoolPrinter)this.printable;
        spoolPrinter.clearPages();
        this.resetFind();
    }

    private void buildPages() {
        SpoolPrinter spoolPrinter = (SpoolPrinter)this.printable;
        PreviewGraphics previewGraphics = new PreviewGraphics();
        spoolPrinter.buildPages(previewGraphics, this.pageFormat, true);
    }

    private void resetFind() {
        this.findTokens = new Vector();
        this.findTokenIdx = 0;
        this.findTokenStartOffs = 0;
        this.findTokenEndOffs = 0;
    }

    private String normalizeString(String string, boolean bl, boolean bl2) {
        if (!bl) {
            string = string.toUpperCase();
        }
        if (!bl2) {
            string = string.replace('-', '_');
        }
        return string;
    }

    private int find(String string, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.findTokens.size();
        if (n2 == 0) {
            this.resetFind();
            return -1;
        }
        string = this.normalizeString(string, bl, bl3);
        int n3 = -1;
        if (this.findTokenIdx < 0 || this.findTokenIdx >= n2) {
            this.findTokenIdx = 0;
        }
        int n4 = this.findTokenIdx;
        if (bl2) {
            int n5;
            String string2;
            DrawStringItem drawStringItem;
            int n6;
            for (n6 = n4; n6 >= 0; --n6) {
                drawStringItem = (DrawStringItem)this.findTokens.elementAt(n6);
                if (n6 == n4) {
                    if (this.findTokenStartOffs == 0) {
                        continue;
                    }
                } else {
                    this.findTokenStartOffs = drawStringItem.text.length();
                }
                string2 = drawStringItem.text;
                n5 = (string2 = this.normalizeString(string2, bl, bl3)).lastIndexOf(string, this.findTokenStartOffs);
                if (n5 < 0 || n6 == n4 || n5 == this.findTokenStartOffs) continue;
                n3 = n6;
                this.findTokenStartOffs = n5;
                break;
            }
            if (n3 < 0) {
                for (n6 = n2 - 1; n6 >= n4; --n6) {
                    drawStringItem = (DrawStringItem)this.findTokens.elementAt(n6);
                    string2 = drawStringItem.text;
                    n5 = (string2 = this.normalizeString(string2, bl, bl3)).lastIndexOf(string);
                    if (n5 < 0) continue;
                    n3 = n6;
                    this.findTokenStartOffs = n5;
                    break;
                }
            }
        } else {
            int n7;
            String string3;
            DrawStringItem drawStringItem;
            int n8;
            for (n8 = n4; n8 < n2; ++n8) {
                drawStringItem = (DrawStringItem)this.findTokens.elementAt(n8);
                if (n8 == n4) {
                    if (this.findTokenEndOffs == drawStringItem.text.length()) {
                        continue;
                    }
                } else {
                    this.findTokenEndOffs = 0;
                }
                string3 = drawStringItem.text;
                n7 = (string3 = this.normalizeString(string3, bl, bl3)).indexOf(string, this.findTokenEndOffs);
                if (n7 < 0) continue;
                n3 = n8;
                this.findTokenStartOffs = n7;
                break;
            }
            if (n3 < 0) {
                for (n8 = 0; n8 <= n4; ++n8) {
                    drawStringItem = (DrawStringItem)this.findTokens.elementAt(n8);
                    string3 = drawStringItem.text;
                    n7 = (string3 = this.normalizeString(string3, bl, bl3)).indexOf(string);
                    if (n7 < 0) continue;
                    n3 = n8;
                    this.findTokenStartOffs = n7;
                    break;
                }
            }
        }
        this.findTokenIdx = n3;
        if (n3 >= 0) {
            this.findTokenEndOffs = this.findTokenStartOffs + string.length();
        }
        return n3;
    }

    public Window getWindow() {
        return this.window;
    }

    private static class MyComboEditor
    extends JTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;

        MyComboEditor() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.getText();
        }

        @Override
        public void setItem(Object object) {
            this.setText(object != null ? object.toString() : "");
        }
    }

    class PreviewGraphics
    extends Graphics2D {
        private Font font;
        private Color foreground;
        private Color background;
        private final FontRenderContext frc = new FontRenderContext(null, false, false);

        public PreviewGraphics() {
            this.font = PreviewDialog.this.window.getFont();
            this.foreground = PreviewDialog.this.window.getForeground();
            this.background = PreviewDialog.this.window.getBackground();
        }

        @Override
        public void draw(Shape shape) {
        }

        @Override
        public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        }

        @Override
        public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        }

        @Override
        public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        }

        @Override
        public void drawString(String string, int n2, int n3) {
        }

        @Override
        public void drawString(String string, float f2, float f3) {
            PreviewDialog.this.findTokens.addElement(new DrawStringItem(string, f2, f3, ((SpoolPrinter)PreviewDialog.this.printable).getPageCount() + 1, this.getFont()));
        }

        @Override
        public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        }

        @Override
        public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        }

        @Override
        public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        }

        @Override
        public void fill(Shape shape) {
        }

        @Override
        public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
            return false;
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            return PreviewDialog.this.window.getGraphicsConfiguration();
        }

        @Override
        public void setComposite(Composite composite) {
        }

        @Override
        public void setPaint(Paint paint) {
        }

        @Override
        public void setStroke(Stroke stroke) {
        }

        @Override
        public void setRenderingHint(RenderingHints.Key key, Object object) {
        }

        @Override
        public Object getRenderingHint(RenderingHints.Key key) {
            return null;
        }

        public void setRenderingHints(Map map) {
        }

        public void addRenderingHints(Map map) {
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }

        @Override
        public void translate(int n2, int n3) {
        }

        @Override
        public void translate(double d2, double d3) {
        }

        @Override
        public void rotate(double d2) {
        }

        @Override
        public void rotate(double d2, double d3, double d4) {
        }

        @Override
        public void scale(double d2, double d3) {
        }

        @Override
        public void shear(double d2, double d3) {
        }

        @Override
        public void transform(AffineTransform affineTransform) {
        }

        @Override
        public void setTransform(AffineTransform affineTransform) {
        }

        @Override
        public AffineTransform getTransform() {
            return null;
        }

        @Override
        public Paint getPaint() {
            return null;
        }

        @Override
        public Composite getComposite() {
            return null;
        }

        @Override
        public void setBackground(Color color) {
            this.background = color;
        }

        @Override
        public Color getBackground() {
            return this.background;
        }

        @Override
        public Stroke getStroke() {
            return null;
        }

        @Override
        public void clip(Shape shape) {
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            return this.frc;
        }

        @Override
        public Graphics create() {
            return null;
        }

        @Override
        public Color getColor() {
            return this.foreground;
        }

        @Override
        public void setColor(Color color) {
            this.foreground = color;
        }

        @Override
        public void setPaintMode() {
        }

        @Override
        public void setXORMode(Color color) {
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        @Override
        public void setFont(Font font) {
            this.font = font;
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return PreviewDialog.this.window.getFontMetrics(this.getFont());
        }

        @Override
        public Rectangle getClipBounds() {
            return null;
        }

        @Override
        public void clipRect(int n2, int n3, int n4, int n5) {
        }

        @Override
        public void setClip(int n2, int n3, int n4, int n5) {
        }

        @Override
        public Shape getClip() {
            return null;
        }

        @Override
        public void setClip(Shape shape) {
        }

        @Override
        public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        }

        @Override
        public void drawLine(int n2, int n3, int n4, int n5) {
        }

        @Override
        public void fillRect(int n2, int n3, int n4, int n5) {
        }

        @Override
        public void clearRect(int n2, int n3, int n4, int n5) {
        }

        @Override
        public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        }

        @Override
        public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        }

        @Override
        public void drawOval(int n2, int n3, int n4, int n5) {
        }

        @Override
        public void fillOval(int n2, int n3, int n4, int n5) {
        }

        @Override
        public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        }

        @Override
        public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        }

        @Override
        public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        }

        @Override
        public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        }

        @Override
        public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        }

        @Override
        public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
            return false;
        }

        @Override
        public void dispose() {
        }
    }
}

