/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.procinfo;

import com.iscobol.procinfo.JThreadInfoExt;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.hatter.tools.commons.misc.ShutdownSignal;
import me.hatter.tools.jtop.management.JTopMXBean;
import me.hatter.tools.jtop.rmi.RmiClient;
import me.hatter.tools.jtop.rmi.interfaces.JMemoryInfo;
import me.hatter.tools.jtop.rmi.interfaces.JThreadInfo;
import me.hatter.tools.jtop.util.EnvUtil;

public class ProcessInfo {
    private String _pid = "";
    private RmiClient rc;
    private JTopMXBean jTopMXBean;

    public ProcessInfo() {
        this._pid = "";
    }

    public static String getJVMPID() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        return string.split("@")[0];
    }

    public ProcessInfo(String string) {
        this.attachToPid(string);
    }

    public void attachToPid(String string) {
        this._pid = string;
        this.rc = new RmiClient(string);
        this.jTopMXBean = this.rc.getJTopMXBean();
    }

    public JMemoryInfo getMemoryInfo() throws IllegalStateException {
        if ("".equals(this._pid)) {
            throw new IllegalStateException("PID not assigned");
        }
        JMemoryInfo jMemoryInfo = null;
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        try {
            jMemoryInfo = this.jTopMXBean.getMemoryInfo();
        }
        finally {
            shutdownSignal.release();
        }
        return jMemoryInfo;
    }

    public JThreadInfoExt[] getThreadInfo() throws InterruptedException {
        JThreadInfoExt[] jThreadInfoExtArray = null;
        long l2 = System.nanoTime();
        long l3 = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo[] jThreadInfoArray = this.jTopMXBean.listThreadInfos();
            jThreadInfoExtArray = JThreadInfoExt.fromJThreadInfos(jThreadInfoArray);
        }
        finally {
            shutdownSignal.release();
        }
        return jThreadInfoExtArray;
    }

    public JThreadInfoExt getThreadInfo(long l2) throws InterruptedException {
        JThreadInfoExt jThreadInfoExt = null;
        long l3 = System.nanoTime();
        long l4 = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo jThreadInfo = this.jTopMXBean.getThreadInfo(l2);
            if (jThreadInfo == null) {
                return null;
            }
            jThreadInfoExt = JThreadInfoExt.fromJThreadInfo(jThreadInfo);
        }
        finally {
            shutdownSignal.release();
        }
        return jThreadInfoExt;
    }

    public JThreadInfoExt getThreadInfoWithLoad(long l2) throws InterruptedException {
        JThreadInfoExt[] jThreadInfoExtArray = null;
        long l3 = System.nanoTime();
        long l4 = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo jThreadInfo;
            JThreadInfo[] jThreadInfoArray = new JThreadInfo[]{this.jTopMXBean.getThreadInfo(l2)};
            if (jThreadInfoArray[0] == null) {
                return null;
            }
            Map<Long, JThreadInfo> map = ProcessInfo.jThreadInfoToMap(jThreadInfoArray);
            Thread.sleep(EnvUtil.getSleepMillis());
            l4 = System.nanoTime();
            jThreadInfoArray[0] = this.jTopMXBean.getThreadInfo(l2);
            JThreadInfo[] jThreadInfoArray2 = ProcessInfo.caculateJThreadInfos(jThreadInfoArray, map);
            jThreadInfoArray2 = ProcessInfo.sortJThreadInfos(jThreadInfoArray2);
            long l5 = l4 - l3;
            HashMap<Thread.State, AtomicInteger> hashMap = new HashMap<Thread.State, AtomicInteger>();
            JThreadInfo[] jThreadInfoArray3 = jThreadInfoArray2;
            int n2 = jThreadInfoArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                jThreadInfo = jThreadInfoArray3[n3];
                Thread.State state = jThreadInfo.getThreadState();
                if (hashMap.containsKey((Object)state)) {
                    ((AtomicInteger)hashMap.get((Object)state)).incrementAndGet();
                } else {
                    hashMap.put(state, new AtomicInteger(1));
                }
                ++n3;
            }
            jThreadInfoExtArray = JThreadInfoExt.fromJThreadInfos(jThreadInfoArray2);
            jThreadInfoArray3 = jThreadInfoExtArray;
            n2 = jThreadInfoExtArray.length;
            n3 = 0;
            while (n3 < n2) {
                jThreadInfo = jThreadInfoArray3[n3];
                jThreadInfo.calcCPU(l5);
                ++n3;
            }
        }
        finally {
            shutdownSignal.release();
        }
        return jThreadInfoExtArray[0];
    }

    public JThreadInfoExt[] getThreadInfoWithLoad() throws InterruptedException {
        JThreadInfoExt[] jThreadInfoExtArray = null;
        long l2 = System.nanoTime();
        long l3 = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo jThreadInfo;
            JThreadInfo[] jThreadInfoArray = this.jTopMXBean.listThreadInfos();
            Map<Long, JThreadInfo> map = ProcessInfo.jThreadInfoToMap(jThreadInfoArray);
            Thread.sleep(EnvUtil.getSleepMillis());
            l3 = System.nanoTime();
            jThreadInfoArray = this.jTopMXBean.listThreadInfos();
            JThreadInfo[] jThreadInfoArray2 = ProcessInfo.caculateJThreadInfos(jThreadInfoArray, map);
            jThreadInfoArray2 = ProcessInfo.sortJThreadInfos(jThreadInfoArray2);
            long l4 = l3 - l2;
            HashMap<Thread.State, AtomicInteger> hashMap = new HashMap<Thread.State, AtomicInteger>();
            JThreadInfo[] jThreadInfoArray3 = jThreadInfoArray2;
            int n2 = jThreadInfoArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                jThreadInfo = jThreadInfoArray3[n3];
                Thread.State state = jThreadInfo.getThreadState();
                if (hashMap.containsKey((Object)state)) {
                    ((AtomicInteger)hashMap.get((Object)state)).incrementAndGet();
                } else {
                    hashMap.put(state, new AtomicInteger(1));
                }
                ++n3;
            }
            jThreadInfoExtArray = JThreadInfoExt.fromJThreadInfos(jThreadInfoArray2);
            jThreadInfoArray3 = jThreadInfoExtArray;
            n2 = jThreadInfoExtArray.length;
            n3 = 0;
            while (n3 < n2) {
                jThreadInfo = jThreadInfoArray3[n3];
                jThreadInfo.calcCPU(l4);
                ++n3;
            }
        }
        finally {
            shutdownSignal.release();
        }
        return jThreadInfoExtArray;
    }

    public static boolean killThread(String string) {
        Thread[] threadArray;
        boolean bl = false;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while ((threadArray = threadGroup.getParent()) != null) {
            threadGroup = threadArray;
        }
        for (int i2 = 256; threadGroup.enumerate(threadArray = new Thread[i2]) >= i2; i2 *= 2) {
        }
        Thread[] threadArray2 = threadArray;
        int n2 = threadArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            Thread thread = threadArray2[n3];
            if (thread != null && (string2 = thread.getName()).contains(string)) {
                bl = true;
                thread.stop();
            }
            ++n3;
        }
        return bl;
    }

    public static boolean killThread(long l2) {
        Thread[] threadArray;
        boolean bl = false;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while ((threadArray = threadGroup.getParent()) != null) {
            threadGroup = threadArray;
        }
        for (int i2 = 256; threadGroup.enumerate(threadArray = new Thread[i2]) >= i2; i2 *= 2) {
        }
        Thread[] threadArray2 = threadArray;
        int n2 = threadArray.length;
        int n3 = 0;
        while (n3 < n2) {
            long l3;
            Thread thread = threadArray2[n3];
            if (thread != null && (l3 = thread.getId()) == l2) {
                bl = true;
                thread.stop();
                break;
            }
            ++n3;
        }
        return bl;
    }

    private static Map<Long, JThreadInfo> jThreadInfoToMap(JThreadInfo[] jThreadInfoArray) {
        HashMap<Long, JThreadInfo> hashMap = new HashMap<Long, JThreadInfo>();
        JThreadInfo[] jThreadInfoArray2 = jThreadInfoArray;
        int n2 = jThreadInfoArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JThreadInfo jThreadInfo = jThreadInfoArray2[n3];
            hashMap.put(jThreadInfo.getThreadId(), jThreadInfo);
            ++n3;
        }
        return hashMap;
    }

    private static JThreadInfo[] caculateJThreadInfos(JThreadInfo[] jThreadInfoArray, Map<Long, JThreadInfo> map) {
        JThreadInfo[] jThreadInfoArray2 = new JThreadInfo[jThreadInfoArray.length];
        int n2 = 0;
        while (n2 < jThreadInfoArray.length) {
            JThreadInfo jThreadInfo = jThreadInfoArray[n2];
            JThreadInfo jThreadInfo2 = map.get(jThreadInfo.getThreadId());
            jThreadInfoArray2[n2] = jThreadInfo2 == null ? jThreadInfo : new JThreadInfo(jThreadInfo, jThreadInfo.getCpuTime() - jThreadInfo2.getCpuTime(), jThreadInfo.getUserTime() - jThreadInfo2.getUserTime(), jThreadInfo.getAlloctedBytes() - jThreadInfo2.getAlloctedBytes());
            ++n2;
        }
        return jThreadInfoArray2;
    }

    static JThreadInfo[] sortJThreadInfos(JThreadInfo[] jThreadInfoArray) {
        boolean bl = EnvUtil.getSortMem();
        if (bl) {
            Arrays.sort(jThreadInfoArray, new Comparator<JThreadInfo>(){

                @Override
                public int compare(JThreadInfo jThreadInfo, JThreadInfo jThreadInfo2) {
                    int n2 = Long.valueOf(jThreadInfo2.getAlloctedBytes()).compareTo(jThreadInfo.getAlloctedBytes());
                    if (n2 != 0) {
                        return n2;
                    }
                    return jThreadInfo2.getThreadName().compareTo(jThreadInfo.getThreadName());
                }
            });
        } else {
            Arrays.sort(jThreadInfoArray, new Comparator<JThreadInfo>(){

                @Override
                public int compare(JThreadInfo jThreadInfo, JThreadInfo jThreadInfo2) {
                    int n2 = Long.valueOf(jThreadInfo2.getCpuTime()).compareTo(jThreadInfo.getCpuTime());
                    if (n2 != 0) {
                        return n2;
                    }
                    int n3 = Long.valueOf(jThreadInfo2.getUserTime()).compareTo(jThreadInfo.getUserTime());
                    if (n3 != 0) {
                        return n3;
                    }
                    return jThreadInfo2.getThreadName().compareTo(jThreadInfo.getThreadName());
                }
            });
        }
        return jThreadInfoArray;
    }
}

