/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.profiler;

import com.iscobol.profiler.Paragraph;
import com.iscobol.profiler.Program;
import com.iscobol.profiler.Transformer;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Profiler {
    public static final String ident = "$Id: Profiler.java 37777 2024-02-26 16:59:39Z gianni_578 $";
    public static final String rev = "$Revision: 37777 $";
    private static final String[] resources = new String[]{"app.js", "clear.png", "clear.svg", "down.gif", "method.gif", "program.gif", "report.css", "report.gif", "sort.gif", "sort.js", "up.gif", "warn.gif"};
    private Map<String, Paragraph> paragraphMap;
    private Map<String, Program> programMap;
    private Stack<Paragraph> paragraphStack = new Stack();
    private static final long overhead1;
    private static final long overhead2;
    private Map<String, byte[]> resourcesStream;
    private long startTime = System.nanoTime();
    private long disabledTime;
    private long disabledTimeAccum;
    private File htmlDir;
    private File xmlFile;
    private File txtFile;
    private boolean enabled = true;
    private Transformer transformer;
    private final boolean logEnabled;
    private static final NumberFormat percFormat;
    private static final DateFormat dateFormat;
    private static final NumberFormat secFormat;
    private static final Calendar calendar;
    private static Profiler sharedInstance;
    private static RuntimeImpl rtn;
    private static final String blanks = "                                     ";

    static RuntimeImpl getRtn() {
        if (rtn == null) {
            rtn = new RuntimeImpl();
        }
        return rtn;
    }

    public static Profiler newProfiler(File file, File file2, File file3) {
        String[] stringArray = new String[]{"iscobol.profiler.enable", "iscobol.tracelevel"};
        Object[] objectArray = new Object[]{Boolean.TRUE, 0};
        Object[] objectArray2 = Profiler.getRtn().getPropertiesSeparate(stringArray, objectArray);
        boolean bl = (Boolean)objectArray2[0];
        boolean bl2 = (Integer)objectArray2[1] > 0;
        return Profiler.newProfiler(file, file2, file3, bl, bl2);
    }

    public static Profiler newProfiler(File file, File file2, File file3, boolean bl, boolean bl2) {
        Profiler profiler = new Profiler(file, file2, file3, bl, bl2);
        return profiler;
    }

    public static Profiler getSharedInstance(File file, File file2, File file3, String string, String string2) {
        if (sharedInstance == null) {
            String[] stringArray = new String[]{"iscobol.profiler.enable", "iscobol.tracelevel", "iscobol.profiler.elapse_time"};
            Object[] objectArray = new Object[]{Boolean.TRUE, 0, 0};
            Object[] objectArray2 = Profiler.getRtn().getPropertiesSeparate(stringArray, objectArray);
            boolean bl = (Boolean)objectArray2[0];
            boolean bl2 = (Integer)objectArray2[1] > 0;
            long l2 = ((Integer)objectArray2[2]).intValue();
            Profiler profiler = Profiler.newProfiler(file, file2, file3, bl, bl2);
            if (l2 > 0L) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Profiler.disableAll();
                        Profiler.flushAll();
                    }
                }, l2 * 1000L);
            }
            try {
                profiler.setTransformer(new Transformer(string, string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            sharedInstance = profiler;
        }
        return sharedInstance;
    }

    public static Profiler getProfiler() {
        return sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int enableAll() {
        if (sharedInstance == null) {
            return 1;
        }
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler profiler2 = sharedInstance;
            if (!profiler2.enabled) {
                profiler2.disabledTimeAccum += System.nanoTime() - profiler2.disabledTime;
                profiler2.disabledTime = 0L;
                try {
                    Paragraph paragraph = profiler2.paragraphStack.peek();
                    paragraph.start = overhead1 + System.nanoTime();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                profiler2.enabled = true;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int disableAll() {
        if (sharedInstance == null) {
            return 1;
        }
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler profiler2 = sharedInstance;
            if (profiler2.enabled) {
                profiler2.disabledTime = System.nanoTime();
                profiler2.enabled = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int flushAll() {
        if (sharedInstance == null) {
            return 1;
        }
        int n2 = 0;
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler profiler2 = sharedInstance;
            Vector<Paragraph> vector = new Vector<Paragraph>(profiler2.paragraphStack);
            while (!profiler2.paragraphStack.isEmpty()) {
                profiler2.exitPar();
            }
            try {
                profiler2.doReport();
            }
            catch (IOException iOException) {
                n2 = 2;
            }
            profiler2.startTime = System.nanoTime();
            profiler2.disabledTime = !profiler2.enabled ? profiler2.startTime : 0L;
            profiler2.disabledTimeAccum = 0L;
            for (Paragraph object : profiler2.paragraphMap.values()) {
                object.count = 0;
                object.accum = 0L;
                object.start = 0L;
            }
            for (Program program : profiler2.programMap.values()) {
                program.count = 0;
            }
            for (Paragraph paragraph : vector) {
                profiler2.enterPar(paragraph);
            }
            profiler2.xmlFile = null;
            profiler2.htmlDir = null;
            profiler2.txtFile = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setAll(String[] stringArray, File[] fileArray) {
        if (sharedInstance == null) {
            return 1;
        }
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler profiler2 = sharedInstance;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if ("xml".equalsIgnoreCase(stringArray[i2])) {
                    profiler2.xmlFile = fileArray[i2];
                    continue;
                }
                if ("html".equalsIgnoreCase(stringArray[i2])) {
                    profiler2.htmlDir = fileArray[i2];
                    continue;
                }
                if (!"txt".equalsIgnoreCase(stringArray[i2])) continue;
                profiler2.txtFile = fileArray[i2];
            }
        }
        return 0;
    }

    private Profiler(File file, File file2, File file3, boolean bl, boolean bl2) {
        this.enabled = bl;
        this.htmlDir = file;
        this.xmlFile = file2;
        this.txtFile = file3;
        this.paragraphMap = new HashMap<String, Paragraph>();
        this.programMap = new HashMap<String, Program>();
        this.logEnabled = bl2;
    }

    public final Program getProgram(String string, boolean bl) {
        Program program = this.programMap.get(string);
        if (program == null) {
            program = new Program(string, bl);
            this.programMap.put(string, program);
        }
        return program;
    }

    public final void enterPar(Paragraph paragraph) {
        if (this.enabled) {
            long l2 = System.nanoTime();
            ++paragraph.count;
            try {
                Paragraph paragraph2 = this.paragraphStack.peek();
                paragraph2.accum += Math.max(0L, l2 - paragraph2.start);
                paragraph2.start = 0L;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.paragraphStack.push(paragraph);
            paragraph.start = overhead1 + System.nanoTime();
        } else {
            this.paragraphStack.push(paragraph);
        }
    }

    public final void exitPar() {
        if (this.enabled) {
            long l2 = System.nanoTime();
            try {
                Paragraph paragraph = this.paragraphStack.pop();
                paragraph.accum += Math.max(0L, l2 - paragraph.start);
                paragraph.start = 0L;
                Paragraph paragraph2 = this.paragraphStack.peek();
                paragraph2.start = overhead2 + System.nanoTime();
            }
            catch (Throwable throwable) {}
        } else {
            this.paragraphStack.pop();
        }
    }

    static final String fmt(String string, int n2, boolean bl) {
        int n3 = string.length();
        if (n3 < n2) {
            string = bl ? string + blanks.substring(0, n2 - n3) : blanks.substring(0, n2 - n3) + string;
        }
        return string;
    }

    private long getElapsed(long l2) {
        return l2 - this.startTime - this.disabledTimeAccum;
    }

    public void doReport() throws IOException {
        if (this.htmlDir != null) {
            this.createHtmlReport();
        }
        if (this.xmlFile != null) {
            try {
                this.createXmlReport();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
        }
        if (this.txtFile != null) {
            this.createTextReport();
        }
    }

    public void loadResources() {
        this.resourcesStream = new HashMap<String, byte[]>();
        for (String string : resources) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/iscobol/coverage/resources/" + string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                int n2 = inputStream.read(byArray);
                while (n2 >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                    n2 = inputStream.read(byArray);
                }
                inputStream.close();
                byteArrayOutputStream.close();
                this.resourcesStream.put(string, byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createHtmlReport() throws IOException {
        if (!this.htmlDir.exists() && !this.htmlDir.mkdirs()) {
            System.err.println("Cannot create '" + this.htmlDir + "'");
            return;
        }
        File file = new File(this.htmlDir.getAbsolutePath() + "/resources");
        file.mkdir();
        if (this.resourcesStream == null) {
            this.loadResources();
        }
        for (String string : this.resourcesStream.keySet()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file.getAbsolutePath() + "/" + string));
                ((OutputStream)fileOutputStream).write(this.resourcesStream.get(string));
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        long l2 = this.getElapsed(System.nanoTime());
        this.createHtmlReport(false, l2);
        this.createHtmlReport(true, l2);
    }

    private void warn(PrintStream printStream, String string) {
        printStream.println("      <div><img src=\"resources/warn.gif\" style=\"position:relative;width:16;height:16;top:3\"></img>" + string + "</div>");
    }

    private void createHtmlReport(boolean bl, long l2) throws IOException {
        int n2;
        int n3;
        Object object;
        Object object2;
        boolean bl2 = false;
        for (Program object32 : this.programMap.values()) {
            if (object32.count <= 0 || !object32.debug) continue;
            bl2 = true;
            break;
        }
        boolean bl3 = bl2;
        String string = "isCOBOL Profile Report";
        String string2 = bl ? "indexpgm.html" : "index.html";
        PrintStream printStream = new PrintStream(new File(this.htmlDir.getAbsolutePath() + "/" + string2));
        printStream.println("<html>");
        printStream.println("  <head>");
        printStream.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        printStream.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
        printStream.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
        printStream.println("    <title>isCOBOL Profile Report</title>");
        printStream.println("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>");
        printStream.println("    <script type=\"text/javascript\" src=\"resources/app.js\"></script>");
        printStream.println("   </head>");
        printStream.println("   <body onload=\"init()\">");
        printStream.println("      <h1>isCOBOL Profile Report</h1>");
        calendar.setTimeInMillis(System.currentTimeMillis());
        printStream.println("      <p><b>Executed:</b> " + dateFormat.format(calendar.getTime()) + "</p>");
        printStream.print("      <p><b>Elapsed:</b> " + secFormat.format((double)l2 / 1.0E9) + "s;");
        long l3 = 0L;
        List<Paragraph> list = this.getParagraphList();
        if (bl) {
            Iterator<Paragraph> n5 = new HashMap();
            for (Paragraph paragraph : list) {
                object2 = (Paragraph)n5.get(paragraph.progName);
                if (object2 == null) {
                    object2 = new Paragraph(paragraph.progName, paragraph.progName);
                    object = this.programMap.get(paragraph.progName);
                    ((Paragraph)object2).count = ((Program)object).count;
                    ((Paragraph)object2).debug = ((Program)object).debug ? 1 : 0;
                    n5.put(paragraph.progName, object2);
                }
                ((Paragraph)object2).accum += paragraph.accum;
            }
            list = new ArrayList(n5.values());
        } else {
            for (Paragraph paragraph : list) {
                paragraph.debug = this.programMap.get((Object)paragraph.progName).debug ? 1 : 0;
            }
        }
        for (Paragraph paragraph : list) {
            l3 += paragraph.accum;
        }
        printStream.print(" <b>Evaluated:</b> " + secFormat.format((double)l3 / 1.0E9) + "s;");
        printStream.print(" <b>Overhead1:</b> " + overhead1 + ";");
        printStream.println(" <b>Overhead2:</b> " + overhead2 + "</p>");
        if (this.logEnabled) {
            this.warn(printStream, "Warning: running with iscobol.tracelevel > 0, this affects performances");
        }
        if (bl3) {
            this.warn(printStream, "Warning: some programs are compiled in debug mode, this affects performances");
        }
        printStream.println("      <p style=\"display:flex;flex-direction: row;align-items: center;\">");
        printStream.println("         <span>Search: </span>");
        printStream.println("         <input type=\"text\" id=\"filter\" oninput=\"filter()\" placeholder=\"filter...\" style=\"margin-left:6px;padding-right:20px\">");
        printStream.println("         <img src=\"resources/clear.svg\" onclick=\"clearFilter()\" style=\"position:relative;left:-20px;width:20px;height:20px;padding-right:22px;cursor:pointer;top:-1px;\"></img>");
        printStream.println("      </p>");
        if (bl) {
            printStream.println("      <p><a href=\"index.html\">View Paragraph table</a></p>");
        } else {
            printStream.println("      <p><a href=\"indexpgm.html\">View Program table</a></p>");
        }
        printStream.println("      <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">");
        printStream.println("        <thead>");
        printStream.println("          <tr>");
        printStream.println("            <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Program</td>");
        if (bl3) {
            printStream.println("            <td class=\"sortable\" id=\"b\" onclick=\"toggleSort(this)\">Debug</td>");
        }
        if (!bl) {
            printStream.println("            <td class=\"sortable\" id=\"c\" onclick=\"toggleSort(this)\">Paragraph</td>");
        }
        printStream.println("            <td class=\"down sortable\" id=\"d\" onclick=\"toggleSort(this)\">Self %</td>");
        printStream.println("            <td class=\"sortable\" id=\"e\" onclick=\"toggleSort(this)\">Seconds</td>");
        printStream.println("            <td class=\"sortable\" id=\"f\" onclick=\"toggleSort(this)\">Count</td>");
        printStream.println("          </tr>");
        printStream.println("        </thead>");
        printStream.println("        <tbody>");
        int n4 = n3 = bl3 ? 2 : 1;
        int n5 = bl ? (bl3 ? 5 : 4) : (bl3 ? 6 : 5);
        int n6 = n5 - 3;
        object2 = new ArrayList<Paragraph>(list);
        Collections.sort(object2, new ParagraphComparator(n6, bl, bl3));
        object = new ArrayList(object2);
        int[][] nArray = new int[object.size()][n5];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2][n6] = n2;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (n2 == n6) continue;
            Collections.sort(object, new ParagraphComparator(n2, bl, bl3));
            block6: for (int i2 = 0; i2 < object2.size(); ++i2) {
                for (int i3 = 0; i3 < object.size(); ++i3) {
                    if (object2.get(i2) != object.get(i3)) continue;
                    nArray[i2][n2] = i3;
                    continue block6;
                }
            }
        }
        n2 = 0;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            Paragraph paragraph = (Paragraph)object3.next();
            printStream.println("          <tr>");
            printStream.print("            <td id=\"a" + nArray[n2][0] + "\">");
            if (bl) {
                printStream.print("<a href=\"index.html?filter=" + paragraph.progName + "\">");
            }
            String string3 = paragraph.progName.indexOf("::") >= 0 ? "el_method" : "el_program";
            printStream.print("<span class=\"" + string3 + "\">" + paragraph.progName + "</span>");
            if (bl) {
                printStream.print("</a>");
            }
            printStream.println("</td>");
            if (bl3) {
                printStream.println("            <td id=\"b" + nArray[n2][1] + "\" class=\"ctr2\">" + (paragraph.debug != 0 ? "Yes" : "No") + "</td>");
            }
            if (!bl) {
                printStream.println("            <td id=\"c" + nArray[n2][n3] + "\">" + paragraph.methName + "</td>");
            }
            printStream.println("            <td id=\"d" + nArray[n2][n6] + "\" class=\"ctr2\">" + percFormat.format((double)paragraph.accum / (double)l3) + "</td>");
            printStream.println("            <td id=\"e" + nArray[n2][n6 + 1] + "\" class=\"ctr2\">" + secFormat.format((double)paragraph.accum / 1.0E9) + "</td>");
            printStream.println("            <td id=\"f" + nArray[n2][n6 + 2] + "\" class=\"ctr2\">" + paragraph.count + "</td>");
            printStream.println("          </tr>");
            ++n2;
        }
        printStream.println("        </tbody>");
        printStream.println("        <tfoot>");
        printStream.println("           <tr style=\"background-color:#e7e7e7\">");
        object3 = bl ? (bl3 ? " colspan=\"2\"" : "") : (bl3 ? " colspan=\"3\"" : " colspan=\"2\"");
        printStream.println("             <td" + (String)object3 + "><span class=\"el_total\">Totals:</span></td>");
        printStream.println("             <td class=\"ctr2\" id=\"totalPerc\"></td>");
        printStream.println("             <td class=\"ctr2\" id=\"totalSecs\"></td>");
        printStream.println("             <td />");
        printStream.println("           </tr>");
        printStream.println("        </tfoot>");
        printStream.println("      </table>");
        if (bl) {
            printStream.println("      <p><a href=\"index.html\">View Paragraph table</a></p>");
        } else {
            printStream.println("      <p><a href=\"indexpgm.html\">View Program table</a></p>");
        }
        printStream.println("   </body>");
        printStream.println("</html>");
        printStream.close();
    }

    private void createXmlReport() throws ParserConfigurationException, TransformerException, IOException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("session");
        document.appendChild(element);
        element.setAttribute("executed", Long.toString(System.currentTimeMillis()));
        element.setAttribute("elapsed", Long.toString(this.getElapsed(System.nanoTime())));
        element.setAttribute("overhead1", Long.toString(overhead1));
        element.setAttribute("overhead2", Long.toString(overhead2));
        element.setAttribute("logEnabled", Boolean.toString(this.logEnabled));
        List<Paragraph> list = this.getParagraphList();
        long l2 = 0L;
        for (Paragraph object22 : list) {
            l2 += object22.accum;
        }
        l2 = Math.max(1L, l2);
        element.setAttribute("evaluated", Long.toString(l2));
        for (Program program : this.programMap.values()) {
            if (program.count <= 0) continue;
            object = document.createElement("program");
            object.setAttribute("name", program.name);
            object.setAttribute("count", Integer.toString(program.count));
            object.setAttribute("debug", Boolean.toString(program.debug));
            element.appendChild((Node)object);
        }
        for (Paragraph paragraph : list) {
            object = document.createElement("paragraph");
            object.setAttribute("name", paragraph.methName);
            object.setAttribute("programName", paragraph.progName);
            object.setAttribute("accum", Long.toString(paragraph.accum));
            object.setAttribute("count", Integer.toString(paragraph.count));
            element.appendChild((Node)object);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        javax.xml.transform.Transformer transformer = transformerFactory.newTransformer();
        object = transformer.getOutputProperties();
        ((Properties)object).setProperty("indent", "yes");
        transformer.setOutputProperties((Properties)object);
        DOMSource dOMSource = new DOMSource(document);
        FileOutputStream fileOutputStream = new FileOutputStream(this.xmlFile);
        StreamResult streamResult = new StreamResult(new OutputStreamWriter(fileOutputStream));
        transformer.transform(dOMSource, streamResult);
        fileOutputStream.close();
    }

    private void createTextReport() throws IOException {
        PrintStream printStream = new PrintStream(this.txtFile);
        long l2 = 0L;
        long l3 = 0L;
        List<Paragraph> list = this.getParagraphList();
        for (Paragraph paragraph : list) {
            if (paragraph.accum < 0L) {
                paragraph.accum = 0L;
            }
            l2 += paragraph.accum;
        }
        if (l2 == 0L) {
            l2 = 1L;
        }
        Collections.sort(list);
        String string = "isCOBOL profile rev $Revision: 37777 $ created " + new Date();
        printStream.println(string);
        long l4 = this.getElapsed(System.nanoTime());
        long l5 = Math.round((double)l4 / 1.0E9);
        long l6 = l4 / 10L % 100L;
        if (l6 < 10L) {
            printStream.println("elapsed   time = " + l5 + ".0" + l6);
        } else {
            printStream.println("elapsed   time = " + l5 + "." + l6);
        }
        l5 = l2 / 1000000000L;
        l6 = l2 / 10000000L % 100L;
        if (l6 < 10L) {
            printStream.println("evaluated time = " + l5 + ".0" + l6);
        } else {
            printStream.println("evaluated time = " + l5 + "." + l6);
        }
        printStream.println("overhead1=" + overhead1 + "; overhead2=" + overhead2);
        printStream.println("-------+-------+---------+-----------+-----------------");
        printStream.println("self % |accum %| seconds |   count   |program:paragraph");
        printStream.println("-------+-------+---------+-----------+-----------------");
        for (Paragraph paragraph : list) {
            l5 = paragraph.accum * 100L / l2;
            string = Profiler.fmt("" + l5, 3, false);
            string = string + ".";
            l6 = paragraph.accum * 10000L / l2 % 100L;
            string = l6 < 10L ? string + Profiler.fmt("0" + l6, 2, false) : string + Profiler.fmt("" + l6, 2, false);
            string = string + "%|";
            l5 = (l3 += paragraph.accum) * 100L / l2;
            string = string + Profiler.fmt("" + l5, 3, false);
            string = string + ".";
            l6 = l3 * 10000L / l2 % 100L;
            string = l6 < 10L ? string + Profiler.fmt("0" + l6, 2, false) : string + Profiler.fmt("" + l6, 2, false);
            string = string + "%|";
            l5 = paragraph.accum / 1000000000L;
            l6 = paragraph.accum / 10000000L % 100L;
            string = string + Profiler.fmt("" + l5, 6, false);
            string = l6 < 10L ? string + Profiler.fmt(".0" + l6, 2, false) : string + Profiler.fmt("." + l6, 2, false);
            string = string + "|";
            string = string + Profiler.fmt("" + paragraph.count, 11, false);
            string = string + "|";
            string = string + paragraph.progName + ":" + paragraph.methName;
            printStream.println(string);
        }
        printStream.close();
    }

    public final Paragraph getParagraph(String string, String string2) {
        String string3 = string + ":" + string2;
        Paragraph paragraph = this.paragraphMap.get(string3);
        if (paragraph == null) {
            paragraph = new Paragraph(string, string2);
            this.paragraphMap.put(string3, paragraph);
        }
        return paragraph;
    }

    private List<Paragraph> getParagraphList() {
        ArrayList<Paragraph> arrayList = new ArrayList<Paragraph>();
        for (Paragraph paragraph : this.paragraphMap.values()) {
            if (paragraph.count <= 0) continue;
            arrayList.add(paragraph);
        }
        return arrayList;
    }

    public void exitAllParagraphs() {
        while (!this.paragraphStack.isEmpty()) {
            this.exitPar();
        }
    }

    public void shutdownAndPrintReports() {
        this.exitAllParagraphs();
        try {
            this.doReport();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    static {
        calendar = Calendar.getInstance();
        Class<ParagraphComparator> clazz = ParagraphComparator.class;
        percFormat = NumberFormat.getPercentInstance();
        percFormat.setMinimumFractionDigits(2);
        percFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        dateFormat = DateFormat.getDateTimeInstance(1, 2);
        secFormat = NumberFormat.getNumberInstance();
        secFormat.setMaximumFractionDigits(3);
        secFormat.setMinimumFractionDigits(3);
        secFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        Profiler profiler = new Profiler(null, null, null, true, false);
        int n2 = 100000;
        Paragraph paragraph = profiler.getParagraph("00", "00");
        Paragraph paragraph2 = profiler.getParagraph("AA", "AA");
        Paragraph paragraph3 = profiler.getParagraph("BB", "BB");
        Paragraph paragraph4 = profiler.getParagraph("CC", "CC");
        profiler.enterPar(paragraph);
        for (int i2 = 0; i2 < 100000; ++i2) {
            profiler.enterPar(paragraph2);
            profiler.enterPar(paragraph3);
            profiler.enterPar(paragraph4);
            profiler.exitPar();
            profiler.enterPar(paragraph4);
            profiler.exitPar();
            profiler.exitPar();
            profiler.exitPar();
        }
        profiler.exitPar();
        overhead1 = paragraph4.accum / 200000L;
        overhead2 = (paragraph3.accum - paragraph2.accum) / 100000L;
    }

    private static class ParagraphComparator
    implements Comparator<Paragraph> {
        int colIdx;
        boolean pgmTable;
        boolean hasDebugPgm;

        ParagraphComparator(int n2, boolean bl, boolean bl2) {
            this.colIdx = n2;
            this.pgmTable = bl;
            this.hasDebugPgm = bl2;
        }

        @Override
        public int compare(Paragraph paragraph, Paragraph paragraph2) {
            if (this.pgmTable) {
                if (this.hasDebugPgm) {
                    switch (this.colIdx) {
                        default: {
                            return paragraph2.progName.compareTo(paragraph.progName);
                        }
                        case 1: {
                            return paragraph2.debug - paragraph.debug;
                        }
                        case 2: 
                        case 3: {
                            long l2 = paragraph2.accum - paragraph.accum;
                            return l2 > 0L ? 1 : (l2 < 0L ? -1 : 0);
                        }
                        case 4: 
                    }
                    return paragraph2.count - paragraph.count;
                }
                switch (this.colIdx) {
                    default: {
                        return paragraph2.progName.compareTo(paragraph.progName);
                    }
                    case 1: 
                    case 2: {
                        long l3 = paragraph2.accum - paragraph.accum;
                        return l3 > 0L ? 1 : (l3 < 0L ? -1 : 0);
                    }
                    case 3: 
                }
                return paragraph2.count - paragraph.count;
            }
            if (this.hasDebugPgm) {
                switch (this.colIdx) {
                    default: {
                        return paragraph2.progName.compareTo(paragraph.progName);
                    }
                    case 1: {
                        return paragraph2.debug - paragraph.debug;
                    }
                    case 2: {
                        return paragraph2.methName.compareTo(paragraph.methName);
                    }
                    case 3: 
                    case 4: {
                        long l4 = paragraph2.accum - paragraph.accum;
                        return l4 > 0L ? 1 : (l4 < 0L ? -1 : 0);
                    }
                    case 5: 
                }
                return paragraph2.count - paragraph.count;
            }
            switch (this.colIdx) {
                default: {
                    return paragraph2.progName.compareTo(paragraph.progName);
                }
                case 1: {
                    return paragraph2.methName.compareTo(paragraph.methName);
                }
                case 2: 
                case 3: {
                    long l5 = paragraph2.accum - paragraph.accum;
                    return l5 > 0L ? 1 : (l5 < 0L ? -1 : 0);
                }
                case 4: 
            }
            return paragraph2.count - paragraph.count;
        }
    }
}

