/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.profiler;

import com.iscobol.profiler.Paragraph;
import com.iscobol.profiler.Profiler;
import com.iscobol.profiler.Program;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public class Transformer
implements ClassFileTransformer {
    private static final String EP_PREFIX = "_entry_Point$";
    private static final Set<String> invalidPackageNames;
    private static final String prClass;
    private static final String prMtd;
    private static final String prInst = "$profiler$";
    private static final String pgmInst = "$program$";
    private static final int lenPgmArg;
    private static final String iArg = "$paragraph$";
    private static final int lenIArg;
    private static final String iCnr = "$profiler$.getParagraph(\"";
    private static final int lenICnr;
    private static final String iMtd = "$profiler$.enterPar(";
    private static final int lenIMtd;
    private static final String oMtd = "$profiler$.exitPar();";
    private final String ciMtd;
    private final int lenCIMtd;
    private final ClassPool classPool;
    private ClassLoader extClassLoader;
    private LoaderClassPath extClassPath;
    private final CtClass profClass;
    private final CtClass paragClass;
    private final CtClass pgmClass;
    private final Pattern[] inclRegExp;
    private final Pattern[] exclRegExp;
    private Map<String, Boolean> transformedClassNames = new HashMap<String, Boolean>();

    private static final boolean isUpperCase(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isLowerCase(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public Transformer(String string, String string2) throws Exception {
        String[] stringArray;
        CtClass ctClass;
        this.ciMtd = prMtd + ").getProgram(\"";
        this.lenCIMtd = this.ciMtd.length();
        ClassPool classPool = ClassPool.getDefault();
        try {
            ctClass = classPool.get(Profiler.class.getName());
        }
        catch (Exception exception) {
            ClassLoader classLoader = classPool.getClassLoader();
            classPool = new ClassPool(classPool);
            classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            ctClass = classPool.get(Profiler.class.getName());
        }
        this.classPool = classPool;
        this.profClass = ctClass;
        this.paragClass = this.classPool.get(Paragraph.class.getName());
        this.pgmClass = this.classPool.get(Program.class.getName());
        if (string != null && string.length() > 0) {
            stringArray = string.split(",");
            this.inclRegExp = new Pattern[stringArray.length];
            for (int i2 = 0; i2 < this.inclRegExp.length; ++i2) {
                this.inclRegExp[i2] = Pattern.compile(stringArray[i2]);
            }
        } else {
            this.inclRegExp = null;
        }
        if (string2 != null && string2.length() > 0) {
            stringArray = string2.split(",");
            this.exclRegExp = new Pattern[stringArray.length];
            for (int i3 = 0; i3 < this.exclRegExp.length; ++i3) {
                this.exclRegExp[i3] = Pattern.compile(stringArray[i3]);
            }
        } else {
            this.exclRegExp = null;
        }
    }

    public boolean matches(String string) {
        int n2;
        boolean bl = true;
        if (this.inclRegExp != null && this.inclRegExp.length > 0) {
            bl = false;
            for (n2 = 0; n2 < this.inclRegExp.length; ++n2) {
                if (!this.inclRegExp[n2].matcher(string).matches()) continue;
                bl = true;
                break;
            }
        }
        if (bl && this.exclRegExp != null && this.exclRegExp.length > 0) {
            for (n2 = 0; n2 < this.exclRegExp.length; ++n2) {
                if (!this.exclRegExp[n2].matcher(string).matches()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        this.setExtClassLoader(classLoader);
        byte[] byArray2 = byArray;
        if (this.matches(string)) {
            try {
                CtClass[] ctClassArray = new CtClass[1];
                byArray2 = this.transform(byArray, null, ctClassArray);
                ctClassArray[0].detach();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return byArray2;
    }

    public byte[] transformBytes(byte[] byArray, ClassLoader classLoader, boolean bl) throws Throwable {
        this.setExtClassLoader(classLoader);
        CtClass[] ctClassArray = new CtClass[1];
        byArray = this.transform(byArray, bl, ctClassArray);
        ctClassArray[0].detach();
        return byArray;
    }

    private void setExtClassLoader(ClassLoader classLoader) {
        if (this.extClassLoader != classLoader) {
            if (this.extClassPath != null) {
                this.classPool.removeClassPath((ClassPath)this.extClassPath);
            }
            this.extClassLoader = classLoader;
            if (this.extClassLoader != null) {
                this.extClassPath = new LoaderClassPath(classLoader);
                this.classPool.appendClassPath((ClassPath)this.extClassPath);
            } else {
                this.extClassPath = null;
            }
        }
    }

    private static boolean check(CtClass ctClass) {
        if (ctClass.isInterface()) {
            return false;
        }
        try {
            if (Transformer.Implements(ctClass, "com.iscobol.rts.IscobolClass")) {
                String string = ctClass.getPackageName();
                return string == null || string.length() == 0 || !invalidPackageNames.contains(string);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean Implements(CtClass ctClass, String string) throws NotFoundException {
        return Transformer.Implements(ctClass, string, new HashSet<String>());
    }

    private static boolean Implements(CtClass ctClass, String string, Set<String> set) throws NotFoundException {
        for (CtClass ctClass2 : ctClass.getInterfaces()) {
            String string2 = ctClass2.getName();
            if (set.contains(string2)) continue;
            if (string.equals(string2)) {
                return true;
            }
            set.add(string2);
            if (!Transformer.Implements(ctClass2, string, set)) continue;
            return true;
        }
        return false;
    }

    private final byte[] transform(byte[] byArray, Boolean bl, CtClass[] ctClassArray) throws Throwable {
        byte[] byArray2 = byArray;
        ctClassArray[0] = this.classPool.makeClass((InputStream)new ByteArrayInputStream(byArray));
        if (bl == null) {
            CtClass ctClass;
            bl = Transformer.Implements(ctClassArray[0], "com.iscobol.debugger.IscobolDebugger");
            if (Transformer.check(ctClassArray[0]) || (ctClass = ctClassArray[0].getDeclaringClass()) != null && (bl = this.transformedClassNames.get(ctClass.getName())) != null) {
                this.transform(ctClassArray[0], bl);
                byArray2 = ctClassArray[0].toBytecode();
            }
        } else {
            this.transform(ctClassArray[0], bl);
            byArray2 = ctClassArray[0].toBytecode();
        }
        return byArray2;
    }

    private final void transform(CtClass ctClass, Boolean bl) throws Throwable {
        CtClass ctClass2;
        boolean bl2 = Transformer.Implements(ctClass, "com.iscobol.rts.IscobolCall");
        CtConstructor ctConstructor = ctClass.getDeclaredMethods();
        StringBuilder stringBuilder = new StringBuilder(iMtd);
        StringBuilder stringBuilder2 = new StringBuilder(iArg);
        StringBuilder stringBuilder3 = new StringBuilder(iCnr);
        StringBuilder stringBuilder4 = new StringBuilder(pgmInst);
        StringBuilder stringBuilder5 = new StringBuilder(this.ciMtd);
        String string = ctClass.getName();
        int n2 = string.indexOf("$class$");
        int n3 = -1;
        boolean bl3 = bl2;
        if (n2 >= 0) {
            n3 = string.indexOf(36, n2 + 7);
            if (n3 >= 0) {
                string = string.substring(0, n2) + "::" + string.substring(n2 + 7, n3);
                bl3 = true;
                for (CtConstructor ctConstructor2 : ctClass.getConstructors()) {
                    stringBuilder5.setLength(this.lenCIMtd);
                    stringBuilder5.append(string);
                    stringBuilder5.append("\"," + bl + ").count++;");
                    ctConstructor2.insertBefore(stringBuilder5.toString());
                }
            }
        } else if (string.matches(".+\\$\\d*inner_\\d+") && (ctClass2 = ctClass.getDeclaringClass()) != null) {
            string = ctClass2.getName();
            bl3 = true;
        }
        int n4 = 0;
        int n5 = 0;
        ctClass.addField(new CtField(this.profClass, prInst, ctClass), prMtd + ")");
        for (CtMethod ctMethod : ctConstructor) {
            String string2 = ctMethod.getName();
            if (bl2 && "call".equals(string2)) {
                stringBuilder4.setLength(lenPgmArg);
                stringBuilder4.append(n5++);
                stringBuilder5.setLength(this.lenCIMtd);
                stringBuilder5.append(string);
                stringBuilder5.append("\"," + bl + ")");
                ctClass.addField(new CtField(this.pgmClass, stringBuilder4.toString(), ctClass), stringBuilder5.toString());
                stringBuilder4.append(".count++;");
                ctMethod.insertBefore(stringBuilder4.toString());
                continue;
            }
            boolean bl4 = string2.startsWith(EP_PREFIX);
            int n6 = bl4 ? 1 : 0;
            if (!bl4 && (!bl3 || !Transformer.isUpperCase(string2) || string2.startsWith("EXEC_SQL_DECLARE_CURSOR$$"))) continue;
            if (n6 != 0) {
                string2 = "(ENTRY) " + string2.substring(EP_PREFIX.length()).toUpperCase();
            }
            if ((n2 = string2.indexOf("$$")) >= 0) {
                String string3 = string2.substring(n2 + 2);
                string2 = string2.substring(0, n2);
                n2 = string3.indexOf(36);
                if (n2 >= 0) {
                    string3 = string3.substring(0, n2);
                }
                string2 = string2.equals(string3) ? string2 + " section" : string2 + " of " + string3;
            }
            stringBuilder3.setLength(lenICnr);
            stringBuilder3.append(string);
            stringBuilder3.append("\",\"");
            stringBuilder3.append(string2);
            stringBuilder3.append("\")");
            stringBuilder2.setLength(lenIArg);
            stringBuilder2.append(n4++);
            ctClass.addField(new CtField(this.paragClass, stringBuilder2.toString(), ctClass), stringBuilder3.toString());
            stringBuilder.setLength(lenIMtd);
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(");");
            ctMethod.insertBefore(stringBuilder.toString());
            ctMethod.insertAfter(oMtd, true);
        }
        this.transformedClassNames.put(ctClass.getName(), bl);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("com.iscobol.lib");
        hashSet.add("com.iscobol.lib_n");
        hashSet.add("com.iscobol.so");
        hashSet.add("com.iscobol.son");
        invalidPackageNames = Collections.unmodifiableSet(hashSet);
        prClass = Profiler.class.getName();
        prMtd = prClass + ".getProfiler(";
        lenPgmArg = pgmInst.length();
        lenIArg = iArg.length();
        lenICnr = iCnr.length();
        lenIMtd = iMtd.length();
    }
}

