/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.report;

import com.iscobol.report.ReportVariable;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class ReportGroup {
    private int groupLine;
    private int vSize;
    private int vPos;
    int nextGroup;
    ICobolVar control;
    private Vector children = new Vector();
    final Method declaratives;
    final Object program;
    final Integer declStart;
    final Integer declEnd;
    private ArrayList sums = new ArrayList();

    public ReportGroup() {
        this.program = null;
        this.declaratives = null;
        this.declEnd = null;
        this.declStart = null;
    }

    public ReportGroup(Object object, int n2, int n3) {
        this.program = object;
        this.declStart = new Integer(n2);
        this.declEnd = new Integer(n3);
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod("declaratives", Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("ReportGroup " + noSuchMethodException);
        }
        this.declaratives = method;
    }

    void setGroupLine(int n2) {
        this.groupLine = n2;
    }

    void setNextGroup(int n2) {
        this.nextGroup = n2;
    }

    void setControl(ICobolVar iCobolVar) {
        this.control = iCobolVar;
    }

    void addVar(ReportVariable reportVariable) {
        this.children.add(reportVariable);
    }

    void init() {
        this.vSize = 0;
        this.vPos = 0;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            ReportVariable reportVariable = (ReportVariable)this.children.elementAt(i2);
            if (reportVariable.line == 0) continue;
            if ((reportVariable.line & 0x20000000) != 0) {
                this.vSize = -1;
                break;
            }
            if ((reportVariable.line & 0x10000000) != 0) {
                this.vSize += reportVariable.line & 0xFFFFFFF;
                continue;
            }
            if (this.vPos == 0) {
                this.vPos = reportVariable.line;
                continue;
            }
            this.vSize = reportVariable.line - this.vPos;
        }
        if ((this.groupLine & 0x10000000) != 0) {
            this.vSize += this.groupLine & 0xFFFFFFF;
        }
    }

    void declaratives() {
        if (this.declaratives != null) {
            try {
                this.declaratives.invoke(this.program, (Object[])new Integer[]{this.declStart, this.declEnd});
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable.getCause() != null && (throwable2 = throwable.getCause()) instanceof RuntimeException) {
                    throw (RuntimeException)throwable2;
                }
                throw new IscobolRuntimeException(throwable2);
            }
        }
    }

    final int getGroupLine() {
        return this.groupLine;
    }

    final int getVSize() {
        return this.vSize;
    }

    Iterator iterator() {
        return this.children.iterator();
    }

    void setSum(ReportVariable reportVariable, CobValue cobValue) {
        this.sums.add(new Sums(reportVariable, cobValue));
    }

    void evalSums() {
        for (int i2 = 0; i2 < this.sums.size(); ++i2) {
            Sums sums = (Sums)this.sums.get(i2);
            sums.doSum();
        }
    }

    private static class Sums {
        ReportVariable rv;
        CobValue cv;

        private Sums(ReportVariable reportVariable, CobValue cobValue) {
            this.rv = reportVariable;
            this.cv = cobValue;
        }

        private void doSum() {
            this.rv.sumToMe(this.cv);
        }
    }
}

