/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.report;

import com.iscobol.report.ReportGroup;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicAlphaEdit;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.types.CobolNum;
import java.util.Vector;

public class ReportVariable {
    ReportGroup parent;
    ICobolVar data;
    CobValue source;
    private int level;
    int line;
    ICobolVar memory;
    private int column;
    private byte[] initValue;
    private byte[] prevValue;
    private CobValue[] sum;
    private ReportGroup[] upon;
    ICobolVar reset;
    private boolean resetFinal;
    private Vector sumToMe;
    private CobolNum sumValue;

    public ReportVariable(int n2) {
        this.level = n2;
    }

    public ReportVariable(int n2, ICobolVar iCobolVar) {
        this(n2);
        this.data = iCobolVar;
        this.initValue = new byte[iCobolVar.length()];
        System.arraycopy(iCobolVar.ieval().getBytes(), 0, this.initValue, 0, this.initValue.length);
    }

    public ReportVariable setLine(int n2) {
        this.line = n2;
        return this;
    }

    public ReportVariable setLine(int n2, ICobolVar iCobolVar) {
        this.setLine(n2);
        this.memory = iCobolVar;
        this.memory.setSpace();
        return this;
    }

    public ReportVariable setColumn(int n2) {
        this.column = n2;
        return this;
    }

    public ReportVariable setSource(CobValue cobValue) {
        this.source = cobValue;
        return this;
    }

    public ReportVariable setGroupIndicate() {
        this.prevValue = new byte[this.initValue.length];
        return this;
    }

    public ReportVariable setSum(CobValue[] cobValueArray, ReportGroup[] reportGroupArray) {
        ICobolVar iCobolVar;
        CobolNum cobolNum;
        this.sum = cobValueArray;
        this.upon = reportGroupArray;
        if (this.data != null && (cobolNum = (iCobolVar = this.data.ieval()) instanceof INumericVar ? ((INumericVar)iCobolVar).num() : (iCobolVar instanceof IPicNumEdit ? ((IPicNumEdit)iCobolVar).num() : null)) != null) {
            this.sumValue = CobolNum.get(cobolNum.precision(), cobolNum.scale());
        }
        return this;
    }

    public ReportVariable setReset(ICobolVar iCobolVar) {
        if (iCobolVar != null) {
            this.reset = iCobolVar;
        } else {
            this.resetFinal = true;
        }
        return this;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    void ctrlBreak() {
        if (this.prevValue != null) {
            for (int i2 = this.prevValue.length - 1; i2 >= 0; --i2) {
                this.prevValue[i2] = 32;
            }
        }
    }

    void evalBefore() {
        if (this.data != null) {
            if (this.source != null) {
                ICobolVar iCobolVar = this.data.ieval();
                ICobolVar iCobolVar2 = this.source.ieval();
                if (iCobolVar instanceof INumericVar) {
                    iCobolVar2.moveTo((INumericVar)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((INumericVar)this.data).num());
                    }
                } else if (iCobolVar instanceof IPicNumEdit) {
                    iCobolVar2.moveTo((IPicNumEdit)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((IPicNumEdit)this.data).num());
                    }
                } else if (iCobolVar instanceof IPicAlphaEdit) {
                    iCobolVar2.moveTo((IPicAlphaEdit)this.data);
                } else {
                    iCobolVar2.moveTo(this.data);
                }
            } else if (this.sum != null) {
                this.data.ieval().set(this.sumValue);
                if (this.sumToMe != null) {
                    this.doSum(this.sumValue);
                }
                if (this.reset == null && !this.resetFinal) {
                    this.resetSum();
                }
            } else {
                this.data.ieval().set(this.initValue);
            }
        }
    }

    void evalAfter() {
        if (this.data != null && this.source != null) {
            ICobolVar iCobolVar = this.data.ieval();
            ICobolVar iCobolVar2 = this.source.ieval();
            if (iCobolVar instanceof INumericVar) {
                iCobolVar2.moveTo((INumericVar)this.data);
            } else if (iCobolVar instanceof IPicNumEdit) {
                iCobolVar2.moveTo((IPicNumEdit)this.data);
            } else if (iCobolVar instanceof IPicAlphaEdit) {
                iCobolVar2.moveTo((IPicAlphaEdit)this.data);
            } else {
                iCobolVar2.moveTo(this.data);
            }
            if (this.prevValue != null) {
                byte[] byArray = this.data.getBytes();
                if (ReportVariable.areEqual(this.prevValue, byArray, this.prevValue.length)) {
                    this.data.setSpace();
                } else {
                    System.arraycopy(byArray, 0, this.prevValue, 0, this.prevValue.length);
                }
            }
        }
    }

    void eval() {
        if (this.data != null) {
            if (this.source != null) {
                ICobolVar iCobolVar = this.data.ieval();
                ICobolVar iCobolVar2 = this.source.ieval();
                if (this.prevValue != null) {
                    byte[] byArray = iCobolVar2.getBytes();
                    if (ReportVariable.areEqual(this.prevValue, byArray, this.prevValue.length)) {
                        this.data.setSpace();
                        return;
                    }
                    System.arraycopy(byArray, 0, this.prevValue, 0, this.prevValue.length);
                }
                if (iCobolVar instanceof INumericVar) {
                    iCobolVar2.moveTo((INumericVar)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((INumericVar)this.data).num());
                    }
                } else if (iCobolVar instanceof IPicNumEdit) {
                    iCobolVar2.moveTo((IPicNumEdit)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((IPicNumEdit)this.data).num());
                    }
                } else if (iCobolVar instanceof IPicAlphaEdit) {
                    iCobolVar2.moveTo((IPicAlphaEdit)this.data);
                } else {
                    iCobolVar2.moveTo(this.data);
                }
            } else if (this.sum != null) {
                this.data.ieval().set(this.sumValue);
                if (this.sumToMe != null) {
                    this.doSum(this.sumValue);
                }
                if (this.reset == null && !this.resetFinal) {
                    this.resetSum();
                }
            } else {
                this.data.ieval().set(this.initValue);
            }
        }
    }

    void resetSum() {
        this.sumValue.set(0L, this.sumValue.scale());
    }

    void setToSum(ReportVariable reportVariable) {
        if (this.sumToMe == null) {
            this.sumToMe = new Vector();
        }
        this.sumToMe.add(reportVariable);
    }

    void sumToMe(CobValue cobValue) {
        ICobolVar iCobolVar = cobValue.ieval();
        if (iCobolVar instanceof INumericVar) {
            this.sumValue = this.sumValue.add(((INumericVar)iCobolVar).num());
        } else if (iCobolVar instanceof IPicNumEdit) {
            this.sumValue = this.sumValue.add(((IPicNumEdit)iCobolVar).num());
        }
    }

    private void doSum(CobolNum cobolNum) {
        for (int i2 = this.sumToMe.size() - 1; i2 >= 0; --i2) {
            ReportVariable reportVariable = (ReportVariable)this.sumToMe.elementAt(i2);
            reportVariable.sumValue = reportVariable.sumValue.add(cobolNum);
        }
    }

    CobValue[] getSum() {
        return this.sum;
    }

    ReportGroup[] getUpon() {
        return this.upon;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return "(null)";
    }
}

