/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.report;

import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.report.ReportGroup;
import com.iscobol.report.ReportVariable;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.Iterator;
import java.util.Vector;

public class ReportWriter
implements RuntimeErrorsNumbers {
    public static final int LINE_MASK = 0xFFFFFFF;
    public static final int LINE_PLUS = 0x10000000;
    public static final int LINE_PAGE = 0x20000000;
    private String name;
    private CobolFile file;
    private String fileName;
    private int fileOpt;
    private Vector controls = new Vector();
    private Object[][] cntrlsVal;
    private ReportGroup reportHeading;
    private ReportGroup pageHeading;
    private Vector controlHeadings = new Vector();
    private Vector details = new Vector();
    private Vector controlFootings = new Vector();
    private ReportGroup finalControlFooting;
    private ReportGroup pageFooting;
    private ReportGroup reportFooting;
    private Vector allDetailVar = new Vector();
    private Vector allControlFootingVar = new Vector();
    private ReportGroup lastVar;
    private ReportGroup lastDetail;
    private ReportGroup lastControlFooting;
    final int lineLimit;
    private int pageSize;
    private int headingLine;
    private int firstDetailLine;
    private int lastDetailLine;
    private int footingLine;
    private ICobolVar line_counter;
    private ICobolVar page_counter;
    private ICobolVar print_switch;
    private int afterAdv;
    private int colCounter;
    private int _lineCounter;
    private int pageCounter;
    private byte[] blanks;
    private ICobolVar buffer;

    public ReportWriter(int n2) {
        this(n2, 2);
    }

    public ReportWriter(int n2, int n3) {
        this.fileOpt = n3;
        this.lineLimit = n2;
        this.blanks = new byte[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.blanks[i2] = 32;
        }
    }

    private int lineCounter() {
        return this._lineCounter;
    }

    private void lineCounterAdd(int n2) {
        this._lineCounter += n2;
    }

    private void lineCounterInit() {
        this._lineCounter = 0;
    }

    private void lineCounterReset() {
        this._lineCounter = 0;
    }

    public ReportWriter setPage(int n2) {
        this.pageSize = n2;
        return this;
    }

    public ReportWriter setHeading(int n2) {
        this.headingLine = n2;
        return this;
    }

    public ReportWriter setFirstDetail(int n2) {
        this.firstDetailLine = n2;
        return this;
    }

    public ReportWriter setLastDetail(int n2) {
        this.lastDetailLine = n2;
        return this;
    }

    public ReportWriter setFooting(int n2) {
        this.footingLine = n2;
        return this;
    }

    public ReportWriter setControl(ICobolVar iCobolVar) {
        this.controls.add(iCobolVar);
        return this;
    }

    public ReportWriter setFinalControl(ICobolVar iCobolVar) {
        this.controls.add(0, iCobolVar);
        return this;
    }

    public void setReportHeading(ReportGroup reportGroup, int n2, int n3) {
        this.lastVar = this.reportHeading = reportGroup;
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
    }

    public void setPageHeading(ReportGroup reportGroup, int n2, int n3) {
        this.lastVar = this.pageHeading = reportGroup;
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
    }

    public void setControlHeading(ReportGroup reportGroup, int n2, int n3, ICobolVar iCobolVar) {
        this.lastVar = reportGroup;
        this.controlHeadings.add(this.lastVar);
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
        reportGroup.setControl(iCobolVar);
    }

    public void setDetail(ReportGroup reportGroup, int n2, int n3) {
        this.lastDetail = this.lastVar = reportGroup;
        this.details.add(this.lastVar);
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
    }

    public void setControlFooting(ReportGroup reportGroup, int n2, int n3, ICobolVar iCobolVar) {
        this.lastControlFooting = this.lastVar = reportGroup;
        this.controlFootings.add(this.lastVar);
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
        if (iCobolVar == null) {
            this.finalControlFooting = reportGroup;
        } else {
            reportGroup.setControl(iCobolVar);
        }
    }

    public void setPageFooting(ReportGroup reportGroup, int n2, int n3) {
        this.lastVar = this.pageFooting = reportGroup;
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
    }

    public void setReportFooting(ReportGroup reportGroup, int n2, int n3) {
        this.lastVar = this.reportFooting = reportGroup;
        reportGroup.setGroupLine(n2);
        reportGroup.setNextGroup(n3);
    }

    public void addVar(ReportVariable reportVariable) {
        this.lastVar.addVar(reportVariable);
        reportVariable.parent = this.lastVar;
        if (this.lastVar == this.lastDetail) {
            this.allDetailVar.add(reportVariable);
        } else if (this.lastVar == this.lastControlFooting) {
            this.allControlFootingVar.add(reportVariable);
        }
    }

    private void newPage() throws CobolIOException {
        if (this.lineCounter() > 0) {
            this.file.writeAdvancing(2, this.pageSize - this.lineCounter() + 1, false, 0, 1);
        }
        this.lineCounterReset();
        this.afterAdv = 0;
        ++this.pageCounter;
        if (this.page_counter != null) {
            this.page_counter.set(this.pageCounter);
        }
    }

    private void bodyAdvance(int n2, boolean bl) {
        this.advance(n2, bl, this.footingLine);
    }

    private void advance(int n2, boolean bl) {
        this.advance(n2, bl, this.pageSize);
    }

    private void advance(int n2, boolean bl, int n3) {
        if (n2 != 0) {
            if ((n2 & 0x20000000) != 0) {
                if (bl) {
                    this.flush();
                }
                this.newPage();
                this.afterAdv = n2 & 0xFFFFFFF;
            } else if ((n2 & 0x10000000) != 0) {
                int n4 = n2 & 0xFFFFFFF;
                if (n3 > 0 && n4 + this.lineCounter() > n3) {
                    n4 = n3 - this.lineCounter();
                }
                if (n4 >= 0) {
                    if (bl) {
                        this.flush();
                    }
                    this.afterAdv += n4;
                }
            } else if (n2 > this.lineCounter() + this.afterAdv) {
                if (bl) {
                    this.flush();
                }
                this.afterAdv = n2 - this.lineCounter();
            } else if (n2 < this.lineCounter() + this.afterAdv) {
                if (bl) {
                    this.flush();
                }
                this.newPage();
                this.afterAdv = n2 & 0xFFFFFFF;
            }
        }
        if (this.line_counter != null) {
            this.line_counter.set(this.lineCounter() + this.afterAdv);
        }
    }

    public void initiate(CobolFile cobolFile, CobValue cobValue, CobValue cobValue2, CobValue cobValue3) {
        this.initiate(cobolFile, cobValue, cobValue2, cobValue3, null);
    }

    public void initiate(CobolFile cobolFile, CobValue cobValue, CobValue cobValue2, CobValue cobValue3, CobValue cobValue4) {
        int n2;
        this.file = cobolFile;
        this.fileName = cobValue.toString();
        if (this.reportHeading != null) {
            this.reportHeading.init();
        }
        if (this.pageHeading != null) {
            this.pageHeading.init();
        }
        for (n2 = 0; n2 < this.controlHeadings.size(); ++n2) {
            ((ReportGroup)this.controlHeadings.elementAt(n2)).init();
        }
        for (n2 = 0; n2 < this.details.size(); ++n2) {
            ((ReportGroup)this.details.elementAt(n2)).init();
        }
        for (n2 = 0; n2 < this.controlFootings.size(); ++n2) {
            ((ReportGroup)this.controlFootings.elementAt(n2)).init();
        }
        if (this.pageFooting != null) {
            this.pageFooting.init();
        }
        if (this.reportFooting != null) {
            this.reportFooting.init();
        }
        if (cobValue2 != null) {
            this.line_counter = cobValue2.ieval();
            this.line_counter.set(0);
        }
        if (cobValue3 != null) {
            this.page_counter = cobValue3.ieval();
            this.page_counter.set(1);
        }
        if (cobValue4 != null) {
            this.print_switch = cobValue4.ieval();
            this.print_switch.set(0);
        }
        this.colCounter = 0;
        this.lineCounterInit();
        this.pageCounter = 1;
        this.file.updateBuffer(this.blanks);
        if (this.controls.size() > 0) {
            this.cntrlsVal = new Object[this.controls.size()][4];
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    ICobolVar iCobolVar = (ICobolVar)ReportWriter.this.controls.elementAt(n2);
                    ((ReportWriter)ReportWriter.this).cntrlsVal[n2][0] = iCobolVar;
                    byte[] byArray = iCobolVar.getBytes();
                    ((ReportWriter)ReportWriter.this).cntrlsVal[n2][1] = new byte[iCobolVar.length()];
                    System.arraycopy(byArray, 0, ReportWriter.this.cntrlsVal[n2][1], 0, iCobolVar.length());
                    ((ReportWriter)ReportWriter.this).cntrlsVal[n2][2] = new byte[iCobolVar.length()];
                    return true;
                }
            }.scan();
        }
        this.initiateSum();
    }

    private void lookForSource(CobValue cobValue, ReportVariable reportVariable) {
        int n2;
        ReportGroup[] reportGroupArray;
        ReportVariable reportVariable2;
        int n3;
        ReportVariable reportVariable3 = null;
        for (n3 = 0; n3 < this.allDetailVar.size(); ++n3) {
            reportVariable2 = (ReportVariable)this.allDetailVar.elementAt(n3);
            if (reportVariable2.source == null || reportVariable2.source.ieval() != cobValue.ieval()) continue;
            reportGroupArray = reportVariable.getUpon();
            if (reportGroupArray != null) {
                for (n2 = 0; n2 < reportGroupArray.length; ++n2) {
                    if (reportGroupArray[n2] != reportVariable2.parent) continue;
                    reportVariable3 = reportVariable2;
                    reportVariable3.setToSum(reportVariable);
                }
                continue;
            }
            reportVariable3 = reportVariable2;
            reportVariable3.setToSum(reportVariable);
        }
        if (reportVariable3 == null) {
            reportGroupArray = reportVariable.getUpon();
            ReportGroup reportGroup = null;
            for (n2 = 0; n2 < this.allDetailVar.size(); ++n2) {
                reportVariable2 = (ReportVariable)this.allDetailVar.elementAt(n2);
                if (reportGroup == reportVariable2.parent) continue;
                reportGroup = reportVariable2.parent;
                if (reportGroupArray != null) {
                    for (int i2 = 0; i2 < reportGroupArray.length; ++i2) {
                        if (reportGroupArray[i2] != reportGroup) continue;
                        reportGroup.setSum(reportVariable, cobValue);
                    }
                    continue;
                }
                reportGroup.setSum(reportVariable, cobValue);
            }
        }
        for (n3 = 0; n3 < this.allControlFootingVar.size() && (reportVariable2 = (ReportVariable)this.allControlFootingVar.elementAt(n3)) != reportVariable; ++n3) {
            if (reportVariable2.data == null || reportVariable2.data.ieval() != cobValue.ieval()) continue;
            reportGroupArray = reportVariable.getUpon();
            if (reportGroupArray != null) {
                for (n2 = 0; n2 < reportGroupArray.length; ++n2) {
                    if (reportGroupArray[n2] != reportVariable2.parent) continue;
                    reportVariable2.setToSum(reportVariable);
                }
                continue;
            }
            reportVariable2.setToSum(reportVariable);
        }
    }

    private void initiateSum() {
        for (int i2 = 0; i2 < this.allControlFootingVar.size(); ++i2) {
            int n2;
            ReportVariable reportVariable = (ReportVariable)this.allControlFootingVar.elementAt(i2);
            CobValue[] cobValueArray = reportVariable.getSum();
            if (cobValueArray != null) {
                for (n2 = 0; n2 < cobValueArray.length; ++n2) {
                    this.lookForSource(cobValueArray[n2], reportVariable);
                }
            }
            if (reportVariable.reset == null) continue;
            for (n2 = 0; n2 < this.cntrlsVal.length; ++n2) {
                if (reportVariable.reset != this.cntrlsVal[n2][0]) continue;
                this.cntrlsVal[n2][3] = reportVariable;
            }
        }
    }

    private void pageStart() {
        this.afterAdv = 0;
        if (this.headingLine > 0) {
            this.afterAdv += this.headingLine - 1;
        }
        if (this.pageCounter == 1 && this.reportHeading != null) {
            this.print(this.reportHeading);
        }
        if (this.pageHeading != null) {
            this.print(this.pageHeading);
        }
        if (this.firstDetailLine != 0) {
            this.afterAdv = this.firstDetailLine - this.lineCounter() - 1;
        }
    }

    private void flush() throws CobolIOException {
        if (this.lineCounter() == 0) {
            this.lineCounterAdd(1);
            --this.afterAdv;
        }
        if (this.buffer != null) {
            this.file.updateBuffer(this.buffer.getBytes());
        }
        this.file.writeAdvancing(1, this.afterAdv, false, this.lineLimit, this.fileOpt);
        this.lineCounterAdd(this.afterAdv);
        this.afterAdv = 0;
        this.file.updateBuffer(this.blanks);
        if (this.buffer != null) {
            this.buffer.set(this.blanks);
        }
    }

    private void print(ReportGroup reportGroup) {
        this.print(reportGroup, true);
    }

    private void print(ReportGroup reportGroup, boolean bl) {
        if (this.print_switch != null) {
            this.printNew(reportGroup, bl);
        } else {
            this.printOld(reportGroup, bl);
        }
    }

    private void printNew(ReportGroup reportGroup, boolean bl) {
        ReportVariable reportVariable;
        reportGroup.evalSums();
        Iterator iterator = reportGroup.iterator();
        while (iterator.hasNext()) {
            reportVariable = (ReportVariable)iterator.next();
            reportVariable.evalBefore();
        }
        this.print_switch.set(0);
        reportGroup.declaratives();
        if (this.print_switch.toint() != 1) {
            boolean bl2 = false;
            if (reportGroup.getGroupLine() > 0) {
                this.advance(reportGroup.getGroupLine(), bl2);
                bl2 = true;
            }
            this.buffer = null;
            Iterator iterator2 = reportGroup.iterator();
            while (iterator2.hasNext()) {
                reportVariable = (ReportVariable)iterator2.next();
                this.advance(reportVariable.line, bl2);
                if (reportVariable.memory != null) {
                    this.buffer = reportVariable.memory;
                }
                reportVariable.evalAfter();
                bl2 = true;
            }
            if (bl) {
                this.advance(reportGroup.nextGroup, true);
                if ((reportGroup.nextGroup & 0x20000000) == 0) {
                    this.flush();
                }
            }
        }
    }

    private void printOld(ReportGroup reportGroup, boolean bl) {
        boolean bl2 = false;
        if (reportGroup.getGroupLine() > 0) {
            this.advance(reportGroup.getGroupLine(), bl2);
            bl2 = true;
        }
        this.buffer = null;
        Iterator iterator = reportGroup.iterator();
        while (iterator.hasNext()) {
            ReportVariable reportVariable = (ReportVariable)iterator.next();
            this.advance(reportVariable.line, bl2);
            if (reportVariable.memory != null) {
                this.buffer = reportVariable.memory;
            }
            reportVariable.eval();
            bl2 = true;
        }
        if (bl) {
            this.advance(reportGroup.nextGroup, true);
            this.flush();
        }
    }

    private static boolean differs(ICobolVar iCobolVar, byte[] byArray) {
        byte[] byArray2 = iCobolVar.getBytes();
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            if (byArray2[i2] == byArray[i2]) continue;
            return true;
        }
        return false;
    }

    private int findControlBreak() {
        int n2 = new ControlsScanner(){

            @Override
            boolean element(int n2) {
                return !ReportWriter.differs((ICobolVar)ReportWriter.this.cntrlsVal[n2][0], (byte[])ReportWriter.this.cntrlsVal[n2][1]);
            }
        }.revScan();
        if (n2 != -1) {
            for (int i2 = this.allDetailVar.size() - 1; i2 >= 0; --i2) {
                ((ReportVariable)this.allDetailVar.elementAt(i2)).ctrlBreak();
            }
        }
        return n2;
    }

    private int printControlHeading() {
        int n2 = this.findControlBreak();
        this.printControlHeading(n2);
        return n2;
    }

    private void printControlHeading(int n2) {
        if (n2 != -1) {
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    for (int i2 = 0; i2 < ReportWriter.this.controlHeadings.size(); ++i2) {
                        ReportGroup reportGroup = (ReportGroup)ReportWriter.this.controlHeadings.elementAt(i2);
                        if (reportGroup.control != ReportWriter.this.cntrlsVal[n2][0]) continue;
                        ReportWriter.this.print(reportGroup);
                    }
                    return true;
                }
            }.scan(n2);
        }
    }

    private int updateControls() {
        int n2 = this.findControlBreak();
        this.updateControls(n2);
        return n2;
    }

    private void updateControls(int n2) {
        if (n2 != -1) {
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    System.arraycopy(((ICobolVar)ReportWriter.this.cntrlsVal[n2][0]).getBytes(), 0, ReportWriter.this.cntrlsVal[n2][1], 0, ((byte[])ReportWriter.this.cntrlsVal[n2][1]).length);
                    return true;
                }
            }.scan(n2);
        }
    }

    private int printControlFooting() {
        int n2 = this.findControlBreak();
        this.printControlFooting(n2);
        return n2;
    }

    private void printControlFooting(int n2) {
        if (n2 != -1) {
            final int[] nArray = new int[]{0};
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    ICobolVar iCobolVar = (ICobolVar)ReportWriter.this.cntrlsVal[n2][0];
                    byte[] byArray = iCobolVar.getBytes();
                    System.arraycopy(byArray, 0, ReportWriter.this.cntrlsVal[n2][2], 0, iCobolVar.length());
                    iCobolVar.set((byte[])ReportWriter.this.cntrlsVal[n2][1]);
                    return true;
                }
            }.scan(n2);
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    for (int i2 = 0; i2 < ReportWriter.this.controlFootings.size(); ++i2) {
                        ReportGroup reportGroup = (ReportGroup)ReportWriter.this.controlFootings.elementAt(i2);
                        if (reportGroup.control != ReportWriter.this.cntrlsVal[n2][0]) continue;
                        ReportWriter.this.print(reportGroup, false);
                        if (reportGroup.nextGroup > nArray[0]) {
                            nArray[0] = reportGroup.nextGroup;
                        }
                        ReportWriter.this.flush();
                    }
                    return true;
                }
            }.scan(n2);
            if (nArray[0] > 0) {
                this.bodyAdvance(nArray[0], false);
                this.flush();
            }
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    ICobolVar iCobolVar = (ICobolVar)ReportWriter.this.cntrlsVal[n2][0];
                    iCobolVar.set((byte[])ReportWriter.this.cntrlsVal[n2][2]);
                    return true;
                }
            }.scan(n2);
            if (this.cntrlsVal[n2][3] != null) {
                ((ReportVariable)this.cntrlsVal[n2][3]).resetSum();
            }
        }
    }

    private void printReportFooting() {
        if (this.pageFooting != null) {
            this.print(this.pageFooting);
        }
        if (this.reportFooting != null) {
            this.print(this.reportFooting);
        }
        this.newPage();
    }

    private void printPageFooting() {
        if (this.pageFooting != null) {
            this.print(this.pageFooting);
        }
        this.newPage();
    }

    private int beforePrint(ReportGroup reportGroup) {
        boolean bl = this.lineCounter() != 0 || this.pageCounter != 1;
        int n2 = this.lineCounter() + reportGroup.getVSize() - 1;
        if (this.file == null) {
            throw new IscobolRuntimeException(29, "");
        }
        int n3 = -2;
        if (this.lastDetailLine > 0 && n2 >= this.lastDetailLine) {
            if (this.footingLine > this.lastDetailLine) {
                n3 = this.printControlFooting();
            }
            this.printPageFooting();
        } else if (this.footingLine > 0 && n2 >= this.footingLine) {
            this.printPageFooting();
        }
        if (this.lineCounter() == 0) {
            this.pageStart();
        }
        if (bl && n3 == -2) {
            n3 = this.printControlFooting();
            n2 = this.lineCounter() + reportGroup.getVSize() - 1;
            if (this.lastDetailLine > 0 && n2 >= this.lastDetailLine || this.footingLine > 0 && n2 >= this.footingLine || n2 >= this.pageSize) {
                this.printPageFooting();
                this.pageStart();
            }
        }
        n3 = this.printControlHeading();
        return n3;
    }

    private void afterPrint(int n2) {
        this.updateControls(n2);
        this.line_counter.set(this.lineCounter());
        this.page_counter.set(this.pageCounter);
    }

    public void generate(ReportGroup reportGroup) {
        int n2 = this.beforePrint(reportGroup);
        this.print(reportGroup);
        this.afterPrint(n2);
    }

    public void generate(ReportGroup reportGroup, int n2) {
        this.fileOpt = n2;
        this.generate(reportGroup);
    }

    public void generate() {
        if (this.file == null) {
            throw new IscobolRuntimeException(29, "");
        }
        if (this.details.size() == 0) {
            return;
        }
        ReportGroup reportGroup = (ReportGroup)this.details.elementAt(0);
        int n2 = this.beforePrint(reportGroup);
        Iterator iterator = reportGroup.iterator();
        while (iterator.hasNext()) {
            ((ReportVariable)iterator.next()).eval();
        }
        this.file.updateBuffer(this.blanks);
        this.afterPrint(n2);
    }

    public void generate(int n2) {
        this.fileOpt = n2;
        this.generate();
    }

    public void terminate() {
        if (this.file == null) {
            throw new IscobolRuntimeException(29, "");
        }
        if (this.cntrlsVal != null) {
            new ControlsScanner(){

                @Override
                boolean element(int n2) {
                    for (int i2 = 0; i2 < ReportWriter.this.controlFootings.size(); ++i2) {
                        ReportGroup reportGroup = (ReportGroup)ReportWriter.this.controlFootings.elementAt(i2);
                        if (reportGroup.control != ReportWriter.this.cntrlsVal[n2][0]) continue;
                        ReportWriter.this.print(reportGroup, false);
                        ReportWriter.this.flush();
                    }
                    return true;
                }
            }.scan();
        }
        if (this.finalControlFooting != null) {
            this.print(this.finalControlFooting, false);
            this.flush();
        }
        this.printReportFooting();
        this.line_counter.set(this.lineCounter());
        this.page_counter.set(this.pageCounter);
        this.file = null;
    }

    private abstract class ControlsScanner {
        static final int NO_CTRL = -1;
        static final int INVALID = -2;

        private ControlsScanner() {
        }

        int scan() {
            return this.scan(0);
        }

        int scan(int n2) {
            int n3 = -1;
            if (ReportWriter.this.cntrlsVal != null) {
                for (n3 = ReportWriter.this.cntrlsVal.length - 1; n3 >= n2 && this.element(n3); --n3) {
                }
            }
            return n3;
        }

        int revScan() {
            int n2 = -1;
            if (ReportWriter.this.cntrlsVal != null) {
                for (n2 = 0; n2 < ReportWriter.this.cntrlsVal.length && this.element(n2); ++n2) {
                }
                if (n2 == ReportWriter.this.cntrlsVal.length) {
                    n2 = -1;
                }
            }
            return n2;
        }

        abstract boolean element(int var1);
    }
}

