/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.gui.ParamVector;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.logger.Logger;
import com.iscobol.rmi.IsExternalizable;
import com.iscobol.rmi.server.ServerRemoteObject;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.MessageSerializationException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.print.RemotePrintCommand;
import com.iscobol.rts.print.RemotePrintResponse;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class IscobolMessageSerializer
implements IMessageSerializer {
    public static final byte TYPE_UNKNOWN = -1;
    public static final byte TYPE_UNKNOWN_COMPRESS = -2;
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_INT = 2;
    public static final byte TYPE_FLOAT = 3;
    public static final byte TYPE_LONG = 4;
    public static final byte TYPE_BYTE = 5;
    public static final byte TYPE_CHAR = 6;
    public static final byte TYPE_SHORT = 7;
    public static final byte TYPE_DOUBLE = 8;
    public static final byte TYPE_STRING = 9;
    public static final byte TYPE_A_BOOLEAN = 10;
    public static final byte TYPE_A_INT = 11;
    public static final byte TYPE_A_FLOAT = 12;
    public static final byte TYPE_A_LONG = 13;
    public static final byte TYPE_A_BYTE = 14;
    public static final byte TYPE_A_CHAR = 15;
    public static final byte TYPE_A_SHORT = 16;
    public static final byte TYPE_A_DOUBLE = 17;
    public static final byte TYPE_A_STRING = 18;
    public static final byte TYPE_RECTANGLE = 19;
    public static final byte TYPE_INSETS = 20;
    public static final byte TYPE_DIMENSION = 21;
    public static final byte TYPE_POINT = 22;
    public static final byte TYPE_RRA = 23;
    public static final byte TYPE_REMOTE = 24;
    public static final byte TYPE_VECTOR_OF_PARAM_ELEMS = 25;
    public static final byte TYPE_JNIWRAPPER_PARAMETER = 26;
    public static final byte TYPE_VECTOR_OF_PARAM_ELEMS_COMPRESS = 27;
    public static final byte TYPE_A_BYTE_COMPRESS = 28;
    public static final byte TYPE_A_R_PRT_CMD = 29;
    public static final byte TYPE_A_R_PRT_CMD_COMPRESS = 30;
    public static final byte TYPE_R_PRT_RESP = 31;
    public static final byte TYPE_IS_EXT = 32;
    public static final byte NO_COMPRESS = 0;
    public static final byte BEST_COMPRESS = 1;
    public static final byte BEST_SPEED_COMPRESS = 2;
    public static Class parameterClass;

    @Override
    public Message deserialize(ObjectInputStream objectInputStream, Logger logger) throws MessageSerializationException {
        try {
            Serializable serializable;
            byte by = objectInputStream.readByte();
            int n2 = objectInputStream.readInt();
            switch (by) {
                case 1: {
                    serializable = this.deserializeCallPayload(objectInputStream, logger);
                    break;
                }
                case 2: {
                    serializable = this.deserializeResultPayload(objectInputStream, logger);
                    break;
                }
                case 3: {
                    serializable = this.deserializeFaultPayload(objectInputStream);
                    break;
                }
                default: {
                    throw new MessageSerializationException("Unknown payload type: " + by);
                }
            }
            return new Message(n2, by, serializable);
        }
        catch (EOFException eOFException) {
            throw new MessageSerializationException(eOFException);
        }
        catch (SocketException socketException) {
            throw new MessageSerializationException(socketException);
        }
        catch (Exception exception) {
            if (logger != null) {
                logger.severe(IscobolMessageSerializer.stackTraceToString(exception));
            }
            throw new MessageSerializationException(exception);
        }
    }

    static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    @Override
    public void serialize(Message message, ObjectOutputStream objectOutputStream, Logger logger, int n2, int n3) throws MessageSerializationException {
        try {
            byte by = message.getPayloadType();
            objectOutputStream.writeByte(by);
            objectOutputStream.writeInt(message.getId());
            Object object = message.getPayload();
            switch (by) {
                case 1: {
                    this.serializeCallPayload((RpcCallPayload)object, objectOutputStream, logger, n2, n3);
                    break;
                }
                case 2: {
                    this.serializeResultPayload((RpcResultPayload)object, objectOutputStream, logger, n2, n3);
                    break;
                }
                case 3: {
                    this.serializeFaultPayload((RpcFaultPayload)object, objectOutputStream);
                    break;
                }
                default: {
                    throw new MessageSerializationException("Unknown payload type: " + by);
                }
            }
        }
        catch (EOFException eOFException) {
            throw new MessageSerializationException(eOFException);
        }
        catch (SocketException socketException) {
            throw new MessageSerializationException(socketException);
        }
        catch (Exception exception) {
            if (logger != null) {
                logger.severe(IscobolMessageSerializer.stackTraceToString(exception));
            }
            throw new MessageSerializationException(exception);
        }
    }

    private RpcCallPayload deserializeCallPayload(ObjectInputStream objectInputStream, Logger logger) throws Exception {
        boolean bl = objectInputStream.readBoolean();
        int n2 = objectInputStream.readInt();
        short s2 = objectInputStream.readShort();
        ArrayList<Object> arrayList = null;
        if (n2 < 0) {
            String string = objectInputStream.readUTF();
            String string2 = objectInputStream.readUTF();
            byte by = objectInputStream.readByte();
            arrayList = new ArrayList(by);
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                arrayList.add(this.deserializeObject(objectInputStream.readByte(), objectInputStream, logger));
            }
            return new RpcCallPayload(string, string2, arrayList, bl);
        }
        byte by = objectInputStream.readByte();
        arrayList = new ArrayList<Object>(by);
        for (byte by3 = 0; by3 < by; by3 = (byte)(by3 + 1)) {
            arrayList.add(this.deserializeObject(objectInputStream.readByte(), objectInputStream, logger));
        }
        return new RpcCallPayload(n2, s2, arrayList, bl);
    }

    private RpcResultPayload deserializeResultPayload(ObjectInputStream objectInputStream, Logger logger) throws Exception {
        int n2 = objectInputStream.readInt();
        Object object = this.deserializeObject(objectInputStream.readByte(), objectInputStream, logger);
        return new RpcResultPayload(object, n2);
    }

    private RpcFaultPayload deserializeFaultPayload(ObjectInputStream objectInputStream) throws Exception {
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        int n2 = objectInputStream.readInt();
        return new RpcFaultPayload(string, string2, n2);
    }

    protected Object deserializeObject(byte by, ObjectInputStream objectInputStream, Logger logger) throws Exception {
        switch (by) {
            case 0: {
                return null;
            }
            case 2: {
                return new Integer(objectInputStream.readInt());
            }
            case 3: {
                return new Float(objectInputStream.readFloat());
            }
            case 1: {
                return new Boolean(objectInputStream.readBoolean());
            }
            case 4: {
                return new Long(objectInputStream.readLong());
            }
            case 5: {
                return new Byte(objectInputStream.readByte());
            }
            case 6: {
                return new Character(objectInputStream.readChar());
            }
            case 8: {
                return new Double(objectInputStream.readDouble());
            }
            case 7: {
                return new Short(objectInputStream.readShort());
            }
            case 11: {
                short s2 = objectInputStream.readShort();
                int[] nArray = new int[s2];
                for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
                    nArray[s3] = objectInputStream.readInt();
                }
                return nArray;
            }
            case 28: {
                return IscobolMessageSerializer.readCompress(objectInputStream);
            }
            case 14: {
                int n2 = objectInputStream.readInt();
                byte[] byArray = new byte[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    byArray[i2] = objectInputStream.readByte();
                }
                return byArray;
            }
            case 12: {
                short s4 = objectInputStream.readShort();
                float[] fArray = new float[s4];
                for (short s5 = 0; s5 < s4; s5 = (short)(s5 + 1)) {
                    fArray[s5] = objectInputStream.readFloat();
                }
                return fArray;
            }
            case 17: {
                short s6 = objectInputStream.readShort();
                double[] dArray = new double[s6];
                for (short s7 = 0; s7 < s6; s7 = (short)(s7 + 1)) {
                    dArray[s7] = objectInputStream.readDouble();
                }
                return dArray;
            }
            case 13: {
                short s8 = objectInputStream.readShort();
                long[] lArray = new long[s8];
                for (short s9 = 0; s9 < s8; s9 = (short)(s9 + 1)) {
                    lArray[s9] = objectInputStream.readLong();
                }
                return lArray;
            }
            case 10: {
                short s10 = objectInputStream.readShort();
                boolean[] blArray = new boolean[s10];
                for (short s11 = 0; s11 < s10; s11 = (short)(s11 + 1)) {
                    blArray[s11] = objectInputStream.readBoolean();
                }
                return blArray;
            }
            case 16: {
                short s12 = objectInputStream.readShort();
                short[] sArray = new short[s12];
                for (short s13 = 0; s13 < s12; s13 = (short)(s13 + 1)) {
                    sArray[s13] = objectInputStream.readShort();
                }
                return sArray;
            }
            case 15: {
                short s14 = objectInputStream.readShort();
                char[] cArray = new char[s14];
                for (short s15 = 0; s15 < s14; s15 = (short)(s15 + 1)) {
                    cArray[s15] = objectInputStream.readChar();
                }
                return cArray;
            }
            case 9: {
                return RtsUtil.readUTF(objectInputStream);
            }
            case 18: {
                short s16 = objectInputStream.readShort();
                String[] stringArray = new String[s16];
                for (short s17 = 0; s17 < s16; s17 = (short)(s17 + 1)) {
                    stringArray[s17] = RtsUtil.readUTF(objectInputStream);
                }
                return stringArray;
            }
            case 19: {
                return new Rectangle(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
            }
            case 20: {
                return new Insets(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
            }
            case 21: {
                return new Dimension(objectInputStream.readInt(), objectInputStream.readInt());
            }
            case 22: {
                return new Point(objectInputStream.readInt(), objectInputStream.readInt());
            }
            case 25: {
                ParamVector paramVector = new ParamVector();
                paramVector.readExternal(objectInputStream);
                return paramVector;
            }
            case 27: {
                return this.readCompress(objectInputStream, new ParamVector());
            }
            case 23: {
                RemoteRecordAccept remoteRecordAccept = (RemoteRecordAccept)Class.forName(objectInputStream.readUTF()).newInstance();
                remoteRecordAccept.readExternal(objectInputStream);
                return remoteRecordAccept;
            }
            case 24: {
                ServerRemoteObject serverRemoteObject = (ServerRemoteObject)Class.forName(objectInputStream.readUTF()).newInstance();
                serverRemoteObject.readExternal(objectInputStream);
                return serverRemoteObject.readResolve();
            }
            case 30: {
                final Object[] objectArray = new Object[1];
                this.readCompress(objectInputStream, new Externalizable(){

                    @Override
                    public void writeExternal(ObjectOutput objectOutput) throws IOException {
                    }

                    @Override
                    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
                        RemotePrintCommand[] remotePrintCommandArray = new RemotePrintCommand[objectInput.readInt()];
                        for (int i2 = 0; i2 < remotePrintCommandArray.length; ++i2) {
                            remotePrintCommandArray[i2] = new RemotePrintCommand();
                            remotePrintCommandArray[i2].readExternal(objectInput);
                        }
                        objectArray[0] = remotePrintCommandArray;
                    }
                });
                return (RemotePrintCommand[])objectArray[0];
            }
            case 29: {
                RemotePrintCommand[] remotePrintCommandArray = new RemotePrintCommand[objectInputStream.readInt()];
                for (int i3 = 0; i3 < remotePrintCommandArray.length; ++i3) {
                    remotePrintCommandArray[i3] = new RemotePrintCommand();
                    remotePrintCommandArray[i3].readExternal(objectInputStream);
                }
                return remotePrintCommandArray;
            }
            case 31: {
                RemotePrintResponse remotePrintResponse = new RemotePrintResponse();
                remotePrintResponse.readExternal(objectInputStream);
                return remotePrintResponse;
            }
            case 32: {
                IsExternalizable isExternalizable = (IsExternalizable)Class.forName(objectInputStream.readUTF()).newInstance();
                isExternalizable.readExternal(objectInputStream);
                return isExternalizable;
            }
            case 26: {
                if (parameterClass != null) {
                    return this.deserializeParameter(objectInputStream);
                }
            }
            case -2: {
                return IscobolMessageSerializer.readObjectCompress(objectInputStream, logger);
            }
        }
        return IscobolMessageSerializer.readObject(objectInputStream, logger);
    }

    private Object deserializeParameter(ObjectInputStream objectInputStream) throws Exception {
        Object obj = Class.forName(objectInputStream.readUTF()).newInstance();
        int n2 = objectInputStream.readInt();
        byte[] byArray = new byte[n2];
        objectInputStream.read(byArray, 0, n2);
        parameterClass.getMethod("read", byte[].class, Integer.TYPE).invoke(obj, byArray, new Integer(0));
        return obj;
    }

    private void serializeCallPayload(RpcCallPayload rpcCallPayload, ObjectOutputStream objectOutputStream, Logger logger, int n2, int n3) throws Exception {
        objectOutputStream.writeBoolean(rpcCallPayload.isSendResults());
        int n4 = rpcCallPayload.getObjectId();
        short s2 = rpcCallPayload.getMethodId();
        ArrayList arrayList = rpcCallPayload.getParameters();
        int n5 = arrayList != null ? (int)arrayList.size() : 0;
        objectOutputStream.writeInt(n4);
        objectOutputStream.writeShort(s2);
        if (n4 < 0) {
            objectOutputStream.writeUTF(rpcCallPayload.getHandlerName());
            objectOutputStream.writeUTF(rpcCallPayload.getMethodName());
        }
        objectOutputStream.writeByte(n5);
        if (n5 > 0) {
            for (int n6 = 0; n6 < n5; n6 = (int)((byte)(n6 + 1))) {
                this.serializeObject(arrayList.get(n6), objectOutputStream, logger, n2, n3);
            }
        }
    }

    private void serializeResultPayload(RpcResultPayload rpcResultPayload, ObjectOutputStream objectOutputStream, Logger logger, int n2, int n3) throws Exception {
        objectOutputStream.writeInt(rpcResultPayload.getOriginatingRpcCallMessageId());
        if (rpcResultPayload.isOldStringTransmission()) {
            objectOutputStream.writeByte(9);
            objectOutputStream.writeUTF((String)rpcResultPayload.getResultObject());
        } else {
            this.serializeObject(rpcResultPayload.getResultObject(), objectOutputStream, logger, n2, n3);
        }
    }

    private void serializeFaultPayload(RpcFaultPayload rpcFaultPayload, ObjectOutputStream objectOutputStream) throws Exception {
        objectOutputStream.writeUTF(rpcFaultPayload.getFaultCode());
        objectOutputStream.writeUTF(rpcFaultPayload.getFaultMessage());
        objectOutputStream.writeInt(rpcFaultPayload.getOriginatingRpcCallMessageId());
    }

    protected void serializeObject(Object object, ObjectOutputStream objectOutputStream, Logger logger, int n2, int n3) throws Exception {
        if (object == null) {
            objectOutputStream.writeByte(0);
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Integer.class) {
            objectOutputStream.writeByte(2);
            objectOutputStream.writeInt((Integer)object);
        } else if (clazz == Float.class) {
            objectOutputStream.writeByte(3);
            objectOutputStream.writeFloat(((Float)object).floatValue());
        } else if (clazz == Boolean.class) {
            objectOutputStream.writeByte(1);
            objectOutputStream.writeBoolean((Boolean)object);
        } else if (clazz == Long.class) {
            objectOutputStream.writeByte(4);
            objectOutputStream.writeLong((Long)object);
        } else if (clazz == Byte.class) {
            objectOutputStream.writeByte(5);
            objectOutputStream.writeByte(((Byte)object).byteValue());
        } else if (clazz == Double.class) {
            objectOutputStream.writeByte(8);
            objectOutputStream.writeDouble((Double)object);
        } else if (clazz == Short.class) {
            objectOutputStream.writeByte(7);
            objectOutputStream.writeShort(((Short)object).shortValue());
        } else if (clazz == Character.class) {
            objectOutputStream.writeByte(6);
            objectOutputStream.writeChar(((Character)object).charValue());
        } else if (clazz == String.class) {
            objectOutputStream.writeByte(9);
            RtsUtil.writeUTF((String)object, objectOutputStream);
        } else if (clazz == int[].class) {
            objectOutputStream.writeByte(11);
            int[] nArray = (int[])object;
            objectOutputStream.writeShort((short)nArray.length);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                objectOutputStream.writeInt(nArray[i2]);
            }
        } else if (clazz == byte[].class) {
            byte[] byArray = (byte[])object;
            if (byArray.length > n3 && (n2 == 1 || n2 == 2)) {
                objectOutputStream.writeByte(28);
                IscobolMessageSerializer.writeCompress(byArray, n2, objectOutputStream);
            } else {
                objectOutputStream.writeByte(14);
                objectOutputStream.writeInt(byArray.length);
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    objectOutputStream.writeByte(byArray[i3]);
                }
            }
        } else if (clazz == boolean[].class) {
            objectOutputStream.writeByte(10);
            boolean[] blArray = (boolean[])object;
            objectOutputStream.writeShort((short)blArray.length);
            for (int i4 = 0; i4 < blArray.length; ++i4) {
                objectOutputStream.writeBoolean(blArray[i4]);
            }
        } else if (clazz == float[].class) {
            objectOutputStream.writeByte(12);
            float[] fArray = (float[])object;
            objectOutputStream.writeShort((short)fArray.length);
            for (int i5 = 0; i5 < fArray.length; ++i5) {
                objectOutputStream.writeFloat(fArray[i5]);
            }
        } else if (clazz == long[].class) {
            objectOutputStream.writeByte(13);
            long[] lArray = (long[])object;
            objectOutputStream.writeShort((short)lArray.length);
            for (int i6 = 0; i6 < lArray.length; ++i6) {
                objectOutputStream.writeLong(lArray[i6]);
            }
        } else if (clazz == double[].class) {
            objectOutputStream.writeByte(17);
            double[] dArray = (double[])object;
            objectOutputStream.writeShort((short)dArray.length);
            for (int i7 = 0; i7 < dArray.length; ++i7) {
                objectOutputStream.writeDouble(dArray[i7]);
            }
        } else if (clazz == char[].class) {
            objectOutputStream.writeByte(15);
            char[] cArray = (char[])object;
            objectOutputStream.writeShort((short)cArray.length);
            for (int i8 = 0; i8 < cArray.length; ++i8) {
                objectOutputStream.writeChar(cArray[i8]);
            }
        } else if (clazz == short[].class) {
            objectOutputStream.writeByte(16);
            short[] sArray = (short[])object;
            objectOutputStream.writeShort((short)sArray.length);
            for (int i9 = 0; i9 < sArray.length; ++i9) {
                objectOutputStream.writeShort(sArray[i9]);
            }
        } else if (clazz == String[].class) {
            objectOutputStream.writeByte(18);
            String[] stringArray = (String[])object;
            objectOutputStream.writeShort((short)stringArray.length);
            for (int i10 = 0; i10 < stringArray.length; ++i10) {
                if (stringArray[i10] != null) {
                    RtsUtil.writeUTF(stringArray[i10], objectOutputStream);
                    continue;
                }
                RtsUtil.writeUTF("", objectOutputStream);
            }
        } else if (clazz == Rectangle.class) {
            objectOutputStream.writeByte(19);
            Rectangle rectangle = (Rectangle)object;
            objectOutputStream.writeInt(rectangle.x);
            objectOutputStream.writeInt(rectangle.y);
            objectOutputStream.writeInt(rectangle.width);
            objectOutputStream.writeInt(rectangle.height);
        } else if (clazz == Insets.class) {
            objectOutputStream.writeByte(20);
            Insets insets = (Insets)object;
            objectOutputStream.writeInt(insets.top);
            objectOutputStream.writeInt(insets.left);
            objectOutputStream.writeInt(insets.bottom);
            objectOutputStream.writeInt(insets.right);
        } else if (clazz == Dimension.class) {
            objectOutputStream.writeByte(21);
            Dimension dimension = (Dimension)object;
            objectOutputStream.writeInt(dimension.width);
            objectOutputStream.writeInt(dimension.height);
        } else if (clazz == Point.class) {
            objectOutputStream.writeByte(22);
            Point point = (Point)object;
            objectOutputStream.writeInt(point.x);
            objectOutputStream.writeInt(point.y);
        } else if (clazz == ParamVector.class) {
            if (n2 == 1 || n2 == 2) {
                byte[] byArray = null;
                byArray = this.object2Bytes((ParamVector)object);
                if (byArray != null && byArray.length > n3) {
                    objectOutputStream.writeByte(27);
                    IscobolMessageSerializer.writeCompress(byArray, n2, objectOutputStream);
                } else {
                    objectOutputStream.writeByte(25);
                    ((ParamVector)object).writeExternal(objectOutputStream);
                }
            } else {
                objectOutputStream.writeByte(25);
                ((ParamVector)object).writeExternal(objectOutputStream);
            }
        } else if (RemoteRecordAccept.class.isAssignableFrom(clazz)) {
            objectOutputStream.writeByte(23);
            objectOutputStream.writeUTF(clazz.getName());
            ((RemoteRecordAccept)object).writeExternal(objectOutputStream);
        } else if (ServerRemoteObject.class.isAssignableFrom(clazz)) {
            objectOutputStream.writeByte(24);
            objectOutputStream.writeUTF(clazz.getName());
            ((ServerRemoteObject)object).writeExternal(objectOutputStream);
        } else if (RemotePrintCommand[].class == clazz) {
            final RemotePrintCommand[] remotePrintCommandArray = (RemotePrintCommand[])object;
            byte[] byArray = null;
            if (n2 == 1 || n2 == 2) {
                byArray = this.object2Bytes(new Externalizable(){

                    @Override
                    public void writeExternal(ObjectOutput objectOutput) throws IOException {
                        objectOutput.writeInt(remotePrintCommandArray.length);
                        for (RemotePrintCommand remotePrintCommand : remotePrintCommandArray) {
                            remotePrintCommand.writeExternal(objectOutput);
                        }
                    }

                    @Override
                    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
                    }
                });
                if (byArray != null && byArray.length > n3) {
                    objectOutputStream.writeByte(30);
                    IscobolMessageSerializer.writeCompress(byArray, n2, objectOutputStream);
                } else {
                    byArray = null;
                }
            }
            if (byArray == null) {
                objectOutputStream.writeByte(29);
                objectOutputStream.writeInt(remotePrintCommandArray.length);
                for (RemotePrintCommand remotePrintCommand : remotePrintCommandArray) {
                    remotePrintCommand.writeExternal(objectOutputStream);
                }
            }
        } else if (RemotePrintResponse.class == clazz) {
            objectOutputStream.writeByte(31);
            ((RemotePrintResponse)object).writeExternal(objectOutputStream);
        } else if (IsExternalizable.class.isAssignableFrom(clazz)) {
            objectOutputStream.writeByte(32);
            objectOutputStream.writeUTF(object.getClass().getName());
            ((IsExternalizable)object).writeExternal(objectOutputStream);
        } else if (parameterClass != null && parameterClass.isAssignableFrom(clazz)) {
            objectOutputStream.writeByte(26);
            this.serializeParameter(object, objectOutputStream);
        } else {
            IscobolMessageSerializer.writeObject(object, objectOutputStream, logger, n2, n3);
        }
    }

    private void serializeParameter(Object object, ObjectOutputStream objectOutputStream) throws Exception {
        objectOutputStream.writeUTF(object.getClass().getName());
        byte[] byArray = (byte[])parameterClass.getMethod("toByteArray", new Class[0]).invoke(object, new Object[0]);
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
    }

    public static Object readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        return IscobolMessageSerializer.readObject(objectInput, null);
    }

    private static Object readObject(ObjectInput objectInput, Logger logger) throws IOException, ClassNotFoundException {
        int n2 = objectInput.readInt();
        byte[] byArray = new byte[n2];
        objectInput.readFully(byArray, 0, n2);
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        if (logger != null) {
            logger.warning(IscobolMessageSerializer.class.getName() + ".deserializeObject: type UNKNOWN[" + object.getClass().getName() + "].");
        }
        return object;
    }

    private static Object readObjectCompress(ObjectInputStream objectInputStream, Logger logger) throws IOException, ClassNotFoundException {
        Object object = null;
        byte[] byArray = IscobolMessageSerializer.readCompress(objectInputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
        object = objectInputStream2.readObject();
        objectInputStream2.close();
        byteArrayInputStream.close();
        if (logger != null) {
            logger.warning(IscobolMessageSerializer.class.getName() + ".deserializeObject: type UNKNOWN_COMPRESS[" + object.getClass().getName() + "].");
        }
        return object;
    }

    public static void writeObject(Object object, ObjectOutput objectOutput) throws IOException {
        IscobolMessageSerializer.writeObject(object, objectOutput, null, 0, 32768);
    }

    private static void writeObject(Object object, ObjectOutput objectOutput, Logger logger, int n2, int n3) throws IOException {
        if (logger != null) {
            logger.warning(IscobolMessageSerializer.class.getName() + ".serializeObject: type UNKNOWN [" + object.getClass().getName() + "] minSizeCompress [" + n3 + "] compressLevel [" + n2 + "].");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > n3 && (n2 == 1 || n2 == 2)) {
            objectOutput.writeByte(-2);
            IscobolMessageSerializer.writeCompress(byArray, n2, (ObjectOutputStream)objectOutput);
        } else {
            objectOutput.writeByte(-1);
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray, 0, byArray.length);
        }
    }

    @Override
    public Message deserialize(ObjectInputStream objectInputStream) throws MessageSerializationException {
        return this.deserialize(objectInputStream, null);
    }

    @Override
    public void serialize(Message message, ObjectOutputStream objectOutputStream) throws MessageSerializationException {
        this.serialize(message, objectOutputStream, null, 0, 32768);
    }

    private byte[] object2Bytes(Externalizable externalizable) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            externalizable.writeExternal(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            if (byteArrayOutputStream != null) {
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private static void writeCompress(byte[] byArray, int n2, ObjectOutputStream objectOutputStream) throws IOException {
        Deflater deflater = null;
        deflater = n2 == 1 ? new Deflater(9) : new Deflater(1);
        deflater.setInput(byArray, 0, byArray.length);
        deflater.finish();
        int n3 = 0;
        byte[] byArray2 = new byte[byArray.length];
        while (true) {
            int n4 = byArray2.length - n3;
            int n5 = deflater.deflate(byArray2, n3, n4);
            n3 += n5;
            if (n5 != n4) break;
            byte[] byArray3 = byArray2;
            byArray2 = new byte[byArray3.length * 2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        }
        objectOutputStream.writeInt(n3);
        objectOutputStream.write(byArray2, 0, n3);
    }

    private static byte[] readCompress(ObjectInputStream objectInputStream) throws IOException {
        int n2 = objectInputStream.readInt();
        byte[] byArray = new byte[n2];
        objectInputStream.readFully(byArray);
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[byArray.length];
        int n3 = 0;
        while (true) {
            int n4 = byArray2.length - n3;
            int n5 = 0;
            try {
                n5 = inflater.inflate(byArray2, n3, n4);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Input Stream is corrupt: " + dataFormatException);
            }
            n3 += n5;
            if (inflater.finished()) break;
            byte[] byArray3 = byArray2;
            byArray2 = new byte[byArray3.length * 2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        }
        inflater.reset();
        if (n3 < byArray2.length) {
            byte[] byArray4 = byArray2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray4, 0, byArray2, 0, n3);
        }
        return byArray2;
    }

    private <T extends Externalizable> T readCompress(ObjectInputStream objectInputStream, T t2) {
        try {
            byte[] byArray = IscobolMessageSerializer.readCompress(objectInputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
            t2.readExternal(objectInputStream2);
            objectInputStream2.close();
            byteArrayInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return t2;
    }

    static {
        try {
            parameterClass = Class.forName("com.jniwrapper.Parameter");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

