/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.logger.Logger;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.util.MethodTable;
import com.iscobol.rpc.dualrpc.common.CallException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RemoteInvocationHandler
implements InvocationHandler {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final Character char_0 = new Character('\u0000');
    private static final Byte byte_0 = new Byte(0);
    private Integer ref;
    private int objectId;
    private int rpcCallTimeout;
    private RemoteCaller caller;
    private Logger problemLog;
    private Logger rpcCallLog;
    private static final String FINALIZE_METHOD = "finalize";
    private MethodTable methodTable;

    public RemoteInvocationHandler(RemoteCaller remoteCaller, Integer n2, MethodTable methodTable, int n3) {
        this.ref = n2;
        this.objectId = n2;
        this.caller = remoteCaller;
        this.methodTable = methodTable;
        this.rpcCallTimeout = n3;
    }

    public Logger getProblemLog() {
        return this.problemLog;
    }

    public void setProblemLog(Logger logger) {
        this.problemLog = logger;
    }

    public Logger getRpcCallLog() {
        return this.rpcCallLog;
    }

    public void setRpcCallLog(Logger logger) {
        this.rpcCallLog = logger;
    }

    private Object invokeObject(Object object, Method method, Object[] objectArray) throws Throwable {
        String string;
        if (this.rpcCallLog != null) {
            this.rpcCallLog.info("RPC CALL: " + RemoteInvocationHandler.getRemoteInterfaceName(object) + "." + method.getName());
        }
        if ((string = method.getName()).equals("hashCode")) {
            return this.proxyHashCode(object);
        }
        if (string.equals("equals")) {
            return this.proxyEquals(object, objectArray[0]);
        }
        if (string.equals("toString")) {
            return this.proxyToString(object);
        }
        return RemoteInvocationHandler.nullValueOf(method.getReturnType());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (FINALIZE_METHOD.equals(method.getName())) {
            if (this.rpcCallLog != null) {
                this.rpcCallLog.info("RPC CALL: " + RemoteInvocationHandler.getRemoteInterfaceName(object) + ".finalize");
            }
            this.caller.removeRemote(this.ref);
            this.caller.call(this.objectId, this.methodTable.getUnexportMethodIndex(), null, false);
            return this.invokeObject(object, method, objectArray);
        }
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObject(object, method, objectArray);
        }
        Object object2 = null;
        try {
            ArrayList<Object> arrayList;
            int n2;
            int n3 = n2 = objectArray != null ? objectArray.length : 0;
            if (n2 > 0) {
                arrayList = new ArrayList<Object>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(objectArray[i2]);
                }
            } else {
                arrayList = null;
            }
            if (this.rpcCallLog != null) {
                RemoteInvocationHandler.logMethod(this.rpcCallLog, method.getName(), objectArray);
            }
            object2 = this.caller.call(this.objectId, this.methodTable.getMethodIndex(method), arrayList, true, this.rpcCallTimeout);
            if (this.rpcCallLog != null) {
                RemoteInvocationHandler.logRetVal(this.rpcCallLog, method.getName(), object2);
            }
            return object2;
        }
        catch (CallException callException) {
            if (this.problemLog != null) {
                this.problemLog.severe(RemoteInvocationHandler.stackTraceToString(callException));
            }
            IOException iOException = new IOException(callException.getMessage()){
                private static final long serialVersionUID = 1L;

                @Override
                public Throwable getCause() {
                    return callException.getCause();
                }
            };
            throw iOException;
        }
    }

    static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    static String getRemoteInterfaceName(Object object) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] == Remote.class || !Remote.class.isAssignableFrom(classArray[i2])) continue;
            return classArray[i2].getName();
        }
        return Remote.class.getName();
    }

    protected Integer proxyHashCode(Object object) {
        return new Integer(System.identityHashCode(object));
    }

    protected Boolean proxyEquals(Object object, Object object2) {
        return object == object2 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object object) {
        return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
    }

    private static final Object nullValueOf(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Void.TYPE) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return char_0;
        }
        return byte_0;
    }

    static void logMethod(Logger logger, String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RPC CALL: methodName = ");
        stringBuffer.append(string);
        if (objectArray != null && objectArray.length > 0) {
            stringBuffer.append(",   parameters:");
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(eol);
                stringBuffer.append(RemoteInvocationHandler.getTypeName(objectArray[i2], "      ", ""));
                if (objectArray[i2] == null) continue;
                stringBuffer.append(" (" + objectArray[i2] + ")");
            }
        } else {
            stringBuffer.append(",   no-parameters");
        }
        logger.info(stringBuffer.toString());
    }

    static void logRetVal(Logger logger, String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RPC RESULT: methodName = ");
        stringBuffer.append(string);
        stringBuffer.append(",   returnValue:");
        stringBuffer.append(eol);
        stringBuffer.append(RemoteInvocationHandler.getTypeName(object, "      ", ""));
        if (object != null) {
            stringBuffer.append(" (" + object + ")");
        }
        logger.info(stringBuffer.toString());
    }

    static String getTypeName(Object object, String string, String string2) {
        StringBuffer stringBuffer;
        block7: {
            Class<?> clazz;
            block6: {
                stringBuffer = new StringBuffer();
                if (object == null) {
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    stringBuffer.append("null");
                    return stringBuffer.toString();
                }
                clazz = object.getClass();
                if (clazz != ParamVector.class) break block6;
                ParamVector paramVector = (ParamVector)object;
                ParamVElement[] paramVElementArray = paramVector.toArray();
                stringBuffer.append(string + string2 + clazz.getName());
                stringBuffer.append(eol);
                if (paramVElementArray.length <= 0) break block7;
                stringBuffer.append(RemoteInvocationHandler.getTypeName(paramVElementArray[0], string + "   ", "elem[0] = "));
                for (int i2 = 1; i2 < paramVElementArray.length; ++i2) {
                    stringBuffer.append(eol);
                    stringBuffer.append(RemoteInvocationHandler.getTypeName(paramVElementArray[i2], string + "   ", "elem[" + i2 + "] = "));
                }
                break block7;
            }
            if (!clazz.isArray()) {
                stringBuffer.append(string);
                stringBuffer.append(string2);
                stringBuffer.append(clazz.getName().replace('$', '.'));
            } else {
                int n2 = 0;
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                    ++n2;
                }
                stringBuffer.append(string + string2 + clazz.getName().replace('$', '.'));
                for (int i3 = 0; i3 < n2; ++i3) {
                    stringBuffer.append("[]");
                }
            }
        }
        return stringBuffer.toString();
    }

    public int getRpcCallTimeout() {
        return this.rpcCallTimeout;
    }

    public void setRpcCallTimeout(int n2) {
        this.rpcCallTimeout = n2;
    }
}

