/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.logger.Logger;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rts.ArrayTable;
import java.util.Hashtable;

public class RemoteRegistry {
    private ArrayTable remoteObjectsTable = new ArrayTable();
    private static RemoteRegistry sharedRegistry;
    private static ClientCaller clientCaller;
    private static RemoteCallersTable remoteCallers;
    public static final int MIN_SIZE_COMPRESS = 32768;

    public static ClientCaller getClientCaller() {
        return clientCaller;
    }

    public static Logger getClientProblemLogger() {
        if (clientCaller != null) {
            return clientCaller.getProblemLog();
        }
        return null;
    }

    public static Logger getClientRpcCallLogger() {
        if (clientCaller != null) {
            return clientCaller.getRpcCallLog();
        }
        return null;
    }

    public static void setClientCaller(ClientCaller clientCaller) {
        RemoteRegistry.clientCaller = clientCaller;
    }

    public static void setClientProblemLogger(Logger logger) {
        if (clientCaller != null) {
            RemoteRegistry.clientCaller.problemLog = logger;
        }
    }

    public static void setClientRpcCallLogger(Logger logger) {
        if (clientCaller != null) {
            RemoteRegistry.clientCaller.rpcCallLog = logger;
        }
    }

    public static RemoteCaller getCaller(int n2) {
        return remoteCallers.get(n2);
    }

    public static Logger getProblemLogger(int n2) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            return remoteCaller.problemLog;
        }
        return null;
    }

    public static Logger getRpcCallLogger(int n2) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            return remoteCaller.rpcCallLog;
        }
        return null;
    }

    public static int getCompressLevel(int n2) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            return remoteCaller.compressLevel;
        }
        return 0;
    }

    public static int getMinSizeCompress(int n2) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            return remoteCaller.minSizeCompress;
        }
        return 32768;
    }

    public static void setProblemLogger(int n2, Logger logger) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            remoteCaller.problemLog = logger;
        }
    }

    public static void setRpcCallLogger(int n2, Logger logger) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            remoteCaller.rpcCallLog = logger;
        }
    }

    public static void setCompressLevel(int n2, int n3) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            remoteCaller.compressLevel = n3;
        }
    }

    public static void setMinSizeCompress(int n2, int n3) {
        RemoteCaller remoteCaller = remoteCallers.get(n2);
        if (remoteCaller != null) {
            remoteCaller.minSizeCompress = n3;
        }
    }

    public Remote get(int n2) {
        return (Remote)this.remoteObjectsTable.get(n2);
    }

    public int put(Remote remote) {
        return this.remoteObjectsTable.put(remote);
    }

    public Remote remove(int n2) {
        return (Remote)this.remoteObjectsTable.remove(n2);
    }

    public Remote remove(Integer n2) {
        return (Remote)this.remoteObjectsTable.remove(n2);
    }

    public void clear() {
        this.remoteObjectsTable.clear();
    }

    public static RemoteRegistry getSharedRegistry() {
        return sharedRegistry;
    }

    public static void setSharedRegistry(RemoteRegistry remoteRegistry) {
        sharedRegistry = remoteRegistry;
    }

    public static int setCaller(RemoteCaller remoteCaller) {
        return remoteCallers.put(remoteCaller);
    }

    public static RemoteCaller removeCaller(int n2) {
        return remoteCallers.remove(n2);
    }

    public static int skipProg() {
        return RemoteCallersTable.nextProg();
    }

    static {
        remoteCallers = new RemoteCallersTable();
    }

    static class RemoteCallersTable
    extends Hashtable {
        private static int _idProg;

        RemoteCallersTable() {
        }

        private static final int nextProg() {
            if (++_idProg < 0) {
                _idProg = 1;
            }
            return _idProg;
        }

        final int put(RemoteCaller remoteCaller) {
            int n2 = RemoteCallersTable.nextProg();
            this.put(new Integer(n2), remoteCaller);
            return n2;
        }

        final RemoteCaller get(int n2) {
            return (RemoteCaller)this.get(new Integer(n2));
        }

        final RemoteCaller remove(int n2) {
            return (RemoteCaller)this.remove(new Integer(n2));
        }
    }
}

