/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi.server;

import com.iscobol.as.AsThreadGroup;
import com.iscobol.as.MultitaskingServerHandler;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.RemoteInvocationHandler;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rmi.util.MethodTable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;

public class ServerRemoteObject
implements Remote,
Externalizable {
    private static final long serialVersionUID = 533265363546734L;
    protected int rpcCallTimeout;
    protected Integer ref;
    protected transient RemoteRegistry registry;
    private static Hashtable remoteInterfaces = new Hashtable();

    public ServerRemoteObject() {
        this.setCallTimeout(0);
        this.init();
    }

    protected void setCallTimeout(int n2) {
        this.rpcCallTimeout = n2;
    }

    protected int getCallTimeout() {
        return this.rpcCallTimeout;
    }

    protected void init() {
        int n2 = -1;
        if (MultitaskingServerHandler.sessionId >= 0) {
            n2 = MultitaskingServerHandler.sessionId;
        } else {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            if (threadGroup instanceof AsThreadGroup) {
                n2 = ((AsThreadGroup)threadGroup).getSessionId();
            }
        }
        if (n2 >= 0) {
            ServerCaller serverCaller = (ServerCaller)RemoteRegistry.getCaller(n2);
            this.registry = serverCaller.getRegistry();
            this.ref = new Integer(this.registry.put(this));
        }
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void unexport() {
        if (this.registry != null) {
            this.registry.remove(this.ref);
        }
    }

    protected Remote toStub(RemoteCaller remoteCaller) {
        Remote remote = remoteCaller.getRemote(this.ref);
        if (remote == null) {
            try {
                RemoteClassInfo remoteClassInfo = ServerRemoteObject.findRemoteInfo(this.getClass());
                RemoteInvocationHandler remoteInvocationHandler = this.createInvocationHandler(remoteCaller, this.ref, remoteClassInfo.methods, this.rpcCallTimeout);
                remoteInvocationHandler.setProblemLog(remoteCaller.getProblemLog());
                remoteInvocationHandler.setRpcCallLog(remoteCaller.getRpcCallLog());
                remote = (Remote)Proxy.newProxyInstance(this.getClass().getClassLoader(), remoteClassInfo.interfaces, (InvocationHandler)remoteInvocationHandler);
                remoteCaller.putRemote(this.ref, remote);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return remote;
    }

    protected RemoteInvocationHandler createInvocationHandler(RemoteCaller remoteCaller, Integer n2, MethodTable methodTable, int n3) {
        return new RemoteInvocationHandler(remoteCaller, n2, methodTable, n3);
    }

    public static Method getMethod(Class clazz, int n2) throws Exception {
        return ServerRemoteObject.findRemoteInfo((Class)clazz).methods.getMethod(n2);
    }

    private static RemoteClassInfo findRemoteInfo(Class clazz) throws Exception {
        RemoteClassInfo remoteClassInfo = (RemoteClassInfo)remoteInterfaces.get(clazz);
        if (remoteClassInfo == null) {
            Hashtable hashtable = new Hashtable();
            ServerRemoteObject.findRemoteInterfaces(clazz, hashtable);
            int n2 = hashtable.size();
            remoteClassInfo = new RemoteClassInfo();
            remoteClassInfo.interfaces = new Class[n2];
            hashtable.values().toArray(remoteClassInfo.interfaces);
            remoteClassInfo.methods = new MethodTable(remoteClassInfo.interfaces);
            remoteInterfaces.put(clazz, remoteClassInfo);
        }
        return remoteClassInfo;
    }

    private static void findRemoteInterfaces(Class clazz, Hashtable hashtable) throws Exception {
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray == null) {
            return;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!hashtable.containsKey(classArray[i2]) && Remote.class.isAssignableFrom(classArray[i2])) {
                hashtable.put(classArray[i2], classArray[i2]);
            }
            ServerRemoteObject.findRemoteInterfaces(classArray[i2], hashtable);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        ClientCaller clientCaller = RemoteRegistry.getClientCaller();
        if (clientCaller != null) {
            return this.toStub(clientCaller);
        }
        return this;
    }

    public Integer getRef() {
        return this.ref;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = new Integer(objectInput.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.ref);
    }

    private static class RemoteClassInfo {
        Class[] interfaces;
        MethodTable methods;

        private RemoteClassInfo() {
        }
    }
}

