/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi.util;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.TreeSet;

public class MethodTable
implements Comparator {
    private Method[] methods;
    private short unexportId = (short)-1;

    public MethodTable(Class[] classArray) {
        TreeSet<Method> treeSet = new TreeSet<Method>(this);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Method[] methodArray = classArray[i2].getMethods();
            for (int i3 = 0; i3 < methodArray.length; ++i3) {
                treeSet.add(methodArray[i3]);
            }
        }
        this.methods = new Method[treeSet.size()];
        treeSet.toArray(this.methods);
        this.unexportId = this.getMethodIndex("unexport", new Class[0]);
    }

    public synchronized short getMethodIndex(Method method) {
        return this.getMethodIndex(method.getName(), method.getParameterTypes());
    }

    private short getMethodIndex(String string, Class[] classArray) {
        int n2 = 0;
        int n3 = this.methods.length - 1;
        int n4 = n2 + (n3 - n2) / 2;
        while (n2 <= n3) {
            int n5 = this.compare(this.methods[n4].getName(), this.methods[n4].getParameterTypes(), string, classArray);
            if (n5 == 0) {
                return (short)n4;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
            } else {
                n2 = n4 + 1;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1;
    }

    public short getUnexportMethodIndex() {
        return this.unexportId;
    }

    public Method getMethod(int n2) {
        return this.methods[n2];
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    public int compare(Object object, Object object2) {
        Method method = (Method)object;
        Method method2 = (Method)object2;
        return this.compare(method.getName(), method.getParameterTypes(), method2.getName(), method2.getParameterTypes());
    }

    private int compare(String string, Class[] classArray, String string2, Class[] classArray2) {
        int n2 = string.compareTo(string2);
        if (n2 != 0) {
            return n2;
        }
        n2 = classArray.length - classArray2.length;
        if (n2 != 0) {
            return n2;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] == classArray2[i2]) continue;
            return classArray[i2].getName().compareTo(classArray2[i2].getName());
        }
        return 0;
    }
}

