/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.client;

import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClientDispatcher;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IDualRpcCaller;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayloadContainer;
import com.iscobol.rpc.dualrpc.common.RpcWorkerFactory;
import com.iscobol.rpc.messageserver.client.MessageClient;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.ArrayTable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;

public class DualRpcClient
implements IDualRpcCaller,
IDualRpcMessageConstants {
    private String host = null;
    private int port = 0;
    private HashMap clientHandlers = new HashMap();
    private MessageClient messageclient = null;
    private ArrayTable callWaitingRegistry = new ArrayTable();
    private int defaultCallTimeoutInSeconds = 60;
    private DualRpcClientDispatcher dispatcher = null;
    private IClientCallbackHandler callbackHandler = null;
    private IMessageSerializer messageSerializer = null;
    private IRpcWorkerFactory rpcWorkerFactory = new RpcWorkerFactory();

    public DualRpcClient(String string, int n2) {
        this.host = string;
        this.port = n2;
    }

    public void registerClientSideHandler(AbstractClientRpcHandler abstractClientRpcHandler) {
        this.getClientHandlers().put(abstractClientRpcHandler.getClass().getName(), abstractClientRpcHandler);
    }

    public void connect() throws UnknownHostException, IOException, GeneralSecurityException {
        this.messageclient = new MessageClient(this.host, this.port);
        if (this.messageSerializer != null) {
            this.getMessageclient().setMessageSerializer(this.messageSerializer);
        }
        this.getMessageclient().connect();
        this.dispatcher = new DualRpcClientDispatcher(this);
        this.dispatcher.setDaemon(true);
        this.dispatcher.start();
    }

    public Object call(String string, String string2) throws CallException {
        ArrayList arrayList = new ArrayList();
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2, Object object3) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2, Object object3, Object object4) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        arrayList.add(object5);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2) throws CallException {
        ArrayList arrayList = new ArrayList();
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2, Object object3) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2, Object object3, Object object4) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        arrayList.add(object5);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, ArrayList arrayList) throws CallException {
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, ArrayList arrayList) throws CallException {
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, int n2, ArrayList arrayList) throws CallException {
        return this.call(string, string2, true, n2, arrayList);
    }

    public Object call(String string, String string2, boolean bl, int n2, ArrayList arrayList) throws CallException {
        return this.call(new RpcCallPayload(string, string2, arrayList, bl), n2);
    }

    @Override
    public Object call(int n2, short s2, ArrayList arrayList, boolean bl, int n3) throws CallException {
        return this.call(new RpcCallPayload(n2, s2, arrayList, bl), n3);
    }

    @Override
    public Object call(int n2, short s2, ArrayList arrayList, boolean bl) throws CallException {
        return this.call(new RpcCallPayload(n2, s2, arrayList, bl), this.defaultCallTimeoutInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(RpcCallPayload rpcCallPayload, int n2) throws CallException {
        Object object;
        block17: {
            object = null;
            try {
                MessageClient messageClient = this.getMessageclient();
                if (messageClient != null) {
                    int n3 = 0;
                    Message message = new Message(n3, 1, rpcCallPayload);
                    if (rpcCallPayload.isSendResults()) {
                        RpcResultPayloadContainer rpcResultPayloadContainer = new RpcResultPayloadContainer();
                        n3 = this.getCallWaitingRegistry().put(rpcResultPayloadContainer);
                        message.setId(n3);
                        boolean bl = false;
                        String string = null;
                        try {
                            RpcResultPayloadContainer rpcResultPayloadContainer2 = rpcResultPayloadContainer;
                            synchronized (rpcResultPayloadContainer2) {
                                this.getMessageclient().sendMessage(message);
                                if (n2 <= 0) {
                                    rpcResultPayloadContainer.wait();
                                } else {
                                    rpcResultPayloadContainer.wait(n2 * 1000);
                                }
                            }
                            int n4 = rpcResultPayloadContainer.getRpcResultPayloadType();
                            switch (n4) {
                                case 2: {
                                    RpcResultPayload rpcResultPayload = (RpcResultPayload)rpcResultPayloadContainer.getRpcMessagePayload();
                                    object = rpcResultPayload.getResultObject();
                                    break;
                                }
                                case 3: {
                                    RpcFaultPayload rpcFaultPayload = (RpcFaultPayload)rpcResultPayloadContainer.getRpcMessagePayload();
                                    bl = true;
                                    string = rpcFaultPayload.getFaultMessage();
                                    break;
                                }
                                default: {
                                    bl = true;
                                    string = "Call timed out. Current timeout=" + n2;
                                    break;
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                            string = "Thread was interrupted. " + interruptedException.toString();
                        }
                        this.getCallWaitingRegistry().remove(n3);
                        if (bl) {
                            throw new CallException(string);
                        }
                        break block17;
                    }
                    this.getMessageclient().sendMessage(message);
                    break block17;
                }
                throw new CallException("This method cannot be called unless there is an active connection to the server.");
            }
            catch (CallException callException) {
                throw callException;
            }
            catch (Throwable throwable) {
                throw new CallException(throwable);
            }
        }
        return object;
    }

    public void disconnect() throws NotConnectedException {
        MessageClient messageClient = this.getMessageclient();
        if (messageClient == null) {
            throw new NotConnectedException("This method cannot be called unless there is an active connection to the server.");
        }
        this.getMessageclient().getSession().closeSession();
    }

    protected MessageClient getMessageclient() {
        return this.messageclient;
    }

    protected ArrayTable getCallWaitingRegistry() {
        return this.callWaitingRegistry;
    }

    public void setDefaultCallTimeoutInSeconds(int n2) {
        this.defaultCallTimeoutInSeconds = n2;
    }

    protected HashMap getClientHandlers() {
        return this.clientHandlers;
    }

    protected IClientCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(IClientCallbackHandler iClientCallbackHandler) {
        this.callbackHandler = iClientCallbackHandler;
    }

    public long getSessionId() throws NotConnectedException {
        return this.getSession().getSessionId();
    }

    public Session getSession() throws NotConnectedException {
        MessageClient messageClient = this.getMessageclient();
        if (messageClient != null) {
            return this.getMessageclient().getSession();
        }
        throw new NotConnectedException("This method cannot be called unless there is an active connection to the server.");
    }

    public void setMessageSerializer(IMessageSerializer iMessageSerializer) {
        this.messageSerializer = iMessageSerializer;
    }

    public void setRpcWorkerFactory(IRpcWorkerFactory iRpcWorkerFactory) {
        this.rpcWorkerFactory = iRpcWorkerFactory;
    }

    protected IRpcWorkerFactory getRpcWorkerFactory() {
        return this.rpcWorkerFactory;
    }
}

