/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.client;

import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rts.ArrayTable;

public class DualRpcClientDispatcher
extends Thread
implements IDualRpcMessageConstants,
IRpcMessageDispatcher {
    private DualRpcClient dualRpcClient = null;

    public DualRpcClientDispatcher(DualRpcClient dualRpcClient) {
        this.dualRpcClient = dualRpcClient;
    }

    @Override
    public void run() {
        long l2 = this.getSession().getSessionId();
        try {
            Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + l2);
            while (true) {
                try {
                    Message message = this.getSession().getMessage(true);
                    Thread thread = this.dualRpcClient.getRpcWorkerFactory().getRpcWorkerThread(this, message);
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (SessionException sessionException) {
                    if (this.dualRpcClient.getCallbackHandler() != null) {
                        this.dualRpcClient.getCallbackHandler().brokenConnection();
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ArrayTable getCallWaitingRegistry() {
        return this.dualRpcClient.getCallWaitingRegistry();
    }

    @Override
    public IRpcHandler getHandler(String string) {
        return (IRpcHandler)this.dualRpcClient.getClientHandlers().get(string);
    }

    @Override
    public Session getSession() {
        return this.dualRpcClient.getMessageclient().getSession();
    }
}

