/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.common;

import com.iscobol.rpc.dualrpc.common.AbstractRpcResultPayload;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcException;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayloadContainer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RpcWorker
extends Thread
implements IDualRpcMessageConstants {
    private IRpcMessageDispatcher dispatcher = null;
    private Message message = null;

    public RpcWorker(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
        this.setDispatcher(iRpcMessageDispatcher);
        this.setMessage(message);
    }

    protected void configureThread() {
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + this.getDispatcher().getSession().getSessionId());
    }

    @Override
    public void run() {
        this.configureThread();
        int n2 = -1;
        try {
            n2 = this.getMessage().getPayloadType();
            switch (n2) {
                case 1: {
                    this.processRpcCallMessage(this.getMessage());
                    break;
                }
                case 2: {
                    this.processRpcResultMessage(this.getMessage(), 2);
                    break;
                }
                case 3: {
                    this.processRpcResultMessage(this.getMessage(), 3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processRpcCallMessage(Message message) throws SessionException {
        block8: {
            Session session = this.getDispatcher().getSession();
            long l2 = session.getSessionId();
            RpcCallPayload rpcCallPayload = null;
            int n2 = message.getId();
            try {
                GenericDeclaration genericDeclaration;
                rpcCallPayload = (RpcCallPayload)message.getPayload();
                String string = rpcCallPayload.getHandlerName();
                String string2 = rpcCallPayload.getMethodName();
                ArrayList arrayList = rpcCallPayload.getParameters();
                IRpcHandler iRpcHandler = this.getDispatcher().getHandler(string);
                if (iRpcHandler == null) {
                    throw new RpcException("Unknown handler=" + string);
                }
                ArrayList arrayList2 = new ArrayList();
                int n3 = arrayList.size();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < n3; ++i2) {
                    genericDeclaration = arrayList.get(i2).getClass();
                    arrayList2.add((Class<?>)genericDeclaration);
                    stringBuffer.append(((Class)genericDeclaration).getName() + ",");
                }
                Class[] classArray = new Class[arrayList2.size()];
                arrayList2.toArray(classArray);
                genericDeclaration = this.findMethod(iRpcHandler.getClass(), string2, classArray);
                if (genericDeclaration == null) {
                    throw new RpcException("Cannot locate method=" + string2 + "( " + stringBuffer.toString() + " )");
                }
                Object[] objectArray = new Object[arrayList.size()];
                arrayList.toArray(objectArray);
                Object object = ((Method)genericDeclaration).invoke(iRpcHandler, objectArray);
                if (rpcCallPayload.isSendResults()) {
                    RpcResultPayload rpcResultPayload = new RpcResultPayload(object, n2);
                    Message message2 = new Message(-1, 2, rpcResultPayload);
                    this.getDispatcher().getSession().sendMessage(message2);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (rpcCallPayload != null && rpcCallPayload.isSendResults()) {
                    String string = this.buildFaultErrorMessage(l2, invocationTargetException.getTargetException());
                    this.sendFaultMessage(n2, string);
                }
            }
            catch (Exception exception) {
                if (rpcCallPayload == null || !rpcCallPayload.isSendResults()) break block8;
                String string = this.buildFaultErrorMessage(l2, exception);
                this.sendFaultMessage(n2, string);
            }
        }
    }

    public String buildFaultErrorMessage(long l2, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return throwable.getMessage() + "\n" + stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRpcResultMessage(Message message, int n2) throws RpcException {
        AbstractRpcResultPayload abstractRpcResultPayload = null;
        switch (n2) {
            case 2: {
                abstractRpcResultPayload = (RpcResultPayload)message.getPayload();
                break;
            }
            case 3: {
                abstractRpcResultPayload = (RpcFaultPayload)message.getPayload();
                break;
            }
            default: {
                throw new RpcException("Unknown rpc message payloadType=" + n2);
            }
        }
        int n3 = abstractRpcResultPayload.getOriginatingRpcCallMessageId();
        RpcResultPayloadContainer rpcResultPayloadContainer = (RpcResultPayloadContainer)this.getDispatcher().getCallWaitingRegistry().get(n3);
        if (rpcResultPayloadContainer != null) {
            rpcResultPayloadContainer.setRpcMessagePayload(abstractRpcResultPayload);
            rpcResultPayloadContainer.setRpcResultMessageType(n2);
            RpcResultPayloadContainer rpcResultPayloadContainer2 = rpcResultPayloadContainer;
            synchronized (rpcResultPayloadContainer2) {
                rpcResultPayloadContainer.notifyAll();
            }
        } else {
            throw new RpcException("Orphaned rpc result message:originating rpc call message id=" + n3);
        }
    }

    public IRpcMessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(IRpcMessageDispatcher iRpcMessageDispatcher) {
        this.dispatcher = iRpcMessageDispatcher;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void sendFaultMessage(int n2, String string) throws SessionException {
        RpcFaultPayload rpcFaultPayload = new RpcFaultPayload("x", string, n2);
        Message message = new Message(-1, 3, rpcFaultPayload);
        this.getDispatcher().getSession().sendMessage(message);
    }

    public Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = this.tryFindMethod(clazz, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException2.printStackTrace();
            }
        }
        return method;
    }

    private Method tryFindMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method[] methodArray = clazz.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Class<?>[] classArray2;
            if (!methodArray[i2].getName().equals(string) || (classArray2 = methodArray[i2].getParameterTypes()).length != classArray.length) continue;
            boolean bl = true;
            for (int i3 = 0; i3 < classArray2.length && bl; bl &= classArray[i3] == null || RpcWorker.isAssignableFrom(classArray2[i3], classArray[i3]), ++i3) {
            }
            if (!bl) continue;
            return methodArray[i2];
        }
        throw new NoSuchMethodException();
    }

    private static boolean isAssignableFrom(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz == Integer.TYPE && clazz2 == Integer.class || clazz == Long.TYPE && clazz2 == Long.class || clazz == Boolean.TYPE && clazz2 == Boolean.class || clazz == Float.TYPE && clazz2 == Float.class || clazz == Double.TYPE && clazz2 == Double.class || clazz == Character.TYPE && clazz2 == Character.class || clazz == Short.TYPE && clazz2 == Short.class || clazz == Byte.TYPE && clazz2 == Byte.class;
    }
}

