/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.server;

import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.common.RpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.DualRpcServerApplicationFactory;
import com.iscobol.rpc.dualrpc.server.ServerNotRunningException;
import com.iscobol.rpc.dualrpc.server.ShutdownThread;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.server.MessageServer;
import java.io.IOException;
import java.util.ArrayList;

public class DualRpcServer {
    private String host = null;
    private int port = 0;
    private boolean reuseAddress;
    private ArrayList listServerSideHandlerClassnames = new ArrayList();
    private MessageServer messageServer = null;
    private Object serverHandlerConfigurationObject = null;
    private DualRpcServerApplicationFactory applicationFactory = null;
    private int maxConnections = 512;
    private boolean keepAlive = true;
    private boolean ignoreMaxConnectionsLimit;
    private IMessageSerializer messageSerializer = null;
    private long messageSequence = 0L;
    private String messageIdSeed = "s" + System.identityHashCode(this) + "-" + System.currentTimeMillis() + "-";
    private IRpcWorkerFactory rpcWorkerFactory = new RpcWorkerFactory();

    public DualRpcServer(String string, int n2, boolean bl, Object object) {
        this.host = string;
        this.port = n2;
        this.reuseAddress = bl;
        this.serverHandlerConfigurationObject = object;
        this.applicationFactory = new DualRpcServerApplicationFactory(this);
    }

    public void listen() throws IOException {
        this.setMessageServer(new MessageServer(this.host, this.port, this.reuseAddress, this.applicationFactory));
        this.getMessageServer().setMaxConnections(this.getMaxConnections());
        this.getMessageServer().setKeepAlive(this.isKeepAlive());
        this.getMessageServer().setIgnoreMaxConnectionsLimit(this.isIgnoreMaxConnectionsLimit());
        if (this.messageSerializer != null) {
            this.getMessageServer().setMessageSerializer(this.messageSerializer);
        }
        this.getMessageServer().listen();
    }

    public void registerServerSideHandlerClassname(String string) throws ClassNotFoundException {
        this.getListServerSideHandlerClassnames().add(string);
    }

    public int currentConnectionCount() {
        return this.getMessageServer().currentConnectionCount();
    }

    protected ArrayList getListServerSideHandlerClassnames() {
        return this.listServerSideHandlerClassnames;
    }

    protected Object getServerHandlerConfigurationObject() {
        return this.serverHandlerConfigurationObject;
    }

    public synchronized void setMaxConnections(int n2) {
        this.maxConnections = n2;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isIgnoreMaxConnectionsLimit() {
        return this.ignoreMaxConnectionsLimit;
    }

    public void setIgnoreMaxConnectionsLimit(boolean bl) {
        this.ignoreMaxConnectionsLimit = bl;
    }

    public synchronized void setSendAndReceiveMessages(boolean bl) throws ServerNotRunningException {
        if (this.getMessageServer() == null) {
            throw new ServerNotRunningException("Method can only be called after DualRpcServer is listening.");
        }
        this.getMessageServer().setSendAndReceiveMessages(bl);
    }

    public void shutdown(int n2) throws ServerNotRunningException {
        this.getMessageServer().setAcceptNewConnections(false);
        this.setSendAndReceiveMessages(false);
        ShutdownThread shutdownThread = new ShutdownThread(n2);
        shutdownThread.run();
    }

    public void setMessageSerializer(IMessageSerializer iMessageSerializer) {
        this.messageSerializer = iMessageSerializer;
    }

    protected synchronized String getNextMessageId() {
        ++this.messageSequence;
        return this.messageIdSeed + this.messageSequence;
    }

    public void setRpcWorkerFactory(IRpcWorkerFactory iRpcWorkerFactory) {
        this.rpcWorkerFactory = iRpcWorkerFactory;
    }

    protected IRpcWorkerFactory getRpcWorkerFactory() {
        return this.rpcWorkerFactory;
    }

    private void setMessageServer(MessageServer messageServer) {
        this.messageServer = messageServer;
    }

    public MessageServer getMessageServer() {
        return this.messageServer;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }
}

