/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.server;

import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IDualRpcCaller;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayloadContainer;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.IMimetic;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rpc.messageserver.server.AbstractServerApplication;
import com.iscobol.rpc.messageserver.server.MessageServer;
import com.iscobol.rts.ArrayTable;
import com.iscobol.rts.HandlesManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;

public class DualRpcServerDispatcher
extends AbstractServerApplication
implements IDualRpcCaller,
IDualRpcMessageConstants,
IRpcMessageDispatcher {
    private int defaultCallTimeoutInSeconds = 60;
    private DualRpcServer dualRpcServer = null;
    private HashMap serverHandlers = new HashMap();
    private ArrayTable callWaitingRegistry = new ArrayTable();
    private IServerCallbackHandler callbackHandler = null;

    public DualRpcServerDispatcher(MessageServer messageServer, Session session, Object object) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        super(messageServer, session, object);
        this.dualRpcServer = (DualRpcServer)this.getConfigurationObject();
        ArrayList arrayList = this.getDualRpcServer().getListServerSideHandlerClassnames();
        for (String string : arrayList) {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(DualRpcServerDispatcher.class);
            AbstractServerRpcHandler abstractServerRpcHandler = (AbstractServerRpcHandler)constructor.newInstance(this);
            if (abstractServerRpcHandler instanceof IMimetic) {
                string = ((IMimetic)((Object)abstractServerRpcHandler)).getFakeName();
            }
            this.serverHandlers.put(string, abstractServerRpcHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l2 = this.getSession().getSessionId();
        try {
            Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + l2);
            while (true) {
                Object object;
                try {
                    Message message = this.getSession().getMessage(true);
                    object = this.getDualRpcServer().getRpcWorkerFactory().getRpcWorkerThread(this, message);
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).start();
                }
                catch (SessionException sessionException) {
                    object = this.getCallWaitingRegistry();
                    int n2 = ((HandlesManager)object).length();
                    for (int i2 = 1; i2 < n2; ++i2) {
                        Object object2 = ((HandlesManager)object).getObject(i2);
                        if (object2 == null) continue;
                        Object object3 = object2;
                        synchronized (object3) {
                            try {
                                object2.notifyAll();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (this.callbackHandler != null) {
                        this.callbackHandler.brokenConnection();
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object call(String string, String string2) throws CallException {
        ArrayList arrayList = new ArrayList();
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2, Object object3) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2, Object object3, Object object4) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        arrayList.add(object5);
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2) throws CallException {
        ArrayList arrayList = new ArrayList();
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2, Object object3) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2, Object object3, Object object4) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5) throws CallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        arrayList.add(object5);
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public void callAsync(String string, String string2, ArrayList arrayList) throws CallException {
        this.call(string, string2, false, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, ArrayList arrayList) throws CallException {
        return this.call(string, string2, true, this.defaultCallTimeoutInSeconds, arrayList);
    }

    public Object call(String string, String string2, int n2, ArrayList arrayList) throws CallException {
        return this.call(string, string2, true, n2, arrayList);
    }

    public Object call(String string, String string2, boolean bl, int n2, ArrayList arrayList) throws CallException {
        return this.call(new RpcCallPayload(string, string2, arrayList, bl), n2);
    }

    @Override
    public Object call(int n2, short s2, ArrayList arrayList, boolean bl, int n3) throws CallException {
        return this.call(new RpcCallPayload(n2, s2, arrayList, bl), n3);
    }

    @Override
    public Object call(int n2, short s2, ArrayList arrayList, boolean bl) throws CallException {
        return this.call(new RpcCallPayload(n2, s2, arrayList, bl), this.defaultCallTimeoutInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(RpcCallPayload rpcCallPayload, int n2) throws CallException {
        Object object;
        block17: {
            object = null;
            try {
                int n3 = 0;
                Message message = new Message(n3, 1, rpcCallPayload);
                if (rpcCallPayload.isSendResults()) {
                    RpcResultPayloadContainer rpcResultPayloadContainer = new RpcResultPayloadContainer();
                    n3 = this.getCallWaitingRegistry().put(rpcResultPayloadContainer);
                    message.setId(n3);
                    boolean bl = false;
                    String string = null;
                    try {
                        RpcResultPayloadContainer rpcResultPayloadContainer2 = rpcResultPayloadContainer;
                        synchronized (rpcResultPayloadContainer2) {
                            this.sendMessage(message);
                            if (n2 <= 0) {
                                rpcResultPayloadContainer.wait();
                            } else {
                                rpcResultPayloadContainer.wait(n2 * 1000);
                            }
                        }
                        int n4 = rpcResultPayloadContainer.getRpcResultPayloadType();
                        switch (n4) {
                            case 2: {
                                RpcResultPayload rpcResultPayload = (RpcResultPayload)rpcResultPayloadContainer.getRpcMessagePayload();
                                object = rpcResultPayload.getResultObject();
                                break;
                            }
                            case 3: {
                                RpcFaultPayload rpcFaultPayload = (RpcFaultPayload)rpcResultPayloadContainer.getRpcMessagePayload();
                                bl = true;
                                string = rpcFaultPayload.getFaultMessage();
                                break;
                            }
                            default: {
                                bl = true;
                                if (rpcCallPayload.getException() != null) {
                                    string = rpcCallPayload.getException().toString();
                                    break;
                                }
                                string = "Call timed out. Current timeout=" + n2;
                                break;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        string = "Thread was interrupted. " + interruptedException.toString();
                    }
                    this.getCallWaitingRegistry().remove(n3);
                    if (bl) {
                        throw new CallException(string);
                    }
                    break block17;
                }
                this.sendMessage(message);
            }
            catch (CallException callException) {
                throw callException;
            }
            catch (Throwable throwable) {
                throw new CallException(throwable);
            }
        }
        return object;
    }

    @Override
    public IRpcHandler getHandler(String string) {
        return (IRpcHandler)this.serverHandlers.get(string);
    }

    public void disconnect() {
        this.getSession().closeSession();
    }

    public DualRpcServer getDualRpcServer() {
        return this.dualRpcServer;
    }

    @Override
    public ArrayTable getCallWaitingRegistry() {
        return this.callWaitingRegistry;
    }

    public void setCallbackHandler(IServerCallbackHandler iServerCallbackHandler) {
        this.callbackHandler = iServerCallbackHandler;
    }

    public void setDefaultCallTimeoutInSeconds(int n2) {
        this.defaultCallTimeoutInSeconds = n2;
    }
}

