/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.client;

import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.ISessionControl;
import com.iscobol.rpc.messageserver.common.JavaSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.RpcSocketFactory;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;

public class MessageClient
implements ISessionControl {
    private String host = null;
    private int port = 0;
    private Session session = null;
    private boolean isSendAndReceiveMessages = true;
    private IMessageSerializer messageSerializer = new JavaSerializer();

    public MessageClient(String string, int n2) {
        this.host = string;
        this.port = n2;
    }

    public void connect() throws UnknownHostException, IOException, GeneralSecurityException {
        Socket socket = RpcSocketFactory.createSocket(this.host, this.port);
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(0);
        socket.setKeepAlive(true);
        Session session = new Session(this, socket, true);
        session.startMessageHandlers();
        this.setSession(session);
    }

    public void sendMessage(Message message) throws SessionException {
        this.getSession().sendMessage(message);
    }

    public Message getMessage(boolean bl) throws SessionException {
        return this.getSession().getMessage(bl);
    }

    public void disconnect() {
        this.getSession().closeSession();
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public synchronized void setSendAndReceiveMessages(boolean bl) {
        this.isSendAndReceiveMessages = bl;
    }

    @Override
    public synchronized boolean isSendAndReceiveMessages() {
        return this.isSendAndReceiveMessages;
    }

    public void setMessageSerializer(IMessageSerializer iMessageSerializer) {
        this.messageSerializer = iMessageSerializer;
    }

    @Override
    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }
}

