/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import com.iscobol.logger.Logger;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.MessageSerializationException;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rpc.messageserver.common.ThreadsafeQueue;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

public class OutboundMessageHandler
extends Thread {
    private Session session = null;
    private ObjectOutputStream outstream = null;
    private ThreadsafeQueue queue = new ThreadsafeQueue();
    private boolean signalToStop = false;
    private IMessageSerializer messageSerializer = null;

    public OutboundMessageHandler(Session session) {
        this.setSession(session);
        this.setOutstream(session.getOutstream());
        this.setMessageSerializer(this.getSession().getSessionControl().getMessageSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSignalToStop(boolean bl) {
        this.signalToStop = bl;
        ThreadsafeQueue threadsafeQueue = this.queue;
        synchronized (threadsafeQueue) {
            this.queue.notifyAll();
        }
    }

    public void sendMessage(Message message) throws SessionException {
        if (this.isSignalToStop()) {
            throw new SessionException("Connection is closed");
        }
        this.queue.put(message);
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + this.getSession().getSessionId());
        Config.c();
        Message message = null;
        while (!this.isSignalToStop()) {
            try {
                message = (Message)this.queue.get();
                Logger logger = this.getSession().isClientSession() ? RemoteRegistry.getClientProblemLogger() : RemoteRegistry.getProblemLogger(this.getSession().getSessionId());
                int n2 = RemoteRegistry.getCompressLevel(this.getSession().getSessionId());
                int n3 = RemoteRegistry.getMinSizeCompress(this.getSession().getSessionId());
                this.getMessageSerializer().serialize(message, this.outstream, logger, n2, n3);
                this.outstream.flush();
            }
            catch (MessageSerializationException messageSerializationException) {
                try {
                    Object object = message.getPayload();
                    if (object != null) {
                        Method method = object.getClass().getMethod("setException", Throwable.class);
                        method.invoke(object, messageSerializationException);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getSession().closeSession();
            }
            catch (Exception exception) {
                this.getSession().closeSession();
            }
            IscobolSystem.destroyEnv(this);
            Thread.yield();
        }
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    protected void setOutstream(ObjectOutputStream objectOutputStream) {
        this.outstream = objectOutputStream;
    }

    protected ObjectOutputStream getOutstream() {
        return this.outstream;
    }

    protected synchronized boolean isSignalToStop() {
        return this.signalToStop;
    }

    public void setMessageSerializer(IMessageSerializer iMessageSerializer) {
        this.messageSerializer = iMessageSerializer;
    }

    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }
}

