/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import com.iscobol.rpc.messageserver.common.ISessionControl;
import com.iscobol.rpc.messageserver.common.InboundMessageHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.OutboundMessageHandler;
import com.iscobol.rpc.messageserver.common.SessionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class Session {
    private Socket socket = null;
    private ObjectInputStream instream = null;
    private ObjectOutputStream outstream = null;
    private int sessionId;
    private InboundMessageHandler inboundHandler = null;
    private OutboundMessageHandler outboundHandler = null;
    private ISessionControl sessionControl = null;
    private boolean client;
    private boolean maxConnectionLimitExceeded;

    public Session(ISessionControl iSessionControl, Socket socket) throws IOException {
        this(iSessionControl, socket, false);
    }

    public Session(ISessionControl iSessionControl, Socket socket, boolean bl) throws IOException {
        this.setSessionControl(iSessionControl);
        this.setSocket(socket);
        this.setOutstream(new ObjectOutputStream(new BufferedOutputStream(this.getSocket().getOutputStream())));
        this.outstream.flush();
        this.setInstream(new ObjectInputStream(new BufferedInputStream(this.getSocket().getInputStream())));
        this.setSessionId(socket.hashCode());
        this.setInboundHandler(new InboundMessageHandler(this));
        this.setOutboundHandler(new OutboundMessageHandler(this));
        this.getInboundHandler().setDaemon(true);
        this.getOutboundHandler().setDaemon(true);
        this.client = bl;
    }

    public boolean isClientSession() {
        return this.client;
    }

    public void startMessageHandlers() {
        this.getInboundHandler().start();
        this.getOutboundHandler().start();
    }

    public String getRemoteHost() {
        return this.getSocket().getInetAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.getSocket().getPort();
    }

    public synchronized void sendMessage(Message message) throws SessionException {
        if (!this.getSessionControl().isSendAndReceiveMessages()) {
            throw new SessionException("sendMessage() activity is suspended");
        }
        this.getOutboundHandler().sendMessage(message);
    }

    public Message getMessage(boolean bl) throws SessionException {
        Message message = null;
        if (!this.getSessionControl().isSendAndReceiveMessages()) {
            throw new SessionException("getMessage() activity is suspended");
        }
        message = this.getInboundHandler().getMessage(bl);
        return message;
    }

    public synchronized void closeSession() {
        this.getInboundHandler().setSignalToStop(true);
        this.getOutboundHandler().setSignalToStop(true);
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected void setInstream(ObjectInputStream objectInputStream) {
        this.instream = objectInputStream;
    }

    protected ObjectInputStream getInstream() {
        return this.instream;
    }

    protected void setOutstream(ObjectOutputStream objectOutputStream) {
        this.outstream = objectOutputStream;
    }

    protected ObjectOutputStream getOutstream() {
        return this.outstream;
    }

    public void setSessionId(int n2) {
        this.sessionId = n2;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    protected void setInboundHandler(InboundMessageHandler inboundMessageHandler) {
        this.inboundHandler = inboundMessageHandler;
    }

    protected InboundMessageHandler getInboundHandler() {
        return this.inboundHandler;
    }

    protected void setOutboundHandler(OutboundMessageHandler outboundMessageHandler) {
        this.outboundHandler = outboundMessageHandler;
    }

    protected OutboundMessageHandler getOutboundHandler() {
        return this.outboundHandler;
    }

    public void setSessionControl(ISessionControl iSessionControl) {
        this.sessionControl = iSessionControl;
    }

    public ISessionControl getSessionControl() {
        return this.sessionControl;
    }

    public boolean isMaxConnectionLimitExceeded() {
        return this.maxConnectionLimitExceeded;
    }

    public void setMaxConnectionLimitExceeded(boolean bl) {
        this.maxConnectionLimitExceeded = bl;
    }
}

