/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.server;

import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.ISessionControl;
import com.iscobol.rpc.messageserver.common.InboundMessageHandler;
import com.iscobol.rpc.messageserver.common.JavaSerializer;
import com.iscobol.rpc.messageserver.common.RpcSocketFactory;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.ThreadDiagnostics;
import com.iscobol.rpc.messageserver.server.AbstractServerApplication;
import com.iscobol.rpc.messageserver.server.AbstractServerApplicationFactory;
import com.iscobol.rpc.messageserver.server.CleanupThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class MessageServer
implements ISessionControl {
    public static final int DEFAULT_MAX_CONNECTIONS = 512;
    private String host = null;
    private int port = 0;
    private boolean reuseAddress;
    private AbstractServerApplicationFactory applicationFactory = null;
    private boolean isAcceptNewConnections = true;
    private boolean isSendAndReceiveMessages = true;
    private int maxConnections = 512;
    private boolean keepAlive;
    private Hashtable applications = new Hashtable();
    private int cleanupThreadSleepTimeInSeconds = 60;
    private IMessageSerializer messageSerializer = new JavaSerializer();
    private boolean ignoreMaxConnectionsLimit;

    public MessageServer(String string, int n2, boolean bl, AbstractServerApplicationFactory abstractServerApplicationFactory) {
        this.host = string;
        this.port = n2;
        this.reuseAddress = bl;
        this.applicationFactory = abstractServerApplicationFactory;
        abstractServerApplicationFactory.setMessageServer(this);
    }

    public void listen() throws UnknownHostException, IOException {
        CleanupThread cleanupThread;
        InetAddress inetAddress;
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode());
        ServerSocket serverSocket = null;
        InetAddress inetAddress2 = inetAddress = this.host != null ? InetAddress.getByName(this.host) : null;
        if (this.reuseAddress) {
            try {
                serverSocket = RpcSocketFactory.createServerSocket();
                serverSocket.getClass().getMethod("setReuseAddress", Boolean.TYPE).invoke((Object)serverSocket, Boolean.TRUE);
                cleanupThread = Class.forName("java.net.InetSocketAddress").getConstructor(InetAddress.class, Integer.TYPE).newInstance(inetAddress, new Integer(this.port));
                serverSocket.getClass().getMethod("bind", Class.forName("java.net.SocketAddress"), Integer.TYPE).invoke((Object)serverSocket, cleanupThread, new Integer(100));
            }
            catch (Throwable throwable) {
                serverSocket = RpcSocketFactory.createServerSocket(this.port, 100, inetAddress);
            }
        } else {
            serverSocket = RpcSocketFactory.createServerSocket(this.port, 100, inetAddress);
        }
        serverSocket.setSoTimeout(0);
        cleanupThread = new CleanupThread(this.getApplications(), this.cleanupThreadSleepTimeInSeconds);
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        boolean bl = false;
        while (true) {
            bl = false;
            Socket socket = serverSocket.accept();
            if (this.isAcceptNewConnections) {
                int n2 = this.currentConnectionCount();
                if (n2 < this.maxConnections) {
                    this.createSession(socket, false);
                } else if (this.ignoreMaxConnectionsLimit) {
                    this.createSession(socket, true);
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSession(final Socket socket, final boolean bl) throws IOException {
        final Boolean[] booleanArray = new Boolean[1];
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl2 = false;
                try {
                    MessageServer.this.createSessionImpl(socket, bl);
                    bl2 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Boolean[] booleanArray2 = booleanArray;
                synchronized (booleanArray) {
                    booleanArray[0] = new Boolean(bl2);
                    booleanArray.notify();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        };
        thread.start();
        Boolean[] booleanArray2 = booleanArray;
        synchronized (booleanArray) {
            if (booleanArray[0] == null) {
                try {
                    booleanArray.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (booleanArray[0] == null || !booleanArray[0].booleanValue()) {
                System.err.println("Connection timeout");
                socket.close();
            }
            return;
        }
    }

    private void createSessionImpl(Socket socket, boolean bl) throws Exception {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            System.err.println("socket.setTcpNoDelay failed: " + socketException.getMessage());
        }
        try {
            socket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            System.err.println("socket.setSoTimeout failed: " + socketException.getMessage());
        }
        try {
            socket.setKeepAlive(this.keepAlive);
        }
        catch (SocketException socketException) {
            System.err.println("socket.setKeepAlive failed: " + socketException.getMessage());
        }
        Session session = new Session(this, socket);
        session.setMaxConnectionLimitExceeded(bl);
        session.startMessageHandlers();
        int n2 = session.getSessionId();
        AbstractServerApplication abstractServerApplication = this.applicationFactory.getApplication(session);
        abstractServerApplication.setDaemon(true);
        abstractServerApplication.start();
        this.getApplications().put(abstractServerApplication.getClass().getName() + n2, abstractServerApplication);
    }

    public int currentConnectionCount() {
        ThreadDiagnostics threadDiagnostics = new ThreadDiagnostics();
        ArrayList arrayList = threadDiagnostics.getAllThreads();
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            InboundMessageHandler inboundMessageHandler;
            Thread thread = (Thread)iterator.next();
            if (!(thread instanceof InboundMessageHandler) || (inboundMessageHandler = (InboundMessageHandler)thread).getSession().isMaxConnectionLimitExceeded()) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized void setAcceptNewConnections(boolean bl) {
        this.isAcceptNewConnections = bl;
    }

    @Override
    public synchronized void setSendAndReceiveMessages(boolean bl) {
        this.isSendAndReceiveMessages = bl;
    }

    @Override
    public synchronized boolean isSendAndReceiveMessages() {
        return this.isSendAndReceiveMessages;
    }

    public synchronized void setMaxConnections(int n2) {
        this.maxConnections = n2;
    }

    public void setMessageSerializer(IMessageSerializer iMessageSerializer) {
        this.messageSerializer = iMessageSerializer;
    }

    @Override
    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }

    public Hashtable getApplications() {
        return this.applications;
    }

    public boolean isIgnoreMaxConnectionsLimit() {
        return this.ignoreMaxConnectionsLimit;
    }

    public void setIgnoreMaxConnectionsLimit(boolean bl) {
        this.ignoreMaxConnectionsLimit = bl;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }
}

