/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class Auth
implements RuntimeErrorsNumbers {
    public static final String CRYPT_ALGORITHM = "Blowfish";
    public static final String DEFAULT_HASH = "SHA-1";
    public static final String LEGACY_HASH = "LEGACY";
    private static String HASH_ALGORITHM = Config.a(".as.digest", "SHA-1");

    public static byte[] nullChallenge() {
        return new byte[16];
    }

    public static byte[] newChallenge() {
        byte[] byArray;
        byte[] byArray2 = SecureRandom.getSeed(16);
        if (LEGACY_HASH.equalsIgnoreCase(HASH_ALGORITHM)) {
            byArray = byArray2;
        } else {
            byte[] byArray3;
            try {
                byArray3 = HASH_ALGORITHM.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray3 = HASH_ALGORITHM.getBytes();
            }
            byte[] byArray4 = byArray3;
            byArray = new byte[byArray4.length + 1 + byArray2.length];
            System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
            System.arraycopy(byArray2, 0, byArray, byArray4.length + 1, byArray2.length);
        }
        return byArray;
    }

    public static void newChallenge(ICobolVar iCobolVar) {
        byte[] byArray = Auth.newChallenge();
        iCobolVar.set(byArray, 0, byArray.length, false);
    }

    public static String getHashAlgorithm() {
        return HASH_ALGORITHM;
    }

    public static void setHashAlgorithm(String string) {
        HASH_ALGORITHM = string;
    }

    public static String getAlgorithmFromChallenge(ICobolVar iCobolVar) {
        byte[] byArray = iCobolVar.getBytes();
        if (iCobolVar.getLength() > 16) {
            int n2 = 0;
            while (byArray[n2] != 0) {
                ++n2;
            }
            iCobolVar.set(byArray, n2 + 1, byArray.length - n2 - 1, false);
            try {
                return new String(byArray, 0, n2, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray, 0, n2);
            }
        }
        return LEGACY_HASH;
    }

    public static void getDigest(ICobolVar[] iCobolVarArray, String string) {
        if (iCobolVarArray.length > 1) {
            try {
                MessageDigest messageDigest;
                if (LEGACY_HASH.equalsIgnoreCase(string)) {
                    messageDigest = MessageDigest.getInstance("MD5");
                    for (int i2 = 1; i2 < iCobolVarArray.length; ++i2) {
                        messageDigest.update(iCobolVarArray[i2].getBytes(), 0, iCobolVarArray[i2].getLength());
                    }
                } else {
                    messageDigest = MessageDigest.getInstance(string);
                    for (int i3 = 1; i3 < iCobolVarArray.length; ++i3) {
                        messageDigest.update(iCobolVarArray[i3].getBytes(), 0, iCobolVarArray[i3].length());
                    }
                }
                iCobolVarArray[0].set(messageDigest.digest());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IscobolRuntimeException(3, noSuchAlgorithmException.toString());
            }
        }
        throw new IllegalArgumentException(" [" + iCobolVarArray.length + "]");
    }

    public static void encrypt(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        Auth.enDeCrypt(iCobolVar, iCobolVar2, iCobolVar3, false);
    }

    public static void decrypt(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        Auth.enDeCrypt(iCobolVar, iCobolVar2, iCobolVar3, true);
    }

    private static void enDeCrypt(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, boolean bl) {
        int n2 = bl ? 2 : 1;
        try {
            Cipher cipher = Cipher.getInstance(CRYPT_ALGORITHM);
            cipher.init(n2, new SecretKeySpec(iCobolVar2.getBytes(), 0, iCobolVar2.getLength(), CRYPT_ALGORITHM));
            iCobolVar3.set(cipher.doFinal(iCobolVar.getBytes(), 0, iCobolVar.getLength()));
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IscobolRuntimeException(3, noSuchPaddingException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IscobolRuntimeException(3, noSuchAlgorithmException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IscobolRuntimeException(3, invalidKeyException.toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IscobolRuntimeException(3, illegalBlockSizeException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IscobolRuntimeException(3, badPaddingException.toString());
        }
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        block36: for (int i2 = 0; i2 < byArray.length; ++i2) {
            switch (byArray[i2] & 0xF0) {
                case 0: {
                    stringBuffer.append('0');
                    break;
                }
                case 16: {
                    stringBuffer.append('1');
                    break;
                }
                case 32: {
                    stringBuffer.append('2');
                    break;
                }
                case 48: {
                    stringBuffer.append('3');
                    break;
                }
                case 64: {
                    stringBuffer.append('4');
                    break;
                }
                case 80: {
                    stringBuffer.append('5');
                    break;
                }
                case 96: {
                    stringBuffer.append('6');
                    break;
                }
                case 112: {
                    stringBuffer.append('7');
                    break;
                }
                case 128: {
                    stringBuffer.append('8');
                    break;
                }
                case 144: {
                    stringBuffer.append('9');
                    break;
                }
                case 160: {
                    stringBuffer.append('A');
                    break;
                }
                case 176: {
                    stringBuffer.append('B');
                    break;
                }
                case 192: {
                    stringBuffer.append('C');
                    break;
                }
                case 208: {
                    stringBuffer.append('D');
                    break;
                }
                case 224: {
                    stringBuffer.append('E');
                    break;
                }
                case 240: {
                    stringBuffer.append('F');
                }
            }
            switch (byArray[i2] & 0xF) {
                case 0: {
                    stringBuffer.append('0');
                    continue block36;
                }
                case 1: {
                    stringBuffer.append('1');
                    continue block36;
                }
                case 2: {
                    stringBuffer.append('2');
                    continue block36;
                }
                case 3: {
                    stringBuffer.append('3');
                    continue block36;
                }
                case 4: {
                    stringBuffer.append('4');
                    continue block36;
                }
                case 5: {
                    stringBuffer.append('5');
                    continue block36;
                }
                case 6: {
                    stringBuffer.append('6');
                    continue block36;
                }
                case 7: {
                    stringBuffer.append('7');
                    continue block36;
                }
                case 8: {
                    stringBuffer.append('8');
                    continue block36;
                }
                case 9: {
                    stringBuffer.append('9');
                    continue block36;
                }
                case 10: {
                    stringBuffer.append('A');
                    continue block36;
                }
                case 11: {
                    stringBuffer.append('B');
                    continue block36;
                }
                case 12: {
                    stringBuffer.append('C');
                    continue block36;
                }
                case 13: {
                    stringBuffer.append('D');
                    continue block36;
                }
                case 14: {
                    stringBuffer.append('E');
                    continue block36;
                }
                case 15: {
                    stringBuffer.append('F');
                }
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length >> 1];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            switch (cArray[n2]) {
                default: {
                    byArray[i2] = 0;
                    break;
                }
                case '1': {
                    byArray[i2] = 16;
                    break;
                }
                case '2': {
                    byArray[i2] = 32;
                    break;
                }
                case '3': {
                    byArray[i2] = 48;
                    break;
                }
                case '4': {
                    byArray[i2] = 64;
                    break;
                }
                case '5': {
                    byArray[i2] = 80;
                    break;
                }
                case '6': {
                    byArray[i2] = 96;
                    break;
                }
                case '7': {
                    byArray[i2] = 112;
                    break;
                }
                case '8': {
                    byArray[i2] = -128;
                    break;
                }
                case '9': {
                    byArray[i2] = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    byArray[i2] = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    byArray[i2] = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    byArray[i2] = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    byArray[i2] = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    byArray[i2] = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    byArray[i2] = -16;
                }
            }
            if (++n2 >= cArray.length) continue;
            switch (cArray[n2]) {
                default: {
                    int n3 = i2;
                    byArray[n3] = (byte)(byArray[n3] | 0);
                    break;
                }
                case '1': {
                    int n4 = i2;
                    byArray[n4] = (byte)(byArray[n4] | 1);
                    break;
                }
                case '2': {
                    int n5 = i2;
                    byArray[n5] = (byte)(byArray[n5] | 2);
                    break;
                }
                case '3': {
                    int n6 = i2;
                    byArray[n6] = (byte)(byArray[n6] | 3);
                    break;
                }
                case '4': {
                    int n7 = i2;
                    byArray[n7] = (byte)(byArray[n7] | 4);
                    break;
                }
                case '5': {
                    int n8 = i2;
                    byArray[n8] = (byte)(byArray[n8] | 5);
                    break;
                }
                case '6': {
                    int n9 = i2;
                    byArray[n9] = (byte)(byArray[n9] | 6);
                    break;
                }
                case '7': {
                    int n10 = i2;
                    byArray[n10] = (byte)(byArray[n10] | 7);
                    break;
                }
                case '8': {
                    int n11 = i2;
                    byArray[n11] = (byte)(byArray[n11] | 8);
                    break;
                }
                case '9': {
                    int n12 = i2;
                    byArray[n12] = (byte)(byArray[n12] | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    int n13 = i2;
                    byArray[n13] = (byte)(byArray[n13] | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    int n14 = i2;
                    byArray[n14] = (byte)(byArray[n14] | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    int n15 = i2;
                    byArray[n15] = (byte)(byArray[n15] | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    int n16 = i2;
                    byArray[n16] = (byte)(byArray[n16] | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    int n17 = i2;
                    byArray[n17] = (byte)(byArray[n17] | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    int n18 = i2;
                    byArray[n18] = (byte)(byArray[n18] | 0xF);
                }
            }
            ++n2;
        }
        return byArray;
    }
}

